<div class="easydocs-accordion" id="most_helpful">
    <ol class="dd-list">
        <?php
        include_once dirname(__FILE__) . '/../doc-rank-helper.php';

        $posts     = get_posts( [ 'post_type' => 'docs', 'posts_per_page'   => -1, 'inclusive' => true] );
        $post_data = [];
        foreach ( $posts as $key => $post ) {
            $post_data[$key]['post_id'] = $post->ID;
            $post_data[$key]['post_title'] = $post->post_title;
            $post_data[$key]['post_edit_link'] = get_edit_post_link( $post->ID );
            $post_data[$key]['post_permalink'] = get_permalink( $post->ID );
            // sum of total positive votes for a post
            $post_data[$key]['positive_time'] = array_sum( get_post_meta( $post->ID, 'positive', false ) );

            $post_data[$key]['negative_time'] = array_sum( get_post_meta( $post->ID, 'negative', false ) );
        }
        // if post has positive_time number large then negative_time number then show large number first
        usort( $post_data, function( $a, $b ) {
            return $b['positive_time'] <=> $a['positive_time'];
        } );

        
        foreach ( $post_data as $key => $post ) {
            if ( $post['positive_time'] > 0 ) {
                // pagination
                if ( $key >= 0 && $key <= 9 ) {
                    ezd_render_doc_rank_item( $post, $key, 'most_helpful' );
                }
            }
        }
        ?>
    </ol>
</div>