<div class="easydocs-tab tab-active" id="analytics-collaboration">
    <h2 class="title"> <?php esc_html_e( 'Collaboration', 'eazydocs-pro' ); ?> </h2> <br>
    <div class="easydocs-filter-container">
        <ul class="single-item-filter collaboration-filter">
            <li id="toggle-articles" class="easydocs-btn easydocs-btn-gray-light easydocs-btn-rounded easydocs-btn-sm is-active">
				        <?php esc_html_e( 'Articles', 'eazydocs-pro' ); ?>
            </li>
            <li id="toggle-likes" class="easydocs-btn easydocs-btn-gray-light easydocs-btn-rounded easydocs-btn-sm">
				        <?php esc_html_e( 'Likes', 'eazydocs-pro' ); ?>
            </li>
            <li id="toggle-dislikes" class="easydocs-btn easydocs-btn-gray-light easydocs-btn-rounded easydocs-btn-sm">
				        <?php esc_html_e( 'Dislikes', 'eazydocs-pro' ); ?>
            </li>
        </ul>
    </div>

    <div id="collboration_chart"></div>

    <?php
    // Collect User Stats
    $users_data = [];
    $docs = get_posts([
        'post_type'      => 'docs',
        'posts_per_page' => -1,
        'post_status'    => 'publish',
    ]);

    foreach ( $docs as $doc ) {
        $post_id   = $doc->ID;
        $author_id = $doc->post_author;

        // Contributors stored as comma-separated string
        $contributors_raw = get_post_meta( $post_id, 'ezd_doc_contributors', true );
        $contributors     = [];

        if ( is_string( $contributors_raw ) && ! empty( $contributors_raw ) ) {
            $contributors = array_map( 'trim', explode( ',', $contributors_raw ) );
        }

        // Combine author + contributors
        $all_contributors = array_unique( array_merge( [ $author_id ], $contributors ) );

        foreach ( $all_contributors as $user_id ) {
            if ( empty( $user_id ) ) continue;
            if ( ! isset( $users_data[ $user_id ] ) ) {
                $user = get_userdata( $user_id );
                $users_data[ $user_id ] = [
                    'name'      => $user ? $user->display_name : "User {$user_id}",
                    'articles'  => 0,
                    'likes'     => 0,
                    'dislikes'  => 0
                ];
            }
            $users_data[ $user_id ]['articles']++;
        }

        // Likes
        $positive_voters = get_post_meta( $post_id, 'positive_voter', true );
        $positive_voters = is_array( $positive_voters ) ? $positive_voters : ( ! empty( $positive_voters ) ? [ $positive_voters ] : [] );

        foreach ( $positive_voters as $user_id ) {
            if ( empty( $user_id ) ) continue;
            if ( ! isset( $users_data[ $user_id ] ) ) {
                $user = get_userdata( $user_id );
                $users_data[ $user_id ] = [
                    'name'      => $user ? $user->display_name : "User {$user_id}",
                    'articles'  => 0,
                    'likes'     => 0,
                    'dislikes'  => 0
                ];
            }
            $users_data[ $user_id ]['likes']++;
        }

        // Dislikes
        $negative_voters = get_post_meta( $post_id, 'negative_voter', true );
        $negative_voters = is_array( $negative_voters ) ? $negative_voters : ( ! empty( $negative_voters ) ? [ $negative_voters ] : [] );

        foreach ( $negative_voters as $user_id ) {
            if ( empty( $user_id ) ) continue;
            if ( ! isset( $users_data[ $user_id ] ) ) {
                $user = get_userdata( $user_id );
                $users_data[ $user_id ] = [
                    'name'      => $user ? $user->display_name : "User {$user_id}",
                    'articles'  => 0,
                    'likes'     => 0,
                    'dislikes'  => 0
                ];
            }
            $users_data[ $user_id ]['dislikes']++;
        }
    }

    // Only keep users with at least 1 article
    $users_data = array_filter( $users_data, fn($u) => $u['articles'] > 0 );

    // Prepare for JS
    $user_names = [];
    $articles   = [];
    $likes      = [];
    $dislikes   = [];

    foreach ( $users_data as $user_id => $data ) {
        $user_names[] = $data['name'];
        $articles[]   = $data['articles'];
        $likes[]      = $data['likes'];
        $dislikes[]   = $data['dislikes'];
    }
    ?>

    <script>
        const categories  = <?php echo json_encode($user_names); ?>;
        const articleData = <?php echo json_encode($articles); ?>;
        const likeData    = <?php echo json_encode($likes); ?>;
        const dislikeData = <?php echo json_encode($dislikes); ?>;
        
        var options = {
          series: [
            { name: 'Articles', data: articleData },
            { name: 'Likes', data: likeData },
            { name: 'Dislikes', data: dislikeData }
          ],
          chart: {
            height: 350,
            type: 'area'
          },
          dataLabels: {
            enabled: false
          },
          stroke: {
            curve: 'smooth'
          },
          xaxis: {
            categories: categories
          },
          fill: {
            type: "gradient",
            gradient: {
                shadeIntensity: 1,
                opacityFrom: 0.7,
                opacityTo: 0.9,
                stops: [0, 90, 100]
            }
        },
          tooltip: {
            y: {
              formatter: function (val) {
                return val + " entries";
              }
            }
          }
        };

        var chart = new ApexCharts(document.querySelector("#collboration_chart"), options);
        chart.render();
        
        document.getElementById('toggle-articles').addEventListener('click', function() {
          chart.toggleSeries('Articles');
          this.classList.toggle('active');
        });

        document.getElementById('toggle-likes').addEventListener('click', function() {
          chart.toggleSeries('Likes');
          this.classList.toggle('active');
        });

        document.getElementById('toggle-dislikes').addEventListener('click', function() {
          chart.toggleSeries('Dislikes');
          this.classList.toggle('active');
        });
        
    </script>

    <!-- =========================== -->
    <!-- Contributor Breakdown Table -->
    <!-- =========================== -->

    <div class="ezd-collaboration-data">
      <div class="title-wrapper">
        <ul>
          <li class="active"><?php esc_html_e( 'Leading Contributors', 'eazydocs-pro' ); ?></li>
        </ul>
      </div>

      <div class="content-wrapper">
        <div class="inner-content" data-content="authors">
            <div class="content-row">
                <div>
                    <?php esc_html_e( 'Authors', 'eazydocs-pro' ); ?>
                </div>
                <div>
                    <li><?php esc_html_e( 'Articles', 'eazydocs-pro' ); ?></li>
                    <li><?php esc_html_e( 'Likes', 'eazydocs-pro' ); ?></li>
                    <li><?php esc_html_e( 'Dislikes', 'eazydocs-pro' ); ?></li>
                </div>
            </div>

            <?php
            foreach ( $users_data as $user_id => $data ) :
                $user = get_userdata( $user_id );
                if ( ! $user ) continue;
                ?>
                <div class="content-row">
                    <div>
                        <span class="avatar">
                          <a href="<?php echo esc_url( get_author_posts_url( $user->ID ) ); ?>">
                            <?php echo get_avatar( $user->ID, 40 ); ?>
                          </a>
                        </span>
                        <span>
                          <a href="<?php echo esc_url( get_author_posts_url( $user->ID ) ); ?>">
                            <?php echo esc_html( $user->display_name ); ?>
                          </a>
                        </span>
                    </div>
                    <div>
                        <li><?php echo esc_html( $data['articles'] ); ?></li>
                        <li><?php echo esc_html( $data['likes'] ); ?></li>
                        <li><?php echo esc_html( $data['dislikes'] ); ?></li>
                    </div>
                </div>
                <?php 
            endforeach; 
            ?>
        </div>
      </div>
    </div>
</div>