<?php

namespace eazyDocsPro\Admin;

/**
 * Class Admin_Actions
 *
 * @package eazyDocsPro\Admin
 */
class Admin_Actions {
	function __construct() {
		add_action( 'eazydocs_duplicate', [ $this, 'eazydocs_duplicate' ], 99, 1 );	
		add_action( 'eazydocs_visibility', [ $this, 'eazydocs_visibility' ], 99, 1 );		

		add_action( 'eazydocs_doc_sidebar', [ $this, 'doc_sidebar' ], 99, 5 );
		add_action( 'eazydocs_notification', [ $this, 'notification' ], 99, 1 );
		add_action( 'wp_ajax_eazydocs_sortable_docs', [ $this, 'sortable_docs' ] );
		add_action( 'ezd_pro_admin_menu', [ $this, 'ezd_admin_menu' ], 0, 1 );
		add_action( 'eazydocs_parent_doc_drag', [ $this, 'parent_doc_drag' ] );
		add_action( 'eazydocs_social_share', [ $this, 'social_share' ] );
	}
	
	/**
	 * EazyDocs Parent Duplicator
	 *
	 * @param $id
	 * @param $parent
	 */
	public function eazydocs_duplicate( $id ) {
		$nonce     = wp_create_nonce( $id );
		$duplicate = esc_attr( $id );

		$url = add_query_arg( [
			'action'    => 'doc_duplicate',
			'_wpnonce'  => $nonce,
			'duplicate' => $duplicate
		], admin_url( 'admin.php' ) );
		?>
		<a href="<?php echo esc_url( $url ); ?>" target="_blank"
		class="docs-duplicate" title="<?php esc_attr_e( 'Duplicate this doc with the child docs.', 'eazydocs-pro' ); ?>">
			<span class="dashicons dashicons-admin-page"></span>
			<span class="duplicate-title"><?php esc_html_e( 'Duplicate', 'eazydocs-pro' ); ?></span>
		</a>
		<?php
	}
	
	/**
	 * EazyDocs Doc visibility
	 *
	 * @param $id
	 * @param $parent
	 */
	public function eazydocs_visibility( $id ) {
		$nonce     = wp_create_nonce( $id );
		$doc_id    = esc_attr( $id );

		$url = add_query_arg( [
			'doc_visibility' => $doc_id,
			'_wpnonce'       => $nonce
		], admin_url( 'admin.php' ) );
		?>
		<a href="<?php echo esc_url( $url ); ?>" target="_blank" class="docs-visibility"
		title="<?php esc_attr_e( 'Docs visibility', 'eazydocs-pro' ); ?>">
			<span class="dashicons dashicons-visibility"></span>
			<span class="visibility-title"><?php esc_html_e( 'Visibility', 'eazydocs-pro' ); ?></span>
		</a>
		<?php
	}

	/**
	 * EazyDocs Doc Sidebar
	 *
	 * @param $id
	 * @param $parent
	 */
	public function doc_sidebar( $id, $left_type, $left_cont, $right_type, $right_cont ) {
		// Safely sanitize all components before using them
		$doc_id     = sanitize_key( $id );
		$left_type  = sanitize_key( $left_type );
		$left_cont  = sanitize_key( $left_cont );
		$right_type = sanitize_key( $right_type );
		$right_cont = sanitize_key( $right_cont );

		// Create a unique nonce action using all relevant parts
		$nonce_action = $doc_id . $left_type . $left_cont . $right_type . $right_cont;
		$nonce        = wp_create_nonce( $nonce_action );

		// Build the safe URL
		$url = add_query_arg( [
			'doc_sidebar' => $nonce_action,
			'_wpnonce'    => $nonce
		], admin_url( 'admin.php' ) );
		?>
		<a href="<?php echo esc_url( $url ); ?>" target="_blank" class="docs-sidebar"
		title="<?php esc_attr_e( 'Docs Sidebar', 'eazydocs-pro' ); ?>">
			<span class="dashicons dashicons-welcome-widgets-menus"></span>
			<span class="sidebar-title"><?php esc_html_e( 'Sidebar', 'eazydocs-pro' ); ?></span>
		</a>
		<?php
	}

	public function parent_doc_drag() { 
		if ( current_user_can('manage_options') ) :
			?>
			<div class="dd-handle dd3-handle" style="z-index: 1;">
				<svg class="dd-handle-icon" width="15px" height="15px" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"
					title="<?php esc_attr_e( 'Hold the mouse and drag to move this doc.', 'eazydocs-pro' ); ?>">
					<path fill="none" stroke="#bbc0c4" stroke-width="2"
						d="M15,5 L17,5 L17,3 L15,3 L15,5 Z M7,5 L9,5 L9,3 L7,3 L7,5 Z M15,13 L17,13 L17,11 L15,11 L15,13 Z M7,13 L9,13 L9,11 L7,11 L7,13 Z M15,21 L17,21 L17,19 L15,19 L15,21 Z M7,21 L9,21 L9,19 L7,19 L7,21 Z"/>
				</svg>
			</div>
			<?php
		endif;
	}

	/**
	 * EazyDocs Notification
	 */
	public function notification() {
		$counter = eazydocs_voted() + ezd_comment_count();
		?>
        <li class="easydocs-notification" title="<?php esc_attr_e( 'Notifications', 'eazydocs-pro' ); ?>">
            <div class="header-notify-icon">
                <img class="notify-icon" src="<?php echo esc_url( EAZYDOCSPRO_IMG . '/admin/notification.svg' ); ?>" alt="<?php esc_attr_e( 'Notify Icon', 'eazydocs-pro' ); ?>">
            </div>

			<?php 
			if ( $counter > 0 ) : 
				?>
				<span class="easydocs-badge">
					<?php echo esc_html( $counter ); ?>
				</span>
				<?php 
			endif; 
			?>
			
            <div class="easydocs-dropdown notification-dropdown">

				<?php 
				if ( $counter > 0 ) : 
					?>
                    <div class="notification-head d-flex alignment-center justify-content-between ez-pb-0">
                        <span class="header-text">
                            <?php esc_html_e( 'Notifications', 'eazydocs-pro' ); ?>
                        </span>
                    </div>
                    <div class="notification-body" data-ref="container-1">
                        <div class="filter-button-group easydocs-filters">
                            <button type="button" class="easydocs-btn easydocs-btn-gray easydocs-btn-round easydocs-btn-sm mixitup-control-active" data-filter="*">
                                <span class="dashicons dashicons-screenoptions"></span>
								<?php esc_html_e( 'All', 'eazydocs-pro' ); ?>
                            </button>
                            <button type="button" class="easydocs-btn easydocs-btn-gray easydocs-btn-round easydocs-btn-sm" data-filter=".chat">
                                <span class="dashicons dashicons-admin-comments"></span>
								<?php esc_html_e( 'Comments', 'eazydocs-pro' ); ?>
                            </button>
                            <button type="button" class="easydocs-btn easydocs-btn-gray easydocs-btn-round easydocs-btn-sm" data-filter=".like">
                                <span class="dashicons dashicons-thumbs-up"></span>
								<?php esc_html_e( 'Vote', 'eazydocs-pro' ); ?>
                            </button>
                        </div>
						
                        <div class="notify-column ezd-mix-wrapper">
							<?php
							$args = array(
								'post_type'      => 'docs',
								'posts_per_page' => -1,
								'post_status'    => array( 'publish' )
							);

							$positive_arr = [];
							$negative_arr = [];

							foreach ( get_posts( $args ) as $posts ) {
								// Positive
								$positive       = get_post_meta( $posts->ID, 'positive_time', true );
								$is_p           = ! empty( $positive ) ? 'p' : '';
								$positive_arr[] = get_post_meta( $posts->ID, 'positive_time', true ) . $is_p;

								// Negative
								$negative       = get_post_meta( $posts->ID, 'negative_time', true );
								$is_n           = ! empty( $negative ) ? 'n' : '';
								$negative_arr[] = get_post_meta( $posts->ID, 'negative_time', true ) . $is_n;
							}
							$positive_arr = array_filter( $positive_arr );
							$negative_arr = array_filter( $negative_arr );
							$vote_dates   = array_merge( $positive_arr, $negative_arr );

							// Sort with vote suffix
							usort( $vote_dates, "ezdpro_date_sort" );
							$votes    = array_filter( $vote_dates );
							$no_np    = array_merge( $positive_arr, $negative_arr );
							$np_value = [];

							foreach ( $no_np as $pid ) {
								$pid_trim = substr( $pid, - 1 );
								if ( $pid_trim == 'p' ) {
									$vote_text = 'Positive ';
								} elseif ( $pid_trim == 'n' ) {
									$vote_text = 'Negative ';
								}
								$np_value[] = rtrim( $pid, $pid_trim );
							}

							// Sort without vote suffix
							usort( $np_value, "ezd_date_sort" );
							$join_arrays = array_combine( $votes, $np_value );
							foreach ( $join_arrays as $np => $item ) :
								$is_np = substr( $np, - 1 );
								if ( $is_np == 'p' ) {
									$vote_text  = 'Positive ';
									$vote_color = 'green ';
									$vote_icon  = 'dashicons-thumbs-up';
								} elseif ( $is_np == 'n' ) {
									$vote_text  = 'Negative ';
									$vote_color = 'red ';
									$vote_icon  = 'dashicons-thumbs-down';
								}
								$args2      = array(
									'post_type'      => 'docs',
									'posts_per_page' => - 1,
									'meta_query'     => array(
										array(
											'value' => $item
										)
									)
								);
								$date_posts = get_posts( $args2 );
								foreach ( $date_posts as $posts ) :
									?>
									<div class="test notification-item mix like show_mix" onclick="window.open('<?php echo esc_url( get_the_permalink( $posts ) . '?read_unread=' . esc_attr( $posts->ID ) ); ?>','new_window');">

                                        <div class="notification-image notification-border-red">
											<?php
											if ( has_post_thumbnail( $posts->ID ) ) {
												echo get_the_post_thumbnail( $posts->ID, 'thumbnail' );
											} else {
												eazydocs_pro_img( EAZYDOCSPRO_IMG . '/admin/placeholder.jpg', 'EazyDocs Pro Placeholder image' );
											}
											?>
                                            <span class="notify-badge notify-badge-blue">
                                             	<span class="dashicons <?php echo esc_attr( $vote_icon ); ?>"> </span>
                                            </span>
                                        </div>
                                        <div class="notification-content">
                                            <div class="d-flex flex-column">
                                                <h5 class="notify-name">
                                                    <a href="<?php echo esc_url( get_the_permalink( $posts ) ); ?>" target="_blank">
														<?php echo esc_html( get_the_title( $posts->ID ) ); ?>
                                                    </a>
                                                    <!---- Read / Unread -->
													<?php //echo get_post_meta(get_the_ID(), 'ezd_doc_read_unread', true); ?>
                                                </h5>
                                                <div class="reply-text text-blue mt-2">
													<?php esc_html_e( 'Voted', 'eazydocs-pro' ); ?>
                                                    <strong> <span class="<?php echo esc_attr( $vote_color ); ?>"> <?php echo esc_html( $vote_text ); ?> </span>
                                                    </strong>
                                                </div>
                                            </div>
                                            <small class="notify-date">
												<?php
												echo esc_html(
													human_time_diff( strtotime( $item ), current_time( 'timestamp', 1 ) ) .
													__( ' ago', 'eazydocs-pro' )
												);
												?>
                                            </small>
                                        </div>
                                    </div>
								<?php
								endforeach;
							endforeach;
							wp_reset_postdata();
							// Ended vote area

							$args = array(
								'number'      => 5,
								'post_status' => 'publish',
								'post_type'   => array( 'docs' ),
								'parent'      => 0,
								'order'       => 'desc',
							);
							$comments = get_comments( $args );
							foreach ( $comments as $comment ) :
								?>
								<div class="test notification-item mix chat show_mix" onclick="window.open('<?php echo esc_url( get_comment_link( $comment ) . '?read_unread=' . esc_attr( $comment->ID ) ); ?>','new_window');">
									<div class="notification-image notification-border-red">
										<?php echo get_avatar( $comment, 40 ); ?>
										<span class="notify-badge notify-badge-green">
										<span class="dashicons dashicons-admin-comments"></span>
									</span>
									</div>
									<div class="notification-content">
										<div class="d-flex alignment-center">
											<h5 class="notify-name">
												<?php echo esc_html( $comment->comment_author ); ?>
											</h5>
											<span class="reply-text">
											<?php esc_html_e( 'Responded on', 'eazydocs-pro' ); ?>
										</span>
										</div>
										<p class="notify-short-description">
											<?php echo esc_html( $comment->post_title ); ?>
										</p>
										<small class="notify-date">
											<?php
											echo esc_html(
												human_time_diff( strtotime( $comment->comment_date ), current_time( 'timestamp', 1 ) ) .
												__( ' ago', 'eazydocs-pro' )
											);
											?>
										</small>
									</div>
								</div>
                                
							<?php
							endforeach;
							?>
                        </div>
                    </div>
				<?php else : ?>
                    <div class="notification-head d-flex alignment-center justify-content-center no-notification-text">
						<?php esc_html_e( 'No new notifications', 'eazydocs-pro' ); ?>
                    </div>
				<?php endif; ?>
            </div>
        </li>
	<?php }
	// Notification ended

	/**
	 * Sort docs.
	 *
	 * @return void
	 */
	public function sortable_docs() {
		check_ajax_referer( 'eazydocs-admin-nonce', 'security' );

		if ( ! current_user_can( 'edit_posts' ) ) {
			wp_send_json_error( [ 'message' => 'Insufficient permissions.' ] );
		}

		$doc_ids = $_POST['page_id_array'];

		if ( $doc_ids ) {
			foreach ( $doc_ids as $order => $id ) {
				wp_update_post( [
					'ID'         => $id,
					'menu_order' => $order
				] );
			}
		}
		exit;
	}

	public function ezd_admin_menu() {
		$capabilites = 'manage_options';
		add_submenu_page( 'eazydocs', __( 'Badges', 'eazydocs-pro' ), __( 'Badges', 'eazydocs-pro' ), $capabilites, 'edit-tags.php?taxonomy=doc_badge&post_type=docs' );
		
		add_submenu_page( 'eazydocs', __( 'Users Feedback', 'eazydocs-pro' ), __( 'Users Feedback', 'eazydocs-pro' ), $capabilites, 'ezd-user-feedback', [ $this, 'user_feedback' ] );

		add_submenu_page( '', __( 'Feedbacks Archived', 'eazydocs-pro' ), __( 'Feedbacks Archived', 'eazydocs-pro' ), $capabilites, 'ezd-user-feedback-archived', [ $this, 'user_feedback_archived' ] );

		if ( class_exists( 'EazyDocs' ) && eaz_fs()->is_plan( 'promax' ) ) {

			$analytics_cap = 'manage_options';

			if ( ! empty( ezd_get_opt('analytics-access') ) ) {
				$current_user_roles 	= ezd_get_current_user_role_by_id(get_current_user_id());
				$analytics_access_roles = ezd_get_opt('analytics-access');
				
				if (is_array($current_user_roles) && is_array($analytics_access_roles)) {
					if (array_intersect($current_user_roles, $analytics_access_roles)) {
						foreach ($current_user_roles as $role) {
							if (in_array($role, $analytics_access_roles)) {
								switch ($role) {
									case 'administrator':
										$analytics_cap = 'manage_options';
										break;
									case 'editor':
										$analytics_cap = 'publish_posts';
										break;
									case 'author':
										$analytics_cap = 'edit_posts';
										break;
								}
							}
						}
					}
				} else {
					error_log('Expected arrays for user roles and analytics access roles');
				}
			}
						
			add_submenu_page( 'eazydocs', __( 'Analytics', 'eazydocs-pro' ), __( 'Analytics', 'eazydocs-pro' ), $analytics_cap, 'ezd-analytics', [ $this, 'analytics_presents_pro' ] );
		}

	}

	public function user_feedback() {
		include EAZYDOCSPRO_PATH . '/includes/feedback/feedback.php';
	}

	public function user_feedback_archived() {
		include EAZYDOCSPRO_PATH . '/includes/feedback/feedback-archived.php';
	}

	public function analytics_presents_pro() {
		include EAZYDOCSPRO_PATH . '/includes/Admin/analytics/Analytics.php';
	}

	public function social_share() {
		echo "sharer";
	}
}

if ( strstr( $_SERVER['REQUEST_URI'], 'wp-admin/post-new.php' ) || strstr( $_SERVER['REQUEST_URI'], 'wp-admin/post.php' ) ) {
	$is_post          = $_GET['post'] ?? '';
	$get_post_type    = get_post_type( $is_post );
	$add_new_doc_type = $_GET['post_type'] ?? '';
	if ( $get_post_type == 'docs' || $add_new_doc_type == 'docs' ) {
		global $current_user;
		wp_get_current_user();

		$guest_email         = strtolower( get_bloginfo( 'name' ) );
		$guest_email         = str_replace( ' ', '_', $guest_email );
		$frontend_submission = ezd_get_opt( 'ezd_fronted_submission' );

		$frontend_edit = $frontend_submission['frontend-edit-switcher'] ?? '';
		$edit_user     = $frontend_submission['docs-frontend-edit-user-permission'] ?? '';
		$user_id       = $frontend_submission['docs-frontend-edit-user'] ?? '';

		$frontend_add = $frontend_submission['frontend-add-switcher'] ?? '';
		$add_user     = $frontend_submission['docs-frontend-add-user-permission'] ?? '';
		$add_user_id  = $frontend_submission['docs-frontend-add-user'] ?? '';

		if ( $frontend_edit == 1 || $frontend_add == 1 ) {
			if ( $edit_user == 'guest' || $add_user == 'guest' ) {
				$user_info     = get_userdata( $user_id );
				$username      = $user_info->user_login ?? $guest_email . '_guest';
				$add_user_info = get_userdata( $add_user_id );
				$add_username  = $add_user_info->user_login ?? $guest_email . '_guest';

				if ( $current_user->user_login == $username || $current_user->user_login == $add_username ) : ?>
                    <style>
                        /* Doc editor screen */
                        #adminmenuback {
                            width: 0 !important;
                        }

                        .editor-post-locked-modal__buttons .components-flex-item:last-child,
                        button.components-button.editor-post-switch-to-draft.is-tertiary,
                        #adminmenuwrap,
                        #wpadminbar {
                            display: none;
                        }

                        .auto-fold .interface-interface-skeleton {
                            left: 0 !important;
                            top: 0 !important;
                        }

                        #wpcontent {
                            margin-left: 0;
                        }

                        .edit-post-header > div:first-child {
                            width: 0;
                        }

                        .edit-post-header > div:first-child .edit-post-fullscreen-mode-close {
                            display: none;
                        }

                        .editor-styles-wrapper .wp-block {
                            width: 100% !important;
                            padding: 0 15px;
                        }

                        a.components-button.components-menu-item__button {
                            display: none;
                        }
                    </style>
				<?php endif;
			}
		}
	}
}