<?php
/**
 * Helper function to render a single doc rank item
 *
 * @param array $post Post data array
 * @param int $key Index for ranking
 * @param string $type Type: 'most_helpful', 'least_helpful', 'most_viewed'
 * @return void
 */
function ezd_render_doc_rank_item( $post, $key, $type = 'most_helpful' ) {
    $positive = $post['positive_time'];
    $negative = $post['negative_time'];

    // translators: %d is the number of positive votes.
    $positive_title = $positive ? sprintf( _n( '%d Positive vote, ', '%d Positive votes and ', $positive, 'eazydocs-pro' ), number_format_i18n( $positive ) ) : esc_html__( 'No Positive votes, ', 'eazydocs-pro' );

    // translators: %d is the number of negative votes.
    $negative_title = $negative ? sprintf( _n( '%d Negative vote found.', '%d Negative votes found.', $negative, 'eazydocs-pro' ), number_format_i18n( $negative ) ) : esc_html__( 'No Negative votes.', 'eazydocs-pro' );

    $positive_icon = '';
    if ( $positive || $negative ) {
        $positive_icon = '<div class="votes">';

        if ( $positive > 0 ) {
            $positive_icon .= '<div class="like"> 
                <span class="t-success dashicons dashicons-thumbs-up"></span> ' . esc_html( $positive ) . '
            </div>';
        }

        $positive_icon .= '<div class="dislike"> 
            <span class="t-danger dashicons dashicons-thumbs-down"></span> ' . esc_html( $negative ) . '
        </div>';

        $positive_icon .= '</div>';
    }

    $sum_votes = $positive + $negative;

    // Determine progress text based on type
    $progress_text = '';
    if ( $type === 'most_viewed' ) {
        $progress_text = esc_html( get_post_meta( $post['post_id'], 'post_views_count', true ) ) . ' views';
    } else {
        if ( $positive || $negative ) {
            $progress_text = '<progress id="file" value="' . (int) $positive . '" max="' . (int) $sum_votes . '" title="' . esc_attr( $positive_title . $negative_title ) . '"></progress>';
        } else {
            $progress_text = esc_html__( 'No rates', 'eazydocs-pro' );
        }
    }

    ?>
    <li class="easydocs-accordion-item" data-id="<?php echo esc_attr( $post['post_id'] ); ?>">
        <div class="dd3-content">
            <div class="accordion-title ez-section-title">
                <div class="left-content">
                    <?php
                    // Rank number for most_helpful
                    echo "<span class='sl-number'>" . esc_html( $key + 1 ) . '</span>';
            
                    $edit_link = 'javascript:void(0)';
                    $target    = '_self';
                    if ( current_user_can( 'publish_pages' ) ) {
                        $edit_link = $post['post_edit_link'];
                        $target    = '_blank';
                    }
                    ?>
                    <h4>
                        <a href="<?php echo esc_attr( $edit_link ); ?>" target="<?php echo esc_attr( $target ); ?>">
                            <?php echo esc_html( $post['post_title'] ); ?>
                        </a>
                    </h4>
                    <ul class="actions">
                        <li>
                            <a href="<?php echo esc_url( $post['post_permalink'] ); ?>" target="_blank" title="<?php esc_attr_e( 'View this doc item in new tab', 'eazydocs-pro' ) ?>">
                                <span class="dashicons dashicons-external"></span>
                            </a>
                        </li>
                    </ul>
                </div>
                <div class="right-content">
                    <?php echo wp_kses_post( $positive_icon ); ?>
                    <span class="progress-text">
                        <?php echo wp_kses_post( $progress_text ); ?>
                    </span>
                </div>
            </div>
        </div>
    </li>
    <?php
}
?>