<?php
/**
 * Feedback display action hooks
 * @package eazyDocsPro\feedback
 */
add_action('ezd_feedback_loop', 'ezd_feedback_loop_callback'); 
function ezd_feedback_loop_callback( $post_id ) { 
    // Get post meta data 
    $doc_id     = get_post_meta( $post_id, 'ezd_feedback_id', true ); 
    $data_type  = get_post_meta( $post_id, 'ezd_feedback_status', true ); 
    $data_type  = $data_type === 'false' ? 'archive' : 'open';
    $subject    = get_post_meta( $post_id, 'ezd_feedback_subject', true ); 
    $name       = get_post_meta( $post_id, 'ezd_feedback_name', true ); 
    $email      = get_post_meta( $post_id, 'ezd_feedback_email', true ); 

    // Determine status and icon class
    $icon_class = ( isset( $_GET['status'] ) && $_GET['status'] === 'archive' ) ? 'hidden' : 'visibility'; 
    // Ensure proper escaping 
    $permalink  = get_the_permalink( $doc_id ); 
    ?>
    <div class="ezd-feedback-item">
        <h2>
            <a href="<?php echo esc_url( $permalink ); ?>" target="_blank"> <?php echo esc_html( $subject ); ?> </a> - <?php echo esc_html( $name ); ?>
        </h2>
        <div class="ezd-feedback-meta">
            <div class="ezd-meta-date-time">
                <span class="dashicons dashicons-clock"></span> <?php echo get_the_date( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ) ); ?>
            </div>
            <div class="ezd-meta-mail">
                <span class="dashicons dashicons-email-alt"></span>
                <a href="mailto:<?php echo esc_attr( antispambot( $email ) ); ?>">
                    <?php echo esc_attr( antispambot( $email ) ); ?>
                </a>
            </div>
        </div>
        
        <div class="ezd-feedback-content">
            <span class="dashicons dashicons-welcome-write-blog"></span>
            <?php echo wpautop( esc_html( get_the_content( $post_id ) ) ); ?>
        </div>

        <div class="ezd-feedback-btn">
            <?php // Delete feedback action 
            $delete_url = add_query_arg( [ 
                'page'          => 'ezd-user-feedback',
                'tab_type'      => 'doc', 
                'feedback_delete' => $post_id, 
                'data_type'     => $data_type, 
                '_wpnonce'      => wp_create_nonce( $post_id ) 
            ], admin_url( 'admin.php' ) );
            ?>
            <a class="ezd-feedback-delete" href="<?php echo esc_url( $delete_url ); ?>">
                <span class="dashicons dashicons-trash"></span>
            </a>
            <?php // Update feedback action 
            $update_url = add_query_arg( [ 
                'page'      => 'ezd-user-feedback', 
                'tab_type'  => 'doc', 
                'feedback_id' => $post_id,
                'data_type' => $data_type, 
                '_wpnonce'  => wp_create_nonce( $post_id ) 
            ], admin_url( 'admin.php' ) ); 
            ?>
            <a class="ezd-feedback-update" href="<?php echo esc_url( $update_url ); ?>">
                <span class="dashicons dashicons-<?php echo esc_attr( $icon_class ); ?>"></span>
            </a>
        </div>
    </div>
    <?php 
}

// Delete text feedback action hook
add_action('ezd_text_feedback_loop', 'ezd_text_feedback_loop_callback');
function ezd_text_feedback_loop_callback( $post_id ) {
    $post = get_post( $post_id );
    if ( ! $post || $post->post_type !== 'ezd-text-feedback' ) return;

    $content     = $post->post_content;
    $author_name = get_post_meta( $post_id, 'author_name', true );
    $author_email = get_post_meta( $post_id, 'author_email', true );
    $related_doc = get_post_meta( $post_id, 'related_doc_id', true );
    $is_archived = get_post_meta( $post_id, 'ezd_feedback_archived', true );

    $data_type  = $is_archived === 'true' ? 'archive' : 'open';
    $icon_class = $is_archived === 'true' ? 'hidden' : 'visibility';
    $title      = get_the_title( $related_doc );
    $permalink  = get_permalink( $related_doc );
    ?>
    <div class="ezd-feedback-item">
        <h2>
            <a href="<?php echo esc_url( $permalink ); ?>" target="_blank">
                <?php echo esc_html( $author_name ?: __('Anonymous', 'eazydocs-pro') ); ?>
            </a>
        </h2>

        <div class="ezd-feedback-meta">
            <div class="ezd-meta-date-time">
                <span class="dashicons dashicons-clock"></span>
                <?php echo esc_html( get_the_date( get_option('date_format') . ' ' . get_option('time_format'), $post_id ) ); ?>
            </div>
            <?php 
            if ( $title ) : 
                ?>
                <div class="ezd-meta-mail">
                    <span class="dashicons dashicons-admin-links"></span>
                    <a href="<?php echo esc_url( $permalink ); ?>">
                        <?php echo esc_html( $title ); ?>
                    </a>
                </div>
                <?php 
            endif; 
            ?>
        </div>

        <div class="ezd-feedback-content">
            <span class="dashicons dashicons-welcome-write-blog"></span>
            <?php echo wpautop( esc_html( $content ) ); ?>
        </div>

        <div class="ezd-feedback-btn">
            <?php 
            $delete_url = add_query_arg([
                'page'          => 'ezd-user-feedback',
                'tab_type'      => 'text',
                'feedback_delete' => $post_id,
                'data_type'     => $data_type,
                '_wpnonce'      => wp_create_nonce( $post_id ),
            ], admin_url( 'admin.php' ) );

            $update_url = add_query_arg([
                'page'          => 'ezd-user-feedback',
                'tab_type'      => 'text',
                'feedback_id'   => $post_id,
                'data_type'     => $data_type,
                '_wpnonce'      => wp_create_nonce( $post_id ),
            ], admin_url( 'admin.php' ) );
            ?>

            <a class="ezd-feedback-delete" href="<?php echo esc_url( $delete_url ); ?>">
                <span class="dashicons dashicons-trash"></span>
            </a>
            <a class="ezd-feedback-update" href="<?php echo esc_url( $update_url ); ?>">
                <span class="dashicons dashicons-<?php echo esc_attr( $icon_class ); ?>"></span>
            </a>
        </div>
    </div>
    <?php
}