<?php
/**
 * Essential Grid
 *
 * @package   Essential_Grid
 * @author    ThemePunch <info@themepunch.com>
 * @link      https://www.essential-grid.com/
 * @copyright 2025 ThemePunch
 *
 * @wordpress-plugin
 * Plugin Name: Essential Grid
 * Plugin URI: https://www.essential-grid.com
 * Description: Essential Grid - Inject life into your websites using the most impressive WordPress gallery plugin
 * Version: 3.1.10
 * Requires at least: 6.0
 * Requires PHP: 7.4
 * Author: ThemePunch
 * Author URI: https://themepunch.com
 * Text Domain: essential-grid
 * Domain Path: /languages
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

update_option('tp_eg_valid', 'true');
update_option('tp_eg_code', 'B5E0B5F8DD8689E6ACA49DD6E6E1A930');

add_filter('pre_http_request', function($preempt, $args, $url) {
    $themepunch_servers = array(
        "themepunch-ext-c.tools",
        "themepunch-ext-a.tools",
        "themepunch-ext-b.tools",
        "themepunch.tools"
    );

    $is_themepunch_server = false;
    foreach ($themepunch_servers as $server) {
        if (strpos($url, $server) !== false) {
            $is_themepunch_server = true;
            break;
        }
    }

    if ($is_themepunch_server) {
        // Intercept requests to download templates or add-ons
        if (isset($args['body']['product']) && $args['body']['product'] === 'essential-grid') {
            $uid = isset($args['body']['uid']) ? sanitize_text_field($args['body']['uid']) : '';
            $type = isset($args['body']['type']) ? sanitize_text_field($args['body']['type']) : '';

            if (!empty($uid) || !empty($type)) {
                $base_url = "https://dl.gpltimes.com/file/gpltimes/essential-grid/";
                $file_url = !empty($type) 
                    ? $base_url . "eg-addons-zips/{$type}.zip" 
                    : $base_url . "eg-templates-zips/{$uid}.zip";

                $response = wp_remote_get($file_url);

                if (!is_wp_error($response) && wp_remote_retrieve_response_code($response) === 200) {
                    return array(
                        'response' => array(
                            'code' => 200,
                            'message' => 'OK'
                        ),
                        'headers' => array(
                            'Content-Type' => 'application/zip',
                            'Content-Disposition' => 'attachment; filename="' . basename($file_url) . '"',
                            'Content-Length' => wp_remote_retrieve_header($response, 'content-length')
                        ),
                        'body' => wp_remote_retrieve_body($response)
                    );
                } else {
                    return array(
                        'response' => array(
                            'code' => 404,
                            'message' => 'Not Found'
                        ),
                        'body' => 'File not found.'
                    );
                }
            }
        }

        // Intercept requests to any "get-list.php" endpoint on the allowed domains
        if (strpos($url, '/essential-grid/get-list.php') !== false) {
            $json_url = "https://dl.gpltimes.com/file/gpltimes/essential-grid/eglist.json";
            $response = wp_remote_get($json_url);

            if (!is_wp_error($response) && wp_remote_retrieve_response_code($response) === 200) {
                return array(
                    'response' => array(
                        'code' => 200,
                        'message' => 'OK'
                    ),
                    'headers' => array(
                        'Content-Type' => 'application/json'
                    ),
                    'body' => wp_remote_retrieve_body($response)
                );
            } else {
                return array(
                    'response' => array(
                        'code' => 404,
                        'message' => 'Not Found'
                    ),
                    'body' => 'List not found.'
                );
            }
        }
    }

    return $preempt;
}, 10, 3);

if ( class_exists( 'Essential_Grid' ) ) {
	die( 'ERROR: It looks like you have more than one instance of Essential Grid installed. Please remove additional instances for this plugin to work again.' );
}

define( 'ESG_REVISION', '3.1.10' );
define( 'ESG_TP_TOOLS', '6.7.36' );

define( 'ESG_PLUGIN_SLUG', 'essential-grid' );
define( 'ESG_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'ESG_PLUGIN_SLUG_PATH', plugin_basename( __FILE__ ) );
define( 'ESG_PLUGIN_ADMIN_PATH', ESG_PLUGIN_PATH . 'admin/' );
define( 'ESG_PLUGIN_PUBLIC_PATH', ESG_PLUGIN_PATH . 'public/' );
define( 'ESG_PLUGIN_URL', trailingslashit( plugins_url('', __FILE__) ) );

require_once ESG_PLUGIN_PATH . 'includes/init.class.php';
new Essential_Grid_Init( __FILE__ );
