<?php
/**
 * Add Divi support to Essential Grid.
 *
 * @package   Essential_Grid
 * @author    ThemePunch <info@themepunch.com>
 * @link      https://www.essential-grid.com/
 * @copyright 2025 ThemePunch
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * Divi Support class.
 */
class Essential_Grid_Builders_Divi {

	/**
	 * Set up hooks.
	 */
	public function __construct() {
		add_action( 'divi_extensions_init', array( $this, 'init' ) );

		// Add support for divi shortcodes in ajax requests.
		add_filter( 'et_builder_load_requests', array( $this, 'add_esg_ajax_action' ) );
	}

	/**
	 * Init Divi Module.
	 *
	 * @return void
	 */
	public function init() {
		// require_once( ESG_PLUGIN_PUBLIC_PATH . 'includes/builders/divi/includes/EsgDivi.php' );
	}

	/**
	 * Add esg ajax action to Divi actions list to load builder and process divi shortcodes
	 *
	 * @param array $actions list of actions supported by Divi.
	 * @return array
	 */
	public function add_esg_ajax_action( $actions ) {
		if ( empty( $actions['action'] ) ) {
			$actions['action'] = array();
		}

		$actions['action'][] = 'Essential_Grid_Front_request_ajax';

		return $actions;
	}
}
