<?php
/**
 * Adds custom post type support for Essential Grid.
 *
 * @package Essential_Grid
 * @author  ThemePunch <info@themepunch.com>
 * @link    https://www.essential-grid.com/
 * @copyright 2025 ThemePunch
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * Post Type Class For Essential Grid.
 * Adds custom post type and taxonomy.
 */
class Essential_Grid_Post_Type {

	const POST_TYPE = 'essential_grid';
	const TAXONOMY  = 'essential_grid_category';

	/**
	 * Instance of this class.
	 *
	 * @var null|object
	 */
	protected static $instance = null;

	/**
	 * Return an instance of this class.
	 *
	 * @return object A single instance of this class.
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Set up hooks.
	 */
	private function __construct() {
		$add_cpt = Essential_Grid_Base::getCpt();
		if ( 'true' === $add_cpt ) {
			add_action( 'init', array( $this, 'register_custom_post_type' ) );
		}
	}

	/**
	 * Register Custom Post Type & Taxonomy.
	 */
	public function register_custom_post_type() {
		$tax_args                      = array();
		$tax_args['hierarchical']      = true;
		$tax_args['label']             = esc_attr__( 'Categories', 'essential-grid' );
		$tax_args['singular_label']    = esc_attr__( 'Category', 'essential-grid' );
		$tax_args['rewrite']           = true;
		$tax_args['public']            = true;
		$tax_args['show_admin_column'] = true;
		register_taxonomy( self::TAXONOMY, array( self::POST_TYPE ), $tax_args );

		$post_args                      = array();
		$post_args['label']             = esc_attr__( 'ESG Posts', 'essential-grid' );
		$post_args['singular_label']    = esc_attr__( 'Grid Post', 'essential-grid' );
		$post_args['public']            = true;
		$post_args['capability_type']   = 'post';
		$post_args['hierarchical']      = false;
		$post_args['show_ui']           = true;
		$post_args['show_in_menu']      = true;
		$post_args['show_in_rest']      = true;
		$post_args['supports']          = array( 'title', 'editor', 'thumbnail', 'author', 'comments', 'excerpt' );
		$post_args['show_in_admin_bar'] = false;
		$post_args['taxonomies']        = array( self::TAXONOMY, 'post_tag' );
		$post_args['rewrite']           = array(
			'slug'       => self::POST_TYPE,
			'with_front' => true,
		);
		register_post_type( self::POST_TYPE, $post_args );
	}
}
