<?php
namespace Elementor;
use Elementor\Widget_base;
use Elementor\Controls_Manager;
use Etn_Pro\Utils\Helper;

defined( "ABSPATH" ) || die();

class Etn_Pro_RSVP_Attendee extends Widget_Base {
    public function get_name() {
        return "etn-rsvp-attendee";
    }

    public function get_title() {
        return esc_html__( "RSVP Attendee", "eventin-pro" );
    }

    public function get_categories() {
        return ["etn-event"];
    }

    public function get_icon() {
        return "eicon-user-circle-o";
    }

    public function register_controls() {
        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__("Rsvp Tab", "eventin-pro")
            ]
        );
        $this->add_control(
            "event_id",
            [
                "label"     => esc_html__("Select Event", "eventin-pro"),
                "type"      => Controls_Manager::SELECT,
                "multiple"  => false,
                "options"   => Helper::get_events(),
            ]
        );
        $this->add_control(
            'show_avatar',
            [
                'label'     => esc_html__('Show Thumbnail', 'eventin-pro'),
                'type'      => Controls_Manager::SWITCHER,
                'label_on'  => esc_html__('Yes', 'eventin-pro'),
                'label_off' => esc_html__('No', 'eventin-pro'),
                'default'   => 'yes',

            ]
        );
        $this->add_control(
            'show_email',
            [
                'label'     => esc_html__('Show Email', 'eventin-pro'),
                'type'      => Controls_Manager::SWITCHER,
                'label_on'  => esc_html__('Yes', 'eventin-pro'),
                'label_off' => esc_html__('No', 'eventin-pro'),
                'default'   => 'yes',

            ]
        );
   
        $this->end_controls_section();

        // Tab Navigation Style Section
        $this->start_controls_section(
            'tab_nav_style_section',
            [
                'label'     => esc_html__('Tab Navigation Style', 'eventin-pro'),
                'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        // Typography for tab navigation
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'tab_nav_typography',
                'label'    => esc_html__('Typography', 'eventin-pro'),
                'selector' => '{{WRAPPER}} .etn-rsvp-tab-wrapper .etn-nav .etn-tab-a',
            ]
        );

        // Padding for tab navigation
        $this->add_responsive_control(
            'tab_nav_padding',
            [
                'label'      => esc_html__('Padding', 'eventin-pro'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .etn-rsvp-tab-wrapper .etn-nav .etn-tab-a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // Tab navigation states (normal and active)
        $this->start_controls_tabs('tab_nav_style_tabs');

        // Normal state
        $this->start_controls_tab(
            'tab_nav_normal',
            [
                'label' => esc_html__('Normal', 'eventin-pro'),
            ]
        );

        $this->add_control(
            'tab_nav_color',
            [
                'label'     => esc_html__('Text Color', 'eventin-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .etn-rsvp-tab-wrapper .etn-nav .etn-tab-a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'tab_nav_bg_color',
            [
                'label'     => esc_html__('Background Color', 'eventin-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .etn-rsvp-tab-wrapper .etn-nav .etn-tab-a' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        // Border for tab navigation
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'tab_nav_border',
                'label'    => esc_html__('Border', 'eventin-pro'),
                'selector' => '{{WRAPPER}} .etn-rsvp-tab-wrapper .etn-nav .etn-tab-a',
            ]
        );

        // Border radius for tab navigation
        $this->add_responsive_control(
            'tab_nav_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'eventin-pro'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .etn-rsvp-tab-wrapper .etn-nav .etn-tab-a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        // Active state
        $this->start_controls_tab(
            'tab_nav_active',
            [
                'label' => esc_html__('Active', 'eventin-pro'),
            ]
        );

        $this->add_control(
            'tab_nav_active_color',
            [
                'label'     => esc_html__('Text Color', 'eventin-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .etn-rsvp-tab-wrapper .etn-nav .etn-tab-a.etn-active' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'tab_nav_active_bg_color',
            [
                'label'     => esc_html__('Background Color', 'eventin-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .etn-rsvp-tab-wrapper .etn-nav .etn-tab-a.etn-active' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'tab_nav_active_border',
                'label'    => esc_html__('Border', 'eventin-pro'),
                'selector' => '{{WRAPPER}} .etn-rsvp-tab-wrapper .etn-nav .etn-tab-a.etn-active',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        // RSVP Card Style Section
        $this->start_controls_section(
            'rsvp_card_style_section',
            [
                'label'     => esc_html__('RSVP Card Style', 'eventin-pro'),
                'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
    
        // Padding for RSVP Card
        $this->add_responsive_control(
            'rsvp_card_padding',
            [
                'label'      => esc_html__('Padding', 'eventin-pro'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .etn-rsvp-tab-wrapper .rsvp-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
    
        // Border for RSVP Card
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'rsvp_card_border',
                'label'    => esc_html__('Border', 'eventin-pro'),
                'selector' => '{{WRAPPER}} .etn-rsvp-tab-wrapper .rsvp-card',
            ]
        );
    
        // Border radius for RSVP Card
        $this->add_responsive_control(
            'rsvp_card_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'eventin-pro'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .etn-rsvp-tab-wrapper .rsvp-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
    
        // Background Color for RSVP Card
        $this->add_control(
            'rsvp_card_bg_color',
            [
                'label'     => esc_html__('Background Color', 'eventin-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .etn-rsvp-tab-wrapper .rsvp-card' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        // Box Shadow for RSVP Card
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'rsvp_card_box_shadow',
                'label'    => esc_html__('Box Shadow', 'eventin-pro'),
                'selector' => '{{WRAPPER}} .etn-rsvp-tab-wrapper .rsvp-card',
            ]
        );
    
    
        $this->end_controls_section();

         // title style section
         $this->start_controls_section(
            'style_section',
            [
                'label'     => esc_html__('Title Style', 'eventin-pro'),
                'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'label'    => esc_html__('Typography', 'eventin-pro'),
                'selector' => '{{WRAPPER}} .etn-rsvp-tab-wrapper .rsvp-name',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__('Color', 'eventin-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .etn-rsvp-tab-wrapper .rsvp-name' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label'      => esc_html__('Margin', 'eventin-pro'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .etn-rsvp-tab-wrapper .rsvp-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

         // email style section
         $this->start_controls_section(
            'email_style_section',
            [
                'label'     => esc_html__('Email Style', 'eventin-pro'),
                'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'email_typography',
                'label'    => esc_html__('Typography', 'eventin-pro'),
                'selector' => '{{WRAPPER}} .etn-rsvp-tab-wrapper .rsvp-email',
            ]
        );

        $this->add_control(
            'meta_color',
            [
                'label'     => esc_html__('Color', 'eventin-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .etn-rsvp-tab-wrapper .rsvp-email' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();

         // status style section
         $this->start_controls_section(
            'status_style_section',
            [
                'label'     => esc_html__('Status Style', 'eventin-pro'),
                'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'status_typography',
                'label'    => esc_html__('Typography', 'eventin-pro'),
                'selector' => '{{WRAPPER}} .etn-rsvp-tab-wrapper .rsvp-status',
            ]
        );

        $this->add_control(
            'status_color',
            [
                'label'     => esc_html__('Color', 'eventin-pro'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .etn-rsvp-tab-wrapper .rsvp-status' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();

    }

    public function render() {
        $settings    = $this->get_settings();
        $id          = !empty($settings['event_id']) ? $settings['event_id'] : 0;
        $show_avatar = $settings['show_avatar'];
        $show_email  = $settings['show_email'];
    
        // Pass these variables to the template
        $instance = [
            'event_id'    => $id,
            'show_avatar' => $show_avatar,
            'show_email'  => $show_email,
        ];
        include ETN_PRO_DIR . "/widgets/rsvp-attendee/style/rsvp-1.php";
    }
}

?>