<?php defined('\ABSPATH') || exit; ?>
<?php
$isDev = \ExternalImporter\application\Plugin::isDevEnvironment();
?>
<div class="ei-card shadow-sm border-0">
    <!-- Stats header -->
    <div class="ei-card-header bg-light">
        <div class="row g-2 align-items-center justify-content-center text-center">
            <?php if ($isDev) : ?>
                <div class="col text-start">
                    <!-- Debug Mode Toggle -->
                    <a
                        id="ei-debug-toggle"
                        href="#"
                        class="p-0 m-0 text-danger d-inline-flex align-items-center gap-1"
                        ng-init="debugPanelOpen = false"
                        ng-click="debugPanelOpen = !debugPanelOpen"
                        aria-controls="ei-debug-panel"
                        ng-attr-aria-expanded="{{ debugPanelOpen ? 'true' : 'false' }}">
                        <span class="ei-chev" aria-hidden="true" ng-class="{'ei-rotate-90': debugPanelOpen}">▸</span>
                        Development mode
                    </a>
                </div>
            <?php endif; ?>
            <div class="col">
                <span class="text-muted"><?php _e('Imported:', 'external-importer'); ?></span>
                <span class="fw-semibold ms-1">{{importStat.success}}</span>
            </div>
            <div class="col">
                <span class="text-muted"><?php _e('In queue:', 'external-importer'); ?></span>
                <span class="fw-semibold ms-1">{{importQueue.length + import_in_progress_count}}</span>
            </div>
            <div class="col">
                <span class="text-muted"><?php _e('Errors:', 'external-importer'); ?></span>
                <span class="fw-semibold ms-1">{{importStat.errors}}</span>
            </div>
        </div>
    </div>
    <?php if ($isDev) \ExternalImporter\application\admin\PluginAdmin::render('_parser_debug'); ?>

    <div class="ei-card-body px-0">
        <?php if (ExternalImporter\application\helpers\WooHelper::isWooInstalled()) : ?>

            <!-- Controls -->
            <div class="ei-controls-toolbar px-2 pb-2 border-bottom">

                <!-- Row 1: Category + AI -->
                <div class="row align-items-center gy-2">
                    <!-- Category -->
                    <div class="col-8 col-md-8 col-lg-9">

                        <select
                            id="ie_default_category"
                            class="form-select form-select-sm"
                            ng-model="importParams.category"
                            ng-init="importParams.category = <?php echo \esc_attr((int) \ExternalImporter\application\admin\WooConfig::getInstance()->option('default_category')); ?>">
                            <?php foreach (ExternalImporter\application\helpers\WooHelper::getCategoryList() as $cid => $cname) : ?>
                                <?php echo '<option ng-value="' . \esc_attr($cid) . '">' . \esc_html($cname)  . '</option>'; ?>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <!-- AI toggle -->
                    <div class="col-4 col-md-4 col-lg-3">
                        <div class="d-flex align-items-center gap-3">
                            <div class="form-check form-switch m-0 d-inline-flex align-items-center gap-2 form-switch-sm">
                                <input
                                    class="form-check-input m-0"
                                    type="checkbox"
                                    id="ie_ai"
                                    role="switch"
                                    ng-model="importParams.applay_ai"
                                    ng-attr-aria-checked="{{ !!(+importParams.applay_ai) }}">
                                <label class="form-check-label small mb-0" for="ie_ai">
                                    <?php _e('AI', 'external-importer'); ?>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Row 2: Select all  + Threads + Automatic + Actions -->
                <div class="row align-items-center gy-2 mt-1">
                    <!-- Select all  -->
                    <div class="col-4 col-md-3 col-lg-2">
                        <div class="d-inline-flex align-items-center gap-2 m-0">
                            <input
                                id="ie_check_all"
                                type="checkbox"
                                ng-model="checkAll"
                                ng-click="toggleSeleted()">
                            <label for="ie_check_all" class="form-check-label small mb-0">
                                <?php _e('Select all', 'external-importer'); ?>
                            </label>
                        </div>
                    </div>

                    <!-- Threads -->
                    <div class="col-4 col-md-3 col-lg-2">
                        <div class="d-flex align-items-center gap-2">
                            <label for="ie_threads" class="form-label small mb-0">
                                <?php _e('Threads', 'external-importer'); ?>
                            </label>
                            <select id="ie_threads" class="form-select form-select-sm w-100" ng-model="importSettings.threads">
                                <option ng-value="1">1</option>
                                <option ng-value="2">2</option>
                                <option ng-value="3">3</option>
                                <option ng-value="4">4</option>
                                <option ng-value="5">5</option>
                                <option ng-value="6">6</option>
                                <option ng-value="7">7</option>
                                <option ng-value="8">8</option>
                                <option ng-value="9">9</option>
                                <option ng-value="10">10</option>
                                <option ng-value="15">15</option>
                            </select>
                        </div>
                    </div>

                    <!-- Automatic toggle -->
                    <div class="col-4 col-md-auto">
                        <div class="form-check form-switch m-0 d-inline-flex align-items-center gap-2 form-switch-sm">
                            <input
                                class="form-check-input m-0"
                                type="checkbox"
                                id="ie_auto"
                                role="switch"
                                ng-model="automaticImport"
                                ng-change="initAutomaticImport()"
                                ng-attr-aria-checked="{{ !!(+automaticImport) }}">
                            <label class="form-check-label small mb-0" for="ie_auto">
                                <?php _e('Automatic import', 'external-importer'); ?>
                            </label>
                        </div>
                    </div>

                    <!-- Actions -->
                    <div class="col text-md-end">
                        <div class="d-flex flex-wrap gap-2 justify-content-md-end">
                            <button ng-click="importSelected()" ng-disabled="!selectedCount()" class="btn btn-outline-primary btn-sm">
                                <?php _e('Import selected', 'external-importer'); ?> ({{selectedCount()}})
                            </button>
                            <button ng-click="deleteAllProducts()" ng-disabled="!products.length" class="btn btn-outline-danger btn-sm">
                                <?php _e('Remove all', 'external-importer'); ?>
                            </button>
                        </div>
                    </div>
                </div>

            </div>

        <?php endif; ?>

        <!-- Products list -->

        <?php
        $dynamic_categories = \ExternalImporter\application\admin\WooConfig::getInstance()->option('dynamic_categories');
        $import_stock_status = \ExternalImporter\application\admin\WooConfig::getInstance()->option('import_stock_status');
        $import_attributes   = \ExternalImporter\application\admin\WooConfig::getInstance()->option('import_attributes');
        $import_gallery      = \ExternalImporter\application\admin\WooConfig::getInstance()->option('import_gallery');
        $import_gtin         = \ExternalImporter\application\admin\WooConfig::getInstance()->option('import_gtin');
        $import_reviews      = \ExternalImporter\application\admin\WooConfig::getInstance()->option('import_reviews');
        $product_type        = \ExternalImporter\application\admin\WooConfig::getInstance()->option('product_type');
        $stock_quantity      = \ExternalImporter\application\admin\WooConfig::getInstance()->option('import_stock_quantity');
        ?>
        <div
            class="product-list"
            fill-to-bottom fill-to-bottom-min="900"
            style="overflow-y:auto; overflow-x:hidden;">

            <div
                class="row product-animate-if align-items-center py-2 px-2 border rounded-2 product-row hoverable"
                ng-repeat="product in products track by $index" ng-if="product"
                ng-class="{
            'bg-warning border-warning bg-opacity-10' : (product._import_in_queue || product._import_in_progress),
            'bg-danger  border-danger bg-opacity-10'  : (product._import_status == 'error'),
            'bg-success border-success bg-opacity-10' : (product._import_status == 'success')
        }">

                <!-- Select -->
                <div class="col-auto p-0 ps-2">
                    <input type="checkbox"
                        ng-model="product._selected"
                        ng-disabled="product._import_in_queue || product._import_status || product._import_in_progress"
                        aria-label="<?php esc_attr_e('Select product', 'external-importer'); ?>">
                </div>

                <!-- Thumb -->
                <div class="col-auto m-0 pe-1 text-center">
                    <div class="ratio ratio-1x1" style="width:90px;">
                        <img ng-src="{{product.image}}" class="img-thumbnail w-100 h-100" style="object-fit:contain;" alt="">
                    </div>
                </div>

                <!-- Title + meta -->
                <div class="col-12 col-lg d-flex flex-column gap-1">
                    <div class="d-flex align-items-start gap-1">
                        <div class="fw-semibold clamp-2 flex-grow-1" title="{{ product.title }}">
                            {{ product.title }}
                        </div>

                        <!-- Tiny JSON link -->
                        <a href=""
                            class="json-link small opacity-75 text-decoration-none flex-shrink-0 ms-1"
                            ng-click="openJson(product, $index, $event)"
                            aria-label="<?php esc_attr_e('View raw product data', 'external-importer'); ?>"
                            title="<?php esc_attr_e('View raw product data', 'external-importer'); ?>">
                            { }
                        </a>
                    </div>

                    <?php if ($dynamic_categories == 'nested') : ?>
                        <div class="text-muted small clamp-2"
                            ng-if="product.categoryPath && product.categoryPath.length"
                            title="{{ product.categoryPath.join(' » ') }}">
                            {{ product.categoryPath.join(' » ') }}
                        </div>
                    <?php endif; ?>

                    <div class="text-muted small">

                        <span class="me-2 d-inline-flex align-items-center align-middle">
                            <img width="12" height="12" class="me-1 align-middle" ng-src="https://www.google.com/s2/favicons?domain={{product.domain}}" alt="">
                            <a class="link-secondary text-decoration-none d-inline-flex"
                                target="_blank" rel="noopener" href="{{product.link}}">
                                {{product.domain}}
                                <span class="ms-1 small opacity-50" aria-hidden="true">↗</span>
                            </a>
                        </span>

                        <!-- In stock -->
                        <span class="ei-status text-muted me-2 text-nowrap d-inline-flex align-middle"
                            ng-if="product.inStock && product.availability != 'Backorder'">
                            <span class="ei-dot ei-dot--success" aria-hidden="true"></span>
                            <?php _e('In stock', 'external-importer'); ?>
                        </span>

                        <!-- Out of stock -->
                        <span class="ei-status text-danger me-2 text-nowrap d-inline-flex align-middle"
                            ng-if="!product.inStock && product.availability != 'Backorder'">
                            <span class="ei-dot ei-dot--danger" aria-hidden="true"></span>
                            <?php _e('Out of stock', 'external-importer'); ?>
                        </span>

                        <!-- Backorder -->
                        <span class="ei-status text-warning me-2 text-nowrap d-inline-flex align-middle"
                            ng-if="product.availability == 'Backorder'">
                            <span class="ei-dot ei-dot--warning" aria-hidden="true"></span>
                            <?php _e('Backorder', 'external-importer'); ?>
                        </span>

                        <?php if ($import_attributes) : ?>
                            <span class="me-2 text-nowrap align-middle" ng-show="product.features.length"><?php _e('Attributes', 'external-importer'); ?>: {{product.features.length}}</span>
                        <?php endif; ?>

                        <?php if ($import_reviews) : ?>
                            <span class="me-2 text-nowrap align-middle" ng-show="product.reviews.length"><?php _e('Reviews', 'external-importer'); ?>: {{product.reviews.length}}</span>
                        <?php endif; ?>

                        <?php if ($import_gallery) : ?>
                            <span class="me-2 text-nowrap align-middle" ng-show="product.images.length"><?php _e('Gallery images', 'external-importer'); ?>: {{product.images.length}}</span>
                        <?php endif; ?>

                        <?php if ($stock_quantity) : ?>
                            <span class="me-2 text-nowrap align-middle" ng-if="product.stockQuantity != null && product.stockQuantity !== '' && !isNaN(Number(product.stockQuantity))">
                                <?php _e('Quantity', 'external-importer'); ?>: {{product.stockQuantity}}
                            </span>
                        <?php endif; ?>

                        <span class="me-2 text-nowrap align-middle" ng-show="product.variations.length"><?php _e('Variations', 'external-importer'); ?>: {{product.variations.length}}</span>

                        <?php if ($import_gtin) : ?>
                            <span class="me-2 text-nowrap align-middle" ng-show="product.gtin"><?php _e('GTIN', 'external-importer'); ?>: {{product.gtin}}</span>
                        <?php endif; ?>

                        <?php if ($dynamic_categories == 'nested') : ?>
                            <span class="me-2 align-middle" ng-if="product.category && product.categoryPath.length < 1"><span class="text-info">{{product.category}}</span></span>
                        <?php elseif ($dynamic_categories == 'create') : ?>
                            <span class="me-2 align-middle" ng-if="product.category"><span class="text-info">{{product.category}}</span></span>
                        <?php endif; ?>

                        <div class="text-danger mt-1" ng-show="product._import_message">{{product._import_message}}</div>
                    </div>
                </div>

                <!-- Right-side controls -->
                <div class="col-12 col-sm-6 col-md-auto">
                    <div class="position-relative"><!-- pin the close button -->
                        <div class="d-flex align-items-start gap-2 pe-4"><!-- leave space for the X -->

                            <!-- Stack: Price + Import control/badge -->
                            <div class="d-flex flex-column align-items-center gap-2 flex-grow-1"><!-- centered + grows -->

                                <!-- Price -->
                                <div class="text-center" ng-if="hasPrice(product.price) || hasPrice(product.oldPrice)">
                                    <span class="fw-semibold d-block" ng-show="hasPrice(product.price)">
                                        {{ product.price | intlCurrency:product.currencyCode }}
                                    </span>
                                    <del class=" text-muted d-block" ng-if="hasPrice(product.oldPrice)">
                                        {{ product.oldPrice | intlCurrency:product.currencyCode }}
                                    </del>
                                </div>

                                <?php if (ExternalImporter\application\helpers\WooHelper::isWooInstalled()) : ?>
                                    <div
                                        class="import-slot d-inline-flex align-items-center justify-content-center"
                                        aria-live="polite" aria-atomic="true"
                                        style="width:7.5rem; height:2rem;"> <!-- fixed width = zero shift -->

                                        <button
                                            type="button"
                                            class="btn btn-sm d-inline-flex align-items-center justify-content-center position-relative px-3 w-100 h-100 text-nowrap"
                                            ng-class="{'btn-outline-primary': !product._import_status,'btn-outline-success': product._import_status === 'success','btn-outline-danger' : product._import_status === 'error'}"
                                            ng-disabled="product._import_in_queue || product._import_in_progress || product._import_status === 'success' || product._import_status === 'error'"
                                            ng-click="addToImportQueue($index)"
                                            ng-attr-aria-busy="{{ product._import_in_progress ? 'true' : 'false' }}"
                                            ng-attr-title="{{ product._import_status === 'error' ? (product._import_message || '') : '' }}">

                                            <!-- Ghost: reserves width for the widest visible label -->
                                            <span class="invisible">Imported</span>

                                            <span class="position-absolute top-50 start-50 translate-middle"
                                                ng-class="{'opacity-0': product._import_in_progress}"
                                                ng-switch="product._import_status">
                                                <span ng-switch-when="success"><?php esc_html_e('Imported', 'external-importer'); ?></span>
                                                <span ng-switch-when="error"><?php esc_html_e('Failed', 'external-importer'); ?></span>
                                                <span ng-switch-default><?php esc_html_e('Import', 'external-importer'); ?></span>
                                            </span>

                                            <!-- Spinner layer (always mounted) -->
                                            <span class="position-absolute top-50 start-50 translate-middle"
                                                ng-class="{'opacity-0': !product._import_in_progress}">
                                                <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                                <span class="visually-hidden"><?php esc_html_e('Importing…', 'external-importer'); ?></span>
                                            </span>
                                        </button>
                                    </div>
                                <?php endif; ?>

                            </div>
                            <!-- /Stack -->
                        </div>

                        <button
                            type="button"
                            class="btn-close position-absolute top-0 end-0 mt-1"
                            aria-label="<?php esc_attr_e('Remove', 'external-importer'); ?>"
                            ng-disabled="product._import_in_queue || product._import_status || product._import_in_progress"
                            ng-click="deleteProduct($index)">
                        </button>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<!-- JSON Modal -->
<div class="modal fade" id="eiJsonModal"
    tabindex="-1"
    role="dialog"
    aria-labelledby="eiJsonModalLabel"
    aria-modal="true"
    aria-hidden="true"
    data-bs-backdrop="true"
    data-bs-keyboard="true">
    <div class="modal-dialog modal-lg modal-dialog-scrollable">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="eiJsonModalLabel">
                    <?php echo esc_html(__('Product data', 'external-importer')); ?>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"
                    aria-label="<?php esc_attr_e('Close', 'external-importer'); ?>"></button>
            </div>

            <div class="modal-body border-0 border-start border-4 border-info-subtle bg-light-subtle">
                <pre class="small font-monospace mb-0 text-break" style="max-height:60vh; white-space:pre-wrap;">{{ currentProduct | json }}</pre>
            </div>

            <div class="modal-footer py-2">
                <button type="button" class="btn btn-sm btn-outline-secondary" data-bs-dismiss="modal">
                    <?php esc_html_e('Close', 'external-importer'); ?>
                </button>
            </div>

        </div>
    </div>
</div>