<?php
defined('\ABSPATH') || exit;

$isDev = \ExternalImporter\application\Plugin::isDevEnvironment();
$d = \get_option(base64_decode('Z' . 'Xhp' . 'X3N5c' . '19kZWF' . 'kbGl' . 'uZQ=='), 0);
?>

<div class="wrap nosubsub">
    <h1 class="wp-heading-inline"><?php _e('Product Import', 'external-importer'); ?></h1>

    <div ng-app="externalImporter" class="cegg5-container" id="external-importer">
        <div ng-controller="ExternalImporterController" ng-cloak>
            <div class="row g-3">
                <!-- Left: Import area -->
                <div id="ei-import-area" class="col-md-8">

                    <div class="ei-card">
                        <div class="ei-card-header p-0">
                            <ul class="nav nav-tabs px-3 pt-2" id="eiTabs" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="listing-tab" data-bs-toggle="tab"
                                        data-bs-target="#listing" type="button" role="tab"
                                        aria-controls="listing" aria-selected="true">
                                        <?php _e('Listing', 'external-importer'); ?>
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="products-tab" data-bs-toggle="tab"
                                        data-bs-target="#products" type="button" role="tab"
                                        aria-controls="products" aria-selected="false">
                                        <?php _e('Products', 'external-importer'); ?>
                                    </button>
                                </li>
                            </ul>
                        </div>
                        <div class="ei-card-body">
                            <div class="tab-content" id="eiTabsContent">

                                <!-- Listing tab pane -->
                                <div class="tab-pane show active" id="listing" role="tabpanel" aria-labelledby="listing-tab">
                                    <fieldset class="ei-import-tab">
                                        <legend class="visually-hidden"><?php _e('Listing import', 'external-importer'); ?></legend>

                                        <input type="hidden" ng-model="listingProcessor.params.salt">

                                        <div class="input-group">
                                            <input <?php if ($d): ?>disabled<?php else: ?>ng-disabled="loading" <?php endif; ?>
                                                id="ie_listing_url"
                                                type="url"
                                                ng-model="listingProcessor.params.url"
                                                select-on-click
                                                on-enter="startImport('listingProcessor')"
                                                class="form-control form-control-sm font-monospace"
                                                placeholder="<?php _e('Enter Listing URL', 'external-importer'); ?>"
                                                aria-label="<?php _e('Enter Listing URL', 'external-importer'); ?>">
                                            <button
                                                type="button"
                                                class="btn btn-action"
                                                ng-class="loading ? 'btn-warning' : 'btn-primary'"
                                                ng-click="loading ? stopImport('listingProcessor') : startImport('listingProcessor')"
                                                ng-disabled="!loading && !hasUrls(listingProcessor.params.url)">
                                                <span ng-if="loading"><?php echo _e('Stop', 'external-importer'); ?></span>
                                                <span ng-if="!loading"><?php _e('Extract', 'external-importer'); ?></span>
                                            </button>

                                        </div>

                                        <div class="row align-items-center g-2 mt-2">
                                            <div class="col-auto">
                                                <label
                                                    for="ie_max_results"
                                                    class="col-form-label small"
                                                    data-bs-toggle="tooltip"
                                                    data-bs-placement="top"
                                                    title="<?php echo esc_attr__('Maximum number of products that will be extracted.', 'external-importer'); ?>">
                                                    <?php _e('Max', 'external-importer'); ?>
                                                </label>
                                            </div>

                                            <div class="col-auto">
                                                <input ng-disabled="loading" id="ie_max_results" type="number" min="1" step="1"
                                                    ng-model="listingProcessor.params.max_count" class="form-control form-control-sm" style="width:90px;">
                                            </div>
                                            <div class="col-auto">
                                                <div class="form-check form-switch m-0 d-inline-flex align-items-center gap-2 form-switch-sm flex-fix">
                                                    <input
                                                        class="form-check-input m-0"
                                                        type="checkbox"
                                                        id="ie_automatic_pagination"
                                                        ng-model="listingProcessor.params.automatic_pagination"
                                                        ng-disabled="loading"
                                                        ng-attr-aria-checked="{{ !!(+listingProcessor.params.automatic_pagination) }}">
                                                    <label class="form-check-label small mb-0" for="ie_automatic_pagination">
                                                        <?php _e('Auto pagination', 'external-importer'); ?>
                                                    </label>
                                                </div>

                                            </div>
                                        </div>

                                    </fieldset>
                                </div>

                                <!-- Products tab pane -->
                                <div class="tab-pane" id="products" role="tabpanel" aria-labelledby="products-tab">
                                    <fieldset class="ei-import-tab">
                                        <legend class="visually-hidden"><?php _e('Products import', 'external-importer'); ?></legend>

                                        <input type="hidden" ng-model="productProcessor.params.salt">

                                        <div class="row g-2">
                                            <div class="col-md-10">
                                                <textarea id="ie_products_urls"
                                                    spellcheck="false" autocorrect="off" autocapitalize="off"
                                                    ng-model="productProcessor.params.urls" <?php if ($d): ?>disabled<?php else: ?>ng-disabled="loading" <?php endif; ?>
                                                    class="form-control form-control-sm font-monospace" rows="4"
                                                    placeholder="<?php _e('Enter one Product URL per line', 'external-importer'); ?>"></textarea>
                                            </div>
                                            <div class="col-md-2 d-grid align-content-start gap-2">
                                                <button
                                                    type="button"
                                                    class="btn"
                                                    ng-class="loading ? 'btn-warning' : 'btn-primary'"
                                                    ng-click="loading ? stopImport('productProcessor') : startImport('productProcessor')"
                                                    ng-disabled="!loading && !hasUrls(productProcessor.params.urls)">

                                                    <span ng-if="loading"><?php echo _e('Stop', 'external-importer'); ?></span>
                                                    <span ng-if="!loading"><?php _e('Extract', 'external-importer'); ?></span>
                                                </button>
                                                <button ng-show="!loading" ng-disabled="!productProcessor.params.urls" ng-click="restartImport('productProcessor');" type="button" class="btn btn-outline-secondary"><?php _e('Retry', 'external-importer'); ?></button>
                                            </div>
                                        </div>
                                    </fieldset>
                                </div>

                            </div>
                        </div>
                    </div>

                    <?php \ExternalImporter\application\admin\PluginAdmin::render('_products'); ?>
                </div>

                <!-- Right: Status & Log -->
                <div class="col-md-4">
                    <div class="ei-card">
                        <div class="ei-card-header p-0">
                            <div class="row text-center stat-badge pt-1 pb-2">
                                <div class="col-4">
                                    <div class="small text-muted"><?php _e('Fetched', 'external-importer'); ?></div>
                                    <div class="fw-semibold">
                                        {{stat.success}}
                                    </div>
                                </div>
                                <div class="col-4">
                                    <div class="small text-muted"><?php _e('Pending', 'external-importer'); ?></div>
                                    <div class="fw-semibold">{{stat.new}}</div>
                                </div>
                                <div class="col-4">
                                    <div class="small text-muted"><?php _e('Errors', 'external-importer'); ?></div>
                                    <div class="fw-semibold">{{stat.errors}}</div>
                                </div>
                            </div>

                        </div>
                        <div class="ei-card-body">
                            <div class="d-flex align-items-center flex-nowrap gap-3 p-2 pb-3">

                                <!-- Status (spinner + text) -->
                                <div
                                    class="d-inline-flex align-items-center gap-2 status-slot"
                                    role="status" aria-live="polite" aria-atomic="true"
                                    ng-class="{'invisible': !(in_progress || in_waiting)}"
                                    ng-attr-aria-busy="{{ (in_progress || in_waiting) ? 'true' : 'false' }}"
                                    style="min-width:0">
                                    <span
                                        class="d-inline-block"
                                        aria-hidden="true"
                                        ng-class="{'text-primary spinner-grow spinner-grow-sm': in_progress || (in_waiting && (+settings.timeout === 0)),'text-secondary spinner-border spinner-border-sm': !in_progress && in_waiting && (+settings.timeout !== 0)}">
                                    </span>

                                    <span class="small text-truncate">
                                        <!-- Fast mode: collapse 'Waiting…' into 'Processing…' -->
                                        <span ng-show="in_progress || (in_waiting && (+settings.timeout === 0))">
                                            <?php esc_html_e('Processing…', 'external-importer'); ?>
                                        </span>
                                        <span ng-show="!in_progress && in_waiting && (+settings.timeout !== 0)">
                                            <?php esc_html_e('Waiting…', 'external-importer'); ?>
                                        </span>
                                    </span>
                                </div>

                                <div class="ms-auto d-flex align-items-center gap-2 flex-nowrap">
                                    <label for="ie_timeout" class="mb-0 small">
                                        <?php esc_html_e('Delay', 'external-importer'); ?>
                                    </label>
                                    <select
                                        id="ie_timeout"
                                        class="form-select form-select-sm w-auto"
                                        ng-model="settings.timeout"
                                        <?php if ($isDev) : ?>ng-init="settings.timeout = 0" <?php endif; ?>>
                                        <option ng-value="0"><?php esc_html_e('0 sec', 'external-importer'); ?></option>
                                        <option ng-value="1"><?php esc_html_e('1 sec', 'external-importer'); ?></option>
                                        <option ng-value="2"><?php esc_html_e('2 sec', 'external-importer'); ?></option>
                                        <option ng-value="3"><?php esc_html_e('3 sec', 'external-importer'); ?></option>
                                        <option ng-value="4"><?php esc_html_e('4 sec', 'external-importer'); ?></option>
                                        <option ng-value="5"><?php esc_html_e('5 sec', 'external-importer'); ?></option>
                                        <option ng-value="6"><?php esc_html_e('6 sec', 'external-importer'); ?></option>
                                        <option ng-value="7"><?php esc_html_e('7 sec', 'external-importer'); ?></option>
                                        <option ng-value="10"><?php esc_html_e('10 sec', 'external-importer'); ?></option>
                                        <option ng-value="15"><?php esc_html_e('15 sec', 'external-importer'); ?></option>
                                        <option ng-value="30"><?php esc_html_e('30 sec', 'external-importer'); ?></option>
                                        <option ng-value="-1"><?php esc_html_e('Rand (1–5)', 'external-importer'); ?></option>
                                        <option ng-value="-2"><?php esc_html_e('Rand (1–10)', 'external-importer'); ?></option>
                                    </select>
                                </div>

                            </div>
                        </div>

                        <div class="ei-card-footer text-center small text-muted d-flex flex-column gap-2">

                            <div class="d-flex flex-wrap align-items-center justify-content-center gap-2">

                                <!-- Parsers -->
                                <div class="d-inline-flex align-items-center gap-1 text-truncate"
                                    title="<?php esc_attr_e('Last used parsers', 'external-importer'); ?>">

                                    <!-- Hide only if: provider exists AND parsers >= 2 -->
                                    <span class="fw-semibold"
                                        ng-if="!usedProvider || (usedParsers && usedParsers.length < 2)">
                                        <?php esc_html_e('Parsers:', 'external-importer'); ?>
                                    </span>

                                    <span ng-if="usedParsers && usedParsers.length"
                                        class="text-truncate">
                                        {{ usedParsers.join(', ') }}
                                    </span>

                                    <span ng-if="!usedParsers || !usedParsers.length">
                                        <?php esc_html_e('N/A', 'external-importer'); ?>
                                    </span>
                                </div>

                                <!-- Separator -->
                                <span ng-if="usedProvider">•</span>

                                <!-- Provider / Crawler -->
                                <div class="d-inline-flex align-items-center gap-1 text-truncate"
                                    ng-if="usedProvider"
                                    title="<?php esc_attr_e('Crawler', 'external-importer'); ?>">

                                    <span class="text-truncate">
                                        {{ usedProvider }}
                                    </span>
                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="ei-card">
                        <div class="ei-card-header ">
                            <?php _e('Activity Log', 'external-importer'); ?>
                        </div>
                        <div fill-to-bottom fill-to-bottom-min="1010" class="ei-card-body p-0" style="max-height: 1050px; overflow-y: auto;">
                            <ul class="list-group list-group-flush ei-activity-log">
                                <li ng-repeat="l in log track by $index"
                                    class="list-group-item small m-0"
                                    ng-bind-html="l.message"
                                    ng-class="{
                                        'list-group-item-danger': l.type == 'error',
                                        'list-group-item-light': l.type == 'success',
                                        'list-group-item-info': l.type == 'info',
                                        'list-group-item-warning': l.type == 'warning'
                                    }"></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div><!-- /.row -->

        </div>
    </div>
</div>