<?php

namespace ExternalImporter\application\components\ai;

use function ExternalImporter\prn;
use function ExternalImporter\prnx;

defined('\ABSPATH') || exit;

/**
 * Prompt class file
 *
 * @author keywordrush.com <support@keywordrush.com>
 * @link https://www.keywordrush.com
 * @copyright Copyright &copy; 2025 keywordrush.com
 */

class Prompt
{
    protected $lang; // Output Language
    protected $input_language; // Input Language
    protected $temperature;
    protected $client;

    public function __construct($api_key, $model, $models = array())
    {
        $this->client = AiClient::createClient($api_key, $model, $models);
    }

    public function setLang($lang)
    {
        $this->lang = $lang;
    }

    public function setInputLang($lang)
    {
        $this->input_language = $lang;
    }

    public function setTemperature($temperature)
    {
        $this->temperature = (float) $temperature;
    }

    protected function query(string $prompt, array $params = [], array $aiParams = []): string
    {
        $params = $this->prepareParams($params, $prompt);
        $finalPrompt = PromptHelper::build($prompt, $params);

        $systemParts = [];

        if (!empty($this->input_language) && $this->input_language !== $this->lang)
        {
            $systemParts[] = sprintf('Input language is %s.', $this->input_language);
        }

        if (!empty($this->lang))
        {
            $systemParts[] = sprintf('Output language is %s. Make sure you answer in %s!', $this->lang, $this->lang);
        }

        $systemMessage = count($systemParts) ? implode("\n", $systemParts) : '';

        if (!empty($this->temperature) && !isset($aiParams['temperature']))
        {
            $aiParams['temperature'] = $this->temperature;
        }

        // GPT-5 models do not support temperature settings
        if (isset($aiParams['temperature']) && strpos($this->client->getModel(), 'gpt-5') !== false)
        {
            unset($aiParams['temperature']);
        }

        $rawContent = $this->client->query($finalPrompt, $systemMessage, $aiParams);

        $fixedContent = ContentHelper::fixAiResponse($rawContent);
        if (ContentHelper::isAiGenerated($fixedContent))
        {
            return '';
        }

        return $fixedContent;
    }

    protected function prepareParams(array $params, $prompt = '')
    {
        return $params;
    }
}
