<?php

namespace ExternalImporter\application\components\scrap;

defined('\ABSPATH') || exit;

use ExternalImporter\application\components\scrap\CrawlbaseScrap;
use ExternalImporter\application\components\scrap\ScraperapiScrap;
use ExternalImporter\application\components\scrap\ScrapingdogScrap;
use ExternalImporter\application\components\scrap\ScrapeowlScrap;

/**
 * ScrapFactory class file
 *
 * @author keywordrush.com <support@keywordrush.com>
 * @link https://www.keywordrush.com
 * @copyright Copyright &copy; 2025 keywordrush.com
 */
class ScrapFactory
{
    public static $services = array(
        ScraperapiScrap::SLUG => ScraperapiScrap::class,
        ScrapingdogScrap::SLUG => ScrapingdogScrap::class,
        ScrapeowlScrap::SLUG => ScrapeowlScrap::class,
        CrawlbaseScrap::SLUG => CrawlbaseScrap::class,
    );

    public static function init()
    {
        foreach (self::$services as $slug => $class)
        {
            $scrap = new $class();
            $scrap->initAction();
        }
    }
}
