<?php

namespace ExternalImporter\application\components\scrap;

defined('\ABSPATH') || exit;

/**
 * ScrapeowlScrap class file
 *
 * @author keywordrush.com <support@keywordrush.com>
 * @link https://www.keywordrush.com
 * @copyright Copyright &copy; 2025 keywordrush.com
 */
class ScrapeowlScrap extends Scrap
{
    const SLUG = 'scrapeowl';

    public function doAction($url, $args)
    {
        // Find the first matching routing rule for this URL
        $rule = $this->getRoutingRuleForUrl($url);

        // If there is no matching rule, or it's for another provider, just return original URL.
        if (!$rule || !isset($rule['provider']) || $rule['provider'] !== $this->getSlug())
        {
            return $url;
        }

        // Mark this provider as used for this URL
        $this->markScrapingServiceUsed($url, $rule);

        // Base query args for ScrapeOwl
        $query_args = array(
            'api_key'       => $this->getToken(),
            'json_response' => 'false',
            'url'           => $url,
        );

        // Extra params from rule, but do not allow overriding api_key or url
        $extra = $this->getExtraParamsFromRule($rule, array('api_key', 'url'));

        if (!empty($extra))
        {
            $query_args = array_merge($query_args, $extra);
        }

        $api_endpoint = 'https://api.scrapeowl.com/v1/scrape';
        $query_args = array_map('rawurlencode', $query_args);

        $url = add_query_arg($query_args, $api_endpoint);

        $url = \apply_filters('ei_parse_url_' . $this->getSlug(), $url);

        return $url;
    }
}
