<?php

namespace ExternalImporter\application\helpers;

defined('\ABSPATH') || exit;

use ExternalImporter\application\libs\pextractor\Extractor;
use ExternalImporter\application\admin\ParserConfig;
use ExternalImporter\application\admin\WooConfig;
use ExternalImporter\application\components\CurlProxy;
use ExternalImporter\application\components\Throttler;
use ExternalImporter\application\components\scrap\ScrapFactory;
use ExternalImporter\application\components\WooImporter;
use ExternalImporter\application\exceptions\ParserWarning;
use ExternalImporter\application\exceptions\ParserException;

use function ExternalImporter\prnx;

/**
 * ParserHelper class file
 *
 * @author keywordrush.com <support@keywordrush.com>
 * @link https://www.keywordrush.com
 * @copyright Copyright &copy; 2025 keywordrush.com
 */
class ParserHelper
{

    private static $extractor = null;

    public static function parseListing($url, $formats = null)
    {
        self::$extractor = new Extractor();
        $error = '';
        $error_code = 0;
        $listing = null;
        $httpOptions = array();
        if ($cookie = ParserConfig::getInstance()->getCookieByUrl($url))
            $httpOptions['headers'] = array('Cookie' => $cookie);

        ScrapFactory::init();

        try
        {
            CurlProxy::initProxy($url);
            $listing = self::$extractor->extractListing($url, ParserConfig::getInstance()->getExtractorConfig(), null, $formats, $httpOptions);
        }
        catch (\Exception $e)
        {
            $error = $e->getMessage();
            $error_code = $e->getCode();
        }

        if (!$listing && !$error)
        {
            $error = __('Products not found', 'external-importer');
            $error_code = 1;
        }

        Throttler::addQueryLog($url, $error_code);

        if ($error)
            throw new \Exception($error, $error_code);
        else
            return $listing;
    }

    public static function maybeParseProduct($url, $update_mode = false, $formats = null)
    {
        if (WooConfig::getInstance()->option('avoid_duplicates') && WooImporter::isProductExistsByUrl($url))
        {
            throw new ParserWarning(__('Product already exists.', 'external-importer'), 409);
        }
        return self::parseProduct($url, $update_mode, $formats);
    }

    public static function parseProduct($url, $update_mode = false, $formats = null)
    {
        self::$extractor = new Extractor();
        $error = '';
        $error_code = 0;
        $product = null;
        $httpOptions = array();
        if ($cookie = ParserConfig::getInstance()->getCookieByUrl($url))
            $httpOptions['headers'] = array('Cookie' => $cookie);

        ScrapFactory::init();

        try
        {
            CurlProxy::initProxy($url);
            $config = ParserConfig::getInstance()->getExtractorConfig();
            $product = self::$extractor->extractProduct($url, $config, null, $formats, $httpOptions, $update_mode);
        }
        catch (\Exception $e)
        {
            $error = $e->getMessage();
            $error_code = $e->getCode();
        }

        if (!$error && !$product)
        {
            $error = __('Unable to extract product data.', 'external-importer');
            $error_code = 1;
        }

        Throttler::addQueryLog($url, $error_code);

        if ($error)
            throw new ParserException($error, $error_code);
        else
            return $product;
    }

    public static function getLastExtractor()
    {
        return self::$extractor;
    }
}
