<?php

namespace ExternalImporter\application\libs\pextractor\parser\parsers;

defined('\ABSPATH') || exit;

use ExternalImporter\application\libs\pextractor\parser\Product;

use function ExternalImporter\prn;
use function ExternalImporter\prnx;

/**
 * CoolblueAdvanced class file
 *
 * @author keywordrush.com <support@keywordrush.com>
 * @link https://www.keywordrush.com
 * @copyright Copyright &copy; 2025 keywordrush.com
 */
class CoolblueAdvanced extends AdvancedParser
{

    public function parseLinks()
    {
        $path = array(
            ".//*[@id='direct-naar-resultaten' or @id='facet_productlist']//h2/a/@href",
            ".//div[contains(@class, 'product-card__title')]//a[@class='link']/@href",
            ".//*[@class='product__display']//a/@href",
            ".//a[contains(@class, 'product__title')]//a[@class='link']/@href",
            ".//*[@class='productlist_item_top_product']//h4/a/@href",
        );

        return $this->xpathArray($path);
    }

    public function parsePagination()
    {
        $path = array(
            ".//ul[@class='pagination']//li/a/@href",
        );

        return $this->xpathArray($path);
    }

    public function parseDescription()
    {
        $paths = array(
            ".//div[@id='product-information']//section[@class='css-1u8qly9']",
        );

        return $this->xpathScalar($paths, true);
    }

    public function parseSku()
    {
        if (preg_match('/Fabrikantcode<\/p><\/td><td[^>]*>([^<]+)<\/td>/', $this->html, $matches))
        {
            return $matches[1];
        }
    }

    public function parseOldPrice()
    {
        $paths = array(
            ".//span[@class='sales-price__former-price']",
            ".//div[@class='grid-section-xs--gap-4']//*[@class='sales-price__former-price']",
        );

        return $this->xpathScalar($paths);
    }

    public function parseImages()
    {
        $xpath = [
            ".//label/img[@width='80']/@src",
        ];

        $images = $this->xpathArray($xpath);

        $images = array_map(function ($image)
        {
            return str_replace('/max/80xauto/', '/max/500x500/', $image);
        }, $images);

        return $images;
    }

    public function parseCategoryPath()
    {
        $paths = array(
            ".//ol[contains(@class, 'breadcrumbs')]/li/a",
        );

        if ($categs = $this->xpathArray($paths))
        {
            array_shift($categs);
            return $categs;
        }
    }

    public function getFeaturesXpath()
    {
        return array(
            array(
                'name' => ".//div[h3[normalize-space(text())='Belangrijkste eigenschappen']]//table//td[2]",
                'value' => ".//div[h3[normalize-space(text())='Belangrijkste eigenschappen']]//table//td[3]",
            ),
            array(
                'name' => ".//div[h3[normalize-space(text())='Korte specificaties']]//table//td[2]",
                'value' => ".//div[h3[normalize-space(text())='Korte specificaties']]//table//td[3]",
            ),
        );
    }

    public function parseFeatures()
    {
        if (!$xpaths = $this->getFeaturesXpath())
            return array();

        if (isset($xpaths['name']))
            $xpaths = array($xpaths);

        foreach ($xpaths as $xpath)
        {
            $names = $values = array();

            if (isset($xpath['name']) && isset($xpath['value']))
            {
                $names = $this->xpathArray($xpath['name'], true);
                $values = $this->xpathArray($xpath['value'], true);
            }

            if (!$names || !$values || count($names) != count($values))
                continue;

            $features = array();
            for ($i = 0; $i < count($names); $i++)
            {
                $feature = array();
                $name = $names[$i];

                $name = preg_replace('#<style.*?>.*?</style>#si', '', $name);
                $name = strip_tags($name);
                $name = trim(\sanitize_text_field($name), " \r\n:-");

                $value = $values[$i];
                if (stripos($values[$i], '"Nee"') !== false)
                    $value = 'Nee';
                elseif (stripos($values[$i], '"Ja"') !== false)
                    $value = 'Ja';

                $value = trim(\sanitize_text_field($value), " \r\n:-");

                if (!$name || !$value)
                    continue;

                $feature['name'] = $name;
                $feature['value'] = $value;

                if (in_array($feature['name'], array('Condition')))
                    continue;
                $features[] = $feature;
            }
            if ($features)
                return $features;
        }
        return array();
    }

    public function afterParseFix(Product $product)
    {
        $product->image = str_replace('/422x390/', '/max/500x500/', $product->image);

        if ($product->features)
        {
            foreach ($product->features as $i => $feature)
            {
                if ($feature['name'] == 'Fabrikantcode')
                    $product->mpn = $feature['value'];

                if (in_array($feature['name'], array('Afhandeling van je defect', 'Artikelnummer')))
                    unset($product->features[$i]);
            }
            $product->features = array_values($product->features);
        }

        return $product;
    }
}
