<?php

namespace ExternalImporter\application\libs\pextractor\parser\parsers;

use function ExternalImporter\prnx;

defined('\ABSPATH') || exit;

/**
 * RozetkacomuaAdvanced class file
 *
 * @author keywordrush.com <support@keywordrush.com>
 * @link https://www.keywordrush.com
 * @copyright Copyright &copy; 2025 keywordrush.com
 */
class RozetkacomuaAdvanced extends AdvancedParser
{

    public function parseLinks()
    {
        $path = array(
            ".//a[@class='tile-title black-link text-base']/@href",
            ".//a[@class='goods-tile__heading']/@href",
        );

        if ($urls = $this->xpathArray($path))
            return $urls;

        if (preg_match_all('/price_pcs&q;:&q;.+?&q;,&q;href&q;:&q;(.+?)&q;,&q;comments_amount/', $this->html, $matches))
            return $matches[1];
    }

    public function parseCategoryPath()
    {
        $paths = array(
            ".//rz-breadcrumbs//a",
        );

        $categs = $this->xpathArray($paths);

        // remove first
        if (isset($categs[0]))
        {
            array_shift($categs);
        }

        return $categs;
    }

    public function parsePagination()
    {
        $path = array(
            ".//div[@class='paginator']//a/@href",
        );

        return $this->xpathArray($path);
    }

    public function parseDescription()
    {

        $xpath = array(
            ".//div[contains(@class, 'product-about__sticky')]//p[@class='mt-4']",
            ".//rz-store-rich-content",
            ".//div[contains(@class, 'product-about__description-content')]",
        );

        $desc =  $this->xpathScalar($xpath, true);

        $desc = preg_replace('/<style.*?<\/style>/is', '', $desc);
        $desc = preg_replace('/<script.*?<\/script>/is', '', $desc);

        return $desc;
    }

    public function parseOldPrice()
    {
        $paths = array(
            ".//div[@class='product-price__wrap']//p[@class='product-price__small']",
        );

        return $this->xpathScalar($paths);
    }

    public function parseImage()
    {
        if ($images = $this->parseImages())
            return reset($images);
    }

    public function parseImages(): array
    {
        $paths = [
            ".//div[@data-testid='thumbnails-slider-wrap']//img/@src",
            ".//div[@data-testid='thumbnails-slider-wrap']//img/@data-src",
            ".//div[@data-testid='thumbnails-slider-wrap']//img/@srcset",
        ];

        $raw = $this->xpathArray($paths) ?: [];
        $images = [];

        foreach ($raw as $item)
        {
            $item = trim((string)$item);
            if ($item === '')
            {
                continue;
            }

            // If this is a srcset, pick the largest candidate (usually the last one)
            if (strpos($item, ',') !== false && preg_match_all('/\s*([^,\s]+)\s+\d+w/', $item, $m) && !empty($m[1]))
            {
                $item = trim(end($m[1]));
            }

            // Upgrade path segment to /big/ when applicable
            $url = preg_replace('#/(medium|preview|base_action)/#', '/big/', $item);

            $images[] = $url;
        }

        $images = array_values(array_unique($images));

        return $images;
    }

    public function parseFeatures()
    {
        if ($features = parent::parseFeatures())
            return $features;

        $names = $this->xpathArray(".//div[@class='product-wrapper__right']//dt");
        $values = $this->xpathArray(".//div[@class='product-wrapper__right']//dd", true);

        if (!$names || !$values || count($names) != count($values))
            return array();

        $features = array();
        for ($i = 0; $i < count($names); $i++)
        {
            $value = str_replace('</li>', '</li>; ', $values[$i]);
            $feature['name'] = \sanitize_text_field($names[$i]);
            $feature['value'] = \sanitize_text_field(html_entity_decode($value));
            $features[] = $feature;
        }

        return $features;
    }

    public function getReviewsXpath()
    {
        return array(
            array(
                'review' => ".//ul[@class='product-comments__list']//p[contains(@class, 'comment__text')]",
                //'rating' => ".//ul[@class='product-comments__list']//div[@class='product-comment__body']",
                'author' => ".//ul[@class='product-comments__list']//div[@class='comment__author']/text()",
                'date' => ".//ul[@class='product-comments__list']//time",
            ),
        );
    }

    public function parseCurrencyCode()
    {
        return 'UAH';
    }

    public function parseMpn()
    {
        if (!$title = $this->xpathScalar(".//h1[@class='product__title']"))
            return;

        if (preg_match('~\((.+?)\)$~', $title, $matches))
            return $matches[1];
    }
}
