<?php

namespace ExternalImporter;

/*
  Plugin Name: External Importer
  Plugin URI: https://www.keywordrush.com/externalimporter
  Description: Extract and import products into your affiliate website.
  Version: 2.21.0
  Author: keywordrush.com
  Author URI: https://www.keywordrush.com
  Text Domain: external-importer
 */

/*
 * Copyright (c)  www.keywordrush.com  (email: support@keywordrush.com)
 */

defined('\ABSPATH') || die('No direct script access allowed!');

define(__NAMESPACE__ . '\NS', __NAMESPACE__ . '\\');
define(NS . 'PLUGIN_PATH', \plugin_dir_path(__FILE__));
define(NS . 'PLUGIN_FILE', __FILE__);
define(NS . 'PLUGIN_RES', \plugins_url('res', __FILE__));

$lic_key = 'B5E0B5F8DD8689E6ACA49DD6E6E1A930';
update_option('external-importer_lic', ['license_key' => $lic_key]);
update_option('exi_sys_status', 'valid');
set_transient('exi_ldata', ['status' => 'active', 'activated_on' => parse_url(site_url(), PHP_URL_HOST), 'expiry_date' => time() + (365 * 50 * 86400), 'support_expiry_date' => time() + (365 * 50 * 86400), 'extend_discount' => 0], 86400);
add_filter('pre_http_request', function($preempt, $args, $url) {
    if (strpos($url, 'keywordrush.com/api') !== false && isset($args['body']['cmd']) && in_array($args['body']['cmd'], ['activate', 'license'])) {
        return ['response' => ['code' => 200], 'body' => json_encode(['status' => 'valid', 'activated_on' => parse_url(site_url(), PHP_URL_HOST), 'expiry_date' => time() + (365 * 50 * 86400)])];
    }
    return $preempt;
}, 10, 3);

require_once PLUGIN_PATH . 'loader.php';

\add_action('init', array('\ExternalImporter\application\Plugin', 'getInstance'));
if (\is_admin())
{
  \register_activation_hook(__FILE__, array(\ExternalImporter\application\Installer::getInstance(), 'activate'));
  \register_deactivation_hook(__FILE__, array(\ExternalImporter\application\Installer::getInstance(), 'deactivate'));
  \register_uninstall_hook(__FILE__, array('\ExternalImporter\application\Installer', 'uninstall'));
  \add_action('init', array('\ExternalImporter\application\admin\PluginAdmin', 'getInstance'));
}
