externalImporter.service(
  "extractorService",
  function ($http, $q, $httpParamSerializerJQLike) {
    // Public API
    return {
      getProducts: getProducts,
      importProduct: importProduct,
    };

    // ----- Helpers -----

    function asForm(data) {
      return $httpParamSerializerJQLike(data);
    }

    // Centralized HTTP error normalization
    function normalizeHttpError(response) {
      response = response || {};

      var status = response.status;
      var data = response.data;

      var err = {
        status: status,
        statusText: response.statusText,
        data: data,
      };

      // Timeout / aborted request
      if (status === -1) {
        err.friendlyMessage = "The request timed out.";
        return $q.reject(err);
      }

      // 403 Forbidden – likely expired admin session
      if (status === 403) {
        err.friendlyMessage =
          "Your admin session has expired. Refresh the page to continue.";
        err.log = [
          {
            message: err.friendlyMessage,
            type: "error",
            code: "SESSION_EXPIRED",
          },
        ];
        return $q.reject(err);
      }

      // Application-level error payload with log[]
      if (data && data.log) {
        err.log = data.log;
        if (data.log.length && data.log[0].message) {
          err.friendlyMessage = data.log[0].message;
        }
        return $q.reject(err);
      }

      // Fallback generic message
      err.friendlyMessage =
        "Local server error (" + (status || "unknown") + "). Please try again.";
      return $q.reject(err);
    }

    function handleSuccess(response) {
      return response.data;
    }

    // ----- API methods -----

    function getProducts(params) {
      var payload = {
        action: "ei-extractor-api",
        params: JSON.stringify(params),
        _ei_nonce: ei_params.nonce,
      };

      return $http({
        method: "POST",
        url: ajaxurl,
        data: asForm(payload),
        headers: {
          "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8",
        },
        timeout: 120000,
      })
        .then(handleSuccess)
        .catch(normalizeHttpError);
    }

    function importProduct(params) {
      var payload = {
        action: "ei-import-api",
        data: JSON.stringify(params),
        _ei_nonce: ei_params.nonce,
      };

      return $http({
        method: "POST",
        url: ajaxurl,
        data: asForm(payload),
        headers: {
          "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8",
        },
        timeout: 500000,
      })
        .then(handleSuccess)
        .catch(normalizeHttpError);
    }
  }
);
