<?php
/**
 * @package         FireBox
 * @version         3.1.1 Pro
 * 
 * @author          FirePlugins <info@fireplugins.com>
 * @link            https://www.fireplugins.com
 * @copyright       Copyright © 2025 FirePlugins All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

namespace FireBox\Core\RevenueAttribution;

if (!defined('ABSPATH'))
{
	exit; // Exit if accessed directly.
}

class OrderHelper
{
    /**
     * Get order total based on order type
     * 
     * @param  int     $order_id
     * @param  string  $order_type
     * 
     * @return float
     */
    public static function getOrderTotal($order_id, $order_type)
    {
        $order_total = 0.0;
        
        if ($order_type === 'woocommerce' && class_exists('\WooCommerce'))
        {
            $order = \wc_get_order($order_id);
            if ($order)
            {
                $order_total = floatval($order->get_total());
            }
        }
        elseif ($order_type === 'edd' && function_exists('\edd_get_payment'))
        {
            $payment = \edd_get_payment($order_id);
            if ($payment)
            {
                $order_total = floatval($payment->total);
            }
        }

        return $order_total;
    }
}
