<?php

/**
 * Handler - Free Shipping Rule.
 *
 * @since 12.2.0
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

if (!class_exists('FGF_Free_Shipping_Rule_Handler')) {

	/**
	 * Class.
	 *
	 * @since 12.2.0
	 */
	class FGF_Free_Shipping_Rule_Handler extends FGF_Rule_Handler {

		/**
		 * Shipping method IDs.
		 *
		 * @since 12.2.0
		 * @var array
		 * */
		protected static $shipping_method_ids;

		/**
		 * Active free shipping method IDs.
		 *
		 * @since 12.2.0
		 * @var array
		 * */
		protected static $active_free_shipping_rule_ids;

		/**
		 * Get the valid shipping method ids.
		 * 
		 * @since 12.2.0
		 * @return array
		 */
		public static function get_valid_shipping_method_ids() {
			if (isset(self::$shipping_method_ids)) {
				return self::$shipping_method_ids;
			}
			
			self::$shipping_method_ids=array();
			self::prepare_eligible_shipping_method_ids();

			return self::$shipping_method_ids;
		}

		 /**
		 * Prepare eligible shipping method ids.
		 * 
		 * @since 12.2.0
		 * @return array
		 */
		public static function prepare_eligible_shipping_method_ids() {
			$rule_ids = self::get_active_free_shipping_rule_ids();
			if (!fgf_check_is_array($rule_ids)) {
				return;
			}

			// // Initialize the matched rules before prepare the notices.
			if (!isset(self::$bogo_rule_products)) {
				self::matched_rules();
			}
			
			foreach ($rule_ids as $rule_id) {
				// Set the default filter.
				self::set_default_filter();
				self::$rule = fgf_get_rule($rule_id);
				// Restrict the adding free gifts based on coupons applied in the cart.
				if (self::validate_applied_WC_coupons()) {
					continue;
				}

				// Return if rule usage count exists.
				if (!self::validate_rule_usage_count() || !self::validate_rule_user_usage_count()) {
					continue;
				}               

				if (self::is_valid_rule()) {
					self::$shipping_method_ids=array_merge(self::$shipping_method_ids, self::$rule->get_free_shipping_methods());
				} elseif (self::is_valid_notice_rule()) {
					self::$cart_notices[$rule_id] = self::get_rule_notice();
				}               
			}
		}

		 /**
		 * Get the active free shipping rule IDs.
		 * 
		 * @since 12.2.0
		 * @return array
		 */
		public static function get_active_free_shipping_rule_ids() {
			if (self::$active_free_shipping_rule_ids) {
				return self::$active_free_shipping_rule_ids;
			}

			self::$active_free_shipping_rule_ids = fgf_get_rule_ids('fgf_active', '15');

			return self::$active_free_shipping_rule_ids;
		}
	}
}
