<?php
/**
 * General - Free Shipping
 * 
 * @since 12.2.0
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}
?>
<div class='fgf-rule-free-shipping-fields-wrapper fgf-rule-general-fields-wrapper'>
	<?php
	/**
	 * This hook is used to do extra action before rule free shipping settings.
	 *
	 * @since 12.2.0
	 */
	do_action('fgf_before_rule_free_shipping_settings', $rule_data);
	?>
	<div class='fgf-rule-fields-section'>
		<h2><?php esc_html_e('Shipping Configuration', 'free-gifts-for-woocommerce'); ?></h2>
		<div class='fgf-field-wrapper'>
			<span class='fgf-field-title'>
				<label><?php esc_html_e('Select Shipping', 'free-gifts-for-woocommerce'); ?><span class='required'>*</span></label>
			</span>
			<span class='fgf-field'>
				<select name="fgf_rule[fgf_free_shipping_methods][]" class = 'fgf_shipping_methods fgf_select2' data-toggle_all_options='true' multiple='multiple'>
					<?php $selected = in_array('', $rule_data['fgf_free_shipping_methods'])?'selected="selected"':''; ?>
							<option value='' <?php echo esc_attr($selected); ?>><?php esc_html_e('All Shipping', 'free-gifts-for-woocommerce'); ?></option>
					
					<?php foreach (fgf_get_shipping_method_options() as $zone_id => $zone) : ?>
						<optgroup label="<?php echo esc_attr($zone['name']); ?>">
							<?php foreach ($zone['methods'] as $method_id => $method_name) : ?>
								<?php $selected = in_array($method_id, $rule_data['fgf_free_shipping_methods'])?'selected="selected"':''; ?>
								<option value='<?php echo esc_attr($method_id); ?>' <?php echo esc_attr($selected); ?>><?php echo esc_html($method_name); ?></option>
							<?php endforeach; ?> 
						</optgroup>
					<?php endforeach; ?> 
				</select>
			</span>
		</div>
	</div>
	<?php
	/**
	 * This hook is used to do extra action after rule free shipping settings.
	 *
	 * @since 12.2.0
	 */
	do_action('fgf_after_rule_free_shipping_settings', $rule_data);
	?>
</div>
<?php
