<?php
/**
 * This template displays content inside a forced gifts popup layout.
 *
 * This template can be overridden by copying it to yourtheme/free-gifts-for-woocommerce/checkout/force-gifts-popup-layout.php
 *
 * To maintain compatibility, Free Gifts for WooCommerce will update the template files and you have to copy the updated files to your theme
 * 
 * @since 12.4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
?>
<div class='fgf-force-gifts-popup-wrapper'>
	<a href='#' class='fgf-hide fgf-popup-gift-products fgf-popup-force-checkout-gifts'></a>
	<?php
	/**
	 * This hook is used to display the extra content before gift products content.
	 * 
	 * @since 12.4.0
	 */
	do_action( 'fgf_before_checkout_force_gifts_content' ) ;

	// Display the gift products popup layout.
	fgf_get_template('popup-layout.php', array( 'data_args' => $data_args ));
		
	/**
	 * This hook is used to display the extra content after gift products content.
	 * 
	 * @since 12.4.0
	 */
	do_action( 'fgf_after_checkout_force_gifts_content' ) ;
	?>
</div>
<?php

