<?php
namespace Frontend_Admin\Pro\Elementor;

use Elementor\Controls_Manager;
use ElementorPro\Modules\QueryControl\Module as Query_Module;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class ContentTab {
	
	public function multi_step_settings( $widget ) {
		$widget->start_controls_section(
			'multi_step_section',
			array(
				'label'     => __( 'Steps Settings', 'frontend-admin' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition' => array(
					'admin_forms_select' => '',
				),
			)
		);
		$post_type_choices = feadmin_get_post_type_choices();
		$widget->add_control(
			'validate_steps',
			array(
				'label'        => __( 'Validate Each Step', 'frontend-admin' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'Yes', 'frontend-admin' ),
				'label_off'    => __( 'No', 'frontend-admin' ),
				'return_value' => 'true',
			)
		);
		$widget->add_control(
			'steps_display',
			array(
				'label'       => __( 'Steps Display', 'frontend-admin' ),
				'type'        => Controls_Manager::SELECT2,
				'label_block' => true,
				'default'     => array(
					'tabs',
				),
				'multiple'    => 'true',
				'options'     => array(
					'tabs'    => __( 'Tabs', 'frontend-admin' ),
					'counter' => __( 'Counter', 'frontend-admin' ),
				),

			)
		);
		
		$widget->add_control(
			'custom_text_between_tabs',
			array(
				'label'       => __( 'Custom Text', 'frontend-admin' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your custom text', 'frontend-admin' ),
				'condition'   => array(
					'between_tabs_display' => 'custom_text',
				),
			)
		);
		$widget->add_control(
			'responsive_description',
			array(
				'raw'             => __( 'Responsive visibility will take effect only on preview or live page, and not while editing in Elementor.', 'elementor' ),
				'type'            => Controls_Manager::RAW_HTML,
				'content_classes' => 'elementor-descriptor',
			)
		);
		$widget->add_control(
			'steps_tabs_display',
			array(
				'label'       => __( 'Step Tabs Display', 'frontend-admin' ),
				'type'        => Controls_Manager::SELECT2,
				'label_block' => 'true',
				'default'     => array(
					'desktop',
					'tablet',
				),
				'multiple'    => 'true',
				'options'     => array(
					'desktop' => __( 'Desktop', 'frontend-admin' ),
					'tablet'  => __( 'Tablet', 'frontend-admin' ),
					'phone'   => __( 'Mobile', 'frontend-admin' ),
				),
				'condition'   => array(
					'steps_display' => 'tabs',
				),
			)
		);
		$widget->add_control(
			'tabs_align',
			array(
				'label'     => __( 'Tabs Position', 'elementor' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'horizontal',
				'options'   => array(
					'horizontal' => __( 'Top', 'elementor' ),
					'vertical'   => __( 'Side', 'elementor' ),
				),
				'condition' => array(
					'steps_display' => 'tabs',
				),
			)
		);

		$widget->add_control(
			'steps_counter_display',
			array(
				'label'       => __( 'Step Counter Display', 'frontend-admin' ),
				'type'        => Controls_Manager::SELECT2,
				'label_block' => 'true',
				'default'     => array(
					'desktop',
					'tablet',
					'phone',
				),
				'multiple'    => 'true',
				'options'     => array(
					'desktop' => __( 'Desktop', 'frontend-admin' ),
					'tablet'  => __( 'Tablet', 'frontend-admin' ),
					'phone'   => __( 'Mobile', 'frontend-admin' ),
				),
				'condition'   => array(
					'steps_display' => 'counter',
				),
			)
		);
		$widget->add_control(
			'counter_prefix',
			array(
				'label'       => __( 'Counter Prefix', 'frontend-admin' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Step ', 'frontend-admin' ),
				'default'     => __( 'Step ', 'frontend-admin' ),
				'dynamic'     => array(
					'active' => true,
				),
				'condition'   => array(
					'steps_display' => 'counter',
				),
			)
		);
		$widget->add_control(
			'counter_suffix',
			array(
				'label'     => __( 'Counter Suffix', 'frontend-admin' ),
				'type'      => Controls_Manager::TEXT,
				'dynamic'   => array(
					'active' => true,
				),
				'condition' => array(
					'steps_display' => 'counter',
				),
			)
		);

		$widget->add_control(
			'step_number',
			array(
				'label'        => __( 'Step Number in Tabs', 'frontend-admin' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'show', 'frontend-admin' ),
				'label_off'    => __( 'hide', 'frontend-admin' ),
				'return_value' => 'true',
				'condition'    => array(
					'steps_display' => 'tabs',
				),
			)
		);

		$widget->add_control(
			'tab_links',
			array(
				'label'        => __( 'Link to Step in Tabs', 'frontend-admin' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'Yes', 'frontend-admin' ),
				'label_off'    => __( 'No', 'frontend-admin' ),
				'return_value' => 'true',
				'condition'    => array(
					'steps_display' => 'tabs',
				),
			)
		);
		$widget->end_controls_section();

	}

	public function submit_limit_setting( $widget ) {
		$widget->add_control(
			'limit_reached',
			array(
				'label'       => __( 'Limit Reached Message', 'frontend-admin' ),
				'type'        => Controls_Manager::SELECT,
				'label_block' => true,
				'default'     => 'show_message',
				'options'     => array(
					'show_message'   => __( 'Limit Message', 'frontend-admin' ),
					'custom_content' => __( 'Custom Content', 'frontend-admin' ),
					'show_nothing'   => __( 'Nothing', 'frontend-admin' ),
				),
			)
		);
		$widget->add_control(
			'limit_submit_message',
			array(
				'label'       => __( 'Reached Limit Message', 'frontend-admin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'rows'        => 4,
				'default'     => __( 'You have already submitted this form the maximum amount of times that you are allowed', 'frontend-admin' ),
				'placeholder' => __( 'you have already submitted this form the maximum amount of times that you are allowed', 'frontend-admin' ),
				'condition'   => array(
					'limit_reached' => 'show_message',
				),
			)
		);
		$widget->add_control(
			'limit_submit_content',
			array(
				'label'       => __( 'Reached Limit Content', 'frontend-admin' ),
				'type'        => Controls_Manager::WYSIWYG,
				'placeholder' => 'You have already submitted this form the maximum amount of times that you are allowed',
				'label_block' => true,
				'render_type' => 'none',
				'condition'   => array(
					'limit_reached' => 'custom_content',
				),
			)
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'rule_name',
			array(
				'label'       => __( 'Rule Name', 'frontend-admin' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => __( 'Rule Name', 'frontend-admin' ),
				'label_block' => true,
			)
		);

		$repeater->add_control(
			'allowed_submits',
			array(
				'label'   => __( 'Allowed Submissions', 'frontend-admin' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => '',
			)
		);

		$repeater->add_control(
			'limit_to_everyone',
			array(
				'label'        => __( 'Limit For Everyone', 'frontend-admin' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'Yes', 'frontend-admin' ),
				'label_off'    => __( 'No', 'frontend-admin' ),
				'return_value' => 'true',
			)
		);

		$user_roles = feadmin_get_user_roles();

		$repeater->add_control(
			'limit_by_role',
			array(
				'label'       => __( 'Limit By Role', 'frontend-admin' ),
				'type'        => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple'    => true,
				'default'     => 'subscriber',
				'options'     => $user_roles,
				'condition'   => array(
					'limit_to_everyone' => '',
				),
			)
		);
		if ( ! class_exists( 'ElementorPro\Modules\QueryControl\Module' ) ) {
			$repeater->add_control(
				'limit_by_user',
				array(
					'label'       => __( 'Limit By User', 'frontend-admin' ),
					'type'        => Controls_Manager::TEXT,
					'placeholder' => __( '18', 'frontend-admin' ),
					'description' => __( 'Enter a commma seperated list of user ids', 'frontend-admin' ),
					'condition'   => array(
						'limit_to_everyone' => '',
					),
				)
			);
		} else {
			$repeater->add_control(
				'limit_by_user',
				array(
					'label'        => __( 'Limit By User', 'frontend-admin' ),
					'type'         => Query_Module::QUERY_CONTROL_ID,
					'label_block'  => true,
					'autocomplete' => array(
						'object'  => Query_Module::QUERY_OBJECT_USER,
						'display' => 'detailed',
					),
					'multiple'     => true,
					'condition'    => array(
						'limit_to_everyone' => '',
					),
				)
			);
		}

		$widget->add_control(
			'limiting_rules',
			array(
				'label'         => __( 'Add Limiting Rules', 'frontend-admin' ),
				'type'          => Controls_Manager::REPEATER,
				'fields'        => $repeater->get_controls(),
				'prevent_empty' => false,
				'default'       => array(
					array(
						'rule_name' => __( 'Subscribers', 'frontend-admin' ),
					),
				),
				'title_field'   => '{{{ rule_name }}}',
			)
		);

	}

	public function elementor_widget_types( $widgets ){
		if ( class_exists( 'woocommerce' ) ) {
			$widgets['products'] = array(
				'path' => __DIR__ . "/widgets/product",
				'edit-product'      => 'Edit_Product_Widget',
				'new-product'       => 'New_Product_Widget',
				'duplicate-product' => 'Duplicate_Product_Widget',
				'delete-product'    => 'Delete_Product_Widget',
				'title-field' 	    => 'Product_Title_Field',
				'excerpt-field' 	=> 'Product_Excerpt_Field',
			);

			if( \Elementor\Plugin::$instance->experiments->is_feature_active( 'nested-elements' ) ){
				$widgets['products']['nested-new-product'] = 'Nested_New_Product';
			}
		}
		$widgets['general']['edit-site'] = 'Edit_Site_Widget';
		return $widgets;
	}

	public function fields_to_choose( $fields, $type ) {
		if ( $type == 'all' || $type == 'options' ) {
			$fields['options'] = array(
				'label'   => __( 'Site', 'frontend-admin' ),
				'options' => array(
					'site_title'   => __( 'Site Title', 'frontend-admin' ),
					'site_tagline' => __( 'Site Tagline', 'frontend-admin' ),
					'site_logo'    => __( 'Site Logo', 'frontend-admin' ),
				),
			);
		}
	
		if ( $type == 'all' ) {
			$fields['security'] = array(
				'label'   => __( 'Security', 'frontend-admin' ),
				'options' => array(
					'recaptcha' => __( 'Recaptcha', 'frontend-admin' ),
				),
			);
		}
		if ( class_exists( 'woocommerce' ) ) {
			if ( $type == 'all' || $type == 'product' ) {
				$fields['product_type']         = array(
					'label'   => __( 'Product Type', 'frontend-admin' ),
					'options' => array(
						'product_type'    => __( 'Product Types', 'woocommerce' ),
						'is_virtual'      => __( 'Virtual', 'woocommerce' ),
						'is_downloadable' => __( 'Downloadable', 'woocommerce' ),
					),
				);
				$fields['product']              = array(
					'label'   => __( 'Product Information', 'frontend-admin' ),
					'options' => array(
						'product_title'      => __( 'Product Title', 'frontend-admin' ),
						'product_slug'       => __( 'Slug', 'frontend-admin' ),
						'price'              => __( 'Price', 'frontend-admin' ),
						'sale_price'         => __( 'Sale Price', 'frontend-admin' ),
						'description'        => __( 'Description', 'frontend-admin' ),
						'main_image'         => __( 'Main Image', 'frontend-admin' ),
						'images'             => __( 'Product Images', 'frontend-admin' ),
						'short_description'  => __( 'Short Description', 'frontend-admin' ),
						'product_categories' => __( 'Categories', 'frontend-admin' ),
						'product_tags'       => __( 'Tags', 'frontend-admin' ),
						'tax_status'         => __( 'Tax Status', 'frontend-admin' ),
						'tax_class'          => __( 'Tax Class', 'frontend-admin' ),
					),
				);
				$fields['product_downloadable'] = array(
					'label'   => __( 'Product Downloads', 'frontend-admin' ),
					'options' => array(
						'download_limit'     => __( 'Download Limit', 'woocommerce' ),
						'download_expiry'    => __( 'Download Expiry', 'woocommerce' ),
						'downloadable_files' => __( 'Downloadable Files', 'woocommerce' ),
					),
				);
				$fields['product_shipping']     = array(
					'label'   => __( 'Product Shipping', 'frontend-admin' ),
					'options' => array(
						'product_weight'         => __( 'Weight', 'woocommerce' ),
						'product_length'         => __( 'Length', 'woocommerce' ),
						'product_width'          => __( 'Width', 'woocommerce' ),
						'product_height'         => __( 'Height', 'woocommerce' ),
						'product_shipping_class' => __( 'Shipping Class', 'woocommerce' ),
					),
				);
				$fields['product_external']     = array(
					'label'   => __( 'External/Affiliate product', 'woocommerce' ),
					'options' => array(
						'external_url' => __( 'Product URL', 'frontend-admin' ),
						'button_text'  => __( 'Button Text', 'frontend-admin' ),
					),
				);
				$fields['product_linked']       = array(
					'label'   => __( 'Linked Products', 'frontend-admin' ),
					'options' => array(
						'grouped_products' => __( 'Grouped Products', 'frontend-admin' ),
						'upsells'          => __( 'Upsells', 'frontend-admin' ),
						'cross_sells'      => __( 'Cross Sells', 'frontend-admin' ),
					),
				);
				$fields['product_attributes']   = array(
					'label'   => __( 'Product Attributes', 'frontend-admin' ),
					'options' => array(
						'attributes' => __( 'Attributes', 'frontend-admin' ),
						'variations' => __( 'Variations', 'frontend-admin' ),
					),
				);
				$fields['product_inventory']    = array(
					'label'   => __( 'Product Inventory', 'frontend-admin' ),
					'options' => array(
						'sku'                 => __( 'sku', 'frontend-admin' ),
						'stock_status'        => __( 'Stock Status', 'frontend-admin' ),
						'sold_individually'   => __( 'Sold Individually', 'frontend-admin' ),
						'manage_stock'        => __( 'Manage Stock', 'frontend-admin' ),
						'stock_quantity'      => __( 'Stock Quantity', 'frontend-admin' ),
						'allow_backorders'    => __( 'Allow Backorders', 'frontend-admin' ),
						'low_stock_threshold' => __( 'Low Stock Threshold', 'frontend-admin' ),
					),
				);
				$fields['product_advanced']     = array(
					'label'   => __( 'Advanced Product Options', 'frontend-admin' ),
					'options' => array(
						'product_purchase_note'  => __( 'Purchase Note', 'frontend-admin' ),
						'product_menu_order'     => __( 'Menu Order', 'frontend-admin' ),
						'product_enable_reviews' => __( 'Enable Reviews', 'frontend-admin' ),
					),
				);
			}
		}
		if ( $type == 'all' ) {
			$fields['layout']['options']['step'] = __( 'Step', 'frontend-admin' );
		}
		return $fields;
	}

	public function __construct() {
		add_filter( 'frontend_admin/elementor/widget_types', array( $this, 'elementor_widget_types' ) );
		add_action( 'frontend_admin/multi_step_settings', array( $this, 'multi_step_settings' ) );
		add_action( 'frontend_admin/limit_submit_settings', array( $this, 'submit_limit_setting' ) );
		add_filter( 'frontend_admin/form/elementor/field_select_options', array( $this, 'fields_to_choose' ), 10, 2 );
		require_once( 'style-tab.php' );
	}

}

new ContentTab();
