<?php
namespace Frontend_Admin\Elementor\Widgets;

use Frontend_Admin\Plugin;

use Frontend_Admin\Classes;
use Elementor\Controls_Manager;

/**

 *
 * @since 1.0.0
 */
class Delete_Product_Widget extends Delete_Post_Widget {


	/**
	 * Get widget name.
	 *
	 * Retrieve acf ele form widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'delete_product';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve acf ele form widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Trash/Delete Product', 'frontend-admin' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve acf ele form widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-trash frontend-icon';
	}

		/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the acf ele form widget belongs to.
	 *
	 * @since  1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( 'frontend-admin-products' );
	}


	/**
	 * Register acf ele form widget controls.
	 *
	 * Adds different input fields to allow the post to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'delete_button_section',
			array(
				'label' => __( 'Trash Button', 'frontend-admin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);
		$this->add_control(
			'delete_button_text',
			array(
				'label'       => __( 'Delete Button Text', 'frontend-admin' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => __( 'Delete', 'frontend-admin' ),
				'placeholder' => __( 'Delete', 'frontend-admin' ),
			)
		);
		$this->add_control(
			'delete_button_icon',
			array(
				'label' => __( 'Delete Button Icon', 'frontend-admin' ),
				'type'  => Controls_Manager::ICONS,
			)
		);

		$this->add_control(
			'confirm_delete_message',
			array(
				'label'       => __( 'Confirm Delete Message', 'frontend-admin' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => __( 'The product will be deleted. Are you sure?', 'frontend-admin' ),
				'placeholder' => __( 'The product will be deleted. Are you sure?', 'frontend-admin' ),
			)
		);

		$this->add_control(
			'show_delete_message',
			array(
				'label'        => __( 'Show Success Message', 'frontend-admin' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'Yes', 'frontend-admin' ),
				'label_off'    => __( 'No', 'frontend-admin' ),
				'default'      => 'true',
				'return_value' => 'true',
			)
		);
		$this->add_control(
			'delete_message',
			array(
				'label'       => __( 'Success Message', 'frontend-admin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => __( 'You have deleted this product', 'frontend-admin' ),
				'placeholder' => __( 'You have deleted this product', 'frontend-admin' ),
				'dynamic'     => array(
					'active'    => true,
					'condition' => array(
						'show_delete_message' => 'true',
					),
				),
			)
		);
		$this->add_control(
			'force_delete',
			array(
				'label'        => __( 'Force Delete', 'frontend-admin' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'true',
				'return_value' => 'true',
				'description'  => __( 'Whether or not to completely delete the products right away.' ),
			)
		);

		$this->add_control(
			'delete_redirect',
			array(
				'label'   => __( 'Redirect After Delete', 'frontend-admin' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'custom_url',
				'options' => array(
					'current'     => __( 'Reload Current Url', 'frontend-admin' ),
					'custom_url'  => __( 'Custom Url', 'frontend-admin' ),
					'referer_url' => __( 'Referer', 'frontend-admin' ),
				),
			)
		);

		$this->add_control(
			'redirect_after_delete',
			array(
				'label'         => __( 'Custom URL', 'frontend-admin' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => __( 'Enter Url Here', 'frontend-admin' ),
				'show_external' => false,
				'dynamic'       => array(
					'active' => true,
				),
				'condition'     => array(
					'delete_redirect' => 'custom_url',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'product_section',
			array(
				'label' => __( 'Product', 'frontend-admin' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		fea_instance()->local_actions['product']->action_controls( $this, false, 'delete_product' );

		$this->end_controls_section();

		do_action( 'frontend_admin/elementor/permissions_controls', $this );

		do_action( 'frontend_admin/delete_button_styles', $this );


	}


	public function prepare_field(){
		$local_field = parent::prepare_field();
		if( ! $local_field ) {
			return false;
		}
		$local_field['type'] = 'delete_product';
		
		return $local_field;
	}


}
