<?php
namespace Frontend_Admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
if ( ! class_exists( 'Pro_Features' ) ) :

	class Pro_Features {

		public $using_freemius = '';

		public function submit_actions_settings( $fields ) {
			
			$fields[] = array(
				'key'               => 'redirect_action',
				'label'             => __( 'After Reload', 'frontend-admin' ),
				'type'              => 'select',
				'instructions'      => '',
				'required'          => 0,
				'wrapper'           => array(
					'width' => '',
					'class' => '',
					'id'    => '',
				),
				'choices'           => array(
					''		=> __( 'Default', 'frontend-admin' ),
					'clear' => __( 'Clear Form', 'frontend-admin' ),
					'edit'  => __( 'Edit Content', 'frontend-admin' ),
				),
				'conditional_logic' => array(
					array(
						array(
							'field'    => 'redirect',
							'operator' => '==',
							'value'    => 'current',
						),
					),
				),
				'allow_null'        => 0,
				'multiple'          => 0,
				'ui'                => 0,
				'return_format'     => 'value',
				'ajax'              => 0,
				'placeholder'       => '',
			);

			$remote_actions = array();
			$action_layouts = array();

			global $fea_instance;
			if( ! empty( $fea_instance->remote_actions ) ){
				foreach ( $fea_instance->remote_actions as $name => $action ) {
					$sub_fields       = array(
						array(
							'key'               => 'action_id',
							'label'             => __( 'Action Name', 'frontend-admin' ),
							'name'              => 'action_id',
							'type'              => 'text',
							'instructions'      => __( 'Give this action an identifier', 'frontend-admin' ),
							'default_value'     => $action->get_label(),
							'conditional_logic' => 0,
							'placeholder'       => __( 'Action Name', 'frontend-admin' ),
							'maxlength'         => '100',
						),
					);
					$sub_fields       = array_merge( $sub_fields, $action->action_options() );
					$layouts[ $name ] = array(
						'key'        => $name,
						'name'       => $name,
						'label'      => $action->get_label(),
						'display'    => 'block',
						'sub_fields' => $sub_fields,
						'min'        => '',
						'max'        => '',
					);
				}

				$default = array();
				global $form;

				$action_types = [
					'email', 'webhook', 'checkout'
				];

				foreach ( $action_types as $action_key ) {
					if ( ! empty( $form[ $action_key ] ) ) {
						foreach ( $form[ $action_key ] as $action ) {
							$row['fea_block_structure'] = $action_key;
							$row['action_id']           = $action_key . '_id';
							$default[]                  = $action;
						}
					}
				}

				$fields[] = array(
					'key'                         => 'submit_actions',
					'label'                       => __( 'Submit Actions', 'frontend-admin' ),
					'type'                        => 'frontend_blocks',
					'instructions'                => '',
					'required'                    => 0,
					'conditional_logic'           => 0,
					'wrapper'                     => array(
						'width' => '',
						'class' => '',
						'id'    => '',
					),
					'block_labels'                => array(
						'remove'    => __( 'Remove Action', 'frontend-admin' ),
						'add'       => __( 'Add Action', 'frontend-admin' ),
						'duplicate' => __( 'Duplicate Action', 'frontend-admin' ),
						'collapse'  => __( 'Click to Toggle', 'frontend-admin' ),
						'button'    => __( 'Add Action', 'frontend-admin' ),
						'no_value'  => __( 'Click the button below to add your first action', 'frontend-admin' ),
					),
					'frontend_admin_display_mode' => 'edit',
					'only_front'                  => 0,
					'default_value'               => $default,
					'blocks'                      => $layouts,
					'min'                         => '',
					'max'                         => '',
				);
			}

			return $fields;
		}
		public function permissions_settings( $fields ) {
			if ( empty( $fields[2]['sub_fields'] ) ) {
				return $fields;
			}
			$fields[2]['sub_fields'] = array_merge(
				$fields[2]['sub_fields'],
				array(
					array(
						'key'               => 'allowed_submits',
						'label'             => __( 'Allowed Submissions', 'frontend-admin' ),
						'type'              => 'number',
						'instructions'      => __( 'Limit the amount of times this form can be submitted', 'frontend-admin' ),
						'conditional_logic' => 0,
						'min'               => 1,
						'wrapper'           => array(
							'width' => '30',
							'class' => '',
							'id'    => '',
						),
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'who_can_see',
									'operator' => '==',
									'value'    => 'logged_in',
								),
							),
						),
					),
					array(
						'key'               => 'limit_reached',
						'label'             => __( 'No Permissions Message', 'frontend-admin' ),
						'type'              => 'select',
						'instructions'      => '',
						'required'          => 0,
						'choices'           => array(
							'show_nothing'   => __( 'None', 'frontend-admin' ),
							'show_message'   => __( 'Message', 'frontend-admin' ),
							'custom_content' => __( 'Custom Content', 'frontend-admin' ),
						),
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'allowed_submits',
									'operator' => '!=empty',
								),
								array(
									'field'    => 'who_can_see',
									'operator' => '==',
									'value'    => 'logged_in',
								),
							),
						),
					),
					array(
						'key'               => 'limit_reached_message',
						'label'             => '',
						'type'              => 'textarea',
						'instructions'      => '',
						'required'          => 0,
						'rows'              => 3,
						'placeholder'       => __( 'You have submitted this form the maximum amount of times allowed', 'frontend-admin' ),
						'default_value'     => __( 'You have submitted this form the maximum amount of times allowed', 'frontend-admin' ),
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'limit_reached',
									'operator' => '==',
									'value'    => 'show_message',
								),
								array(
									'field'    => 'allowed_submits',
									'operator' => '!=empty',
								),
								array(
									'field'    => 'who_can_see',
									'operator' => '==',
									'value'    => 'logged_in',
								),
							),

						),
					),
					array(
						'key'               => 'limit_reached_content',
						'label'             => '',
						'type'              => 'wysiwyg',
						'instructions'      => '',
						'required'          => 0,
						'conditional_logic' => array(
							array(
								array(
									'field'    => 'limit_reached',
									'operator' => '==',
									'value'    => 'custom_content',
								),
								array(
									'field'    => 'allowed_submits',
									'operator' => '!=empty',
								),
								array(
									'field'    => 'who_can_see',
									'operator' => '==',
									'value'    => 'logged_in',
								),
							),
						),
					),
				)
			);

			return $fields;
		}

		public function scripts() {
			$min = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '-min';

			wp_register_style( 'fea-public-pro', FEA_URL . 'pro/assets/css/frontend-admin-pro' . $min . '.css', array(), FEA_VERSION );
			wp_register_script( 'fea-public-pro', FEA_URL . 'pro/assets/js/frontend-admin-pro' . $min . '.js', array( 'fea-public' ), FEA_VERSION, true );

			wp_enqueue_style( 'fea-public-pro' );
			wp_enqueue_script( 'fea-public-pro' );

		}

		public function field_types( $field_types ) {
			if( ! is_array( $field_types ) ) return $field_types;

			$field_types['pro'] = [
				'path' => __DIR__ . "/forms/fields/",
				'groups' => [
					'general' => [
						'form-step',
						'frontend-blocks',
						'signature',
					],
					'advanced' => [
						'countries',
						'cities',
					],
					'options' => [
						'site-title',
						'site-tagline',
						'site-logo',
						'site-favicon',
					],
					'mailchimp' => [
						'mailchimp-email',
						'mailchimp-first-name',
						'mailchimp-last-name',
						'mailchimp-status',
					],
				]
			];

			if( class_exists( 'Frontend_Admin_Payments' ) ){
				$field_types['pro']['groups']['general'][] = 'payments';
			}
		
			if ( class_exists( 'woocommerce' ) ) {
				$field_types['pro']['groups']['product'] = [
					'product-to-edit',
					'product-title',
					'product-description',
					'product-short-description',
					'product-slug',
					'product-status',
					'product-author',
					'product-date',
					'product-sku',
					'shipping-attributes',
					'product-weight',
					'product-height',
					'product-length',
					'product-width',
					'product-shipping-class',
					'is-downloadable',
					'downloadable-files',
					'download-limit',
					'download-expiry',
					'product-price',
					'product-sale-price',
					'product-menu-order',
					'main-image',
					'product-images',
					'product-tax-class',
					'product-tax-status',
					'product-attributes',
					'external-url',
					'button-text',
					'product-types',
					'is-virtual',
					'product-variations',
					'multiple-selection',
					'product-linked',
					'product-grouped',
					'product-upsells',
					'product-cross-sells',
					'stock-status',
					'allow-backorders',
					'stock-quantity',
					'low-stock-threshold',
					'manage-stock',
					'sold-individually',
					'product-enable-reviews',
					'product-purchase-note',
					'delete-product',
				];
			}

			return $field_types;
		}
		public function form_types( $form_types ) {
				if ( class_exists( 'woocommerce' ) ) {
				$form_types = array_merge(
				   $form_types,
				   array(
					   __( 'Product', 'frontend-admin' ) => array(
						   'new_product'       => __( 'New Product Form', 'frontend-admin' ),
						   'edit_product'      => __( 'Edit Product Form', 'frontend-admin' ),
						   'duplicate_product' => __( 'Duplicate Product Form', 'frontend-admin' ),
						   'delete_product'    => __( 'Delete Product Button', 'frontend-admin' ),
						   'status_product'    => __( 'Post Status Button', 'frontend-admin' ),
					   ),
				   )
			   );
			}
			$form_types['edit_options'] = __( 'Edit Options Form', 'frontend-admin' );
			return $form_types;
		}

		function pro_tabs( $tabs ) {

			$tabs['pdf'] = 'PDF Generator';
			$tabs['payments'] = 'Payments';

			return $tabs;
		}

		function license_tab( $tabs ) {

			// $this->tabs['pdf'] = 'PDF Generator';
			$tabs['license'] = 'License';

			return $tabs;
		}

		
		public function license_page() {
			add_submenu_page(  'fea-settings', __( 'License', 'frontend-admin' ), __( 'License', 'frontend-admin' ), 'manage_options',  admin_url( '?page=fea-settings&tab=license' ), '', 10 );
	   }


		public function get_settings_fields( $field_keys ) {
			$license     = get_option( 'fea_main_license_key' );
			$is_valid    = get_option( 'fea_main_license_valid' );
			$instruction = '';

			if ( $is_valid ) {
				$instruction = sprintf( __( 'License activated successfully', 'frontend-admin' ), $is_valid );
			} else {
				if ( $license ) {
					$instruction = __( 'Your license is not valid', 'frontend-admin' );
				} else {
					$instruction = __( 'Enter your license key to activate pro features', 'frontend-admin' );
				}
			}

			$local_fields = array(
				'fea_main_license_key' => array(
					'label'         => __( 'License Key', 'frontend-admin' ),
					'type'          => 'text',
					'instructions'  => $instruction,
					'required'      => 0,
					'default_value' => $license,
					'wrapper'       => array(
						'width' => '50.1',
						'class' => '',
						'id'    => '',
					),
				),
			);

			return $local_fields;
		}

		public function pro_form_tabs( $tabs ) {
			if ( class_exists( 'woocommerce' ) ) {
				$tabs['product'] = __( 'Product', 'frontend-admin' );
			}
			$tabs['steps'] = __( 'Multi Step', 'frontend-admin' );
			return $tabs;
		}

		public function included_files(){
			include_once 'forms/actions/email.php';
			include_once 'forms/actions/mailchimp.php';
			include_once 'forms/actions/pdf.php';
			include_once 'forms/actions/webhook.php';
			include_once 'addon-installer.php';
			
			if ( class_exists( 'woocommerce' ) ) {
				include_once 'forms/actions/product.php';
				include_once 'forms/actions/woo-checkout.php';
			}elseif ( class_exists( 'Easy_Digital_Downloads' ) ) {
				include_once 'forms/actions/edd-checkout.php';
			}
			
		}

		public function init(){

			add_action( 'frontend_admin/forms/enqueue_scripts', array( $this, 'scripts' ) );
			
			add_filter( 'frontend_admin/field_types', array( $this, 'field_types' ) );

			add_filter( 'frontend_admin/admin_tabs', array( $this, 'pro_tabs' ), 15 );
		
			add_filter( 'frontend_admin/forms/form_types', array( $this, 'form_types' ) );
			add_filter( 'frontend_admin/forms/settings_tabs', array( $this, 'pro_form_tabs' ) );
			add_filter( 'frontend_admin/forms/settings/permissions', array( $this, 'permissions_settings' ) );
			add_filter( 'frontend_admin/forms/settings/submit_actions', array( $this, 'submit_actions_settings' ) );
			add_action( 'frontend_admin/forms/included_files', array( $this, 'included_files' ) );


			// elementor
			require_once( 'elementor/main.php' );

			/* if ( class_exists( 'woocommerce' ) ) {
				require( 'woocommerce/module.php' );
			} */
		}


		public function is_license_active() {

			if ( function_exists( 'feap_freemius' ) ) {
				return feap_freemius()->can_use_premium_code__premium_only();
			}

			return get_option( 'fea_main_license_valid' );
		}

		public function plugin_updater() {
			require_once 'license.php';

			// To support auto-updates, this needs to run during the wp_version_check cron job for privileged users.
			$doing_cron = defined( 'DOING_CRON' ) && DOING_CRON;
			if ( ! current_user_can( 'manage_options' ) && ! $doing_cron ) {
				return;
			}

			// retrieve our license key from the DB
			$license_key = trim( get_option( 'fea_main_license_key' ) );

			if ( $this->is_license_active() ) {
				require_once 'updater.php';
				// setup the updater
				$updater = new \Frontend_Admin\Plugin_Updater(
					'https://dynamiapps.com/wp-json/paddlepress-api/v1/update',
					__FILE__,
					array(
						'version'      => FEA_VERSION,   // current version number
						'license_key'  => $license_key,             // license key (used get_option above to retrieve from DB)
						'license_url'  => home_url(),             // license domain
						'download_tag' => 'frontend-admin-pro',            // download tag slug
						'beta'         => false,
					)
				);
			}

		}
	

		public function after_theme_setup() {
			global $fea_instance;
			if( $fea_instance && $this->is_license_active() ){
				$fea_instance->pro_features = $this;
			}else{
				$fea_instance->pro_features = null;
			}
		
		}

		public function __construct( $data = false ) {
			if( empty( $data['using_freemius'] ) ){
				add_action( 'init', array( $this, 'plugin_updater' ) );
				add_filter( 'frontend_admin/admin_tabs', array( $this, 'license_tab' ), 16 );
				add_filter( 'frontend_admin/license_fields', array( $this, 'get_settings_fields' ) );
				add_action( 'admin_menu', array( $this, 'license_page' ), 20 );
			}else{
				$this->using_freemius = true;
			}
			add_action( 'after_setup_theme', array( $this, 'after_theme_setup' ), 12 );
			
			if ( ! $this->is_license_active() ) {
				return;
			}
			
			$this->init();
			do_action( 'front_end_admin_pro_loaded' );
		}
	}
endif;
