<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

?>
<div class="pack-summary">
	<div class="pack-image js-modal"
		tabindex="0"
		data-modal-close-img="<?php echo esc_url( GENESIS_JS_URL . '/vendor/modal/modal-close.png' ); ?>"
		data-modal-content-id="<?php echo esc_attr( 'pack-details-' . $pack_slug ); ?>"
		data-modal-prefix-class="genesis">
		<div class="pack-screenshot">
			<?php echo $pack_image; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- image attributes escaped in `genesis_onboarding_starter_packs_list()`. ?>
		</div>

		<span class="pack-overlay"><?php esc_html_e( 'Pack Details', 'genesis' ); ?></span>
	</div>

	<div class="pack-details">
		<h2 class="pack-name" id="<?php echo esc_attr( 'pack-name-' . $pack_slug ); ?>">
			<?php echo esc_html( $pack['title'] ); ?>
		</h2>

		<div class="pack-actions">
			<button class="button-primary genesis-install-pack" data-pack="<?php echo esc_attr( $pack_slug ); ?>" aria-label="<?php echo esc_attr( $pack_install_label ); ?>">Install Pack</button>
		</div>
	</div>
</div>
