<?php

/**
 * MonsterInsights PPC Tracking Bing Provider class.
 *
 * @access public
 * @since 1.0.0
 *
 * @package MonsterInsights_PPC_Tracking
 * @subpackage Ad_Providers
 * @author  David Paternina
 */
class MonsterInsights_PPC_Tracking_Bing extends MonsterInsights_PPC_Tracking_Provider {

    public function __construct() {
        parent::__construct();
    }

    /**
     * @inheritDoc
     */
    public function get_provider_id() {
        return 'bing';
    }

    /**
     * @inheritDoc
     */
    protected function add_frontend_hooks() {
        add_action( 'monsterinsights_frontend_tracking_gtag_after_pageview', array( $this, 'inject_pixel_code' ) );
    }

	/**
	 * Not in use for Bing
	 */
	protected function init_server_handler() {
        return null;
    }

    /**
     * @return void
     */
    public function inject_pixel_code() {
        $tag_id = $this->get_tag_id();

        if ( empty( $tag_id ) ) {
            return;
        }
        ob_start();
        ?>
        <!-- MS UET Tag -->
        (function(w,d,t,r,u)
        {
        var f,n,i;
        w[u]=w[u]||[],f=function()
        {
        var o={ti:"<?php echo esc_attr( $tag_id ); ?>"};
        o.q=w[u],w[u]=new UET(o),w[u].push("pageLoad")
        },
        n=d.createElement(t),n.src=r,n.async=1,n.onload=n.onreadystatechange=function()
        {
        var s=this.readyState;
        s&&s!=="loaded"&&s!=="complete"||(f(),n.onload=n.onreadystatechange=null)
        },
        i=d.getElementsByTagName(t)[0],i.parentNode.insertBefore(n,i)
        })
        (window,document,"script","//bat.bing.com/bat.js","uetq");
        <!-- End UET Tag -->
        <?php
        echo ob_get_clean();
    }

    /**
     * @inheritDoc
     */
    public function maybe_print_conversion_code( $conversion_data, $customer_info = [] ) {
        $tag_id = $this->get_tag_id();

        if ( empty( $tag_id ) ) {
            return false;
        }

        $order_id = $conversion_data['order_id'];
        $order_total = $conversion_data['order_total'];
        $currency = $conversion_data['currency'];
        $platform = $conversion_data['ecommerce_platform'];

        // TODO Work a way of adding product details to conversion
        // 'ecomm_prodid': ['REPLACE_WITH_PRODUCT_ID', 'REPLACE_WITH_PRODUCT_ID', …],

        /**
         * At the moment bing doesn't seem to support custom parameters.
         * This is why we don't send the 'ecommerce_platform' parameter like we do with the other integrations.
         */
        ob_start();
        ?>
        window.uetq = window.uetq || [];
        window.uetq.push('event', 'purchase', {
            'transaction_id': '<?php echo esc_attr( $order_id ); ?>',
            'ecomm_pagetype': 'purchase',
            'ecomm_totalvalue': <?php echo esc_attr( $order_total ); ?>,
            'revenue_value': <?php echo esc_attr( $order_total ); ?>,
            'currency': '<?php echo esc_attr( $currency ); ?>'
        });
        <?php
        echo ob_get_clean();
        return true;
    }

    /**
     * Get pixel id from settings
     *
     * @return string
     */
    private function get_tag_id() {
        return apply_filters( 'monsterinsights_ppc_tracking_bing_tag_id', monsterinsights_get_option( 'ads_bing_tag_id' ) );
    }

	/**
	 * @inheritDoc
	 */
	public function get_tracking_id()
	{
		return $this->get_tag_id();
	}

	/**
	 * Not in use for Bing
	 */
	public function get_api_token()
	{
		return null;
	}

    /**
     * @inheritdoc
     */
    public function is_active() {
        $is_active = !empty( $this->get_provider_id() );

        return apply_filters(
            "monsterinsights_ppc_tracking_provider_active_{$this->get_provider_id()}",
            $is_active
        );
    }
}
