<?php

/**
 * MonsterInsights PPC Tracking Meta Provider class.
 *
 * @access public
 * @since 1.0.0
 *
 * @package MonsterInsights_PPC_Tracking
 * @subpackage Ad_Providers
 * @author  David Paternina
 */
class MonsterInsights_PPC_Tracking_Meta extends MonsterInsights_PPC_Tracking_Provider {

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @inheritDoc
     */
    public function get_provider_id()
    {
        return 'meta';
    }

    /**
     * @inheritDoc
     */
    protected function add_frontend_hooks()
    {
        add_action( 'monsterinsights_frontend_tracking_gtag_after_pageview', array( $this, 'inject_pixel_code' ) );
    }

	/**
	 * @inheritdoc
	 */
	protected function init_server_handler()
    {
        return new MonsterInsights_PPC_Meta_Server( $this );
    }

    /**
     * @return void
     */
    public function inject_pixel_code()
    {
        $pixel_id = $this->get_pixel_id();

        if ( empty( $pixel_id ) ) {
            return;
        }
        ob_start();
        ?>
        <!-- Meta Pixel Code -->
        !function(f,b,e,v,n,t,s)
        {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
            n.callMethod.apply(n,arguments):n.queue.push(arguments)};
            if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
            n.queue=[];t=b.createElement(e);t.async=!0;
            t.src=v;s=b.getElementsByTagName(e)[0];
            s.parentNode.insertBefore(t,s)}(window, document,'script',
            'https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', '<?php echo esc_attr( $pixel_id ); ?>');
        fbq('track', 'PageView');
        <!-- End Meta Pixel Code -->
        <?php
        echo ob_get_clean();
    }

    /**
     * @inheritDoc
     */
    public function maybe_print_conversion_code( $conversion_data, $customer_info = [] )
    {
        $pixel_id = $this->get_pixel_id();

        if ( empty( $pixel_id ) || $this->is_tracking_server_side() ) {
            return false;
        }

        ob_start();
        ?>
        fbq('track', 'Purchase', {
            currency:           '<?php echo esc_attr( $conversion_data['currency'] ); ?>',
            value:              <?php echo esc_attr( $conversion_data['order_total'] ); ?>,
            order_id:           '<?php echo esc_attr( $conversion_data['order_id'] ); ?>',
            ecommerce_platform: '<?php echo esc_attr( $conversion_data['ecommerce_platform'] ); ?>'
        });
        <?php
        echo ob_get_clean();

        return true;
    }

    /**
     * Get pixel id from settings
     *
     * @return string
     */
    public function get_pixel_id()
    {
        return apply_filters( 'monsterinsights_ppc_tracking_meta_pixel_id', monsterinsights_get_option( 'ads_meta_pixel_id' ) );
    }

	/**
	 * @inheritDoc
	 */
	public function get_tracking_id()
	{
		return $this->get_pixel_id();
	}

	/**
	 * @inheritDoc
	 */
	public function get_api_token()
	{
		return apply_filters( 'monsterinsights_ppc_tracking_meta_api_token', monsterinsights_get_option( 'ads_meta_api_access_token' ) );
	}

    /**
     * @inheritdoc
     */
    public function is_active()
    {
        $is_active = !empty( $this->get_pixel_id() );

        return apply_filters(
            "monsterinsights_ppc_tracking_provider_active_{$this->get_provider_id()}",
            $is_active
        );
    }
}
