<?php
/**
 * CRUD class for Site Notes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class MonsterInsights_Site_Notes_Important_Events_Model {
	/**
	 * Holds instance of self object.
	 */
	private static $instance;

	/**
	 * Create singleton instance of the class.
	 */
	public static function get_instance() {
		if ( ! self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Add new site note.
	 *
	 * @param array $args {
	 *     An array of elements that create the site note.
	 *
	 *     @type string $description  The actual title/note of the site note. This data is required.
	 *     @type int    $author_id    ID of the site note creator/author.
	 *     @type string $date         Date of the note. Format: Y-m-d H:i:s. Default value is current time.
	 *     @type int    $category_id  Term ID from monsterinsights_note_category taxonomy.
	 *     @type int    $media_id     Attachment post ID. Media needs to be uploaded in the WP media library.
	 *     @type bool   $important    Is the note important or not. Default is false.
	 * }
	 *
	 * @return int|false
	 */
	public function create( $args ) {
		$controller = MonsterInsights_SiteNotes_Controller::get_instance();

		// If no description then don't create site note.
		if ( ! isset( $args['description'] ) ) {
			return false;
		}

		$params = array(
			'note'      => sanitize_text_field( $args['description'] ),
			'author_id' => isset( $args['author_id'] ) ? intval( $args['author_id'] ) : null,
			'date'      => isset( $args['date'] ) ? sanitize_text_field( $args['date'] ) : null,
			'category'  => isset( $args['category_id'] ) ? intval( $args['category_id'] ) : null,
			'medias'    => isset( $args['media_id'] ) ? array( intval( $args['media_id'] ) ) : null,
			'important' => isset( $args['important'] ) && $args['important'] ? '1' : '0',
		);

		return $controller->create_note( $params );
	}
}
