<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Main ads tracking and conversions class
 *
 * @access public
 * @since 1.0.0
 *
 * @package MonsterInsights_PPC_Tracking
 * @author  David Paternina
 */
class MonsterInsights_PPC_Tracking {

    /**
     * @var MonsterInsights_PPC_Tracking_Provider[]
     */
    private $ad_providers;

    public function __construct() {
		$this->init_tracking();
    }

    /**
     * Initialize tracking
     *
     * @return void
     */
    public function init_tracking() {
        $this->require_files();
        $this->init_ad_providers();
        $this->init_ecommerce_providers();
    }

    /**
     * Initialize ad providers
     *
     * @return void
     */
    private function init_ad_providers() {
        $this->ad_providers = [
            new MonsterInsights_PPC_Tracking_Google(),
            new MonsterInsights_PPC_Tracking_Meta(),
            new MonsterInsights_PPC_Tracking_Bing()
        ];
    }

    /**
     * Initialize ecommerce providers
     *
     * @return void
     */
    private function init_ecommerce_providers() {
        new MonsterInsights_PPC_Tracking_Ecommerce_Woo( $this->ad_providers );
        new MonsterInsights_PPC_Tracking_Ecommerce_EDD( $this->ad_providers );
        new MonsterInsights_PPC_Tracking_Ecommerce_MemberPress( $this->ad_providers );
        new MonsterInsights_PPC_Tracking_Ecommerce_RCP( $this->ad_providers );
        new MonsterInsights_PPC_Tracking_Ecommerce_GiveWP( $this->ad_providers );
        new MonsterInsights_PPC_Tracking_Ecommerce_Lifter_LMS( $this->ad_providers );
    }

    /**
     * Load integration classes
     *
     * @return void
     */
    private function require_files() {

        //  Load parent classes
        require_once plugin_dir_path( __FILE__ ) . 'ad-providers/class-monsterinsights-ppc-tracking-provider.php';
        require_once plugin_dir_path( __FILE__ ) . 'ecommerce-providers/class-monsterinsights-ppc-tracking-ecommerce-tracking.php';

        //  Load specific integration classes

	    //  Load Server Classes
        require_once plugin_dir_path( __FILE__ ) . 'ad-providers/server/class-monsterinsights-ppc-server.php';
        require_once plugin_dir_path( __FILE__ ) . 'ad-providers/server/class-monsterinsights-ppc-meta-server.php';

        //  Google Ads
        require_once plugin_dir_path( __FILE__ ) . 'ad-providers/class-monsterinsights-ppc-tracking-google.php';
        //  Meta
        require_once plugin_dir_path( __FILE__ ) . 'ad-providers/class-monsterinsights-ppc-tracking-meta.php';
        //  Bing
        require_once plugin_dir_path( __FILE__ ) . 'ad-providers/class-monsterinsights-ppc-tracking-bing.php';

        //  WooCommerce
        require_once plugin_dir_path( __FILE__ ) . 'ecommerce-providers/class-monsterinsights-ppc-tracking-ecommerce-woo.php';

        //  EDD
        require_once plugin_dir_path( __FILE__ ) . 'ecommerce-providers/class-monsterinsights-ppc-tracking-ecommerce-edd.php';

        //  MemberPress
        require_once plugin_dir_path( __FILE__ ) . 'ecommerce-providers/class-monsterinsights-ppc-tracking-ecommerce-memberpress.php';

        //  RCP
        require_once plugin_dir_path( __FILE__ ) . 'ecommerce-providers/class-monsterinsights-ppc-tracking-ecommerce-rcp.php';

        //  GiveWP
        require_once plugin_dir_path( __FILE__ ) . 'ecommerce-providers/class-monsterinsights-ppc-tracking-ecommerce-give-wp.php';

        //  LifterLMS
        require_once plugin_dir_path( __FILE__ ) . 'ecommerce-providers/class-monsterinsights-ppc-tracking-ecommerce-lifter-lms.php';
    }
}

new MonsterInsights_PPC_Tracking();
