<?php
/**
 * Uncanny Automator action to create Site Notes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class MonsterInsights_Site_Notes_IE_Action_Create_Site_Notes extends \Uncanny_Automator\Recipe\Action {

	/**
	 * Action Setup
	 */
	protected function setup_action() {
		// Define the Actions's info
		$this->set_integration( 'MONSTERINSIGHTS_SITE_NOTES' );
		$this->set_action_code( 'CREATE_SITE_NOTES' );
		$this->set_action_meta( 'SITE_NOTE_TEXT' );
		$this->set_requires_user( false );

		// Define the Action's sentence
		$this->set_sentence( sprintf( esc_attr__( 'Add {{Site Note Information:%1$s}}', 'monsterinsights-site-notes-important-events' ), $this->get_action_meta() ) );
		$this->set_readable_sentence( esc_attr__( 'Create {{Site Note}} using MonsterInsights Site Notes Integration', 'monsterinsights-site-notes-important-events' ) );
	}

	/**
	 * Option field on recipe page.
	 */
	public function options() {
		return array(
			Automator()->helpers->recipe->field->text(
				array(
					'option_code' => 'SITE_NOTE_TEXT',
					'label'       => 'Site Note Message',
					'input_type'  => 'text',
					'description' => 'Please write the information which you want to add as a site note.',
					'placeholder' => 'Add site note message',
				)
			),
		);
	}

	/**
	 * Action processing method.
	 * Here we will create site note.
	 */
	protected function process_action( $user_id, $action_data, $recipe_id, $args, $parsed ) {
		if ( ! MonsterInsights()->license->license_can( 'agency' ) ) {
			return;
		}

		$action_meta = $action_data['meta'];

		$text = sanitize_text_field( Automator()->parse->text( $action_meta['SITE_NOTE_TEXT'], $recipe_id, $user_id, $args ) );

		monsterinsights_add_site_note( array(
			'description' => $text,
		) );

		return true;
	}
}
