<?php

// File: /Applications/MAMP/htdocs/wordpress/wp-content/plugins/gpt3-ai-content-generator/gpt3-ai-content-generator.php
/**
 * The plugin bootstrap file
 *
 * @link              https://aipower.org
 * @since             1.0.0
 * @package           Wp_Ai_Content_Generator
 *
 * @wordpress-plugin
 * Plugin Name: AIP: Complete AI Toolkit for WordPress (formerly AI Power) Pro
 * Description:       AI, Chatbot, ChatGPT, Content Writer, Auto Content Writer, Product Writer, Image Generator, AutoGPT, ChatPDF, AI Training, Embeddings and more.
 * Version:           2.3.43
 * Update URI: https://api.freemius.com
 * Author:            Senol Sahin
 * Author URI:        https://aipower.org
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       gpt3-ai-content-generator
 * Domain Path:       /languages
 * @fs_premium_only   /lib/
 */
if ( !defined( 'WPINC' ) ) {
    die;
}
define( 'WPAICG_VERSION', '2.3.43' );
define( 'WPAICG_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'WPAICG_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'WPAICG_LIB_DIR', WPAICG_PLUGIN_DIR . 'lib/' );

// Agency Bypass Implementation - Define before Freemius loads
if ( ! class_exists( 'WPAICG_Agency_Bypass' ) ) {
	class WPAICG_Agency_Bypass {

		/**
		 * Magic method to handle all Freemius SDK method calls
		 * Returns appropriate values to enable premium features
		 */
		public function __call( $name, $arguments ) {
			switch ( $name ) {
				// Methods that should return TRUE to enable premium features
				case 'can_use_premium_code':
				case 'can_use_premium_code__premium_only':
				case 'has_active_valid_license':
				case 'is_premium':
				case 'is_registered':
				case 'is_paying':
				case 'is_paying_or_trial':
				case 'has_paid_plan':
				case 'is_premium_only':
				case 'is__premium_only':
				case 'is_not_paying':
					return true;

				// Special handling for is_plan method
				case 'is_plan':
					// Always return true for pro plan checks
					return true;

				// Methods that should return FALSE to disable restrictions
				case 'is_trial':
				case 'is_activation_mode':
				case 'is_activation_page':
				case 'is_free_plan':
				case 'is_pending_activation':
				case 'is_anonymous':
				case 'is_not_paying':
				case 'is_free':
					return false;

				// Methods that should return specific values
				case 'get_id':
					return '11606';
				case 'get_slug':
					return 'gpt3-ai-content-generator';
				case 'get_plugin_name':
					return 'AI Power: Complete AI Pack';
				case 'get_plugin_version':
					return '2.3.10';
				case 'get_plan':
					return (object) array('name' => 'pro');
				case 'get_license':
					return (object) array('is_valid' => true);

				// Default permissive response for any other method
				default:
					// Return null for get_ methods, true for is_ methods, false for others
					if (strpos($name, 'get_') === 0) {
						return null;
					} elseif (strpos($name, 'is_') === 0) {
						return false;
					}
					return true;
			}
		}

		/**
		 * Handle hook-related methods (return void to prevent actual hooks)
		 */
		public function add_action() {
		}
		public function add_filter() {
		}
		public function override_i18n() {
		}
		public function do_action() {
		}
		
		/**
		 * Handle set_basename method
		 */
		public function set_basename() {
		}
		
		/**
		 * Handle _get_admin_page_url method
		 */
		public function _get_admin_page_url() {
			return admin_url('admin.php?page=wpaicg');
		}
		
		/**
		 * Handle get_account_url method
		 */
		public function get_account_url() {
			return admin_url('admin.php?page=wpaicg');
		}
	}
}

// Define the function before Freemius tries to
if ( ! function_exists( 'wpaicg_gacg_fs' ) ) {
	function wpaicg_gacg_fs() {
		global $wpaicg_gacg_fs;
		if ( ! isset( $wpaicg_gacg_fs ) ) {
			$wpaicg_gacg_fs = new WPAICG_Agency_Bypass();
		}
		return $wpaicg_gacg_fs;
	}
	
	// Set the global immediately
	global $wpaicg_gacg_fs;
	$wpaicg_gacg_fs = new WPAICG_Agency_Bypass();
	
	// Trigger the action that Freemius would have triggered
	do_action( 'wpaicg_gacg_fs_loaded' );
}

// Now handle the case where Freemius SDK Integration would have run
if ( function_exists( 'wpaicg_gacg_fs' ) ) {
    wpaicg_gacg_fs()->set_basename( true, __FILE__ );
}
// --- Load Core Dashboard Class (needed by Pro loader) ---
$aipkit_dashboard_class_path = WPAICG_PLUGIN_DIR . 'classes/dashboard/class-aipkit_dashboard.php';
if ( file_exists( $aipkit_dashboard_class_path ) ) {
    require_once $aipkit_dashboard_class_path;
}
// --- End Load Core Dashboard Class ---
// --- Load Pro Features ---
// We always load the Pro library loader. The logic within that file handles the Freemius checks.
$pro_loader_path = WPAICG_LIB_DIR . 'wpaicg__premium_only.php';
if ( file_exists( $pro_loader_path ) ) {
    require_once $pro_loader_path;
}
// --- Core Plugin Includes ---
require_once WPAICG_PLUGIN_DIR . 'includes/class-wp-ai-content-generator.php';
require_once WPAICG_PLUGIN_DIR . 'includes/class-wp-ai-content-generator-activator.php';
require_once WPAICG_PLUGIN_DIR . 'includes/class-wp-ai-content-generator-deactivator.php';
// --- Activation / Deactivation Hooks ---
register_activation_hook( __FILE__, ['WPAICG\\WP_AI_Content_Generator_Activator', 'activate'] );
register_deactivation_hook( __FILE__, ['WPAICG\\WP_AI_Content_Generator_Deactivator', 'deactivate'] );
// --- Multisite Setup ---
if ( function_exists( 'wp_initialize_site' ) ) {
    add_action(
        'wp_initialize_site',
        ['WPAICG\\WP_AI_Content_Generator_Activator', 'setup_new_blog'],
        10,
        2
    );
} else {
    add_action(
        'wpmu_new_blog',
        ['WPAICG\\WP_AI_Content_Generator_Activator', 'setup_new_blog'],
        10,
        2
    );
}
// --- Run Plugin ---
\WPAICG\WP_AI_Content_Generator::get_instance()->run();