<?php
/**
 * Happy Addons Pro widget base
 *
 * @package Happy_Addons
 */
namespace Happy_Addons_Pro\Widget;

use Happy_Addons\Elementor\Widget\Base as Widget_Base;

defined( 'ABSPATH' ) || die();

abstract class Base extends Widget_Base {

	/**
     * Get widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        /**
         * Automatically generate widget name from class
         *
         * Card will be card
         * Blog_Card will be blog-card
         */
        $name = str_replace( strtolower(__NAMESPACE__), '', strtolower($this->get_class_name()) );
        $name = str_replace( '_', '-', $name );
        $name = ltrim( $name, '\\' );
        return 'ha-' . $name;
    }

    /**
     * Get widget categories.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'happy_addons_pro_category' ];
    }

	protected function is_dynamic_content(): bool {
		return true;
	}

    /**
     * Overriding default function to add custom html class.
     *
     * @return string
     */
    public function get_html_wrapper_class() {
        $html_class = parent::get_html_wrapper_class();
        $html_class .= ' happy-addon-pro';
        return $html_class;
    }
}
