<?php

	add_action( 'admin_menu', 'ihafs_submenu' );
	add_action( 'admin_init', 'ihafs_settings_init' );

	function ihafs_submenu(){

		add_submenu_page( 'edit.php?post_type=ihafs_script', esc_html__('Settings', 'ihafs-pro'), esc_html__('Settings', 'ihafs-pro'), 'manage_options', 'ihafs-setting-options', 'ihafs_seeting_options_page_html' );

		add_submenu_page( 'edit.php?post_type=ihafs_script', esc_html__('Our Plugins', 'ihafs-pro'), esc_html__('Our Plugins', 'ihafs-pro'), 'manage_options', 'ihafs-plugin-options', 'ihafs_plugin_options_page_html' );

		add_submenu_page( 'edit.php?post_type=ihafs_script', esc_html__('Our Theme', 'ihafs-pro'), esc_html__('Our Theme', 'ihafs-pro'), 'manage_options', 'ihafs-theme-options', 'ihafs_theme_options_page_html' );
	}

	function ihafs_settings_init(){

		register_setting( 'seeting_options_group_1', 'ihafs_setting_opt' );

		add_settings_section(
			'ihafs_setting_options_group_1_section', 
			'', 
			null, 
			'seeting_options_group_1'
		);

		add_settings_field( 
			'post_number_toshow', 
			__( 'Post List', 'ihafs-pro' ), 
			'ihafs_post_no_render', 
			'seeting_options_group_1', 
			'ihafs_setting_options_group_1_section' 
		);

		add_settings_field( 
			'page_number_toshow', 
			__( 'Page List', 'ihafs-pro' ), 
			'ihafs_page_no_render', 
			'seeting_options_group_1', 
			'ihafs_setting_options_group_1_section' 
		);

	}

	function ihafs_post_no_render(  ) { 

		$options = get_option( 'ihafs_setting_opt' );
		$post_list_val = isset($options['post_number_toshow']) ? $options['post_number_toshow'] : '50';
		?>
		<input type='text' name='ihafs_setting_opt[post_number_toshow]' value="<?php echo esc_attr($post_list_val); ?>">
		<p class="description"><?php esc_html_e('Set The number to show how many posts in the list on select only posts (Default: 50).','htpm')?></p>
		<?php

	}

	function ihafs_page_no_render(  ) { 

		$options = get_option( 'ihafs_setting_opt' );
		$page_list_val = isset($options['page_number_toshow']) ? $options['page_number_toshow'] : '50';
		?>
		<input type='text' name='ihafs_setting_opt[page_number_toshow]' value="<?php echo esc_attr($page_list_val); ?>">
		<p class="description"><?php esc_html_e('The number to show how many pages in the list on select only pages (Default: 50).','htpm') ?></p>
		<?php

	}

	function ihafs_plugin_options_page_html(){
		// check user capabilities
		if ( ! current_user_can( 'manage_options' ) ) {
		 	return;
		}

		// show message when updated
		if ( isset( $_GET['settings-updated'] ) ) {
		 	add_settings_error( 'ihafs_pro_messages', 'ihafs_pro_message', esc_html__( 'Settings Saved', 'ihafs-pro' ), 'updated' );
		}
		 
		 // show error/update messages
		 settings_errors( 'ihafs_pro_messages' );
		?>
			<div class="wrap">
				<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
				<div class="ihafs-row">
		        	<div class="ihafs-column-2">
		                <div class="ihafs-singleplugin">
		                	<div class="ihafs-thumb">
		                		<img src="<?php echo IHAFS_PRO_URI . '/admin/images/plugins-image/woolentor.png' ?>">
		                	</div>
		                	<div class="ihafs-content">
			                    <h3><?php esc_html_e( 'Woolentor Pro','htpm' );?></h3>
			                    <p><?php esc_html_e( 'WooLentor is a most popular WooCommerce Elementor Addon on WordPress.org. Downloaded more than 100,000 times and 15,000 stores are using WooLentor plugin.', 'htpm' )?></p>
			                    <div class="ihafs-button-area">
			                        <a class="button primary" href="https://hasthemes.com/plugins/woolentor-pro-woocommerce-page-builder/" target="_blank"><?php esc_html_e( 'More Details', 'htpm' )?></a>
			                       
			                        <?php ihafs_plugin_install_button( 'woolentor-addons/woolentor_addons_elementor.php','woolentor-addons' ); ?>
			                    </div>
			                </div>
		                </div>
		            </div>
		            <div class="ihafs-column-2">
		                <div class="ihafs-singleplugin">
		                	<div class="ihafs-thumb">
		                		<img src="<?php echo IHAFS_PRO_URI . '/admin/images/plugins-image/ht-mega.png' ?>">
		                	</div>
		                	<div class="ihafs-content">
			                    <h3><?php esc_html_e( 'HT Mega','htpm' );?></h3>
			                    <p><?php esc_html_e( 'HTMega is a absolute addons for elementor includes 80+ elements & 360 Blocks with unlimited variations.', 'htpm' )?></p>
			                    <div class="ihafs-button-area">
			                        <a class="button primary" href="https://hasthemes.com/plugins/ht-mega-pro/" target="_blank"><?php esc_html_e( 'More Details', 'htpm' )?></a>
			                       
			                        <?php ihafs_plugin_install_button( 'ht-mega-for-elementor/htmega_addons_elementor.php','ht-mega-for-elementor' ); ?>
			                    </div>
			                </div>
		                </div>
		            </div>
		            <div class="ihafs-column-2">
		                <div class="ihafs-singleplugin">
		                	<div class="ihafs-thumb">
		                		<img src="<?php echo IHAFS_PRO_URI . '/admin/images/plugins-image/multy-currency.png' ?>">
		                	</div>
		                	<div class="ihafs-content">
			                    <h3><?php esc_html_e( 'Multi Currency Pro for WooCommerce','htpm' );?></h3>
			                    <p><?php esc_html_e( 'Multi-Currency Pro for WooCommerce is a prominent currency switcher plugin for WooCommerce.', 'htpm' )?></p>
			                    <div class="ihafs-button-area">
			                        <a class="button primary" href="https://hasthemes.com/plugins/multi-currency-pro-for-woocommerce/" target="_blank"><?php esc_html_e( 'More Details', 'htpm' )?></a>
			                        <?php ihafs_plugin_install_button( 'wc-multi-currency/wcmilticurrency.php','wc-multi-currency' ); ?>
			                    </div>
		                    </div>
		                </div>
		            </div>
		            <div class="ihafs-column-2">
		                <div class="ihafs-singleplugin">
		                	<div class="ihafs-thumb">
		                		<img src="<?php echo IHAFS_PRO_URI . '/admin/images/plugins-image/ht-script.png' ?>">
		                	</div>

		                	<div class="ihafs-content">
			                    <h3><?php esc_html_e( 'HT Script - Insert Headers and Footers Code','htpm' );?></h3>
			                    <p><?php esc_html_e( 'Insert Headers and Footers Code allows you to insert Google Analytics, Facebook Pixel, custom CSS, custom HTML, JavaScript code to your website header and footer without modifying your theme code.', 'htpm' )?></p>
			                    <div class="ihafs-button-area">
			                        <a class="button primary" href="https://hasthemes.com/plugins/insert-headers-and-footers-code-ht-script/" target="_blank"><?php esc_html_e( 'More Details', 'htpm' )?></a>
			                        <?php ihafs_plugin_install_button( 'insert-headers-and-footers-script/init.php','insert-headers-and-footers-script' ); ?>
			                    </div>
		                	</div>
		                </div>
		            </div>
		            <div class="ihafs-column-2">
		                <div class="ihafs-singleplugin">
		                	<div class="ihafs-thumb">
		                		<img src="<?php echo IHAFS_PRO_URI . '/admin/images/plugins-image/hashbar.png' ?>">
		                	</div>
		                	<div class="ihafs-content">
			                    <h3><?php esc_html_e( 'HashBar Pro','htpm' );?></h3>
			                    <p><?php esc_html_e( 'HashBar is a WordPress Notification / Alert / Offer Bar plugin which allows you to create unlimited notification bars.This plugin has option to show email subscription form, Offer text and buttons about your promotions', 'htpm' )?></p>
			                    <div class="ihafs-button-area">
			                        <a class="button primary" href="https://hasthemes.com/wordpress-notification-bar-plugin/" target="_blank"><?php esc_html_e( 'More Details', 'htpm' )?></a>
			                        <?php ihafs_plugin_install_button( 'hashbar-wp-notification-bar/init.php','hashbar-wp-notification-bar' ); ?>
			                    </div>
			                </div>
		                </div>
		            </div>
		            <div class="ihafs-column-2">
		                <div class="ihafs-singleplugin">
		                	<div class="ihafs-thumb">
		                		<img src="<?php echo IHAFS_PRO_URI . '/admin/images/plugins-image/wcbuilder.png' ?>">
		                	</div>
		                	<div class="ihafs-content">
			                    <h3><?php esc_html_e( 'WC Builder','htpm' );?></h3>
			                    <p><?php esc_html_e( 'WC Builder Pro is a WooCommerce Page Builder which allows you to build Shop, Product Details, Cart, Checkout, My Account and Thank You page without even touching a single line of code!', 'htpm' )?></p>
			                    <div class="ihafs-button-area">
			                        <a class="button primary" href="https://hasthemes.com/plugins/wc-builder-woocoomerce-page-builder-for-wpbakery/#pricing" target="_blank"><?php esc_html_e( 'More Details', 'htpm' )?></a>
			                       
			                        <?php ihafs_plugin_install_button( 'wc-builder/wc-builder.php','wc-builder' ); ?>
			                    </div>
			                </div>
		                </div>
		            </div>
	        	</div>
			</div>
		<?php
	}

	function ihafs_theme_options_page_html(){
		// check user capabilities
		if ( ! current_user_can( 'manage_options' ) ) {
		 	return;
		}

		// show message when updated
		if ( isset( $_GET['settings-updated'] ) ) {
		 	add_settings_error( 'ihafs_pro_messages', 'ihafs_pro_message', esc_html__( 'Settings Saved', 'ihafs-pro' ), 'updated' );
		}
		 
		// show error/update messages
		settings_errors( 'ihafs_pro_messages' );
		?>

			<div class="wrap">
				<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
				<div class="ihafs-row">
		        	<div class="ihafs-column-2">
		                <div class="ihafs-singletheme">
		                	<div class="ihafs-thumb">
		                		<img src="<?php echo IHAFS_PRO_URI . '/admin/images/template-images/preview_flone.png' ?>">
		                	</div>
		                	<div class="ihafs-content content-theme">
			                    <div class="ihafs-button-area">
			                        <?php ihafs_theme_install_button( 'flone','Flone - Multipurpose WooCommerce Theme','https://hasthemes.com/flone-minimal-woocommerce-wordpress-theme/' ); ?>
			                        <a class="button primary theme-button" href="https://hasthemes.com/flone-minimal-woocommerce-wordpress-theme/" target="_blank"><?php esc_html_e( 'More Details', 'ihafs-pro' )?></a>
			                    </div>
			                </div>
		                </div>
		            </div>
		            <div class="ihafs-column-2">
		                <div class="ihafs-singletheme">
		                	<div class="ihafs-thumb">
		                		<img src="<?php echo IHAFS_PRO_URI . '/admin/images/template-images/99fy-preview.jpg' ?>">
		                	</div>
		                	<div class="ihafs-content content-theme">
			                    <div class="ihafs-button-area">
			                        <?php ihafs_theme_install_button( '99fy','99fy - Mega WooCommerce Theme','' ); ?>
			                        <a class="button primary theme-button" href="https://wordpress.org/themes/99fy/" target="_blank"><?php esc_html_e( 'More Details', 'ihafs-pro' )?></a>
			                    </div>
			                </div>
		                </div>
		            </div>
		        </div>
			</div>
		<?php
	}

	function ihafs_seeting_options_page_html(){

		?>
		<form action='options.php' method='post'>

			<h2><?php echo esc_html__( 'HT Sctipt Pro Global Options', 'ihafs-pro' ) ?></h2>

			<?php
			settings_fields( 'seeting_options_group_1' );
			do_settings_sections( 'seeting_options_group_1' );
			submit_button();
			?>

		</form>
		<?php

	}


?>