<?php
/**
 * Plugin Name: HT Script Pro
 * Plugin URI: https://hasthemes.com/plugins/insert-headers-and-footers-code-ht-script/
 * Description: This plugin allow you to insert script in headers and footers
 * Version: 1.1.0
 * Author: CodeCarnival
 * Author URI: https://hasthemes.com/
 * License:  	GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain: ihafs-pro
 * Domain Path: /languages
*/

// define path
define( 'IHAFS_PRO_ROOT',  __FILE__);
define( 'IHAFS_PRO_URI', plugins_url('', __FILE__) );
define( 'IHAFS_PRO_DIR', dirname( __FILE__ ) );

// include all files
if( is_admin() ){
	include_once( IHAFS_PRO_DIR. '/inc/custom-posts.php');
	include_once( IHAFS_PRO_DIR. '/admin/cmb2/init.php');
	include_once( IHAFS_PRO_DIR. '/admin/functions.php');
	include_once( IHAFS_PRO_DIR. '/inc/install-option.php');
	include_once( IHAFS_PRO_DIR. '/inc/plugin-option-page.php');
	include_once( IHAFS_PRO_DIR. '/inc/license/HTScriptPro.php');
}

add_action( 'cmb2_admin_init', 'ihafs_pro_add_metabox' );
function ihafs_pro_add_metabox(){
    include_once( IHAFS_PRO_DIR. '/inc/metabox-multiple-select.php');
    include_once( IHAFS_PRO_DIR. '/inc/metabox.php');
}

//deactivate the light version 
register_activation_hook( IHAFS_PRO_ROOT, 'ihafs_pro_deactivate_light_version' );
function ihafs_pro_deactivate_light_version(){
	if( is_plugin_active('insert-headers-and-footers-script/init.php') ){
        deactivate_plugins('insert-headers-and-footers-script/init.php');
    }
}

// load textdomain
add_action( 'plugins_loaded', 'ihafs_pro_load_textdomain' );
function ihafs_pro_load_textdomain() {
    load_plugin_textdomain( 'ihafs-pro', false, basename(IHAFS_PRO_URI) . '/languages/' );
}

// admin enqueue scripts
add_action( 'admin_enqueue_scripts','ihafs_pro_enqueue_scripts');

function  ihafs_pro_enqueue_scripts($hook){

	//enque css
	wp_enqueue_style( 'ihafs-pro-admin-option-style', IHAFS_PRO_URI.'/admin/css/admin-options.css');
	wp_enqueue_style( 'ihafs-pro-select2-style', IHAFS_PRO_URI.'/admin/css/select2.min.css');
	//enqueue js
	wp_enqueue_script( 'ihafs-pro-select2-script', IHAFS_PRO_URI.'/admin/js/select2.min.js', array('jquery'), '', true);
	wp_enqueue_script( 'ihafs-pro-admin', IHAFS_PRO_URI.'/admin/js/admin.js', array('jquery'), '', true);

	if($hook === 'ihafs_script_page_ihafs-plugin-options' || $hook === 'ihafs_script_page_ihafs-theme-options'){

		wp_enqueue_script( 'ihafs-pro-install-manager', IHAFS_PRO_URI.'/admin/js/install_manager.js', array('jquery', 'wp-util', 'updates'), '', true);

		ihafs_loaclize_data();

	}

}

// load header scripts
add_action( 'wp_head', 'ihafs_pro_load_script_to_header' );
function ihafs_pro_load_script_to_header(){
	$args = array(
		'post_type' => 'ihafs_script',
		'meta_query' => array(
			array(
				'key'     => '_ihafs_condition',
				'value'   => 'in_header',
				'compare' => 'IN',
			),
		),
	);
	if(is_front_page()){
		$current_page_id = get_option('page_on_front');
	}else{
		$current_page_id = get_the_ID();
	}

	$query = new WP_Query($args);

	while($query->have_posts()){
	    $query->the_post();

	    $post_id = get_the_id();
	    
		echo ihafs_pro_output_script($post_id, $current_page_id);

	}
	wp_reset_query();
}

// load footer scripts
add_action( 'wp_footer', 'ihafs_pro_load_script_to_footer' );
function ihafs_pro_load_script_to_footer(){
	$args = array(
		'post_type' => 'ihafs_script',
		'meta_query' => array(
			array(
				'key'     => '_ihafs_condition',
				'value'   => 'in_footer',
				'compare' => 'IN',
			),
		),
	);

	if(is_front_page()){
		$current_page_id = get_option('page_on_front');
	}else{
		$current_page_id = get_the_ID();
	}


	$query = new WP_Query($args);

	while($query->have_posts()){
	    $query->the_post();

	    $post_id = get_the_id();

		echo ihafs_pro_output_script($post_id, $current_page_id);

	}
	wp_reset_query();
}

// load scripts after body
add_action( 'wp_body_open', 'ihafs_pro_load_script_after_body', -1 );
function ihafs_pro_load_script_after_body(){
	$args = array(
		'post_type' => 'ihafs_script',
		'meta_query' => array(
			array(
				'key'     => '_ihafs_condition',
				'value'   => 'after_body',
				'compare' => 'IN',
			),
		),
	);

	if(is_front_page()){
		$current_page_id = get_option('page_on_front');
	}else{
		$current_page_id = get_the_ID();
	}


	$query = new WP_Query($args);

	while($query->have_posts()){
	    $query->the_post();

	    $post_id = get_the_id();

		echo ihafs_pro_output_script($post_id, $current_page_id);

	}
	wp_reset_query();
}

// after check the conditions return script output 
function ihafs_pro_output_script($post_id, $current_page_id){
	$status            = get_post_meta($post_id, '_ihafs_status', true);
	$snippet           = get_post_meta($post_id, '_ihafs_code', true);
	$current_post_type = get_post_type($current_page_id);
	$is_shop 		   = function_exists('is_shop') ? is_shop() : false;

	if(defined('IHAFS_PRO_URI')){
		global $wp_query;

		$show_on = get_post_meta($post_id, '_ihafs_show_on', true);
		$home_pageID = get_option('page_on_front');
		$exclude_posts = get_post_meta($post_id, '_ihafs_exclude_posts', true);
		$exclude_pages = get_post_meta($post_id, '_ihafs_exclude_pages', true);
		$pages_list = get_post_meta($post_id, '_ihafs_pages_list', true);
		$posts_list = get_post_meta($post_id, '_ihafs_posts_list', true);
		$categories_list = get_post_meta($post_id, '_ihafs_categories_list', true);
		$woo_categories_list = get_post_meta($post_id, '_ihafs_woo_categories_list', true);
		$get_page_ids = get_post_meta($post_id, '_ihafs_page_ids', true);
		$tags_list = get_post_meta($post_id, '_ihafs_tags_list', true);
		$existing_cat_post = false;
		$existing_tag_post = false;
		$existing_woo_cat_post = false;

		is_archive() ? $current_category_id = $wp_query->get_queried_object_id() : $current_category_id = '';
		is_archive() ? $current_tag_id = $wp_query->get_queried_object_id() : $current_tag_id = '';
		
		if ( class_exists( 'WooCommerce') && !is_category()) {
			if ( is_shop() || ( is_tax('product_cat') && is_product_category() ) ){

				$current_category_id = $wp_query->get_queried_object_id();
				$page_ids = '';
				$current_page_id = get_option( 'woocommerce_shop_page_id' );
			}else{
				$current_category_id = '';
			}

			if(is_singular() && 'product' == $current_post_type){
				$product = wc_get_product($current_page_id); 
				$product_cat_ids = $product->get_category_ids();

				if(!empty($woo_categories_list)){
					foreach ($product_cat_ids as $id) {
						if(in_array($id, $woo_categories_list)){
							$existing_woo_cat_post = true;
						}
					}
				}
			}

		}

		if(!empty($get_page_ids)){

	    	$page_ids = explode(',', $get_page_ids);

		}

		if(is_single()){
			$post_categories = wp_get_post_categories($current_page_id);
			$post_tages 	 = wp_get_post_tags($current_page_id);
			if(!empty($categories_list)){
				foreach ($post_categories as $value){
					if(in_array($value,$categories_list)){
						$existing_cat_post = true;
					}
				}
			}
			if(!empty($tags_list)){
				foreach ($post_tages as $value){
					if(in_array($value->term_id,$tags_list)){
						$existing_tag_post = true;
					}
				}
			}
		}


		if($status != 'active' || is_admin()){
			return;
		}

		if($show_on == 'only_home' && $current_page_id != $home_pageID){
			return;
		}

		if($show_on == 'full_website' && !empty($exclude_posts) && in_array($current_page_id, $exclude_posts) ){
			return;
		}

		if($show_on == 'full_website' && !empty($exclude_pages) && in_array($current_page_id, $exclude_pages) ){
			return;
		}

		if($show_on == 'only_pages' && ('page' != $current_post_type || (!empty($pages_list) && !in_array($current_page_id, $pages_list)))){
			return;
		}

		if($show_on == 'only_posts' && ('post' != $current_post_type || is_archive() || is_front_page() || is_category() || ( !empty($posts_list) && !in_array($current_page_id, $posts_list) ))){
			return;
		}

		if($show_on == 'only_categories' && !$existing_cat_post){
			return;
		}

		if($show_on == 'woo_categories' && !$existing_woo_cat_post){
			return;
		}

		if($show_on == 'page_ids' && (empty($get_page_ids) || !in_array($current_page_id, $page_ids)) ){
			return;
		}

		if($show_on == 'only_tags' && !$existing_tag_post){
			return;
		}

		if($show_on == 'category_archives' && (!is_category() || !is_archive() || (!empty($categories_list) && !in_array($current_category_id, $categories_list)))){
			return;
		}

		if($show_on == 'tag_archives' && (!is_tag() || !is_archive() || (!empty($tags_list) && !in_array($current_tag_id, $tags_list)))){
			return;
		}

		if($show_on == 'product_category_archives' && ('product' != $current_post_type || !is_archive() || (!empty($woo_categories_list) && !in_array($current_category_id, $woo_categories_list)))){
			return;
		}
	}
	return wp_unslash($snippet);
}