<?php

// add condition column
add_filter( 'manage_ihafs_script_posts_columns', 'ihafs_pro_filter_posts_columns' );
function ihafs_pro_filter_posts_columns( $columns ) {

  $columns = array(
    'cb' => $columns['cb'],
    'title' => $columns['title'],
    'condition' => esc_html__( 'Conditon', 'ihafs-pro' ),
    'date' => $columns['date'],
  );

  return $columns;
}


// condition column value
add_action('plugins_loaded', 'ihafs_pro_posts_custom_column_fire');
function ihafs_pro_posts_custom_column_fire(){
	if(!defined('IHAFS_URI')){
		add_action( 'manage_ihafs_script_posts_custom_column', 'ihafs_pro_posts_custom_column', 10, 2);
	}
}


function ihafs_pro_posts_custom_column( $column, $post_id ) {
  if ( 'condition' === $column ) {
    echo ucwords(get_post_meta( $post_id, '_ihafs_condition', true ));
  }
}

function ihafs_plugin_install_button( $pl_location, $pl_slug ){

    $data = array(
        'slug'      => ( isset( $pl_slug ) ? $pl_slug : '' ),
        'location'  => ( isset( $pl_location ) ? $pl_location : '' ),
    );

    if ( ! is_wp_error( $data ) ) {

        // Installed but Inactive.
        if ( file_exists( WP_PLUGIN_DIR . '/' . $pl_location ) && is_plugin_inactive( $pl_location ) ) {

            $button_classes = 'button activate-now button-primary';
            $button_text    = esc_html__( 'Activate', 'ihafs-pro' );

        // Not Installed.
        } elseif ( ! file_exists( WP_PLUGIN_DIR . '/' . $pl_location ) ) {
            $button_classes = 'button install-now';
            $button_text    = esc_html__( 'Install Now', 'ihafs-pro' );

        // Activated.
        } else {
            $activation_url = '#';
            $button_classes = 'button disabled';
            $button_text    = esc_html__( 'Activated', 'ihafs-pro' );
        }

        ?>
        <span class="htwptemplata-plugin-<?php echo $pl_slug; ?>">
            <button class="<?php echo $button_classes; ?>" data-pluginopt='<?php echo wp_json_encode( $data ); ?>'><?php echo $button_text; ?></button>
        </span>
        <?php
    }

}

function ihafs_theme_install_button( $theme_slug,$name,$prolink ){

    $data = array(
        'slug'      => isset( $theme_slug ) ? $theme_slug : '',
        'name'      => isset( $name ) ? $name : '',
        'prolink'   => isset( $prolink ) ? $prolink : '',
    );

    if ( ! is_wp_error( $data ) ) {

        $theme = wp_get_theme();

        // Installed but Inactive.
        if ( file_exists( get_theme_root(). '/' . $data['slug'] . '/functions.php' ) && ( $theme->stylesheet != $data['slug'] ) ) {

            $button_classes = 'button themeactivate-now button-primary';
            $button_text    = esc_html__( 'Activate', 'ihafs-pro' );

        // Not Installed.
        } elseif ( ! file_exists( get_theme_root(). '/' . $data['slug'] . '/functions.php' ) ) {

            $button_classes = 'button themeinstall-now';
            $button_text    = esc_html__( 'Install Now', 'ihafs-pro' );

        // Active.
        } else {
            $button_classes = 'button disabled';
            $button_text    = esc_html__( 'Activated', 'ihafs-pro' );
        }

        ?>
            <h3><?php echo $data['name']; ?></h3>
            <div class="htwptemplata-theme-<?php echo $data['slug']; ?>">
                <?php
                    if ( !empty( $data['prolink']) && $button_text === 'Install Now') {
                        echo '<a class="button theme-button" href="'.esc_url( $data['prolink'] ).'" target="_blank">'.esc_html__( 'Buy Now', 'ihafs-pro' ).'</a>';
                    }else{
                ?>
                    <button class="<?php echo $button_classes; ?> theme-button" data-themeopt='<?php echo wp_json_encode( $data ); ?>'><?php echo $button_text; ?></button>
                <?php } ?>
            </div>
        <?php
    }

}