<?php

	function ihafs_loaclize_data(){

		if( is_admin() ){

            $localize_data = [
                'ajaxurl'          => admin_url( 'admin-ajax.php' ),
                'adminURL'         => admin_url(),
                'pluginURL'        => plugin_dir_url( __FILE__ ),
                'message'          =>[
                    'packagedesc'=> esc_html__( 'in this package', 'ihafs-pro' ),
                    'allload'    => esc_html__( 'All Items have been Loaded', 'ihafs-pro' ),
                    'notfound'   => esc_html__( 'Nothing Found', 'ihafs-pro' ),
                ],
                'buttontxt'      =>[
                    'tmplibrary' => esc_html__( 'Import to Library', 'ihafs-pro' ),
                    'tmppage'    => esc_html__( 'Import to Page', 'ihafs-pro' ),
                    'import'     => esc_html__( 'Import', 'ihafs-pro' ),
                    'buynow'     => esc_html__( 'Buy Now', 'ihafs-pro' ),
                    'preview'    => esc_html__( 'Preview', 'ihafs-pro' ),
                    'installing' => esc_html__( 'Installing..', 'ihafs-pro' ),
                    'activating' => esc_html__( 'Activating..', 'ihafs-pro' ),
                    'active'     => esc_html__( 'Active', 'ihafs-pro' ),
                ],
            ];
            wp_localize_script( 'ihafs-pro-admin', 'IIHAFS', $localize_data );

    	}

	}

	//plugin and template ajax installation hook
	add_action( 'wp_ajax_ihafs_ajax_plugin_activation', 'ihafs_ajax_plugin_activation');
	add_action( 'wp_ajax_ihafs_ajax_theme_activation', 'ihafs_ajax_theme_activation');


    //plugin ajax activatio function
	function ihafs_ajax_plugin_activation() {

	    if ( ! current_user_can( 'install_plugins' ) || ! isset( $_POST['location'] ) || ! $_POST['location'] ) {
	        wp_send_json_error(
	            array(
	                'success' => false,
	                'message' => esc_html__( 'Plugin Not Found', 'ihafs-pro' ),
	            )
	        );
	    }

	    $plugin_location = ( isset( $_POST['location'] ) ) ? esc_attr( $_POST['location'] ) : '';
	    $activate    = activate_plugin( $plugin_location, '', false, true );

	    if ( is_wp_error( $activate ) ) {
	        wp_send_json_error(
	            array(
	                'success' => false,
	                'message' => $activate->get_error_message(),
	            )
	        );
	    }

	    wp_send_json_success(
	        array(
	            'success' => true,
	            'message' => esc_html__( 'Plugin Successfully Activated', 'ihafs-pro' ),
	        )
	    );

	}

	//template ajax activation function

	function ihafs_ajax_theme_activation() {

        if ( ! current_user_can( 'install_themes' ) || ! isset( $_POST['themeslug'] ) || ! $_POST['themeslug'] ) {
            wp_send_json_error(
                array(
                    'success' => false,
                    'message' => esc_html__( 'Sorry, you are not allowed to install themes on this site.', 'ihafs-pro' ),
                )
            );
        }

        $theme_slug = ( isset( $_POST['themeslug'] ) ) ? esc_attr( $_POST['themeslug'] ) : '';
        switch_theme( $theme_slug );

        wp_send_json_success(
            array(
                'success' => true,
                'message' => __( 'Theme Activated', 'ihafs-pro' ),
            )
        );
    }

?>