<?php
function ihafs_pro_get_term_options( $field ) {
	$args = $field->args( 'get_terms_args' );
	$args = is_array( $args ) ? $args : array();

	$args = wp_parse_args( $args, array( 'taxonomy' => 'category' ) );

	$taxonomy = $args['taxonomy'];

	$terms = (array) cmb2_utils()->wp_at_least( '4.5.0' )
		? get_terms( $args )
		: get_terms( $taxonomy, $args );

	// Initate an empty array
	$term_options = array();
	if ( ! empty( $terms ) ) {
		foreach ( $terms as $term ) {
			$term_options[ $term->term_id ] = $term->name;
		}
	}

	return $term_options;
}

function ihafs_pro_post_list_arr($post_type = 'post', $per_page = 50){

	$ihafs_settings_opt = get_option( 'ihafs_setting_opt');

	if($post_type === 'post'){
		$per_page_no =isset($ihafs_settings_opt['post_number_toshow']) && !empty($ihafs_settings_opt['post_number_toshow']) ? $ihafs_settings_opt['post_number_toshow'] : $per_page;
	}else{
		$per_page_no =isset($ihafs_settings_opt['page_number_toshow']) && !empty($ihafs_settings_opt['page_number_toshow']) ? $ihafs_settings_opt['page_number_toshow'] : $per_page;
	}

	$arr = array();

	$args = array(
		'post_type' => $post_type,
		'posts_per_page'	=> $per_page_no
	);

	$query = new WP_Query($args);
	while($query->have_posts()){
		$query->the_post();
		$arr[get_the_id()] = get_the_title();
	}
	wp_reset_postdata();

	return $arr;
}

add_action('cmb2_meta_boxes','ihafs_meta_boxes');
function ihafs_meta_boxes(){

	$prefix = '_ihafs_';

	if( function_exists('wp_body_open') ){
		$where_to_show_options = array(
			'in_header'	=> 	__('Header - The Script will be placed within the &lt;head&gt; section. ', 'ihafs-pro'),
			'after_body' => 	__('After Body - The script will be printed just below the body tag. <br><span>This option may not be compatible with your current theme.</span> ', 'ihafs-pro'),
			'in_footer'	=>  __('Footer - The Script will be placed near the bottom of the &lt;body&gt; section.', 'ihafs-pro')
		);
	} else{
		$where_to_show_options = array(
			'in_header'	=> 	__('Header - The Script will be placed within the &lt;head&gt; section. ', 'ihafs-pro'),
			'in_footer'	=>  __('Footer - The Script will be placed near the bottom of the &lt;body&gt; section.', 'ihafs-pro')
		);
	}

	$ihafs_option =  array(
		'full_website'              => 	esc_html__('Full Website', 'ihafs-pro'),
		'only_home'                 =>  esc_html__('Only Homepage', 'ihafs-pro'),
		'only_pages'                =>  esc_html__('Only Pages', 'ihafs-pro'),
		'only_posts'                =>  esc_html__('Only Posts', 'ihafs-pro'),
		'page_ids'                  =>  esc_html__('Page ID', 'ihafs-pro'),
		'only_categories'           =>  esc_html__('Only Categories', 'ihafs-pro'),
		'category_archives'         =>  esc_html__('Category Archives', 'ihafs-pro'),
		'only_tags'                 =>  esc_html__('Only Tags', 'ihafs-pro'),
		'tag_archives'              =>  esc_html__('Tag Archives', 'ihafs-pro'),
	);

	if ( class_exists( 'WooCommerce' ) ) {
		$ihafs_option['woo_categories']            =  esc_html__('Product Category', 'ihafs-pro');
		$ihafs_option['product_category_archives'] =  esc_html__('Product Category Archives', 'ihafs-pro');
	}


	$meta_box = new_cmb2_box( array(
		'id'           		 => $prefix . 'options',
		'title'        		 => esc_html__( 'Headers and Footers Script Options', 'ihafs-pro' ),
		'object_types' 		 => array('ihafs_script'),
		'context'      		 => 'normal',
		'priority'     		 => 'high',
		'show_names'         => true,
	) );

	$meta_box->add_field( array(
		'id'                 => $prefix.'code',
		'name'        		 => esc_html__( 'Script', 'ihafs-pro' ),
		'type'        		 => 'textarea_code',
	) );

	$meta_box->add_field( array(
		'id'                 => $prefix.'status',
		'name'        		 => esc_html__( 'Status', 'ihafs-pro' ),
		'type'        		 => 'select',
		'options'		     => array(
			'active'	=> 		esc_html__('Active', 'ihafs-pro'),
			'inactive'	=> 		esc_html__('Inactive', 'ihafs-pro'),
		)
	) );

	$meta_box->add_field( array(
		'id'                 => $prefix.'condition',
		'name'        		 => esc_html__( 'Condition', 'ihafs-pro' ),
		'type'        		 => 'radio',
		'options'     		 => $where_to_show_options,
		'default'     		 => 'in_header',
	) );

	$meta_box->add_field( array(
		'id'                 => $prefix.'show_on',
		'name'        		 => esc_html__( 'Show On', 'ihafs-pro' ),
		'type'        		 => 'radio_inline',
		'options'     		 => $ihafs_option,
		'default'     		 => 'full_website',
	) );

	$meta_box->add_field( array(
		'id'                 => $prefix.'pages_list',
		'name'        		 => esc_html__( 'Pages List', 'ihafs-pro' ),
		'type'        		 => 'select_multiple',
		'options'     		 => ihafs_pro_post_list_arr('page'),
		'description'		 => esc_html__('If you keep the field blank then the script will be added in all page.', 'ihafs-pro'),
	) );

	$meta_box->add_field( array(
		'id'                 => $prefix.'posts_list',
		'name'        		 => esc_html__( 'Posts List', 'ihafs-pro' ),
		'type'        		 => 'select_multiple',
		'options'     		 => ihafs_pro_post_list_arr(),
		'description'		 => esc_html__('If you keep the field blank then the script will be added in all post.', 'ihafs-pro'),
	) );

	$meta_box->add_field( array(
		'id'             => $prefix.'categories_list',
		'name'       	 => esc_html__( 'Categories List', 'ihafs-pro' ),
		'type'           => 'multicheck',
		'options_cb'     => 'ihafs_pro_get_term_options',
		'get_terms_args' => array(
			'taxonomy'   => 'category',
			'hide_empty' => false,
		),
		'before' => esc_html__('Select the categories below. The script will show on the blog posts, which has any one of your selected categories.', 'ihafs-pro')
	) );

    if ( class_exists( 'WooCommerce' ) ) {
		$meta_box->add_field( array(
			'id'             => $prefix.'woo_categories_list',
			'name'       	 => esc_html__( 'WooCommece Categories', 'ihafs-pro' ),
			'type'           => 'multicheck',
			'options_cb'     => 'ihafs_pro_get_term_options',
			'get_terms_args' => array(
				'taxonomy'   => 'product_cat',
				'hide_empty' => false,
			),
			'before' => esc_html__('Select the categories below. The script will show on the products, which has any one of your selected categories.', 'ihafs-pro')
		) );
	}

	$meta_box->add_field( array(
		'id'                 => $prefix.'page_ids',
		'name'        		 => esc_html__( 'Page IDS', 'ihafs-pro' ),
		'type'        		 => 'text',
		'description'		 => esc_html__('Write the page/post/any custom post ids here. Each id should be separated by comma. Example: 7,9,15', 'ihafs-pro')
	) );


	$meta_box->add_field( array(
		'id'             => $prefix.'tags_list',
		'name'       	 => esc_html__( 'Tags List', 'ihafs-pro' ),
		'type'           => 'multicheck',
		'options_cb'     => 'ihafs_pro_get_term_options',
		'get_terms_args' => array(
			'taxonomy'   => 'post_tag',
			'hide_empty' => false,
		),
		'before' => esc_html__('Select the tags below. The script will show on the blog posts, which has any one of your selected tags.', 'ihafs-pro')
	) );

	$meta_box->add_field( array(
		'id'                 => $prefix.'exclude_pages',
		'name'        		 => esc_html__( 'Exclude Pages', 'ihafs-pro' ),
		'type'        		 => 'select_multiple',
		'options'     		 =>  ihafs_pro_post_list_arr('page'),
		'description'		 => esc_html__('Select the pages you want to exclude', 'ihafs-pro'),
	) );

	$meta_box->add_field( array(
		'id'                 => $prefix.'exclude_posts',
		'name'        		 => esc_html__( 'Exclude Posts', 'ihafs-pro' ),
		'type'        		 => 'select_multiple',
		'options'     		 =>  ihafs_pro_post_list_arr('post'),
		'description'		 => esc_html__('Select the posts you want to exclude', 'ihafs-pro'),
	) );
}