<?php
if ( ! defined( 'WPINC' ) ) {
	wp_die();
}

/**
 * Class Iconic_WLV_Settings
 */
class Iconic_WLV_Settings {
	/**
	 * Run.
	 */
	public static function run() {
		add_filter( 'wpsf_show_save_changes_button_iconic_wlv', '__return_false' );
	}

	/**
	 * Print taxonomy dropdown.
	 *
	 * @param object $taxonomy Taxonomy.
	 * @param string $selected Selected value.
	 *
	 * @return void
	 */
	public static function print_taxonomy_dropdown( $taxonomy, $selected = array() ) {
		$terms = get_terms(
			array(
				'taxonomy'   => $taxonomy->name,
				'hide_empty' => false,
			)
		);

		if ( empty( $terms ) || is_wp_error( $terms ) ) {
			$terms = array();
		}

		$selected = array_map( 'intval', $selected );

		?>
		<p class="form-field">
			<select class='iconic-wlv-select-taxonomy' id="iconic-wlv-taxonomy-<?php echo esc_attr( $taxonomy->name ); ?>" name="iconic_wlv_taxonomy_<?php echo esc_html( $taxonomy->name ); ?>[]" multiple>
				<?php
				foreach ( $terms as $term ) {
					echo '<option ' . selected( in_array( $term->term_id, $selected ), true, false ) . 'value="' . esc_attr( $term->term_id ) . '">' . esc_html( $term->name ) . '</option>';
				}
				?>
			</select>
		</p>
		<?php
	}

	/**
	 * Get export button.
	 *
	 * @return string
	 */
	public static function export_button() {
		return sprintf( '<a class="button button-secondary" href="%s">%s</a>', admin_url( 'admin.php?page=iconic-wlv-settings&action=download_csv&_wpnonce=' . wp_create_nonce( 'iconic-wlv-export' ) ), __( 'Export Data', 'iconic-wlv' ) );
	}
}
