<?php
namespace QuadLayers\IGG_PRO\Api\Rest;

use QuadLayers\IGG_PRO\Api\Rest\Endpoints\Frontend\User_Stories;
use QuadLayers\IGG_PRO\Api\Rest\Endpoints\Frontend\Tagged_Media;
use QuadLayers\IGG_PRO\Api\Rest\Endpoints\Frontend\Media_Comments;

class Routes_Library {

	protected static $instance;

	public function __construct() {
		// Priority -10 to register PRO endpoints before FREE stubs (default priority 10)
		// This allows PRO plugin to override the premium endpoint routes
		add_action( 'rest_api_init', array( $this, '_rest_init' ), -10 );
	}

	public function _rest_init() {
		// Register premium endpoints that override FREE stubs
		new User_Stories();
		new Tagged_Media();
		new Media_Comments();
	}

	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
}
