<?php

namespace QuadLayers\IGG_PRO;

use QuadLayers\IGG_PRO\Controllers\Backend;

final class Plugin {

	protected static $instance;

	private function __construct() {
		/**
		 * Load plugin textdomain.
		 */
		add_action( 'init', array( $this, 'load_textdomain' ) );

		add_action(
			'qligg_init',
			function () {

				if ( ! class_exists( 'QuadLayers\\IGG\\Plugin', false ) ) {
					return;
				}

				if ( ! class_exists( 'QuadLayers\\IGG\\Controllers\\Backend', false ) ) {
					return;
				}

				/**
				 * Fires before initializing premium features.
				 * Allows license client to verify license status.
				 *
				 * @since 4.4.1
				 */
				do_action( 'qligg_pro_init' );

				// Defer admin initialization to ensure license client is fully loaded.
				// The license client initializes its models (activation, user_data) on 'init'.
				// We need to wait until after 'init' to access these properties safely.
				add_action(
					'wp_loaded',
					function () {
						$is_premium = $this->is_premium_enabled();
						Backend::instance( $is_premium );
					}
				);

				// Defer premium features initialization to ensure license client is fully loaded.
				add_action(
					'wp_loaded',
					function () {
						if ( ! $this->is_premium_enabled() ) {
							return;
						}

						Api\Rest\Routes_Library::instance();
					}
				);
			}
		);
	}

	/**
	 * Checks if premium features are enabled based on license status.
	 *
	 * @since 4.4.1
	 * @return bool True if license allows premium features.
	 */
	private function is_premium_enabled() {
		// Allow forcing premium mode for development/testing
		// Define in wp-config.php: define('QLIGG_PRO_FORCE_PREMIUM', true);
		if ( defined( 'QLIGG_PRO_FORCE_PREMIUM' ) && QLIGG_PRO_FORCE_PREMIUM ) {
			return true;
		}

		global $qligg_license_client;

		if ( ! isset( $qligg_license_client ) || ! isset( $qligg_license_client->activation ) ) {
			return false;
		}

		$status = $qligg_license_client->activation->status();

		return 'valid' === $status;
	}

	public function load_textdomain() {
		load_plugin_textdomain( 'insta-gallery-pro', false, QLIGG_PRO_PLUGIN_DIR . '/languages/' );
	}

	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
}

Plugin::instance();
