<?php

namespace QuadLayers\IGG_PRO\Controllers;

use QuadLayers\IGG\Controllers\Backend as Backend_Free;
use QuadLayers\IGG\Models\Accounts as Models_Accounts;

class Backend {

	protected static $instance;

	public function __construct( $is_premium_active ) {
		add_action( 'admin_enqueue_scripts', array( $this, 'register_scripts' ), 10 );
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ), 10 );
		add_action( 'admin_menu', array( $this, 'add_menu' ) );

		if ( ! $is_premium_active ) {
			return;
		}

		add_action( 'init', array( self::class, 'init_add_account' ) );
		remove_action( 'init', array( 'QuadLayers\IGG\Controllers\Backend', 'init_add_account' ) );
		remove_action( 'admin_head', array( 'QuadLayers\IGG\Controllers\Backend', 'add_premium_js' ) );
		remove_action( 'admin_footer', array( 'QuadLayers\IGG\Controllers\Backend', 'add_premium_styles' ) );
		remove_action( 'elementor/editor/footer', array( 'QuadLayers\IGG\Controllers\Elementor', 'add_premium_js' ) );
		remove_action( 'elementor/editor/after_enqueue_scripts', array( 'QuadLayers\IGG\Controllers\Backend', 'add_premium_styles' ), 10 );
	}

	public function add_menu() {

		$menu_slug = Backend_Free::get_menu_slug();

		add_submenu_page(
			$menu_slug,
			esc_html__( 'License', 'insta-gallery-pro' ),
			esc_html__( 'License', 'insta-gallery-pro' ),
			'qligg_manage_feeds',
			'qligg_backend&tab=license',
			'__return_null'
		);

		remove_submenu_page( $menu_slug, "{$menu_slug}&tab=premium" );
	}

	public function register_scripts() {

		global $qligg_license_client;

		$routes_paths = array();

		$backend = include_once QLIGG_PRO_PLUGIN_DIR . 'build/backend/js/index.asset.php';

		if ( ! empty( $qligg_license_client->routes->get() ) ) {
			$routes_paths = array_map(
				function ( $route ) {
					return $route->get_rest_path();
				},
				$qligg_license_client->routes->get()
			);
		}

		wp_register_style(
			'qligg-pro-backend',
			plugins_url( '/build/backend/css/style.css', QLIGG_PRO_PLUGIN_FILE ),
			array(
				'media-views',
				'wp-components',
				'wp-editor',
			),
			QLIGG_PRO_PLUGIN_VERSION
		);

		wp_register_script(
			'qligg-pro-backend',
			plugins_url( '/build/backend/js/index.js', QLIGG_PRO_PLUGIN_FILE ),
			$backend['dependencies'],
			$backend['version'],
			true
		);

		wp_localize_script(
			'qligg-pro-backend',
			'qligg_pro_backend',
			array(
				'licenseClientRoutesPaths' => $routes_paths,
				'plugin_url'               => plugins_url( '/', QLIGG_PRO_PLUGIN_FILE ),
			)
		);
	}

	public function enqueue_scripts() {
		$menu_slug = Backend_Free::get_menu_slug();
		if ( ! isset( $_GET['page'] ) || $_GET['page'] !== $menu_slug ) {
			return;
		}
		wp_enqueue_style( 'qligg-pro-backend' );
		wp_enqueue_script( 'qligg-pro-backend' );
	}

	public static function init_add_account() {

		if ( ! is_admin() || ! current_user_can( 'qligg_manage_feeds' ) ) {
			return;
		}

		if ( ! isset( $_REQUEST['qligg_nonce'] ) || ! wp_verify_nonce( $_REQUEST['qligg_nonce'], 'qligg_add_account' ) ) {
			return;
		}

		if ( ! isset( $_REQUEST['accounts'][0]['id'], $_REQUEST['accounts'][0]['access_token'], $_REQUEST['accounts'][0]['access_token_type'], $_REQUEST['accounts'][0]['expires_in'] ) ) {
			return;
		}

		foreach ( $_REQUEST['accounts'] as $account_data ) {

			if ( ! isset( $account_data['id'], $account_data['access_token'], $account_data['access_token_type'], $account_data['expires_in'] ) ) {
				continue;
			}

			$account = Models_Accounts::instance()->get( $account_data['id'] );

			if ( $account ) {
				$account = Models_Accounts::instance()->update( $account_data['id'], $account_data );
			} else {
				$account = Models_Accounts::instance()->create( $account_data );
			}
		}

		/*
		 * Redirect via php is not working because it preserve the hash in the url
		if ( wp_safe_redirect( admin_url() ) ) {
			exit;
		}
		*/

		/**
		 * Don't escape because it replace & with &#038;
		 */
		?>
		<script type="text/javascript">
			window.location.replace("<?php echo QLIGG_ACCOUNT_URL; ?>");
		</script>
		<?php
	}

	public static function instance( $is_premium_active ) {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self( $is_premium_active );
		}
		return self::$instance;
	}
}
