<?php
	global $wpdb;
	$main_class = new eplugins_jobbank;
	
	wp_enqueue_script("jquery");
	wp_enqueue_script('jquery-ui-core');
	wp_enqueue_script('jquery-ui-datepicker'); 
	wp_enqueue_style('bootstrap', ep_jobbank_URLPATH . 'admin/files/css/iv-bootstrap.css');
	wp_enqueue_style('jobbank_signup-css', ep_jobbank_URLPATH . 'admin/files/css/signup.css');
	wp_enqueue_script('bootstrap.min', ep_jobbank_URLPATH . 'admin/files/js/bootstrap.min-4.js');
	wp_enqueue_style('jquery-ui', ep_jobbank_URLPATH . 'admin/files/css/jquery-ui.css');
	wp_enqueue_style('datetimepicker', ep_jobbank_URLPATH . 'admin/files/css/jquery.datetimepicker.css');
	

	$eprecaptcha_api=get_option( 'eprecaptcha_api');
	
	
?>
<div class="bootstrap-wrapper  mb-3">
	<div class="container  jobbankborder p-4">	
				<form id="jobbank_registration" name="jobbank_candidate_registration" class="form-horizontal" action="<?php  the_permalink() ?>?&iv-submit-listing=candidate_registration" method="post" role="form"  enctype="multipart/form-data">
							
				<div class="border-bottom pb-4 mb-3 toptitle "><?php esc_html_e('Candidate Info','jobbank');?></div>
				
				<div class="row user_info">
				 
					<div class="col-md-12  ">
						<?php
							if(isset($_REQUEST['message-error'])){?>
						  <div class="row alert alert-info alert-dismissable" id='loading-2'><a class="panel-close close" data-dismiss="alert">x</a> <?php   esc_html_e('User_or_Email_Exists','jobbank'); ?></div>
						  <?php
							}
						?>
						<!--
							For Form Validation we used plugins https://formvalidation.io/
							This is in line validation so you can add fields easily.
						-->
						
						
						<div class="form-group row">
							<label  class="col-md-4 control-label" ><?php   esc_html_e('User Type','jobbank');?><span class="chili"></span></label>
							<div class="col-md-8">
							<select name="user_type" id ="user_type" class="form-control">
								<option value="candidate" ><?php   esc_html_e("I'm a candidate",'jobbank'); ?></option>							
							</select>								
							</div>
						</div>
						
						
						<div class="text-center" id="loading"> </div>
						<div class="form-group row"  >
							<label for="text" class="col-md-4 control-label"><?php   esc_html_e('User Name','jobbank');?><span class="chili"></span></label>
							<div class="col-md-8">
								<input type="text"  name="iv_member_user_name" id="iv_member_user_name"  data-validation="length alphanumeric"
								data-validation-length="4-12" data-validation-error-msg="<?php   esc_html_e(' The user name has to be an alphanumeric value between 4-12 characters','jobbank');?>" class="form-control ctrl-textbox" placeholder="<?php  esc_html_e('Enter User Name','jobbank');?>"  alt="required">
							</div>
						</div>
						
						<div class="form-group row">
							<label for="email" class="col-md-4 control-label" ><?php   esc_html_e('Email Address','jobbank');?><span class="chili"></span></label>
							<div class="col-md-8">
								<input type="email" name="iv_member_email" id="iv_member_email" data-validation="email"  class="form-control ctrl-textbox" placeholder="<?php   esc_html_e('Enter email address','jobbank');?>" data-validation-error-msg="<?php   esc_html_e('Please enter a valid email address','jobbank');?> " >
							</div>
						</div>
						
						<?php wp_nonce_field( 'signup1' ); ?>
						<div class="form-group row ">
							<label for="text" class="col-md-4 control-label"><?php   esc_html_e('Password','jobbank');?><span class="chili"></span></label>
							<div class="col-md-8">
								<input type="password" name="iv_member_password"  id="iv_member_password" class="form-control ctrl-textbox" placeholder="" data-validation="strength"
								data-validation-strength="2" data-validation-error-msg="<?php   esc_html_e('The password is not strong enough','jobbank');?>">
							</div>
						</div>
						
							
							<?php
							$iv_membership_signup_profile_pic=get_option('jobbank_signup_profile_pic');
							if($iv_membership_signup_profile_pic=='' ){ $iv_membership_signup_profile_pic='yes';}	
							if($iv_membership_signup_profile_pic=='yes' ){
							?>
							<div class="form-group row ">
								<label for="text" class="col-md-4 control-label"><?php  esc_html_e('Profile Image','jobbank');?></label>
								<div class="col-md-8">
									<input type="file" name="profilepicture"  id="profilepicture" size="25" class="form-input " />
								</div>
							</div>
							<?php
							}
						?>
						
				
						<?php
						$i=1;
						$default_fields = array();
						$default_fields=get_option('jobbank_profile_fields');
						$sign_up_array=get_option( 'jobbank_candi_signup_fields');
						
						$require_array=get_option( 'jobbank_signup_require');
						if(is_array($default_fields)){
							foreach ( $default_fields as $field_key => $field_value ) {
								$sign_up='no';
								if(isset($sign_up_array[$field_key]) && $sign_up_array[$field_key] == 'yes') {
									$sign_up='yes';
								}
								$require='no';
								if(isset($require_array[$field_key]) && $require_array[$field_key] == 'yes') {
									$require='yes';
								}
								if($sign_up=='yes--'){
								?>
								<div class="form-group row">
									<label  class="col-md-4 control-label" ><?php echo esc_html($field_value); ?><span class="<?php echo($require=='yes'?'chili':''); ?>"></span></label>
									<div class="col-md-8">
										<input type="text"  name="<?php echo esc_html($field_key);?>" <?php echo($require=='yes'?'data-validation="length" data-validation-length="2-100"':''); ?>
										class="form-control ctrl-textbox" placeholder="<?php esc_html_e('Enter', 'jobbank');?><?php echo esc_html($field_value);?>" >
									</div>
								</div>
								<?php
								}
								echo  $main_class->jobbank_check_field_input_access_signup($field_key, $field_value,'candidate');
							}
						}
					?>
						
											
					<div class="row form-group" id="nopaymentform">
						<input type="hidden" name="reg_error" id="reg_error" value="yes">								
						<input type="hidden" name="return_page" id="return_page" value="<?php  the_permalink() ?>">
							<div class="col-md-4"> </div>
							<div class="col-md-8">
							<div id="errormessage" class="alert alert-danger mt-2 displaynone" role="alert"></div>
								<div id="paypal-button">
									<div id="loading-3" class="displaynone"  ><img src='<?php echo ep_jobbank_URLPATH. 'admin/files/images/loader.gif'; ?>' /></div>
									<?php
									if($eprecaptcha_api==''){
									?>
										<button  id="submit_jobbank_payment" name="submit_jobbank_payment"  type="submit" class="btn btn-secondary"  >												
											<?php  esc_html_e('Submit','jobbank');?>
										</button>
									<?php
									}else{
									?>
										<button  id="submit_jobbank_payment" name="submit_jobbank_payment"  class="btn btn-secondary g-recaptcha" data-sitekey="<?php echo esc_html($eprecaptcha_api); ?>"  data-callback='jobbank_epluginrecaptchaSubmit' data-action='submit' >
											<?php  esc_html_e('Submit','jobbank');?>
										</button>
									<?php
									}
									?>
									
								</div>
							</div>
						</div>
						
						<input type="hidden" name="hidden_form_name" id="hidden_form_name" value="jobbank_registration">
					</div>
				
				</div>
		
			</form>
		</div>
	</div>
	<?php
		
		wp_enqueue_script('jquery.form-validator', ep_jobbank_URLPATH . 'admin/files/js/jquery.form-validator.js');
		wp_enqueue_script('jobbank_signup', ep_jobbank_URLPATH . 'admin/files/js/signup.js');
		wp_localize_script('jobbank_signup', 'dirpro_data', array(
		'ajaxurl' 			=> admin_url( 'admin-ajax.php' ),
		'loader_image'=>'<img src="'.ep_jobbank_URLPATH. 'admin/files/images/loader.gif" />',
		'loader_image2'=>'<img src="'.ep_jobbank_URLPATH. 'admin/files/images/old-loader.gif" />',
		'right_icon'=>'<img src="'.ep_jobbank_URLPATH. 'admin/files/images/right_icon.png" />',
		'wrong_16x16'=>'<img src="'.ep_jobbank_URLPATH. 'admin/files/images/wrong_16x16.png" />',
		'stripe_publishable'=>'',
		'package_amount'=>'',
		'api_currency'=>'',
		'iv_gateway'=>'',
		'total_package'=> '',
		'errormessage'=>esc_html__("Please complete the form",'jobbank'),
		'HideCoupon'=>esc_html__("Hide Coupon",'jobbank'),
		'Havecoupon'=> esc_html__("Have Coupon",'jobbank'),
		'dirwpnonce'=> wp_create_nonce("signup"),
		'signup'=> wp_create_nonce("signup"),
		) );


	if($eprecaptcha_api!=''){	
		wp_register_script( 'rechaptcha', 'https://www.google.com/recaptcha/api.js?render='.$eprecaptcha_api, null, null, true );
		wp_enqueue_script('rechaptcha');
	}
	

?>	