var gulp = require('gulp');
var sass = require('gulp-sass')(require('sass'));
var cssbeautify = require('gulp-cssbeautify');
var rename = require('gulp-rename');
const autoprefixer = require('gulp-autoprefixer');
const postcss = require('gulp-postcss');
const postcssrtl = require('postcss-rtl');

gulp.task('css', function () {
    return new Promise(function (resolve, reject) {
        gulp.src('assets/scss/main.scss')
            .pipe(sass().on('error', sass.logError))
            .pipe(autoprefixer({
                cascade: false
            }))
            // .pipe(postcss([postcssrtl()])) // Add the postcss-rtl plugin
            .pipe(cssbeautify())
            .pipe(rename('style.css'))
            .pipe(gulp.dest('.'));
        resolve();
    });
});

gulp.task('css-rtl', function () {
    return new Promise(function (resolve, reject) {
        gulp.src('assets/scss/main.scss')
            .pipe(sass().on('error', sass.logError))
            .pipe(autoprefixer({
                cascade: false
            }))
            .pipe(postcss([postcssrtl(
                {
                    removeComments: false, // Important: keep the comments
                    onlyDirection: 'rtl',
                }
            )])) // Add the postcss-rtl plugin
            .pipe(cssbeautify())
            .pipe(rename('style-rtl.css'))
            .pipe(gulp.dest('.'));
        resolve();
    });
});

gulp.task('default', function () {
    gulp.watch('assets/**/**/*.scss', gulp.series('css'))
});