<?php

use Tangibledesign\Listivo\Widgets\General\PatternWidget;

/* @var PatternWidget $lstCurrentWidget */
global $lstCurrentWidget;
?>
<div class="listivo-pattern listivo-pattern--<?php echo esc_attr($lstCurrentWidget->getPattern()); ?>">
    <?php if ($lstCurrentWidget->isPatternV1()) : ?>
        <svg xmlns="http://www.w3.org/2000/svg" width="1860" height="347" viewBox="0 0 1860 347" fill="none">
            <mask id="mask0_7141_13994" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="1860"
                  height="347">
                <rect width="1860" height="346.167" fill="#9F2626"/>
            </mask>
            <g mask="url(#mask0_7141_13994)">
                <path
                        class="listivo-fill-color-4"
                        fill-rule="evenodd" clip-rule="evenodd"
                        d="M-386.384 97.9602C-357.021 143.907 -168.971 276.902 -98.4806 272.199C-37.126 268.106 6.92744 115.115 68.2037 84.8052C147.924 45.3722 299.01 9.89605 334.166 -60.4852C369.737 -131.696 366.445 -171.581 326.002 -219.593C290.047 -262.278 230.618 -281.142 161.313 -283.37C91.8907 -285.603 -16.8969 -241.876 -81.8344 -194.418C-142.358 -150.186 -195.121 -34.259 -221.724 25.085C-249.627 87.3312 -415.674 52.1281 -386.384 97.9602Z"
                        fill="#F2F4F8"/>
                <path
                        class="listivo-fill-primary-1"
                        fill-rule="evenodd" clip-rule="evenodd"
                        d="M-385.284 79.1433C-355.921 125.09 -167.87 258.085 -97.38 253.382C-36.0254 249.289 53.1807 69.3835 114.457 39.0739C194.178 -0.35916 288.257 -8.7194 323.413 -79.1006C358.983 -150.312 360.121 -208.757 319.679 -256.769C283.723 -299.454 231.719 -299.959 162.413 -302.187C92.9913 -304.42 -13.6386 -286.303 -80.7338 -213.235C-154.211 -133.217 -194.021 -53.0759 -220.623 6.26807C-248.526 68.5142 -414.573 33.3112 -385.284 79.1433Z"
                        fill="#3F71F0"/>
                <path
                        class="listivo-fill-color-4"
                        fill-rule="evenodd" clip-rule="evenodd"
                        d="M1516.99 -410.034C1384.41 -334.587 1238.56 -277.949 1141.04 -186.34C1022.4 -74.8869 864.203 84.1579 916.497 161.822C1037.38 326.461 1209.57 146.114 1356.48 151.634C1503.48 157.158 1679.38 329.687 1858.34 357.18C1975.17 375.13 2357.55 453.52 2730.17 123.283C2872.98 -3.2783 2527.31 -412.464 2474.62 -517.402C2423.81 -618.61 2288.75 -744.632 2089.43 -726.039C1891.08 -707.536 1713.2 -521.696 1516.99 -410.034Z"
                        fill="#F2F4F8"/>
                <path
                        class="listivo-fill-primary-2"
                        fill-rule="evenodd" clip-rule="evenodd"
                        d="M1475.51 -439.622C1342.93 -364.175 1197.08 -307.537 1099.56 -215.927C980.922 -104.475 822.723 54.57 875.017 132.234C995.898 296.873 1168.09 116.526 1315 122.046C1462 127.57 1637.91 300.099 1816.86 327.593C1933.69 345.542 2316.07 423.933 2688.69 93.6956C2831.5 -32.8662 2485.83 -442.052 2433.14 -546.99C2382.33 -648.198 2247.27 -774.22 2047.95 -755.627C1849.6 -737.123 1671.72 -551.284 1475.51 -439.622Z"
                        fill="#FA823E"/>
                <path
                        class="listivo-stroke-color-5"
                        opacity="0.6" d="M1758.94 73.8918L1758.18 105.709L1731 89.1393L1758.94 73.8918Z"
                        stroke="#FDFDFE"/>
            </g>
        </svg>
    <?php elseif ($lstCurrentWidget->isPatternV2()) : ?>
        <svg xmlns="http://www.w3.org/2000/svg" width="1860" height="347" viewBox="0 0 1860 347" fill="none">
            <mask id="mask0_7141_14023" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="1860"
                  height="347">
                <rect width="1860" height="346.167" fill="#9F2626"/>
            </mask>
            <g mask="url(#mask0_7141_14023)">
                <path
                        class="listivo-fill-color-4"
                        fill-rule="evenodd" clip-rule="evenodd"
                        d="M-226.538 -365.563C-259.584 -305.918 -293.883 -19.9406 -246.744 54.7781C-205.715 119.813 -11.2442 77.1754 58.5682 126.516C149.395 190.709 278.357 335.737 376.685 332.497C476.173 329.218 518.075 301.853 546.796 228.794C572.33 163.841 557.694 87.2566 518.884 9.7146C480.008 -67.9582 367.155 -161.559 276.305 -204.717C191.631 -244.941 32.7325 -233.948 -48.3659 -227.872C-133.43 -221.499 -193.574 -425.059 -226.538 -365.563Z"
                        fill="#F2F4F8"/>
                <path
                        class="listivo-fill-primary-1"
                        fill-rule="evenodd" clip-rule="evenodd"
                        d="M-183.341 -386.412C-216.388 -326.767 -250.686 -40.7898 -203.548 33.9288C-162.519 98.9636 88.4318 89.9569 158.244 139.298C249.071 203.49 314.274 301.972 412.603 298.731C512.091 295.453 577.041 261.909 605.762 188.85C631.296 123.897 600.891 66.4074 562.08 -11.1346C523.205 -88.8074 439.799 -195.283 319.502 -225.566C187.761 -258.731 75.929 -254.797 -5.16934 -248.721C-90.2338 -242.348 -150.377 -445.908 -183.341 -386.412Z"
                        fill="#3F71F0"/>
                <path
                        class="listivo-fill-color-4"
                        fill-rule="evenodd" clip-rule="evenodd"
                        d="M1064.48 -262.663C994.06 -127.345 902.29 -0.624212 870.095 129.241C830.926 287.237 784.355 506.676 870.425 543.531C1061.3 616.222 1108.06 371.298 1234.46 296.208C1360.93 221.077 1602.31 270.536 1767.54 196.515C1875.41 148.191 2239.13 6.53034 2372.9 -473.059C2424.17 -656.859 1911.78 -812.972 1810.58 -872.523C1712.97 -929.956 1531.14 -962.517 1373.82 -838.737C1217.25 -715.556 1168.7 -462.935 1064.48 -262.663Z"
                        fill="#F2F4F8"/>
                <path
                        class="listivo-fill-primary-2"
                        fill-rule="evenodd" clip-rule="evenodd"
                        d="M975.692 -224.243C905.275 -88.9251 813.505 37.7957 781.309 167.661C742.14 325.657 695.57 545.096 781.64 581.951C972.517 654.642 1019.28 409.718 1145.68 334.628C1272.15 259.497 1513.52 308.956 1678.76 234.935C1786.63 186.611 2150.35 44.9503 2284.12 -434.639C2335.39 -618.439 1822.99 -774.553 1721.79 -834.103C1624.19 -891.536 1442.36 -924.097 1285.03 -800.317C1128.47 -677.136 1079.91 -424.515 975.692 -224.243Z"
                        fill="#FA823E"/>
                <path
                        class="listivo-stroke-color-5"
                        opacity="0.6" d="M1758.94 73.8918L1758.18 105.709L1731 89.1393L1758.94 73.8918Z"
                        stroke="#FDFDFE"/>
            </g>
        </svg>
    <?php elseif ($lstCurrentWidget->isPatternV3()) : ?>
        <svg xmlns="http://www.w3.org/2000/svg" width="1860" height="1160" viewBox="0 0 1860 1160" fill="none">
            <mask id="mask0_7141_14099" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="1860"
                  height="1160">
                <rect width="1860" height="1159.92" fill="#9F2626"/>
            </mask>
            <g mask="url(#mask0_7141_14099)">
                <path
                        class="listivo-fill-color-4"
                        fill-rule="evenodd" clip-rule="evenodd"
                        d="M1871.82 644.171C1982.04 642.942 2095.33 648.146 2187.33 638.258C2299.24 626.23 2451.63 607.596 2440.63 581.362C2410.7 524.423 2253.48 503.873 2158.28 483.067C2063.03 462.25 1712.67 452.755 1602.98 422.246C1501.24 393.947 1380.99 324.26 1233.1 351.054C1102.78 374.667 1138.23 491.104 1057.16 532.833C1025.66 549.05 1261.8 625.315 1398.84 647.054C1535.22 668.687 1708.68 645.991 1871.82 644.171Z"
                        fill="#F2F4F8"/>
                <path
                        class="listivo-fill-color-4"
                        fill-rule="evenodd" clip-rule="evenodd"
                        d="M75.7927 959.251C139.242 869.109 209.701 780.243 255.466 699.832C311.143 602.004 385.124 467.48 357.408 461.069C293.713 452.064 185.124 567.589 112.581 632.66C39.9992 697.766 -172.549 976.448 -261.431 1047.6C-343.875 1113.59 -470.719 1170.4 -535.446 1306.04C-592.487 1425.58 -477.3 1464.89 -490.842 1555.06C-496.104 1590.1 -296.17 1443.12 -198.407 1344.65C-101.119 1246.65 -18.1121 1092.66 75.7927 959.251Z"
                        fill="#F2F4F8"/>
                <path
                        class="listivo-fill-color-4"
                        fill-rule="evenodd" clip-rule="evenodd"
                        d="M-254.91 253.011C-233.39 303.113 -69.4054 464.852 0.914253 471.647C62.1202 477.561 130.409 333.744 195.791 313.776C280.852 287.798 435.692 277.302 481.8 213.556C528.451 149.059 531.674 109.169 499.556 55.232C471.001 7.27954 415.42 -20.9755 347.394 -34.4177C279.253 -47.8826 164.813 -22.3831 93.037 13.9114C26.1398 47.7389 -44.7311 153.571 -80.6081 207.814C-118.24 264.709 -276.376 203.035 -254.91 253.011Z"
                        fill="#F2F4F8"/>
                <path
                        class="listivo-fill-primary-1"
                        fill-rule="evenodd" clip-rule="evenodd"
                        d="M-250.736 234.621C-229.215 284.723 -65.2312 446.462 5.08842 453.257C66.2943 459.171 183.504 296.121 248.885 276.153C333.947 250.175 428.136 257.188 474.244 193.442C520.896 128.945 531.5 71.4579 499.382 17.5215C470.827 -30.431 419.594 -39.3653 351.568 -52.8075C283.428 -66.2724 175.271 -65.6936 97.2112 -4.4784C11.726 62.5599 -40.5569 135.181 -76.434 189.424C-114.066 246.319 -272.202 184.645 -250.736 234.621Z"
                        fill="#3F71F0"/>
                <path
                        class="listivo-fill-color-4"
                        fill-rule="evenodd" clip-rule="evenodd"
                        d="M1965.83 1077.37C1958.04 1023.4 1841.61 824.673 1775.46 799.876C1717.88 778.292 1614.63 899.481 1546.31 901.811C1457.42 904.843 1305.16 874.828 1244.09 924.436C1182.31 974.63 1168.86 1012.32 1185.89 1072.74C1201.03 1126.46 1247.39 1168.16 1309.6 1198.78C1371.92 1229.46 1489.05 1234.5 1567.79 1218.06C1641.17 1202.74 1737.06 1118.91 1785.77 1075.82C1836.87 1030.63 1973.61 1131.21 1965.83 1077.37Z"
                        fill="#F2F4F8"/>
                <path
                        class="listivo-fill-primary-1"
                        fill-rule="evenodd" clip-rule="evenodd"
                        d="M1957.07 1094.06C1949.28 1040.09 1832.84 841.361 1766.69 816.564C1709.11 794.98 1553.63 922.059 1485.31 924.389C1396.42 927.42 1307.27 896.223 1246.21 945.832C1184.43 996.025 1159.28 1048.8 1176.31 1109.22C1191.46 1162.93 1238.62 1184.85 1300.83 1215.47C1363.15 1246.14 1467.76 1273.63 1559.02 1234.75C1658.97 1192.18 1728.29 1135.6 1777.01 1092.51C1828.11 1047.32 1964.84 1147.89 1957.07 1094.06Z"
                        fill="#3F71F0"/>
                <path
                        class="listivo-fill-color-4"
                        fill-rule="evenodd" clip-rule="evenodd"
                        d="M2051.23 -772.72C2029.22 -923.668 2029.56 -1080.13 1979.73 -1204.3C1919.11 -1355.37 1828.57 -1560.61 1737.2 -1540.18C1539.85 -1487.52 1645.14 -1261.5 1586.52 -1126.67C1527.87 -991.765 1303.14 -890.734 1212.39 -734.063C1153.15 -631.781 940.94 -304.17 1112.88 163.095C1178.78 342.172 1685.72 169.172 1802.64 158.297C1915.4 147.809 2081.94 67.8915 2137.17 -124.52C2192.14 -315.999 2083.8 -549.317 2051.23 -772.72Z"
                        fill="#F2F4F8"/>
                <path
                        class="listivo-fill-primary-2"
                        fill-rule="evenodd" clip-rule="evenodd"
                        d="M2093.89 -800.583C2071.88 -951.531 2072.22 -1107.99 2022.39 -1232.16C1961.77 -1383.23 1871.22 -1588.47 1779.85 -1568.04C1582.51 -1515.38 1687.8 -1289.36 1629.18 -1154.53C1570.52 -1019.63 1345.8 -918.597 1255.05 -761.926C1195.8 -659.645 983.598 -332.034 1155.54 135.232C1221.43 314.309 1728.38 141.308 1845.29 130.434C1958.05 119.946 2124.59 40.0283 2179.83 -152.383C2234.8 -343.862 2126.46 -577.18 2093.89 -800.583Z"
                        fill="#FA823E"/>
                <path
                        class="listivo-fill-color-4"
                        fill-rule="evenodd" clip-rule="evenodd"
                        d="M767.313 1385.65C745.303 1234.71 745.642 1078.25 695.816 954.073C635.196 803.002 544.65 597.762 453.279 618.198C255.932 670.854 361.227 896.879 302.604 1031.71C243.95 1166.61 19.2265 1267.64 -71.5245 1424.31C-130.771 1526.59 -342.976 1854.2 -171.035 2321.47C-105.14 2500.55 401.801 2327.55 518.719 2316.67C631.481 2306.18 798.021 2226.27 853.258 2033.85C908.228 1842.38 799.887 1609.06 767.313 1385.65Z"
                        fill="#F2F4F8"/>
                <path
                        class="listivo-fill-primary-2"
                        fill-rule="evenodd" clip-rule="evenodd"
                        d="M809.97 1357.79C787.961 1206.84 788.3 1050.38 738.473 926.21C677.854 775.14 587.308 569.9 495.936 590.335C298.59 642.991 403.884 869.016 345.262 1003.84C286.607 1138.75 61.8839 1239.78 -28.8671 1396.45C-88.1133 1498.73 -300.319 1826.34 -128.378 2293.61C-62.4824 2472.68 444.458 2299.68 561.377 2288.81C674.138 2278.32 840.678 2198.4 895.915 2005.99C950.885 1814.51 842.544 1581.19 809.97 1357.79Z"
                        fill="#FA823E"/>
                <path
                        class="listivo-stroke-color-5"
                        opacity="0.6" d="M1758.94 73.8918L1758.18 105.709L1731 89.1393L1758.94 73.8918Z"
                        stroke="#FDFDFE"/>
            </g>
        </svg>
    <?php elseif ($lstCurrentWidget->isPatternV4()) : ?>
        <svg xmlns="http://www.w3.org/2000/svg" width="1084" height="473" viewBox="0 0 1084 473" fill="none">
            <path d="M1083.87 225.586C1085.76 211.982 1066.41 200.793 1051.87 199.632C1044.93 199.077 1037.73 200.128 1031.16 197.856C1016.93 192.934 1011.24 174.695 997.355 168.883C986.974 164.539 975.021 168.407 964.953 173.431C954.887 178.458 944.942 184.781 933.696 185.496C923.913 186.117 913.292 182.519 904.732 187.26C898.356 190.79 895.016 198.081 889.137 202.382C883.387 206.588 875.886 207.481 868.751 207.866C861.616 208.249 854.229 208.322 847.731 211.272C841.234 214.224 835.86 221.039 837.209 228L1083.87 225.586Z"
                  fill="#F8FAFD"/>
            <path d="M569.912 26.3361C571.211 16.9718 557.894 9.26719 547.885 8.46805C543.113 8.0849 538.155 8.80958 533.635 7.24413C523.839 3.85708 519.925 -8.7015 510.368 -12.7038C503.219 -15.6946 494.994 -13.03 488.067 -9.57069C481.139 -6.11138 474.293 -1.75661 466.552 -1.26618C459.818 -0.837048 452.509 -3.31548 446.618 -0.0510295C442.228 2.38143 439.929 7.40182 435.885 10.3598C431.927 13.2586 426.764 13.8716 421.853 14.1365C416.942 14.4014 411.859 14.4496 407.387 16.4814C402.915 18.5154 399.215 23.2073 400.144 28L569.912 26.3361"
                  fill="#F8FAFD"/>
            <path d="M924.864 123.464C926.867 109.195 906.343 97.4548 890.916 96.237C883.562 95.6532 875.921 96.7575 868.954 94.372C853.858 89.2108 847.826 70.0739 833.096 63.9752C822.079 59.4178 809.403 63.4781 798.727 68.7494C788.05 74.0207 777.499 80.6566 765.568 81.4039C755.19 82.0578 743.926 78.2812 734.847 83.2556C728.081 86.9622 724.538 94.6123 718.305 99.1196C712.205 103.537 704.249 104.471 696.68 104.875C689.111 105.278 681.277 105.352 674.385 108.448C667.492 111.547 661.79 118.697 663.222 126L924.864 123.464"
                  fill="#F8FAFD"/>
            <path d="M464.759 204.406C468.308 178.54 431.88 157.263 404.508 155.052C391.452 153.996 377.894 155.999 365.526 151.68C338.731 142.319 328.027 107.631 301.881 96.5821C282.335 88.3201 259.833 95.675 240.884 105.231C221.934 114.79 203.207 126.814 182.036 128.173C163.622 129.355 143.625 122.51 127.515 131.524C115.508 138.242 109.22 152.106 98.1534 160.281C87.3273 168.283 73.2046 169.978 59.7751 170.712C46.3414 171.442 32.4355 171.579 20.2035 177.192C7.97291 182.801 -2.14444 195.761 0.392919 209L464.759 204.406"
                  fill="#F8FAFD"/>
            <path
                    class="listivo-fill-color-4"
                    d="M436.323 330.403C436.323 330.403 428.776 327.957 425.236 345.366C421.695 362.774 421.191 372.388 421.191 372.388C421.191 372.388 420.023 376.154 417.249 374.674C414.474 373.195 409.823 368.103 406.388 370.206C402.826 372.386 402.749 377.059 405.248 383.199C407.747 389.341 412.728 402.996 413.174 404.232C413.612 405.446 413.409 407.47 411.357 406.765C409.306 406.06 396.327 397.77 392.762 404.164C389.197 410.557 398.97 426.522 400.005 428.287C401.04 430.053 400.893 430.97 400.118 431.694C399.344 432.417 395.244 429.219 391.457 427.013C387.669 424.805 382.89 422.912 381.142 426.773C379.394 430.633 382.168 443.877 400.415 461.575L409.408 469.223L420.639 465.425C444.18 455.831 451.703 444.584 451.525 440.35C451.347 436.114 446.207 436.085 441.869 436.716C437.531 437.347 432.533 438.78 432.085 437.819C431.637 436.86 431.844 435.954 433.464 434.703C435.083 433.451 450.115 422.297 449.199 415.036C448.49 409.415 439.263 409.844 434.123 410.272C432.622 410.398 431.469 410.523 430.979 410.498C428.813 410.385 429.381 408.431 430.241 407.468C431.117 406.488 440.841 395.684 445.455 390.923C450.068 386.16 451.744 381.799 449.255 378.445C446.854 375.212 440.637 378.195 437.511 378.53C434.384 378.865 434.709 374.936 434.709 374.936C434.709 374.936 437.835 365.831 441.059 348.361C444.282 330.891 436.166 330.364 436.166 330.364L436.323 330.403"
                    fill="#F2F4F8"/>
            <path d="M408.156 471.775C410.574 458.954 415.255 436.239 419.172 416.715C423.087 397.198 426.616 379.525 429.099 366.717C430.332 360.324 431.33 355.144 432.024 351.546C432.368 349.768 432.636 348.381 432.822 347.422C432.915 346.963 432.987 346.607 433.038 346.351C433.09 346.111 433.124 345.989 433.124 345.989C433.124 345.989 433.114 346.115 433.075 346.358C433.032 346.615 432.972 346.973 432.895 347.435C432.725 348.396 432.479 349.788 432.164 351.573C431.525 355.165 430.565 360.356 429.354 366.767C426.935 379.587 423.447 397.27 419.531 416.787C415.614 436.31 410.894 459.015 408.411 471.824"
                  fill="#DADBD8"/>
            <path d="M412.608 377.59C412.629 377.575 412.806 377.823 413.108 378.281C413.413 378.738 413.833 379.411 414.345 380.248C415.365 381.924 416.714 384.274 418.157 386.893C419.569 389.483 420.847 391.824 421.824 393.616C422.27 394.419 422.646 395.098 422.948 395.643C423.216 396.122 423.354 396.393 423.332 396.406C423.311 396.42 423.132 396.174 422.826 395.718C422.523 395.26 422.102 394.586 421.599 393.744C420.596 392.058 419.277 389.69 417.835 387.072C416.404 384.493 415.111 382.163 414.121 380.379C413.671 379.576 413.292 378.899 412.987 378.355C412.722 377.875 412.586 377.603 412.608 377.59Z"
                  fill="#DADBD8"/>
            <path d="M424.432 396.318C424.379 396.232 429.102 393.237 434.979 389.628C440.858 386.019 445.665 383.164 445.718 383.25C445.771 383.337 441.05 386.33 435.171 389.94C429.294 393.549 424.485 396.405 424.432 396.318"
                  fill="#DADBD8"/>
            <path d="M417.066 426.023C417.061 425.998 417.357 425.903 417.895 425.752C418.508 425.584 419.272 425.375 420.18 425.126C422.108 424.596 424.767 423.851 427.671 422.922C430.578 421.999 433.18 421.074 435.058 420.388C435.943 420.066 436.688 419.794 437.284 419.577C437.811 419.389 438.108 419.295 438.117 419.318C438.127 419.342 437.849 419.48 437.338 419.71C436.827 419.939 436.081 420.257 435.151 420.629C433.294 421.379 430.698 422.346 427.782 423.271C424.87 424.203 422.192 424.91 420.245 425.378C419.27 425.606 418.479 425.784 417.929 425.891C417.379 426 417.072 426.048 417.066 426.023"
                  fill="#DADBD8"/>
            <path d="M402.642 411.437C402.659 411.419 402.88 411.602 403.264 411.949C403.699 412.357 404.233 412.857 404.864 413.446C406.204 414.72 408.037 416.498 410.047 418.477C412.056 420.459 413.861 422.266 415.154 423.588C415.753 424.211 416.26 424.737 416.673 425.166C417.026 425.545 417.213 425.763 417.195 425.781C417.177 425.799 416.956 425.615 416.573 425.268C416.138 424.861 415.603 424.362 414.973 423.772C413.633 422.499 411.799 420.72 409.789 418.739C407.78 416.758 405.975 414.952 404.682 413.63C404.084 413.009 403.577 412.481 403.164 412.052C402.811 411.673 402.624 411.455 402.642 411.437Z"
                  fill="#DADBD8"/>
            <path d="M392.808 436.835C392.825 436.817 393.105 437.054 393.597 437.499C394.133 437.997 394.825 438.638 395.655 439.407C397.381 441.031 399.749 443.291 402.348 445.806C404.948 448.32 407.287 450.61 408.968 452.281C409.765 453.085 410.43 453.755 410.945 454.274C411.405 454.75 411.652 455.023 411.635 455.04C411.617 455.059 411.337 454.821 410.846 454.376C410.309 453.879 409.617 453.237 408.787 452.468C407.061 450.844 404.693 448.583 402.093 446.068C399.494 443.555 397.155 441.265 395.475 439.594C394.677 438.791 394.013 438.121 393.498 437.601C393.037 437.125 392.79 436.853 392.808 436.835"
                  fill="#DADBD8"/>
            <path d="M411.307 454.478C411.3 454.453 411.671 454.323 412.348 454.107C413.087 453.876 414.053 453.574 415.216 453.211C417.637 452.45 420.976 451.387 424.629 450.109C428.285 448.837 431.564 447.598 433.93 446.685C435.068 446.247 436.012 445.884 436.735 445.604C437.399 445.352 437.77 445.223 437.78 445.247C437.79 445.27 437.437 445.443 436.79 445.736C436.143 446.03 435.2 446.438 434.027 446.925C431.682 447.902 428.412 449.18 424.749 450.455C421.09 451.735 417.732 452.761 415.29 453.458C414.069 453.804 413.077 454.074 412.387 454.245C411.698 454.418 411.314 454.503 411.307 454.478"
                  fill="#DADBD8"/>
            <path
                    class="listivo-fill-color-4"
                    d="M644.494 401.127C648.578 400.975 652.562 402.909 655.471 405.779C658.38 408.649 660.308 412.384 661.647 416.246C664.237 423.716 663.637 432.798 662.014 440.537C653.553 438.187 647.829 429.76 645.193 425.303C641.028 418.259 637.778 402.996 644.494 401.127"
                    fill="#F2F4F8"/>
            <path
                    class="listivo-fill-color-4"
                    d="M674.554 448.909C671.681 445.362 671.243 440.17 673.004 435.958C674.767 431.748 678.507 428.531 682.762 426.878C684.73 426.114 687.046 425.685 688.881 426.728C690.598 427.701 691.461 429.795 691.392 431.767C691.323 433.74 690.461 435.603 689.407 437.271C685.79 442.992 681.242 447.863 674.554 448.909"
                    fill="#F2F4F8"/>
            <path d="M675.344 468.682C675.24 468.703 674.634 466.811 673.924 463.651C673.57 462.07 673.364 460.102 673.408 457.961C673.464 455.826 673.476 453.477 673.858 451.004C674.57 446.064 676.532 441.845 678.521 439.261C679.508 437.956 680.471 437.043 681.151 436.443C681.861 435.873 682.278 435.595 682.315 435.64C682.421 435.76 680.836 437.005 679.031 439.625C677.228 442.229 675.428 446.329 674.734 451.135C674.364 453.52 674.325 455.865 674.225 457.977C674.139 460.091 674.271 461.961 674.54 463.538C675.084 466.69 675.48 468.654 675.344 468.682"
                  fill="#DADBD8"/>
            <path d="M647.997 412.531C648.051 412.502 648.537 413.309 649.37 414.79C650.205 416.273 651.382 418.434 652.813 421.115C655.673 426.479 659.545 433.935 663.617 442.271C667.688 450.613 671.161 458.266 673.558 463.856C674.755 466.649 675.699 468.923 676.318 470.506C676.942 472.089 677.26 472.974 677.204 473C677.147 473.023 676.722 472.183 676.002 470.643C675.223 468.956 674.208 466.758 672.985 464.11C670.445 458.592 666.888 450.991 662.821 442.66C658.731 434.429 655.029 426.982 652.257 421.403C650.963 418.788 649.889 416.617 649.065 414.951C648.326 413.419 647.943 412.56 647.997 412.531"
                  fill="#DADBD8"/>
            <path
                    class="listivo-fill-color-4"
                    d="M666.853 455.948C660.352 448.85 650.266 445.218 640.733 446.54C638.305 446.877 635.515 447.893 634.908 450.267C634.298 452.646 636.269 454.886 638.275 456.303C646.619 462.197 658.628 462.309 667.079 456.572"
                    fill="#F2F4F8"/>
            <path d="M645.902 451.519C645.902 451.459 646.394 451.408 647.287 451.37C648.178 451.317 649.47 451.33 651.067 451.387C654.234 451.578 658.748 451.986 663.284 454.023C665.537 455.041 667.505 456.398 669.07 457.862C670.648 459.325 671.756 460.925 672.601 462.292C673.397 463.692 673.958 464.867 674.24 465.719C674.547 466.561 674.69 467.033 674.632 467.056C674.469 467.125 673.777 465.263 672.069 462.625C671.181 461.337 670.06 459.831 668.516 458.461C666.982 457.088 665.091 455.812 662.919 454.83C658.555 452.867 654.147 452.358 651.022 452.012C647.871 451.724 645.901 451.663 645.902 451.519"
                  fill="#DADBD8"/>
            <path d="M418.838 190.122L406.477 164.635L394.057 172.554L375 156.172L392.276 181.38L404.856 173.298L418.838 190.122Z"
                  fill="white"/>
            <path d="M415.139 197.113L397.921 188.707L394.617 198.107L377.637 197.342L397.353 203.547L400.675 193.995L415.139 197.113"
                  fill="white"/>
            <path d="M748.806 445.224C748.8 445.242 748.582 445.193 748.172 445.087C747.758 444.992 747.167 444.789 746.38 444.62C744.823 444.228 742.533 443.782 739.676 443.548C736.82 443.308 733.383 443.359 729.643 443.968C725.907 444.572 721.882 445.79 717.975 447.744C714.086 449.737 710.72 452.259 708.022 454.913C705.315 457.566 703.24 460.305 701.741 462.748C700.238 465.191 699.242 467.299 698.636 468.786C698.305 469.52 698.119 470.116 697.951 470.506C697.794 470.9 697.704 471.104 697.687 471.099C697.669 471.093 697.726 470.878 697.851 470.471C697.986 470.07 698.144 469.459 698.446 468.711C698.997 467.194 699.948 465.046 701.425 462.556C702.896 460.065 704.963 457.272 707.683 454.569C710.394 451.864 713.795 449.295 717.739 447.276C721.699 445.296 725.783 444.076 729.567 443.492C733.355 442.902 736.829 442.89 739.707 443.178C742.587 443.462 744.882 443.968 746.431 444.423C747.214 444.623 747.799 444.858 748.203 444.986C748.604 445.126 748.812 445.208 748.806 445.224"
                  fill="#17282F"/>
            <path
                    class="listivo-fill-primary-1"
                    d="M745.345 443.677C741.708 447.682 740.579 453.789 742.544 458.829C742.934 459.831 743.648 460.929 744.722 460.935C745.866 460.941 746.587 459.722 746.952 458.636C748.488 454.087 748.02 448.9 745.696 444.697C747.181 448.366 749.781 451.576 753.065 453.788C754.315 454.631 756.039 455.317 757.247 454.414C758.411 453.545 758.306 451.762 757.821 450.394C756.136 445.642 751.027 442.352 746.004 442.782C750.511 443.187 755.129 440.439 756.922 436.284C757.611 434.689 757.685 432.421 756.141 431.623C755.201 431.137 754.054 431.433 753.082 431.849C749.322 433.453 746.342 436.786 745.167 440.701C747.191 436.3 746.245 430.705 742.888 427.213C741.815 426.097 740.278 425.14 738.792 425.572C736.911 426.118 736.287 428.479 736.345 430.436C736.486 435.302 738.977 440.048 742.902 442.926C740.395 441.282 737.054 440.993 734.303 442.181C732.493 442.961 730.798 444.947 731.608 446.744C732.383 448.465 734.763 448.614 736.618 448.269C739.976 447.644 743.189 446.261 745.949 444.252"
                    fill="#3F71F0"/>
            <path d="M710.723 451.599C716.3 458.633 725.121 462.985 734.096 463.126C733.948 461.159 732.388 459.612 730.82 458.415C725.208 454.128 718.126 451.803 711.064 451.927"
                  fill="#33535F"/>
            <path d="M744.414 454.33C744.257 454.278 745.197 451.761 745.369 448.503C745.572 445.247 744.928 442.638 745.089 442.604C745.205 442.553 746.098 445.176 745.891 448.533C745.712 451.892 744.522 454.395 744.414 454.33"
                  fill="#17282F"/>
            <path d="M751.948 450.123C751.799 450.193 750.964 448.14 749.015 446.328C747.084 444.513 745.109 443.527 745.196 443.373C745.232 443.268 747.354 444.053 749.376 445.948C751.42 447.857 752.077 450.107 751.948 450.123"
                  fill="#17282F"/>
            <path d="M751.575 436.939C751.693 436.966 751.038 439.066 749.208 441.004C747.386 442.977 745.211 443.586 745.197 443.45C745.132 443.305 747.1 442.52 748.828 440.645C750.573 438.801 751.423 436.865 751.575 436.939"
                  fill="#17282F"/>
            <path d="M745.271 441.147C745.983 441.1 746.704 441.511 747.026 442.148C747.348 442.785 747.25 443.609 746.79 444.154C746.346 443.805 745.846 443.529 745.314 443.341C745.394 442.56 745.407 441.879 745.271 441.147Z"
                  fill="#F8FAFD"/>
            <path d="M739.942 430.477C739.988 430.435 740.584 430.989 741.369 432.041C742.156 433.087 743.097 434.658 743.807 436.538C744.511 438.418 744.84 440.22 744.941 441.526C745.041 442.833 744.96 443.643 744.899 443.642C744.728 443.658 744.725 440.4 743.316 436.722C741.949 433.029 739.804 430.578 739.942 430.477"
                  fill="#17282F"/>
            <path d="M383.462 433.097C385.617 433.041 387.707 434.085 389.224 435.617C390.741 437.149 391.735 439.13 392.418 441.175C393.74 445.131 393.369 449.918 392.466 453.991C388.017 452.7 385.048 448.221 383.685 445.854C381.53 442.112 379.908 434.042 383.462 433.097"
                  fill="#70B64F"/>
            <path d="M399.031 458.482C397.537 456.594 397.337 453.854 398.292 451.641C399.247 449.431 401.239 447.757 403.493 446.911C404.536 446.52 405.76 446.307 406.723 446.868C407.622 447.393 408.064 448.501 408.016 449.542C407.968 450.582 407.502 451.559 406.935 452.432C404.994 455.428 402.565 457.972 399.031 458.482Z"
                  fill="#70B64F"/>
            <path d="M400.332 471.893C400.31 471.898 400.227 471.603 400.086 471.07C399.933 470.481 399.736 469.719 399.498 468.805C399.037 466.898 398.324 464.191 398.552 461.135C398.763 458.094 399.807 455.443 400.971 453.826C401.544 453.009 402.102 452.421 402.521 452.055C402.723 451.864 402.903 451.743 403.017 451.652C403.134 451.564 403.198 451.522 403.204 451.53C403.255 451.581 402.23 452.304 401.149 453.945C400.051 455.563 399.062 458.168 398.853 461.157C398.628 464.15 399.297 466.836 399.706 468.755C399.921 469.719 400.095 470.499 400.2 471.043C400.306 471.586 400.351 471.889 400.332 471.893"
                  fill="#17282F"/>
            <path d="M385.239 439.133C385.249 439.128 385.316 439.238 385.435 439.452C385.566 439.696 385.735 440.008 385.943 440.395C386.379 441.215 386.995 442.41 387.744 443.893C389.242 446.859 391.254 450.986 393.373 455.592C395.49 460.201 397.314 464.415 398.59 467.483C399.229 469.017 399.735 470.262 400.074 471.127C400.231 471.538 400.359 471.869 400.458 472.126C400.543 472.356 400.583 472.477 400.573 472.481C400.563 472.486 400.504 472.372 400.402 472.15C400.289 471.897 400.145 471.573 399.965 471.173C399.579 470.287 399.046 469.064 398.394 467.566C397.067 464.522 395.215 460.324 393.098 455.718C390.98 451.115 389 446.977 387.552 443.988C386.84 442.519 386.259 441.317 385.838 440.447C385.65 440.051 385.498 439.729 385.38 439.479C385.279 439.257 385.23 439.138 385.239 439.133Z"
                  fill="#17282F"/>
            <path d="M394.619 463.317C391.784 459.104 386.808 456.418 381.731 456.36C380.438 456.346 378.904 456.657 378.4 457.848C377.896 459.041 378.748 460.363 379.683 461.261C383.573 464.989 389.829 465.99 394.688 463.66"
                  fill="#70B64F"/>
            <path d="M383.9 459.686C383.901 459.666 384.187 459.659 384.708 459.667C384.969 459.669 385.288 459.673 385.655 459.719C386.022 459.765 386.446 459.777 386.902 459.876C387.361 459.959 387.868 460.039 388.395 460.193C388.931 460.316 389.486 460.51 390.068 460.715C391.222 461.155 392.453 461.75 393.639 462.547C394.818 463.356 395.828 464.278 396.659 465.192C397.061 465.661 397.445 466.107 397.75 466.565C398.084 467.003 398.339 467.446 398.578 467.847C398.831 468.24 398.99 468.634 399.16 468.962C399.331 469.29 399.444 469.589 399.534 469.834C399.719 470.321 399.811 470.592 399.791 470.599C399.729 470.625 399.351 469.533 398.394 467.956C398.147 467.568 397.885 467.137 397.548 466.713C397.238 466.267 396.853 465.837 396.453 465.379C395.624 464.49 394.627 463.591 393.469 462.797C392.304 462.014 391.099 461.424 389.969 460.975C389.399 460.766 388.855 460.567 388.33 460.436C387.812 460.272 387.316 460.183 386.865 460.086C385.052 459.744 383.897 459.753 383.9 459.686"
                  fill="#17282F"/>
            <path d="M670.615 472.587H697.959L737.193 282.666L710.966 277.249L670.615 472.587Z" fill="#374B5C"/>
            <path d="M788.385 412.417L623.196 378.294L618.514 374.091L635.981 316.405L643.646 316.907L631.822 310.618L638.59 276.904L803.78 311.028L808.463 315.23L801.613 348.388L788.53 348.628L795.727 350.008L800.411 354.209L788.385 412.417"
                  fill="#314352"/>
            <path d="M783.702 408.217L618.514 374.092L631.298 312.205L638.963 312.707L632.569 306.053L638.59 276.905L803.78 311.028L796.93 344.188L783.848 344.427L795.727 350.008L783.702 408.217Z"
                  fill="#374B5C"/>
            <path d="M787.383 344.09C787.382 344.1 787.249 344.098 786.987 344.083C786.693 344.064 786.311 344.037 785.829 344.003C784.774 343.917 783.283 343.795 781.384 343.639C780.414 343.555 779.341 343.461 778.17 343.36C776.996 343.222 775.726 343.071 774.36 342.911C771.63 342.568 768.511 342.243 765.091 341.683C763.376 341.422 761.583 341.148 759.715 340.864C757.845 340.57 755.914 340.197 753.907 339.845C749.889 339.167 745.629 338.272 741.138 337.368C732.176 335.464 722.371 333.157 712.129 330.551C691.651 325.28 673.2 320.212 659.747 316.927C656.392 316.071 653.34 315.376 650.666 314.733C647.993 314.083 645.682 313.563 643.792 313.145C641.934 312.721 640.477 312.388 639.445 312.152C638.975 312.039 638.604 311.948 638.318 311.879C638.064 311.814 637.936 311.776 637.938 311.765C637.94 311.754 638.071 311.773 638.33 311.817C638.619 311.872 638.995 311.942 639.47 312.032C640.508 312.24 641.974 312.536 643.843 312.912C645.741 313.293 648.061 313.778 650.742 314.398C653.424 315.009 656.487 315.675 659.851 316.503C673.337 319.681 691.813 324.687 712.281 329.954C722.518 332.559 732.309 334.882 741.256 336.814C745.738 337.731 749.989 338.645 753.998 339.343C756 339.706 757.929 340.089 759.793 340.395C761.656 340.694 763.446 340.979 765.156 341.253C768.568 341.84 771.678 342.194 774.403 342.569C775.764 342.748 777.031 342.915 778.201 343.068C779.37 343.19 780.44 343.3 781.407 343.401C783.301 343.606 784.787 343.767 785.839 343.881C786.32 343.939 786.701 343.985 786.992 344.021C787.252 344.056 787.384 344.079 787.383 344.09"
                  fill="#314352"/>
            <path d="M795.675 338.798C795.668 338.807 795.543 338.726 795.305 338.559C795.046 338.371 794.702 338.121 794.263 337.804C793.342 337.15 792.036 336.113 790.273 334.891C786.76 332.432 781.576 328.998 774.806 325.397C768.041 321.802 759.659 318.101 749.988 315.073C740.302 312.132 729.329 309.836 717.656 309.111C705.979 308.262 694.832 309.402 684.677 309.632C679.599 309.771 674.756 309.718 670.246 309.337C665.733 308.983 661.565 308.295 657.801 307.507C650.267 305.909 644.398 303.74 640.44 302.083C638.457 301.252 636.947 300.542 635.933 300.042C635.451 299.798 635.07 299.605 634.785 299.461C634.527 299.327 634.397 299.255 634.402 299.245C634.408 299.235 634.545 299.289 634.812 299.405C635.104 299.535 635.493 299.709 635.985 299.929C637.015 300.393 638.539 301.066 640.53 301.86C644.508 303.446 650.377 305.546 657.889 307.081C661.642 307.839 665.794 308.497 670.286 308.828C674.775 309.185 679.595 309.219 684.661 309.066C694.786 308.805 705.957 307.644 717.696 308.497C729.422 309.227 740.44 311.549 750.156 314.531C759.857 317.601 768.252 321.357 775.013 325.012C781.776 328.675 786.937 332.173 790.413 334.697C792.157 335.951 793.441 337.02 794.339 337.707C794.761 338.044 795.093 338.309 795.344 338.508C795.569 338.693 795.68 338.79 795.675 338.798"
                  fill="#314352"/>
            <path d="M715.829 294.398C715.835 294.418 715.568 294.512 715.053 294.672C714.477 294.843 713.726 295.068 712.793 295.344C711.811 295.639 710.605 295.977 709.185 296.301C707.768 296.633 706.165 297.06 704.361 297.384C702.565 297.749 700.594 298.134 698.46 298.434C696.334 298.8 694.043 299.034 691.636 299.31C686.81 299.764 681.479 300.027 675.883 299.925C670.287 299.782 664.972 299.285 660.17 298.621C657.775 298.239 655.497 297.905 653.389 297.446C651.269 297.051 649.318 296.58 647.54 296.138C645.751 295.735 644.169 295.237 642.767 294.843C641.364 294.458 640.173 294.067 639.206 293.73C638.285 293.412 637.546 293.156 636.978 292.96C636.471 292.777 636.208 292.671 636.215 292.651C636.222 292.632 636.498 292.697 637.017 292.842C637.593 293.01 638.344 293.229 639.278 293.501C640.254 293.803 641.452 294.159 642.861 294.512C644.267 294.873 645.853 295.34 647.642 295.715C649.421 296.129 651.37 296.575 653.487 296.945C655.589 297.379 657.863 297.693 660.248 298.058C665.034 298.689 670.326 299.168 675.897 299.309C681.467 299.412 686.773 299.166 691.58 298.747C693.98 298.486 696.264 298.273 698.385 297.93C700.515 297.653 702.483 297.293 704.278 296.957C706.081 296.661 707.686 296.265 709.107 295.966C710.529 295.675 711.742 295.371 712.731 295.112C713.676 294.881 714.437 294.695 715.019 294.553C715.544 294.432 715.824 294.377 715.829 294.398"
                  fill="#314352"/>
            <path d="M671.896 353.466C671.896 353.466 672.156 353.606 672.645 353.905C673.15 354.216 673.872 354.662 674.813 355.241C676.725 356.402 679.519 358.171 683.267 360.167C687.012 362.136 691.737 364.444 697.628 365.736C699.097 366.039 700.64 366.328 702.228 366.44C703.794 366.523 705.535 366.393 706.878 365.423C707.54 364.945 708.038 364.236 708.265 363.43C708.49 362.621 708.48 361.734 708.266 360.887C707.862 359.164 706.589 357.737 705.097 356.627C692.504 348.281 674.763 342.19 654.689 341.627C652.187 341.552 649.637 341.55 647.084 341.651C644.578 341.771 641.899 342.335 640.174 344.247C639.317 345.164 638.8 346.386 638.86 347.643C638.887 348.899 639.481 350.098 640.271 351.123C641.889 353.201 644.218 354.642 646.462 356.191C655.484 362.328 665.108 368.423 675.894 372.649C686.633 376.853 698.13 378.772 708.925 377.171C711.617 376.794 714.245 376.136 716.777 375.322C719.276 374.476 721.695 373.24 723.288 371.215C724.892 369.207 725.587 366.617 725.605 364.104C725.625 361.575 725.033 359.077 723.976 356.846C721.849 352.338 718.214 348.836 714.263 346.288C710.285 343.719 705.928 342.086 701.658 340.843C697.376 339.606 693.148 338.725 689.101 337.798C685.055 336.882 681.17 336.004 677.461 335.165C662.645 331.798 650.653 329.073 642.344 327.184C638.214 326.232 635.004 325.493 632.802 324.985C631.727 324.73 630.901 324.534 630.324 324.397C629.767 324.261 629.484 324.177 629.484 324.177C629.484 324.177 629.776 324.22 630.339 324.336C630.918 324.459 631.747 324.635 632.828 324.864C635.036 325.345 638.255 326.047 642.396 326.952C650.717 328.795 662.723 331.454 677.556 334.74C681.268 335.566 685.156 336.433 689.206 337.334C693.251 338.249 697.487 339.119 701.799 340.354C706.099 341.594 710.508 343.231 714.556 345.832C718.572 348.412 722.293 351.974 724.489 356.605C725.583 358.908 726.201 361.485 726.183 364.109C726.168 366.717 725.45 369.443 723.749 371.579C722.051 373.739 719.515 375.02 716.97 375.886C714.394 376.716 711.741 377.382 709.014 377.767C698.089 379.394 686.486 377.456 675.671 373.222C664.811 368.967 655.153 362.841 646.122 356.689C643.893 355.143 641.51 353.682 639.799 351.488C638.965 350.401 638.3 349.087 638.268 347.662C638.2 346.247 638.799 344.848 639.74 343.852C640.667 342.834 641.884 342.126 643.158 341.718C644.436 341.304 645.757 341.147 647.052 341.073C649.641 340.974 652.187 340.981 654.707 341.059C674.892 341.665 692.681 347.807 705.36 356.279C706.885 357.422 708.241 358.938 708.668 360.79C708.891 361.695 708.902 362.652 708.653 363.541C708.4 364.43 707.839 365.217 707.11 365.738C705.624 366.793 703.809 366.895 702.206 366.807C700.576 366.684 699.039 366.387 697.554 366.072C691.62 364.736 686.892 362.383 683.155 360.377C679.412 358.344 676.638 356.543 674.747 355.347C673.821 354.743 673.109 354.282 672.611 353.959C672.133 353.641 671.896 353.466 671.896 353.466"
                  fill="#314352"/>
            <path d="M792.47 364.198C792.463 364.219 792.13 364.15 791.503 364C790.881 363.828 789.949 363.648 788.744 363.445C786.335 363.06 782.768 362.878 778.45 363.521C774.136 364.174 769.117 365.711 763.911 368.211C758.694 370.696 753.341 374.165 747.747 377.83C742.151 381.495 736.745 384.944 731.445 387.381C726.16 389.831 721.051 391.276 716.673 391.815C712.289 392.348 708.687 392.028 706.281 391.52C705.078 391.254 704.154 391.017 703.544 390.792C702.928 390.591 702.61 390.475 702.617 390.456C702.622 390.435 702.955 390.511 703.579 390.673C704.197 390.859 705.125 391.058 706.326 391.283C708.725 391.717 712.289 391.964 716.617 391.384C720.939 390.796 725.979 389.322 731.207 386.868C736.445 384.426 741.816 380.979 747.41 377.314C753.004 373.65 758.39 370.179 763.668 367.699C768.931 365.206 774.017 363.695 778.386 363.092C782.762 362.494 786.368 362.748 788.784 363.21C789.992 363.45 790.921 363.669 791.535 363.881C792.155 364.069 792.476 364.177 792.47 364.198"
                  fill="#314352"/>
            <path d="M789.414 380.573C789.391 380.636 788.623 380.317 787.173 379.991C785.733 379.666 783.569 379.411 780.948 379.785C778.323 380.131 775.308 381.145 772.073 382.526C768.822 383.871 765.434 385.746 761.935 387.827C758.432 389.904 755.094 391.918 751.892 393.456C748.696 395.005 745.654 396.065 743.028 396.647C740.398 397.227 738.206 397.338 736.706 397.273C735.956 397.239 735.376 397.188 734.985 397.123C734.595 397.067 734.392 397.029 734.395 397.008C734.401 396.944 735.223 397.051 736.709 397.033C738.195 397.024 740.348 396.848 742.93 396.224C745.506 395.595 748.493 394.508 751.643 392.947C754.799 391.397 758.112 389.378 761.621 387.297C765.124 385.213 768.559 383.332 771.853 382.004C775.119 380.642 778.202 379.652 780.892 379.352C783.58 379.027 785.787 379.358 787.231 379.758C787.955 379.967 788.507 380.152 788.869 380.315C789.234 380.465 789.422 380.552 789.414 380.573"
                  fill="#314352"/>
            <path d="M736.189 297.216C736.153 297.382 729.82 296.132 722.046 294.425C714.272 292.717 707.999 291.198 708.035 291.032C708.072 290.867 714.403 292.116 722.179 293.824C729.953 295.531 736.226 297.05 736.189 297.216Z"
                  fill="#17282F"/>
            <path d="M695.661 133.724C695.664 133.715 695.792 133.78 696.037 133.914C696.301 134.064 696.659 134.266 697.117 134.524C698.032 135.11 699.402 135.966 700.975 137.322C704.107 139.975 708.292 144.598 710.879 151.612C712.142 155.103 712.963 159.147 712.997 163.523C713.037 167.89 712.301 172.578 710.613 177.197C708.926 181.804 706.314 186.382 702.603 190.259C700.754 192.196 698.633 193.95 696.254 195.374C693.884 196.811 691.243 197.869 688.49 198.563C682.956 199.947 677.342 199.892 672.042 199.516C666.728 199.12 661.643 198.428 656.773 198.209C651.913 197.973 647.25 198.228 643.066 199.329C638.883 200.387 635.192 202.219 632.428 204.63C629.63 207.009 627.871 209.961 627.012 212.738C626.118 215.511 626.017 218.09 626.322 220.111C626.633 222.142 627.26 223.638 627.793 224.578C628.329 225.518 628.677 225.977 628.649 225.995C628.649 225.995 628.27 225.562 627.702 224.629C627.134 223.7 626.467 222.197 626.12 220.142C625.78 218.096 625.852 215.476 626.733 212.65C627.576 209.824 629.352 206.788 632.186 204.351C634.984 201.878 638.726 199.998 642.958 198.908C647.191 197.775 651.908 197.503 656.796 197.727C661.694 197.934 666.788 198.617 672.079 199.004C677.354 199.372 682.916 199.418 688.362 198.055C691.072 197.371 693.659 196.337 695.987 194.927C698.321 193.531 700.409 191.808 702.232 189.905C705.891 186.092 708.482 181.578 710.16 177.031C711.839 172.472 712.584 167.843 712.562 163.525C712.547 159.201 711.758 155.2 710.531 151.738C708.017 144.783 703.914 140.159 700.841 137.477C699.3 136.106 697.955 135.227 697.06 134.613C696.616 134.336 696.267 134.121 696.01 133.961C695.775 133.811 695.656 133.731 695.661 133.724"
                  fill="#17282F"/>
            <path d="M626.066 6.70381C628.674 14.2843 631.307 21.9926 631.673 30.0017C632.038 38.0097 629.826 46.5037 624.012 52.0209C617.267 58.4203 607.273 59.6386 598.02 60.5329C604.674 60.7683 611.964 62.3398 615.952 67.6738C620.522 73.7865 619.032 82.5159 615.909 89.4787C612.787 96.4415 608.211 102.923 606.958 110.452C617.493 103.785 631.697 103.403 642.576 109.497C653.454 115.59 660.549 127.901 660.368 140.368C666.087 129.574 675.912 120.748 687.67 117.439C699.429 114.129 712.994 116.832 721.781 125.316C714.947 115.458 712.289 102.8 714.58 91.025C716.872 79.2493 724.082 68.5118 734.114 61.9354C728.764 66.379 720.394 65.8448 714.703 61.8448C709.014 57.8448 705.767 51.0732 704.559 44.224C703.351 37.3739 703.948 30.3498 704.549 23.4212C698.529 31.2572 686.01 33.0339 678.046 27.1827C669.873 21.1767 667.81 10.0419 666.375 0.000581797C667.119 9.83461 659.579 19.6103 649.879 21.388C640.178 23.1657 629.661 16.6998 626.87 7.24107"
                  fill="#F8FAFD"/>
            <path
                    class="listivo-fill-primary-1"
                    d="M690.652 128.022C689.937 132.754 691.251 137.604 692.719 142.16C692.999 143.027 693.334 143.91 693.971 144.561C694.609 145.213 695.621 145.578 696.457 145.212C697.248 144.867 697.659 144.001 697.94 143.185C698.546 141.425 698.858 139.564 698.859 137.704C700.356 138.816 701.974 139.975 703.836 140.063C705.699 140.153 707.749 138.629 707.459 136.786C707.295 135.744 706.475 134.946 705.698 134.231C702.381 131.17 699.064 128.108 695.747 125.046C695.747 125.046 690.268 128.248 690.652 128.022"
                    fill="#3F71F0"/>
            <path
                    class="listivo-fill-primary-1"
                    d="M637.531 32.2683C637.531 32.2683 611.061 51.8096 619.157 83.0451L621.827 83.3801L631.176 73.703L644.044 91.5894L642.261 73.3499L647.768 77.3328L657.216 57.5953C657.216 57.5953 643.177 47.5057 645.183 37.6828C645.183 37.6828 636.91 37.227 637.531 32.2683"
                    fill="#3F71F0"/>
            <path
                    class="listivo-fill-primary-1"
                    d="M627.23 98.2429C627.23 98.2429 628.466 110.021 638.691 119.632L654.406 110.173C654.406 110.173 633.951 106.446 627.23 98.2429Z"
                    fill="#3F71F0"/>
            <path
                    class="listivo-fill-primary-1"
                    d="M660.158 119.155C660.158 119.155 667.412 130.833 685.833 130.202C698.9 129.754 707.344 113.096 704.087 97.1706L693.423 105.242L689.469 102.67L689.487 111.074C689.487 111.074 685.193 117.283 679.647 113.778C679.647 113.778 674.816 124.047 660.158 119.155Z"
                    fill="#3F71F0"/>
            <path
                    class="listivo-fill-primary-1"
                    d="M666.945 28.9079C666.325 29.1745 679.53 44.7338 679.645 54.0347C679.645 54.0347 683.994 45.5326 692.885 45.1664C692.885 45.1664 693.207 37.8032 700.379 39.3425C700.379 39.3425 685.056 21.0909 666.945 28.9079"
                    fill="#3F71F0"/>
            <path
                    class="listivo-fill-primary-1"
                    d="M709.895 59.3426C709.895 59.3426 716.139 70.3145 715.892 81.4795C715.892 81.4795 706.888 72.2098 699.614 78.732L697.792 74.3316C697.792 74.3316 702.086 73.4754 702.066 68.3195C702.043 63.1625 696.963 60.0941 696.963 60.0941C696.963 60.0941 706.857 68.3446 709.895 59.3426Z"
                    fill="#3F71F0"/>
            <path d="M656.051 86.2864C656.087 86.4263 644.581 89.3186 630.357 92.7442C616.129 96.1707 604.571 98.8347 604.537 98.6939C604.503 98.553 616.006 95.6617 630.234 92.2351C644.458 88.8096 656.017 86.1456 656.051 86.2864"
                  fill="#17282F"/>
            <path d="M659.07 68.0959C659.022 68.2317 652.826 66.113 645.235 63.3645C637.644 60.615 631.529 58.2759 631.578 58.1401C631.628 58.0043 637.821 60.122 645.414 62.8715C653.005 65.62 659.12 67.959 659.07 68.0959"
                  fill="#17282F"/>
            <path d="M650.009 0.204427C650.146 0.157143 654.968 13.7447 660.779 30.5485C666.591 47.3595 671.191 61.0205 671.055 61.0677C670.918 61.115 666.096 47.5305 660.285 30.7196C654.473 13.9147 649.872 0.250705 650.009 0.204427Z"
                  fill="#17282F"/>
            <path d="M688.333 39.246C688.403 39.251 688.388 40.3918 688.247 42.2299C688.107 44.0669 687.824 46.6001 687.363 49.3758C686.902 52.1514 686.351 54.6404 685.89 56.4241C685.43 58.2098 685.074 59.2933 685.008 59.2752C684.934 59.2571 685.162 58.1414 685.528 56.3416C685.897 54.5418 686.386 52.0528 686.846 49.2892C687.304 46.5267 687.644 44.0136 687.878 42.1916C688.114 40.3697 688.258 39.2399 688.333 39.246Z"
                  fill="#17282F"/>
            <path d="M726.681 41.1593C726.753 41.284 717.95 46.5567 707.022 52.934C696.087 59.3143 687.169 64.3837 687.096 64.258C687.024 64.1332 695.825 58.8615 706.757 52.4822C717.686 46.104 726.607 41.0335 726.681 41.1593Z"
                  fill="#17282F"/>
            <path d="M726.786 90.0903C726.781 90.1265 726.261 90.0873 725.324 89.9847C724.387 89.8841 723.035 89.7151 721.367 89.4887C718.03 89.038 713.431 88.3428 708.368 87.4656C703.305 86.5873 698.738 85.6919 695.445 84.9937C693.798 84.6446 692.468 84.3488 691.553 84.1285C690.636 83.9092 690.133 83.7714 690.141 83.7362C690.148 83.7 690.665 83.7714 691.593 83.9283C692.616 84.1114 693.934 84.3479 695.516 84.6306C698.924 85.2412 703.452 86.0521 708.458 86.9495C713.473 87.7905 718.007 88.5501 721.422 89.1225C723.007 89.3891 724.328 89.6104 725.353 89.7825C726.28 89.9465 726.791 90.0541 726.786 90.0903"
                  fill="#17282F"/>
            <path d="M712.239 133.536C712.132 133.632 704.462 125.277 695.111 114.876C685.757 104.47 678.264 95.9602 678.37 95.8637C678.477 95.7671 686.146 104.12 695.5 114.526C704.851 124.926 712.346 133.439 712.239 133.536Z"
                  fill="#17282F"/>
            <path d="M651.237 129.8C651.204 129.786 651.338 129.377 651.609 128.649C651.879 127.92 652.29 126.874 652.812 125.588C653.856 123.015 655.357 119.483 657.098 115.62C658.84 111.757 660.492 108.293 661.728 105.807C662.346 104.563 662.858 103.563 663.225 102.878C663.592 102.193 663.809 101.821 663.842 101.838C663.875 101.854 663.719 102.255 663.408 102.966C663.046 103.774 662.596 104.778 662.063 105.966C660.867 108.597 659.304 112.035 657.575 115.836C655.872 119.646 654.332 123.093 653.153 125.733C652.616 126.919 652.162 127.92 651.797 128.728C651.469 129.431 651.271 129.814 651.237 129.8"
                  fill="#17282F"/>
            <path d="M659.037 79.1322C659.025 79.0437 659.841 78.9632 661.031 78.4783C662.212 78.0084 663.77 77.0437 664.904 75.4632C666.038 73.8797 666.452 72.0959 666.518 70.8253C666.594 69.5426 666.408 68.7438 666.497 68.7277C666.548 68.7086 666.868 69.4903 666.888 70.8354C666.917 72.1613 666.541 74.0769 665.331 75.769C664.118 77.4571 662.424 78.427 661.16 78.8264C659.879 79.2398 659.036 79.1865 659.037 79.1322Z"
                  fill="#17282F"/>
            <path d="M667.382 93.441C667.3 93.3958 667.736 92.7207 667.964 91.5014C668.204 90.3072 668.138 88.4943 667.155 86.8978C666.16 85.3092 664.565 84.447 663.389 84.1291C662.195 83.7941 661.397 83.8847 661.393 83.7911C661.378 83.7438 662.185 83.5104 663.477 83.77C664.743 84.0094 666.509 84.8796 667.6 86.6221C668.677 88.3726 668.673 90.3414 668.326 91.5819C667.985 92.8555 667.419 93.4752 667.382 93.441"
                  fill="#17282F"/>
            <path d="M686.997 84.9049C686.966 84.9894 686.109 84.6594 684.671 84.4904C683.243 84.3154 681.193 84.3828 679.147 85.1936C677.103 86.0065 675.567 87.3647 674.648 88.4713C673.717 89.582 673.32 90.4099 673.24 90.3697C673.19 90.3506 673.469 89.4532 674.358 88.2419C675.23 87.0387 676.802 85.5618 678.955 84.7067C681.107 83.8526 683.263 83.8476 684.724 84.1242C686.201 84.3958 687.021 84.8566 686.997 84.9049"
                  fill="#17282F"/>
            <path d="M686.462 79.0317C686.458 79.0881 685.756 79.0921 684.735 78.6474C683.729 78.2188 682.419 77.248 681.648 75.7017C680.88 74.1534 680.896 72.5226 681.161 71.4613C681.422 70.3798 681.849 69.8224 681.896 69.8536C681.975 69.8908 681.679 70.4945 681.525 71.5307C681.365 72.5528 681.414 74.0518 682.116 75.4683C682.823 76.8828 683.988 77.8275 684.899 78.3154C685.819 78.8174 686.48 78.9462 686.462 79.0317"
                  fill="#17282F"/>
            <path d="M680.525 66.3755C680.562 66.4309 680.088 66.8574 679.234 67.447C678.388 68.0134 677.094 68.8092 675.431 68.9259C673.735 69.0174 672.333 68.0918 671.757 67.1794C671.156 66.2307 671.363 65.4902 671.402 65.5184C671.501 65.5063 671.454 66.1914 672.06 66.9641C672.635 67.7186 673.92 68.4852 675.4 68.4027C676.897 68.3021 678.157 67.612 679.041 67.1321C679.928 66.6331 680.481 66.3111 680.525 66.3755"
                  fill="#17282F"/>
            <path d="M690.575 133.108C690.547 133.108 690.49 132.398 690.464 131.549C690.483 132.068 690.522 132.588 690.575 133.108ZM690.451 130.705C690.45 130.262 690.462 129.832 690.493 129.483C690.466 129.89 690.452 130.298 690.451 130.705Z"
                  fill="#A7A9A8"/>
            <path
                    class="listivo-fill-primary-1"
                    d="M690.575 133.108C690.522 132.588 690.483 132.068 690.464 131.549C690.456 131.275 690.451 130.988 690.451 130.705C690.452 130.298 690.466 129.89 690.493 129.483C690.498 129.42 690.505 129.361 690.512 129.305H690.513C692.676 128.527 694.653 127.274 696.402 125.655L698.184 127.297C695.646 129.114 692.708 130.828 690.576 133.108H690.575Z"
                    fill="#3F71F0"/>
            <path d="M690.512 129.305C692.659 128.241 694.523 127.164 696.318 125.578L696.401 125.655C694.653 127.274 692.675 128.527 690.512 129.305"
                  fill="#BA2C42"/>
            <path d="M696.872 124.969C696.983 125.042 695.882 126.637 693.904 127.911C691.935 129.2 690.03 129.555 690.009 129.425C689.962 129.273 691.732 128.709 693.618 127.471C695.517 126.253 696.753 124.866 696.872 124.969"
                  fill="#17282F"/>
            <path d="M692.85 125.217C692.864 125.25 692.48 125.442 691.772 125.761C691.42 125.928 690.982 126.116 690.457 126.286C689.934 126.464 689.347 126.698 688.669 126.858C687.331 127.248 685.694 127.555 683.86 127.742C682.024 127.894 679.987 127.905 677.87 127.671C675.754 127.413 673.775 126.934 672.023 126.365C670.279 125.761 668.756 125.087 667.545 124.399C666.921 124.088 666.404 123.726 665.935 123.433C665.463 123.145 665.081 122.863 664.776 122.62C664.159 122.146 663.831 121.872 663.853 121.843C663.916 121.757 665.271 122.817 667.718 124.072C668.935 124.709 670.45 125.336 672.172 125.906C673.905 126.44 675.852 126.897 677.931 127.151C680.012 127.381 682.011 127.384 683.819 127.261C685.626 127.102 687.244 126.84 688.576 126.499C691.246 125.841 692.808 125.118 692.85 125.217Z"
                  fill="#F8FAFD"/>
            <path d="M693.437 141.78C693.315 141.839 692.466 140.158 692.085 137.887C691.691 135.617 691.937 133.749 692.07 133.764C692.225 133.77 692.219 135.598 692.602 137.798C692.969 140.001 693.58 141.723 693.437 141.78"
                  fill="#F8FAFD"/>
            <path d="M637.324 115.045C637.28 115.093 636.6 114.573 635.615 113.606C634.629 112.64 633.359 111.207 632.15 109.476C630.944 107.743 630.039 106.055 629.473 104.795C628.907 103.536 628.655 102.719 628.716 102.694C628.866 102.627 630.187 105.766 632.579 109.177C634.95 112.602 637.439 114.926 637.324 115.045"
                  fill="#F8FAFD"/>
            <path d="M627.879 47.7488C627.958 47.8021 626.945 49.3111 625.608 51.9077C624.267 54.4983 622.685 58.2307 621.604 62.5516C620.537 66.8776 620.189 70.9158 620.161 73.8344C620.127 76.7549 620.318 78.5617 620.222 78.5708C620.186 78.5748 620.113 78.1271 620.013 77.3102C619.903 76.4953 619.821 75.3062 619.79 73.8354C619.723 70.8947 620.016 66.8001 621.096 62.4259C622.189 58.0546 623.845 54.3001 625.281 51.7337C625.996 50.447 626.624 49.4349 627.104 48.7659C627.575 48.0908 627.848 47.7286 627.879 47.7488"
                  fill="#F8FAFD"/>
            <path d="M635.29 39.0153C635.381 39.128 634.751 39.796 633.881 40.5093C633.012 41.2226 632.233 41.7095 632.142 41.5978C632.049 41.4852 632.68 40.8172 633.549 40.1049C634.419 39.3916 635.198 38.9037 635.29 39.0153Z"
                  fill="#F8FAFD"/>
            <path d="M655.846 286.04C655.846 286.04 656.109 286.211 656.416 286.704C656.719 287.188 657.033 288.035 656.947 289.143C656.878 290.251 656.293 291.552 655.23 292.694C654.17 293.835 652.723 294.915 650.92 295.689C649.128 296.465 646.951 296.913 644.641 296.665C642.345 296.409 639.941 295.437 638.005 293.67C636.058 291.912 634.773 289.302 634.414 286.496C634.018 283.686 634.51 280.692 635.686 277.952C636.854 275.196 638.56 272.796 640.387 270.684C642.215 268.57 644.127 266.687 645.661 264.668C647.209 262.666 648.348 260.506 648.812 258.309C649.296 256.123 649.237 253.985 648.819 252.127C647.979 248.365 645.822 245.881 644.233 244.494C642.596 243.097 641.467 242.63 641.504 242.573C641.504 242.573 642.662 242.97 644.364 244.339C646.016 245.696 648.268 248.189 649.18 252.044C649.633 253.946 649.717 256.143 649.237 258.401C648.778 260.673 647.61 262.918 646.046 264.961C644.494 267.023 642.579 268.922 640.776 271.019C638.975 273.109 637.308 275.47 636.169 278.156C635.023 280.829 634.549 283.715 634.922 286.428C635.264 289.136 636.483 291.627 638.332 293.315C640.174 295.015 642.483 295.968 644.69 296.233C646.911 296.491 649.024 296.081 650.776 295.348C654.278 293.874 656.588 291.281 656.745 289.124C656.856 288.066 656.589 287.243 656.323 286.757C656.056 286.263 655.825 286.059 655.846 286.04"
                  fill="#314352"/>
            <path
                    class="listivo-fill-primary-2"
                    d="M452.089 419.998C455.042 406.211 471.937 306.109 471.937 306.109C471.937 306.109 459.751 308.034 457.295 312.4C454.596 317.199 441.46 390.958 440.006 415.973C438.801 415.898 437.596 415.885 436.392 415.991C433.364 416.255 430.303 417.305 428.17 419.471C425.612 422.069 424.724 426.181 425.981 429.603C426.651 431.424 427.917 432.984 429.495 434.11C429.297 436.252 429.98 438.87 431.667 439.975C433.596 441.238 436.309 441.163 438.165 439.795C438.574 441.092 439.776 442.102 441.123 442.282C442.471 442.461 443.896 441.802 444.631 440.657C445.436 442.522 448.071 442.703 449.977 442.005C453.537 440.702 456.188 437.366 456.973 433.656C457.758 429.949 456.77 425.969 454.617 422.85C453.891 421.8 453.033 420.853 452.089 419.998"
                    fill="#FA823E"/>
            <path
                    class="listivo-pattern__fill-v4"
                    d="M454.538 405.646C447.337 392.984 443.67 379.511 449.125 359.908C453.031 345.872 460.818 331.519 467.978 318.832C465.828 328.406 463.169 337.752 459.681 348.239C454.069 365.115 447.821 384.754 455.104 401.991L454.538 405.646"
                    fill="#D76E32"/>
            <path d="M450.607 432.547C450.581 432.501 451.004 432.351 451.498 431.783C451.972 431.237 452.512 430.151 452.222 428.857C451.94 427.59 450.672 426.269 448.944 426.025C447.22 425.765 445.231 426.607 443.988 428.217C442.716 429.821 442.196 431.81 442.123 433.578C442.07 435.365 442.452 436.97 442.993 438.21C444.096 440.722 445.628 441.702 445.529 441.784C445.518 441.799 445.426 441.743 445.259 441.624C445.092 441.505 444.846 441.328 444.569 441.052C444.002 440.519 443.26 439.635 442.655 438.362C442.051 437.097 441.612 435.435 441.64 433.565C441.691 431.714 442.215 429.611 443.578 427.89C444.915 426.158 447.104 425.228 449.016 425.548C450.948 425.852 452.312 427.347 452.583 428.776C452.855 430.244 452.198 431.381 451.647 431.922C451.364 432.204 451.095 432.362 450.91 432.452C450.718 432.535 450.613 432.562 450.607 432.547"
                  fill="#17282F"/>
            <path d="M428.325 433.437C428.357 433.395 428.672 433.649 429.312 433.972C429.947 434.298 430.927 434.678 432.195 434.793C433.45 434.901 435.013 434.742 436.485 433.957C437.21 433.566 437.932 433.038 438.462 432.328C439.005 431.628 439.272 430.728 439.129 429.801C438.85 428.103 437.774 426.651 436.691 425.578C435.575 424.494 434.307 423.795 433.165 423.386L432.552 423.167L433.178 423.008C436.103 422.267 437.709 421.181 437.757 421.282C437.776 421.312 437.397 421.604 436.646 422.022C435.894 422.438 434.761 422.974 433.277 423.39L433.29 423.012C434.495 423.399 435.841 424.102 437.028 425.224C437.625 425.777 438.174 426.439 438.644 427.183C439.11 427.927 439.512 428.776 439.648 429.73C439.818 430.774 439.487 431.871 438.872 432.638C438.271 433.425 437.493 433.976 436.709 434.384C435.119 435.2 433.464 435.321 432.156 435.161C430.833 434.992 429.834 434.54 429.212 434.15C428.9 433.953 428.671 433.784 428.53 433.651C428.384 433.523 428.314 433.45 428.325 433.437"
                  fill="#17282F"/>
            <path d="M437.5 433.615C437.666 433.668 437.068 435.116 437.302 436.915C437.546 438.709 438.435 439.995 438.282 440.082C438.208 440.167 437.064 438.963 436.782 436.982C436.535 434.988 437.41 433.541 437.5 433.615Z"
                  fill="#17282F"/>
            <path d="M444.914 426.546C444.826 426.546 444.902 425.987 444.448 425.323C444.226 425.001 443.874 424.667 443.408 424.464C442.946 424.259 442.358 424.209 441.77 424.328C440.567 424.566 439.723 425.41 439.214 426.046C438.7 426.698 438.442 427.163 438.37 427.128C438.312 427.101 438.449 426.577 438.912 425.831C439.363 425.111 440.265 424.096 441.667 423.814C442.35 423.675 443.054 423.748 443.612 424.026C444.169 424.302 444.55 424.73 444.766 425.134C445.204 425.973 444.962 426.577 444.914 426.546"
                  fill="#17282F"/>
            <path d="M451.66 426.988C451.026 426.277 450.112 425.721 449.014 425.548C448.764 425.506 448.509 425.486 448.252 425.486C447.624 425.486 446.984 425.607 446.366 425.835C445.884 425.955 445.419 426.141 444.989 426.396C445.046 426.169 445.063 425.706 444.764 425.133C444.548 424.73 444.168 424.302 443.61 424.026C443.236 423.84 442.797 423.745 442.342 423.745C442.118 423.745 441.89 423.768 441.665 423.813C440.264 424.096 439.362 425.111 438.911 425.831C438.649 426.254 438.491 426.605 438.414 426.835C437.998 426.232 437.529 425.689 437.027 425.224C436.213 424.454 435.324 423.882 434.458 423.474C434.267 423.379 434.072 423.291 433.875 423.211C434.169 423.116 434.448 423.018 434.71 422.918C434.759 422.916 434.808 422.915 434.857 422.915C436.125 422.915 437.396 423.423 438.284 424.331C439.389 423.163 440.726 422.084 442.318 421.85C442.486 421.824 442.657 421.812 442.828 421.812C444.283 421.812 445.79 422.684 446.073 424.095C446.588 423.862 447.154 423.746 447.72 423.746C448.417 423.746 449.113 423.921 449.718 424.267C450.716 424.839 451.439 425.862 451.66 426.988"
                  fill="#BA2C42"/>
            <path d="M451.712 427.324C450.694 426.241 449.203 425.671 447.721 425.671C447.264 425.671 446.809 425.726 446.367 425.834C446.985 425.607 447.625 425.485 448.252 425.485C448.51 425.485 448.765 425.506 449.015 425.548C450.113 425.721 451.027 426.277 451.661 426.988C451.683 427.099 451.7 427.212 451.712 427.324"
                  fill="#0F191D"/>
            <path d="M438.35 427.139C437.456 425.567 436.078 424.277 434.459 423.474C435.325 423.882 436.214 424.454 437.028 425.224C437.53 425.689 437.999 426.232 438.415 426.835C438.364 426.986 438.348 427.086 438.361 427.117C438.357 427.124 438.354 427.132 438.35 427.139ZM433.876 423.211C433.74 423.154 433.602 423.102 433.463 423.053L433.655 423.075C434 422.98 434.355 422.929 434.711 422.918C434.449 423.018 434.17 423.116 433.876 423.211"
                  fill="#0F191D"/>
            <path d="M444.763 426.539C444.787 425.659 444.189 424.842 443.395 424.458C443.398 424.46 443.402 424.462 443.406 424.464C443.872 424.666 444.224 425.001 444.446 425.323C444.8 425.84 444.832 426.293 444.87 426.468C444.834 426.491 444.798 426.515 444.763 426.539Z"
                  fill="#BA2C42"/>
            <path d="M438.362 427.117C438.349 427.086 438.365 426.986 438.415 426.835C438.492 426.605 438.65 426.254 438.912 425.831C439.363 425.111 440.266 424.096 441.667 423.813C441.892 423.768 442.119 423.745 442.343 423.745C442.798 423.745 443.238 423.84 443.612 424.026C444.17 424.302 444.55 424.73 444.766 425.133C445.065 425.706 445.047 426.169 444.991 426.396C444.951 426.42 444.911 426.444 444.872 426.468C444.834 426.293 444.802 425.84 444.448 425.323C444.226 425.001 443.874 424.666 443.408 424.464C443.404 424.462 443.4 424.46 443.396 424.458C443.291 424.408 443.181 424.364 443.069 424.329C442.797 424.245 442.515 424.206 442.233 424.206C441.527 424.206 440.815 424.451 440.227 424.852C439.41 425.409 438.81 426.236 438.362 427.117Z"
                  fill="#0F191D"/>
            <path d="M430.159 432.883C430.134 432.929 429.316 432.523 428.352 431.438C427.395 430.377 426.357 428.538 426.191 426.301C426.031 424.062 426.793 422.093 427.587 420.904C428.384 419.692 429.134 419.171 429.165 419.214C429.231 419.277 428.586 419.886 427.904 421.095C427.221 422.287 426.564 424.162 426.714 426.263C426.869 428.363 427.79 430.123 428.639 431.203C429.489 432.302 430.214 432.81 430.159 432.883"
                  fill="white"/>
            <path
                    class="listivo-fill-primary-2"
                    d="M648.327 236.348C647.661 234.431 645.854 232.504 643.9 233.06C644.321 231.768 643.932 230.247 642.939 229.317C641.948 228.387 640.405 228.096 639.142 228.599C639.027 226.296 637.369 224.148 635.171 223.453C633.248 222.845 630.789 223.972 629.254 225.481C627.384 224.971 625.373 224.978 623.541 225.611C620.095 226.803 617.473 230.092 617.078 233.717C616.75 236.738 617.873 239.774 619.584 242.286C621.05 244.436 622.932 246.258 624.854 248.021C614.495 296.398 561.406 304.812 561.406 304.812L566.38 324.29C617.258 311.716 631.275 271.16 635.087 252.107C635.533 252.109 635.981 252.096 636.428 252.058C640.205 251.755 643.912 250.002 646.287 247.047C648.663 244.095 649.57 239.929 648.327 236.348"
                    fill="#FA823E"/>
            <path d="M641.4 242.819C641.416 242.814 641.461 242.912 641.518 243.113C641.565 243.314 641.613 243.623 641.574 244.02C641.503 244.79 641.039 246.017 639.73 246.735C638.45 247.429 636.43 247.319 634.973 246.015C633.516 244.736 632.851 242.454 633.346 240.322C633.818 238.177 635.113 236.442 636.516 235.23C637.945 234.026 639.511 233.314 640.873 232.982C642.24 232.645 643.394 232.661 644.166 232.762C644.555 232.802 644.849 232.879 645.047 232.934C645.244 232.988 645.346 233.024 645.342 233.042C645.341 233.086 645.131 233.047 644.745 233.008C644.025 232.934 642.691 232.86 640.968 233.34C639.667 233.705 638.181 234.424 636.831 235.595C635.509 236.77 634.295 238.432 633.859 240.431C633.398 242.413 634.005 244.487 635.298 245.657C636.578 246.841 638.405 246.987 639.563 246.403C640.75 245.81 641.25 244.704 641.372 243.992C641.5 243.25 641.348 242.828 641.4 242.819"
                  fill="#17282F"/>
            <path d="M627.992 225.001C627.996 224.983 628.096 224.992 628.287 225.024C628.479 225.048 628.756 225.12 629.106 225.236C629.802 225.471 630.783 225.959 631.751 226.875C632.703 227.788 633.656 229.147 634.031 230.893C634.21 231.759 634.275 232.711 634.045 233.674C633.841 234.636 633.202 235.585 632.284 236.115C631.459 236.613 630.548 236.839 629.678 236.948C628.803 237.055 627.944 237.048 627.137 236.936C625.518 236.726 624.121 236.129 623.061 235.44L623.345 235.192C623.961 236.603 624.263 237.821 624.416 238.666C624.568 239.512 624.581 239.99 624.546 239.995C624.438 240.022 624.263 238.09 622.986 235.356L622.713 234.771L623.27 235.108C624.309 235.733 625.655 236.272 627.199 236.451C628.716 236.611 630.521 236.526 632.013 235.668C632.821 235.192 633.348 234.415 633.547 233.552C633.76 232.693 633.713 231.801 633.558 230.991C633.234 229.354 632.368 228.043 631.491 227.14C630.6 226.23 629.685 225.711 629.032 225.426C628.376 225.135 627.98 225.052 627.992 225.001"
                  fill="#17282F"/>
            <path d="M633.934 231.992C633.819 231.97 634.386 230.377 636.087 229.307C637.799 228.272 639.455 228.395 639.437 228.507C639.465 228.68 637.908 228.806 636.364 229.751C634.822 230.708 634.08 232.087 633.934 231.992Z"
                  fill="#17282F"/>
            <path d="M633.151 242.207C633.206 242.224 632.89 242.795 631.962 242.986C631.514 243.073 630.941 243.049 630.375 242.793C629.807 242.536 629.305 242.038 628.979 241.421C628.312 240.157 628.527 238.815 628.8 238.011C629.085 237.18 629.404 236.743 629.461 236.772C629.534 236.804 629.337 237.299 629.157 238.109C628.986 238.905 628.867 240.093 629.443 241.176C629.724 241.706 630.135 242.129 630.586 242.358C631.037 242.591 631.519 242.651 631.91 242.62C632.71 242.551 633.095 242.139 633.151 242.207"
                  fill="#17282F"/>
            <path
                    class="listivo-pattern__fill-v4"
                    d="M635.845 247.628C635.362 247.628 634.879 247.542 634.427 247.369C633.247 246.918 632.311 245.876 631.988 244.655C631.624 244.848 631.231 244.936 630.833 244.935C629.679 244.935 628.487 244.196 627.874 243.169C627.048 241.787 627.038 240.07 627.243 238.474C625.929 238.357 624.689 237.646 623.888 236.602C623.799 236.335 623.699 236.056 623.586 235.769C623.773 235.87 623.963 235.965 624.157 236.053C625.023 236.466 626.029 236.793 627.139 236.937C627.561 236.995 627.995 237.025 628.439 237.025C628.712 237.025 628.987 237.013 629.265 236.991C629.135 237.195 628.962 237.54 628.801 238.011C628.529 238.815 628.313 240.157 628.98 241.421C629.306 242.038 629.808 242.536 630.376 242.793C630.754 242.964 631.135 243.032 631.479 243.032C631.651 243.032 631.814 243.015 631.963 242.986C632.596 242.855 632.944 242.548 633.084 242.361C633.158 242.854 633.308 243.332 633.521 243.782C633.821 244.659 634.317 245.439 634.973 246.015C635.802 246.756 636.811 247.111 637.763 247.153C637.177 247.466 636.511 247.628 635.845 247.628"
                    fill="#D76E32"/>
            <path d="M637.762 247.153C636.81 247.111 635.801 246.755 634.972 246.015C634.316 245.439 633.82 244.659 633.52 243.782C634.344 245.528 636.114 246.845 638.055 246.98C637.959 247.041 637.862 247.1 637.762 247.153Z"
                  fill="#0F191D"/>
            <path d="M628.438 237.025C627.994 237.025 627.559 236.995 627.138 236.936C626.027 236.793 625.021 236.466 624.156 236.053C625.346 236.592 626.653 236.874 627.96 236.874C628.462 236.873 628.963 236.832 629.458 236.748C629.454 236.755 629.451 236.763 629.448 236.771C629.414 236.781 629.348 236.856 629.264 236.991C628.986 237.013 628.71 237.025 628.438 237.025V237.025ZM623.886 236.601C623.669 236.318 623.484 236.011 623.339 235.684L623.201 235.548C623.327 235.626 623.455 235.699 623.584 235.768C623.697 236.056 623.798 236.335 623.886 236.601"
                  fill="#0F191D"/>
            <path d="M631.714 242.626C631.364 242.626 630.964 242.553 630.585 242.358C630.578 242.354 630.57 242.35 630.562 242.346C630.9 242.505 631.274 242.588 631.645 242.588C632.157 242.588 632.662 242.43 633.049 242.095C633.053 242.138 633.058 242.181 633.064 242.223C632.903 242.305 632.531 242.566 631.909 242.619C631.846 242.624 631.781 242.626 631.714 242.626"
                  fill="#BA2C42"/>
            <path d="M631.478 243.032C631.134 243.032 630.753 242.964 630.375 242.793C629.807 242.536 629.305 242.038 628.979 241.421C628.312 240.157 628.527 238.815 628.8 238.011C628.961 237.54 629.134 237.195 629.264 236.991C629.348 236.856 629.415 236.782 629.448 236.772C629.049 237.676 628.788 238.664 628.874 239.649C628.96 240.641 629.435 241.631 630.268 242.18C630.361 242.242 630.461 242.298 630.564 242.346C630.571 242.35 630.579 242.354 630.586 242.358C630.965 242.553 631.365 242.627 631.716 242.627C631.782 242.627 631.847 242.625 631.91 242.62C632.532 242.566 632.904 242.305 633.065 242.223C633.07 242.27 633.076 242.316 633.083 242.361C632.943 242.548 632.595 242.855 631.962 242.986C631.813 243.015 631.65 243.032 631.478 243.032Z"
                  fill="#0F191D"/>
            <path
                    class="listivo-fill-primary-2"
                    d="M493.449 423.936C496.642 437.5 499.834 451.062 503.027 464.625C498.113 463.909 492.969 464.868 488.643 467.307C487.137 468.156 485.541 469.843 486.351 471.37C486.99 472.571 488.643 472.671 490.002 472.61C495.295 472.38 500.589 472.49 505.881 472.599C511.178 472.708 516.475 472.818 521.772 472.587L521.189 431.328L493.449 423.936"
                    fill="#FA823E"/>
            <path
                    class="listivo-fill-primary-2"
                    d="M550.832 423.936C547.639 437.5 544.446 451.062 541.254 464.625C546.168 463.909 551.312 464.868 555.638 467.307C557.144 468.156 558.739 469.843 557.929 471.37C557.291 472.571 555.638 472.671 554.278 472.61C548.986 472.38 543.692 472.49 538.399 472.599C533.102 472.708 527.806 472.818 522.51 472.587L523.091 431.328L550.832 423.936"
                    fill="#FA823E"/>
            <path d="M521.295 438.97L521.23 434.439C521.231 434.439 521.231 434.439 521.232 434.439L521.299 438.97C521.297 438.97 521.296 438.97 521.295 438.97Z"
                  fill="#A7A9A8"/>
            <path
                    class="listivo-pattern__fill-v4"
                    d="M513.125 439.744C508.012 439.744 502.559 439.094 496.998 438.793L495.68 433.412C495.689 433.415 495.697 433.418 495.706 433.422C500.566 435.349 505.666 436.673 510.855 437.323C510.286 435.958 509.718 434.593 509.15 433.228C513.172 433.927 517.217 434.35 521.232 434.439L521.296 438.97C518.704 439.543 515.967 439.744 513.125 439.744"
                    fill="#D76E32"/>
            <path d="M522.985 438.895C522.983 438.895 522.982 438.893 522.982 438.893L523.047 434.457C523.048 434.457 523.048 434.457 523.048 434.457L522.985 438.895Z"
                  fill="#A7A9A8"/>
            <path
                    class="listivo-pattern__fill-v4"
                    d="M533.997 440.246C528.066 440.246 523.138 438.936 522.984 438.894L523.047 434.457C525.668 434.449 528.277 434.294 530.857 433.979L533.029 433.982L532.487 433.758C537.756 432.969 542.896 431.486 547.796 429.177C548.074 429.046 548.351 428.915 548.624 428.784C549.332 428.472 549.738 428.25 549.813 428.207C549.817 428.205 549.822 428.202 549.827 428.201L547.68 437.323C547.68 437.323 546.706 438.578 539.738 439.783C537.802 440.118 535.852 440.246 533.997 440.246"
                    fill="#D76E32"/>
            <path
                    class="listivo-fill-primary-2"
                    d="M589.557 371.748C586.207 364.995 582.02 358.662 577.136 352.921L577.11 352.849C579.749 353.39 582.458 353.598 585.147 353.444C580.432 349.952 576.421 345.529 573.352 340.53C569.245 325.352 564.837 310.098 564.747 294.59L472.444 293.869C469.659 313.742 466.052 329.087 459.683 348.239C453.314 367.391 446.127 390.103 458.827 408.823C461.102 412.179 464.05 414.976 467.42 417.377C471.377 421.561 475.616 425.477 480.112 429.077C479.346 427.115 478.58 425.153 477.814 423.192C478.336 423.428 478.859 423.664 479.387 423.89C488.363 431.164 499.391 435.887 510.856 437.323C510.287 435.958 509.719 434.593 509.151 433.228C522.367 435.528 535.804 434.829 547.799 429.177C570.211 418.616 581.976 406.111 584.781 389.705C586.199 381.402 584.594 373.935 582.102 366.474C584.586 368.233 587.072 369.99 589.557 371.748"
                    fill="#FA823E"/>
            <path d="M559.086 376.309C559.083 376.325 558.955 376.312 558.712 376.274C558.471 376.23 558.111 376.179 557.655 376.07C556.739 375.87 555.42 375.511 553.824 374.916C550.642 373.744 546.333 371.454 542.48 367.614L542.903 367.337C543.344 368.468 543.804 369.648 544.273 370.853C545.119 373.046 545.936 375.16 546.689 377.112L547.267 378.606L546.263 377.361C543.384 373.791 540.892 370.703 539.055 368.426C538.219 367.358 537.533 366.484 537.006 365.811C536.535 365.195 536.292 364.853 536.314 364.834C536.337 364.816 536.625 365.122 537.136 365.704C537.693 366.353 538.415 367.197 539.298 368.227C541.172 370.474 543.713 373.522 546.65 377.045L546.223 377.294C545.462 375.343 544.638 373.233 543.784 371.043C543.317 369.837 542.86 368.657 542.423 367.525L541.978 366.377L542.846 367.25C546.622 371.042 550.831 373.353 553.948 374.599C555.51 375.231 556.805 375.636 557.7 375.89C558.598 376.143 559.093 376.274 559.086 376.309"
                  fill="#17282F"/>
            <path d="M479.346 358.043C479.289 358.068 478.827 357.179 478.309 355.649C477.789 354.122 477.259 351.937 477.054 349.474C476.856 347.009 477.023 344.766 477.288 343.175C477.55 341.581 477.862 340.629 477.921 340.643C478.001 340.662 477.82 341.638 477.654 343.224C477.487 344.807 477.381 347.01 477.576 349.431C477.777 351.849 478.241 354.005 478.663 355.541C479.085 357.079 479.423 358.012 479.346 358.043"
                  fill="#17282F"/>
            <path d="M482.436 350.177C482.373 350.195 482.09 349.517 481.801 348.366C481.512 347.215 481.251 345.584 481.223 343.768C481.198 341.951 481.414 340.312 481.669 339.155C481.924 337.994 482.189 337.308 482.252 337.324C482.412 337.362 481.68 340.195 481.747 343.76C481.782 347.324 482.596 350.136 482.436 350.177Z"
                  fill="#17282F"/>
            <path d="M515.224 409.268C515.22 409.285 515.029 409.249 514.668 409.166C514.31 409.076 513.775 408.965 513.102 408.762C511.748 408.386 509.807 407.749 507.479 406.77C502.83 404.836 496.639 401.287 491.083 395.783L491.478 395.441C491.681 395.728 491.9 396.039 492.12 396.349C494.185 399.354 495.667 402.551 496.624 405.58L496.814 406.184L496.269 405.867C491.445 403.072 488.341 399.299 486.625 396.467C485.755 395.042 485.192 393.84 484.847 393.005C484.669 392.59 484.562 392.258 484.48 392.037C484.404 391.816 484.371 391.698 484.384 391.692C484.414 391.682 484.611 392.127 484.993 392.941C485.384 393.749 485.983 394.918 486.88 396.306C488.649 399.064 491.758 402.731 496.511 405.442L496.156 405.731C495.194 402.751 493.723 399.606 491.688 396.646C491.471 396.34 491.256 396.034 491.056 395.752L491.451 395.41C496.947 400.862 503.043 404.429 507.624 406.437C509.918 407.452 511.829 408.139 513.16 408.571C513.822 408.803 514.347 408.945 514.696 409.066C515.047 409.181 515.228 409.251 515.224 409.268"
                  fill="#17282F"/>
            <path d="M467.978 315.638C467.987 315.639 467.986 315.718 467.976 315.873C467.961 316.06 467.942 316.287 467.919 316.563C467.869 317.169 467.761 318.059 467.606 319.204C467.288 321.491 466.687 324.785 465.71 328.798C464.73 332.81 463.358 337.533 461.716 342.736C460.082 347.941 458.206 353.634 456.499 359.684C454.8 365.735 453.46 371.585 452.754 376.977C452.049 382.37 452.046 387.296 452.52 391.376C453.005 395.46 453.917 398.682 454.727 400.832C455.14 401.906 455.475 402.734 455.737 403.281C455.847 403.536 455.938 403.744 456.012 403.915C456.071 404.059 456.098 404.135 456.089 404.14C456.082 404.143 456.039 404.076 455.964 403.939C455.877 403.773 455.771 403.573 455.642 403.327C455.348 402.793 454.981 401.974 454.537 400.906C453.664 398.766 452.689 395.531 452.152 391.422C451.627 387.314 451.592 382.346 452.275 376.917C452.96 371.485 454.291 365.61 455.995 359.542C457.706 353.477 459.598 347.784 461.255 342.591C462.921 337.401 464.328 332.698 465.351 328.707C466.371 324.716 467.026 321.445 467.404 319.172C467.591 318.036 467.732 317.152 467.814 316.55C467.857 316.277 467.894 316.052 467.923 315.867C467.951 315.714 467.969 315.637 467.978 315.638"
                  fill="#17282F"/>
            <path d="M471.908 413.902C471.896 413.915 471.673 413.731 471.256 413.364C470.856 412.984 470.197 412.488 469.486 411.712C467.985 410.237 466.015 407.877 464.069 404.645C462.11 401.421 460.322 397.254 459.067 392.426C457.821 387.598 457.171 382.107 457.307 376.355C457.483 370.603 458.316 365.167 459.381 360.311C460.444 355.45 461.693 351.147 462.811 347.56C463.932 343.974 464.91 341.096 465.599 339.113C465.937 338.158 466.205 337.399 466.406 336.833C466.596 336.314 466.704 336.044 466.722 336.049C466.739 336.055 466.664 336.336 466.506 336.866C466.329 337.44 466.091 338.208 465.792 339.176C465.164 341.179 464.24 344.073 463.166 347.669C462.094 351.263 460.886 355.566 459.852 360.413C458.818 365.255 458.005 370.658 457.83 376.368C457.696 382.073 458.326 387.516 459.535 392.307C460.753 397.098 462.488 401.24 464.388 404.458C466.276 407.683 468.186 410.061 469.634 411.571C470.318 412.366 470.951 412.883 471.328 413.287C471.719 413.676 471.92 413.889 471.908 413.902"
                  fill="white"/>
            <path d="M481.339 416.993C481.246 417.104 479.072 415.422 476.482 413.238C473.893 411.053 471.869 409.192 471.962 409.082C472.056 408.97 474.23 410.652 476.82 412.837C479.409 415.023 481.433 416.883 481.339 416.993Z"
                  fill="white"/>
            <path
                    class="listivo-fill-primary-2"
                    d="M480.813 154.679C480.813 154.679 480.597 146.131 481.945 133.552L509.676 150.908C509.676 150.908 502.743 117.961 501.563 111.671C501.563 111.671 511.749 139.965 538.535 152.038C543.264 152.922 559.548 153.59 578.419 169.764C597.289 185.939 605.836 201.615 607.895 218.585C611.23 246.072 606.275 269.508 593.246 285.233L592.796 280.74C592.796 280.74 578.867 300.959 557.752 306.8C536.634 312.64 474.182 306.8 474.182 306.8C474.182 306.8 439.137 297.364 427.007 269.958C414.876 242.55 421.615 238.507 421.615 238.507L416.392 243.44C416.392 243.44 415.027 203.987 450.37 176.055C478.226 154.039 480.813 154.679 480.813 154.679Z"
                    fill="#FA823E"/>
            <path d="M568.658 302.319C568.662 302.325 568.582 302.372 568.423 302.459C568.241 302.554 568.007 302.676 567.713 302.83C567.081 303.148 566.158 303.636 564.937 304.214C562.501 305.38 558.92 307.013 554.316 308.733C549.707 310.415 544.075 312.27 537.522 313.377C534.256 313.968 530.756 314.325 527.097 314.372C523.44 314.418 519.611 314.133 515.753 313.306L515.955 312.844C518.751 314.797 521.681 316.842 524.67 318.929L525.732 319.672L524.466 319.4C523.726 319.242 522.928 319.071 522.127 318.9C514.863 317.34 507.871 315.839 501.366 314.442L501.597 314.027C503.27 315.787 504.895 317.496 506.467 319.151L507.027 319.738L506.24 319.546C494.815 316.76 485.633 312.791 479.42 309.612C476.306 308.021 473.914 306.64 472.298 305.665C471.488 305.18 470.88 304.785 470.466 304.523C470.276 304.399 470.125 304.3 470.002 304.219C469.899 304.15 469.849 304.111 469.852 304.105C469.855 304.099 469.912 304.127 470.023 304.186C470.151 304.257 470.308 304.346 470.507 304.458C470.957 304.716 471.579 305.075 472.375 305.534C474.013 306.467 476.423 307.807 479.548 309.357C485.784 312.455 494.961 316.349 506.352 319.083L506.123 319.479C504.546 317.829 502.916 316.126 501.237 314.371L500.679 313.787L501.469 313.956C507.977 315.345 514.971 316.837 522.237 318.388C523.038 318.559 523.836 318.73 524.575 318.888L524.37 319.359C521.383 317.268 518.455 315.221 515.661 313.265L514.616 312.534L515.863 312.804C519.675 313.627 523.466 313.917 527.091 313.883C530.72 313.848 534.197 313.506 537.446 312.932C543.967 311.864 549.59 310.054 554.201 308.418C558.808 306.746 562.403 305.164 564.86 304.05C566.062 303.493 567.002 303.057 567.672 302.746C567.975 302.61 568.215 302.501 568.402 302.416C568.568 302.344 568.655 302.311 568.658 302.319"
                  fill="#17282F"/>
            <path d="M565.529 303.929H568.643V302.332H565.529V303.929Z" fill="#A7A9A8"/>
            <path d="M565.423 305.135C565.379 304.77 565.338 304.406 565.299 304.041C565.377 304.003 565.455 303.966 565.53 303.929C566.114 303.785 566.753 303.621 567.439 303.435C566.923 303.888 566.249 304.465 565.423 305.135"
                  fill="#BA2C42"/>
            <path
                    class="listivo-pattern__fill-v4"
                    d="M513.074 324.409C511.895 324.409 510.7 324.381 509.495 324.323C492.469 323.503 477.306 311.049 471.928 306.106C473.361 306.579 474.182 306.8 474.182 306.8C474.182 306.8 474.199 306.801 474.233 306.804C475.64 307.613 477.374 308.568 479.42 309.613C485.633 312.791 494.814 316.761 506.24 319.547L507.026 319.739L506.467 319.151C505.07 317.68 503.63 316.166 502.153 314.612C508.434 315.96 515.154 317.404 522.127 318.901C522.928 319.072 523.726 319.243 524.465 319.401L525.732 319.672L524.669 318.93C522.038 317.092 519.452 315.286 516.963 313.549C520.148 314.14 523.303 314.377 526.347 314.377C526.598 314.377 526.847 314.375 527.097 314.372C530.756 314.325 534.256 313.968 537.521 313.377C544.075 312.271 549.707 310.416 554.315 308.734C558.92 307.013 562.5 305.38 564.937 304.214C565.061 304.156 565.182 304.098 565.299 304.041C565.338 304.407 565.38 304.77 565.423 305.135C558.082 311.089 538.785 324.41 513.074 324.409"
                    fill="#D76E32"/>
            <path d="M474.232 306.804C474.199 306.801 474.182 306.8 474.182 306.8C474.182 306.8 473.361 306.578 471.927 306.106C470.718 304.995 470.003 304.262 469.873 304.128C469.896 304.147 469.939 304.178 470.001 304.219C470.125 304.3 470.275 304.399 470.466 304.523C470.879 304.785 471.487 305.18 472.298 305.665C472.852 305.999 473.497 306.382 474.232 306.804"
                  fill="#BA2C42"/>
            <path d="M507.027 319.738L506.24 319.546C494.814 316.76 485.633 312.791 479.42 309.612C477.375 308.567 475.64 307.612 474.233 306.804C473.497 306.382 472.853 305.999 472.298 305.665C471.487 305.18 470.88 304.785 470.466 304.523C470.276 304.399 470.125 304.3 470.001 304.219C469.94 304.178 469.897 304.147 469.874 304.128C469.859 304.113 469.852 304.105 469.852 304.105C481.092 311.062 493.445 316.218 506.296 319.315C504.67 317.61 503.044 315.904 501.417 314.199C509.118 315.848 516.818 317.496 524.52 319.145C521.616 317.115 518.712 315.084 515.807 313.054C519.259 313.809 522.814 314.155 526.438 314.155C540.336 314.154 555.2 309.058 568.658 302.319C568.658 302.319 568.654 302.323 568.645 302.332C568.616 302.352 568.542 302.394 568.423 302.459C568.241 302.554 568.007 302.676 567.713 302.83C567.189 303.093 566.462 303.476 565.531 303.928C565.455 303.966 565.378 304.003 565.3 304.041C565.182 304.097 565.061 304.156 564.937 304.214C562.501 305.38 558.92 307.013 554.316 308.733C549.707 310.415 544.075 312.27 537.522 313.377C534.256 313.968 530.756 314.325 527.097 314.372C526.848 314.375 526.598 314.377 526.348 314.377C523.303 314.377 520.148 314.14 516.963 313.548C519.452 315.286 522.038 317.091 524.67 318.929L525.732 319.672L524.465 319.4C523.726 319.242 522.928 319.071 522.127 318.9C515.155 317.403 508.434 315.96 502.153 314.612C503.63 316.166 505.07 317.68 506.467 319.151L507.027 319.738"
                  fill="#0F191D"/>
            <path d="M451.284 275.275C451.275 275.29 451.061 275.168 450.661 274.923C450.267 274.665 449.658 274.329 448.938 273.8C447.464 272.792 445.421 271.183 443.157 268.917C440.889 266.657 438.458 263.674 436.304 260.013C434.146 256.359 432.323 251.999 431.242 247.203L431.759 247.14C431.763 247.258 431.767 247.388 431.771 247.518C431.931 252.903 432.082 258.008 432.216 262.542L432.252 263.756L431.762 262.647C429.279 257.021 428.274 251.872 427.888 248.261C427.693 246.45 427.638 245.012 427.627 244.03C427.62 243.539 427.634 243.162 427.64 242.907C427.649 242.653 427.66 242.521 427.673 242.521C427.685 242.521 427.701 242.653 427.717 242.906C427.734 243.204 427.754 243.572 427.778 244.025C427.836 245.002 427.936 246.431 428.17 248.227C428.636 251.808 429.699 256.899 432.195 262.454L431.741 262.557C431.592 258.023 431.425 252.92 431.248 247.534C431.244 247.405 431.24 247.276 431.236 247.155L431.753 247.091C432.821 251.827 434.607 256.142 436.72 259.771C438.828 263.407 441.204 266.385 443.42 268.66C445.632 270.941 447.626 272.581 449.056 273.636C449.755 274.188 450.345 274.55 450.718 274.834C451.099 275.109 451.294 275.26 451.284 275.275"
                  fill="#17282F"/>
            <path d="M590.435 250.356C590.422 250.343 590.53 250.181 590.747 249.884C591.002 249.545 591.322 249.124 591.712 248.608C592.103 248.035 592.506 247.282 593.019 246.444C593.229 245.994 593.452 245.517 593.687 245.013C593.805 244.76 593.927 244.499 594.05 244.231C594.152 243.955 594.257 243.67 594.364 243.38C596.185 238.755 597.276 231.862 597.22 224.275C597.204 223.199 597.182 222.133 597.112 221.103L596.973 219.081L597.618 220.999C598.283 222.977 598.923 224.879 599.526 226.673L599.061 226.665C599.986 224.178 600.347 221.694 600.302 219.489C600.285 217.279 599.887 215.349 599.421 213.804C598.458 210.703 597.278 209.135 597.371 209.087C597.383 209.079 597.457 209.174 597.589 209.364C597.715 209.557 597.921 209.834 598.141 210.221C598.594 210.987 599.189 212.153 599.712 213.711C600.227 215.268 600.67 217.225 600.72 219.481C600.799 221.731 600.457 224.279 599.523 226.84L599.285 227.495L599.058 226.832C598.448 225.041 597.799 223.141 597.125 221.166L597.631 221.062C597.705 222.118 597.727 223.184 597.745 224.271C597.801 231.91 596.643 238.862 594.709 243.514C594.596 243.805 594.483 244.092 594.374 244.369C594.243 244.638 594.115 244.898 593.989 245.153C593.738 245.657 593.501 246.135 593.277 246.584C592.732 247.422 592.298 248.165 591.877 248.726C591.453 249.222 591.105 249.629 590.826 249.954C590.583 250.229 590.449 250.368 590.435 250.356"
                  fill="#17282F"/>
            <path d="M545.898 175.581C545.897 175.6 545.657 175.606 545.198 175.604C544.741 175.591 544.061 175.61 543.192 175.544C541.451 175.459 538.931 175.2 535.867 174.585C529.763 173.394 521.406 170.412 513.763 164.592L514.108 164.2L514.281 164.375C517.574 167.729 520.714 170.926 523.576 173.842L524.129 174.404L523.359 174.25C520.241 173.624 517.492 172.464 515.273 171.08C513.031 169.72 511.307 168.162 510.016 166.77C508.727 165.37 507.868 164.126 507.331 163.25C507.055 162.815 506.881 162.459 506.751 162.226C506.627 161.99 506.568 161.865 506.579 161.859C506.609 161.842 506.897 162.314 507.463 163.165C508.037 164.009 508.927 165.213 510.23 166.568C511.536 167.915 513.261 169.422 515.483 170.733C517.683 172.068 520.393 173.181 523.449 173.774L523.231 174.182C520.36 171.275 517.211 168.087 513.906 164.743L513.734 164.567L514.079 164.175C521.647 169.938 529.897 172.947 535.944 174.224C538.977 174.881 541.477 175.196 543.207 175.342C544.07 175.438 544.747 175.452 545.202 175.499C545.659 175.536 545.898 175.563 545.898 175.581"
                  fill="#17282F"/>
            <path d="M479.407 162.566C479.409 162.574 479.328 162.61 479.168 162.672C478.978 162.742 478.743 162.828 478.452 162.935C477.825 163.172 476.878 163.455 475.695 163.923C473.309 164.797 469.902 166.2 465.859 168.267C457.785 172.351 447.222 179.586 438.369 190.291C429.506 200.993 424.376 212.726 421.875 221.42C420.601 225.779 419.861 229.389 419.449 231.897C419.211 233.145 419.11 234.128 418.994 234.788C418.943 235.094 418.903 235.341 418.87 235.541C418.839 235.71 418.819 235.796 418.81 235.795C418.801 235.794 418.804 235.706 418.817 235.535C418.836 235.334 418.86 235.083 418.889 234.775C418.972 234.11 419.04 233.121 419.248 231.865C419.599 229.342 420.285 225.709 421.519 221.318C422.747 216.927 424.612 211.8 427.3 206.395C429.98 200.99 433.54 195.342 437.965 189.957C442.426 184.604 447.307 180.051 452.114 176.408C456.921 172.756 461.607 169.964 465.69 167.937C469.773 165.903 473.213 164.548 475.627 163.732C476.823 163.292 477.782 163.04 478.42 162.834C478.716 162.748 478.958 162.678 479.152 162.621C479.318 162.576 479.404 162.557 479.407 162.566Z"
                  fill="#F8FAFD"/>
            <path d="M433.836 272.683C433.809 272.707 433.447 272.347 432.814 271.672C432.493 271.339 432.112 270.919 431.706 270.402C431.295 269.888 430.802 269.323 430.336 268.637C429.347 267.308 428.296 265.632 427.263 263.697C426.261 261.747 425.294 259.531 424.509 257.124C423.747 254.707 423.245 252.342 422.926 250.173C422.641 247.998 422.52 246.023 422.552 244.366C422.533 243.538 422.604 242.791 422.64 242.134C422.669 241.477 422.736 240.914 422.803 240.457C422.925 239.539 423.01 239.036 423.045 239.041C423.082 239.045 423.065 239.557 423.006 240.475C422.97 240.933 422.933 241.495 422.933 242.149C422.925 242.801 422.88 243.544 422.922 244.364C422.937 246.006 423.096 247.957 423.404 250.102C423.745 252.243 424.255 254.576 425.008 256.964C425.784 259.343 426.725 261.535 427.692 263.476C428.69 265.399 429.696 267.078 430.638 268.423C431.081 269.117 431.55 269.693 431.935 270.219C432.317 270.751 432.673 271.186 432.968 271.539C433.551 272.251 433.862 272.658 433.836 272.683"
                  fill="#F8FAFD"/>
            <path d="M442.153 282.118C442.111 282.25 441.123 282.03 440.114 281.327C439.101 280.631 438.547 279.783 438.656 279.697C438.77 279.6 439.464 280.245 440.412 280.897C441.355 281.555 442.205 281.977 442.153 282.118"
                  fill="#F8FAFD"/>
            <path d="M514.384 149.39C514.316 149.538 512.091 147.261 510.826 143.276C509.526 139.308 509.874 135.766 510.006 135.816C510.187 135.805 510.105 139.216 511.354 143.017C512.562 146.837 514.52 149.245 514.384 149.39Z"
                  fill="#F8FAFD"/>
            <path d="M486.191 154.575C486.097 154.611 484.63 152.587 484.406 150.237C484.147 147.879 485.261 146.459 485.367 146.541C485.53 146.618 484.684 148.101 484.936 150.361C485.146 152.611 486.345 154.572 486.191 154.575Z"
                  fill="#F8FAFD"/>
            <path d="M500.246 264.366C499.471 264.366 498.65 264.02 497.945 263.638C497.421 263.355 496.897 263.043 496.511 262.588C496.127 262.132 495.902 261.503 496.064 260.931C495.451 261.944 494.839 262.958 494.227 263.972L494.291 262.869C496.463 257.223 501.492 252.829 507.305 251.158C509.19 250.617 511.143 250.355 513.1 250.355C517.178 250.355 521.272 251.491 524.782 253.586C526.039 254.334 527.318 255.34 527.594 256.777C524.404 254.295 520.416 252.953 516.39 252.59C515.573 252.516 514.754 252.481 513.934 252.481C510.72 252.481 507.504 253.019 504.398 253.866C503.348 254.153 502.218 254.541 501.648 255.468C501.151 256.278 501.209 257.315 501.461 258.231C501.711 259.148 502.135 260.015 502.329 260.946C502.571 262.105 502.328 263.514 501.299 264.101C500.97 264.289 500.613 264.366 500.246 264.366"
                  fill="#BA2C42"/>
            <path d="M496.959 258.644C497.33 260.339 498.269 261.904 499.588 263.029C500.08 263.449 500.767 263.822 501.343 263.528C501.999 263.195 502.018 262.275 501.895 261.549C501.533 259.43 500.749 257.382 499.599 255.565"
                  fill="#F8FAFD"/>
            <path d="M530.758 258.644C530.387 260.339 529.449 261.904 528.129 263.029C527.637 263.449 526.95 263.822 526.374 263.528C525.719 263.195 525.7 262.275 525.823 261.549C526.183 259.43 526.968 257.382 528.118 255.565"
                  fill="#F8FAFD"/>
            <path d="M535.468 263.165C535.141 263.415 533.325 261.121 529.747 258.29C527.954 256.89 525.694 255.392 522.98 254.2C520.282 252.998 517.099 252.174 513.715 252.011C510.335 251.861 507.104 252.434 504.435 253.556C501.763 254.687 499.623 256.318 498.128 257.945C495.076 261.228 494.573 264.206 494.153 264.097C493.996 264.072 493.908 263.309 494.186 261.965C494.474 260.635 495.21 258.731 496.708 256.756C498.188 254.779 500.465 252.77 503.45 251.353C506.435 249.942 510.071 249.226 513.833 249.394C517.593 249.572 521.103 250.57 524 252.012C526.905 253.442 529.222 255.225 530.961 256.89C534.433 260.271 535.726 262.998 535.468 263.165"
                  fill="#17282F"/>
            <path
                    class="listivo-pattern__fill-v4"
                    d="M511.751 279.972C509.139 279.972 506.815 279.446 505.214 278.796C503.453 278.085 502.536 277.311 502.669 276.995C502.733 276.843 502.981 276.785 503.383 276.785C504.024 276.785 505.056 276.931 506.363 277.078C507.669 277.225 509.249 277.373 510.984 277.373C511.443 277.373 511.911 277.362 512.389 277.339C516.731 277.203 520.281 276.056 521.562 276.056C521.824 276.056 521.991 276.103 522.051 276.218C522.208 276.524 521.356 277.369 519.657 278.217C517.969 279.066 515.404 279.837 512.494 279.958C512.244 279.968 511.996 279.972 511.751 279.972"
                    fill="#D76E32"/>
            <path d="M509.486 239.985C502.946 239.573 497.636 237.468 493.328 234.445C494.169 234.958 495.046 235.451 495.969 235.906C499.893 237.921 504.516 239.428 509.486 239.985"
                  fill="#A4A6A5"/>
            <path d="M452.82 207.439C469.071 212.887 486.031 213.479 503.833 207.882C503.833 207.882 500.559 231.176 478.369 232.45C456.18 233.724 452.82 207.439 452.82 207.439Z"
                  fill="#F8FAFD"/>
            <path d="M469.736 211.421C468.894 217.032 469.859 222.265 472.311 227.381C472.958 228.73 473.741 230.062 474.916 230.987C476.091 231.913 477.736 232.365 479.121 231.799C480.469 231.249 481.297 229.898 481.911 228.578C484.597 222.805 484.842 218.098 485.125 211.738C480.25 212.972 475.097 212.744 469.736 211.421Z"
                  fill="#17282F"/>
            <path
                    class="listivo-pattern__fill-v4"
                    d="M477.63 234.313C477.288 234.313 476.944 234.307 476.598 234.293C472.49 234.07 468.69 232.856 465.593 231.164C464.028 230.339 462.662 229.354 461.429 228.391C460.227 227.385 459.167 226.381 458.299 225.374C456.554 223.369 455.439 221.517 454.828 220.174C454.211 218.834 454.005 218.042 454.1 218.001C454.105 217.999 454.11 217.998 454.116 217.998C454.254 217.998 454.666 218.687 455.415 219.846C456.187 221.053 457.415 222.73 459.193 224.539C460.077 225.449 461.134 226.353 462.31 227.261C463.027 227.773 463.783 228.295 464.59 228.788C467.434 230.784 470.94 232.174 475.258 232.446C475.727 232.499 476.202 232.539 476.681 232.565C477.016 232.579 477.351 232.585 477.683 232.585C481.138 232.585 484.424 231.871 487.244 230.748C488.803 230.153 490.201 229.393 491.486 228.647C492.742 227.856 493.88 227.056 494.846 226.234C496.788 224.601 498.171 223.049 499.054 221.92C499.901 220.848 500.375 220.204 500.519 220.204C500.525 220.204 500.532 220.205 500.537 220.208C500.629 220.258 500.348 221.027 499.607 222.304C498.871 223.582 497.585 225.319 495.657 227.15C494.698 228.07 493.547 228.97 492.256 229.857C490.937 230.698 489.484 231.549 487.849 232.222C484.878 233.495 481.358 234.313 477.63 234.313"
                    fill="#D76E32"/>
            <path
                    class="listivo-pattern__fill-v4"
                    d="M478.937 211.811C474.874 211.811 470.857 211.496 466.882 210.881C464.59 210.089 462.391 209.045 460.351 207.731C459.022 206.874 457.709 205.837 457.102 204.378C456.493 202.918 456.85 200.952 458.246 200.209C463.387 204.631 470.309 206.983 477.038 207.819C478.438 207.993 479.849 208.079 481.259 208.079C486.628 208.079 491.998 206.831 496.802 204.433C497.294 204.187 497.836 203.925 498.366 203.925C498.522 203.925 498.677 203.947 498.829 203.999C499.494 204.226 499.87 204.983 499.832 205.685C499.794 206.385 499.421 207.027 498.974 207.569C498.024 208.721 496.76 209.51 495.376 210.093C489.815 211.252 484.337 211.811 478.937 211.811"
                    fill="#D76E32"/>
            <path d="M497.958 203.825C498.213 204.172 496.484 206.083 492.816 207.95C490.991 208.881 488.68 209.747 486.005 210.31C483.334 210.876 480.296 211.102 477.135 210.811C473.975 210.498 471.034 209.699 468.519 208.637C465.998 207.578 463.893 206.289 462.277 205.03C459.029 202.501 457.694 200.298 458.01 200.005C458.377 199.638 460.289 201.161 463.619 202.985C466.924 204.817 471.806 206.827 477.464 207.368C483.121 207.908 488.294 206.861 491.886 205.688C495.502 204.528 497.669 203.395 497.958 203.825"
                  fill="#17282F"/>
            <path d="M474.614 227.27C474.594 227.284 474.465 227.135 474.244 226.852C474.021 226.572 473.731 226.142 473.405 225.59C472.751 224.489 472.019 222.85 471.592 220.932C471.172 219.012 471.147 217.217 471.276 215.943C471.338 215.306 471.421 214.793 471.506 214.445C471.586 214.096 471.642 213.906 471.665 213.911C471.724 213.922 471.583 214.698 471.52 215.961C471.454 217.221 471.518 218.976 471.93 220.858C472.348 222.737 473.029 224.355 473.619 225.472C474.208 226.59 474.663 227.234 474.614 227.27"
                  fill="#F8FAFD"/>
            <path d="M509.107 206.507C509.132 206.574 508.351 206.918 506.911 207.484C506.193 207.771 505.31 208.113 504.261 208.437C503.212 208.762 502.034 209.198 500.691 209.53C499.354 209.887 497.893 210.299 496.295 210.613C495.497 210.777 494.678 210.979 493.823 211.123C492.966 211.264 492.084 211.41 491.181 211.558C487.556 212.08 483.534 212.464 479.301 212.464C475.067 212.458 471.043 212.116 467.414 211.604C465.608 211.292 463.884 211.04 462.299 210.656C461.505 210.476 460.734 210.322 460.001 210.137C459.273 209.938 458.573 209.748 457.904 209.566C456.561 209.225 455.381 208.805 454.336 208.464C453.816 208.289 453.329 208.133 452.887 207.973C452.452 207.801 452.052 207.642 451.69 207.5C450.254 206.924 449.475 206.574 449.501 206.507C449.566 206.331 452.762 207.537 458.09 208.857C458.758 209.016 459.457 209.183 460.184 209.357C460.914 209.52 461.682 209.654 462.472 209.813C464.048 210.156 465.758 210.374 467.547 210.657C471.142 211.111 475.118 211.421 479.299 211.427C483.48 211.426 487.454 211.076 491.046 210.613C491.942 210.479 492.816 210.35 493.665 210.224C494.515 210.097 495.328 209.913 496.121 209.77C497.712 209.496 499.168 209.128 500.506 208.819C501.85 208.536 503.033 208.153 504.091 207.883C505.15 207.614 506.045 207.328 506.781 207.102C508.254 206.656 509.083 206.44 509.107 206.507"
                  fill="#17282F"/>
            <path d="M522.238 208.193C538.489 213.641 555.448 214.233 573.251 208.636C573.251 208.636 569.977 231.93 547.787 233.204C525.598 234.478 522.238 208.193 522.238 208.193Z"
                  fill="#F8FAFD"/>
            <path d="M539.154 212.176C538.312 217.786 539.277 223.02 541.729 228.135C542.376 229.484 543.159 230.816 544.334 231.742C545.509 232.668 547.154 233.119 548.539 232.553C549.887 232.004 550.715 230.652 551.329 229.332C554.015 223.56 554.26 218.853 554.543 212.493C549.668 213.727 544.515 213.498 539.154 212.176Z"
                  fill="#17282F"/>
            <path
                    class="listivo-pattern__fill-v4"
                    d="M547.048 235.068C546.706 235.068 546.361 235.061 546.016 235.047C541.908 234.824 538.108 233.61 535.011 231.918C533.446 231.093 532.08 230.108 530.847 229.145C529.645 228.14 528.585 227.135 527.717 226.128C525.972 224.123 524.857 222.271 524.246 220.929C523.629 219.589 523.423 218.797 523.518 218.756C523.523 218.754 523.528 218.752 523.534 218.752C523.672 218.752 524.084 219.441 524.833 220.6C525.605 221.807 526.833 223.484 528.611 225.293C529.495 226.203 530.552 227.108 531.728 228.015C532.445 228.528 533.201 229.049 534.008 229.543C536.852 231.538 540.358 232.929 544.676 233.2C545.145 233.253 545.62 233.293 546.098 233.319C546.434 233.333 546.769 233.34 547.101 233.34C550.556 233.34 553.842 232.626 556.662 231.502C558.221 230.907 559.618 230.148 560.904 229.402C562.16 228.611 563.298 227.81 564.264 226.989C566.206 225.356 567.589 223.803 568.472 222.674C569.319 221.602 569.793 220.958 569.936 220.958C569.943 220.958 569.95 220.959 569.955 220.963C570.047 221.013 569.766 221.782 569.025 223.058C568.289 224.336 567.003 226.074 565.075 227.904C564.116 228.824 562.965 229.725 561.674 230.611C560.355 231.453 558.902 232.304 557.267 232.976C554.296 234.25 550.776 235.068 547.048 235.068"
                    fill="#D76E32"/>
            <path
                    class="listivo-pattern__fill-v4"
                    d="M548.355 212.565C544.292 212.565 540.275 212.25 536.3 211.636C534.008 210.843 531.809 209.8 529.769 208.485C528.44 207.629 527.127 206.592 526.52 205.132C525.911 203.673 526.268 201.707 527.664 200.964C532.805 205.386 539.727 207.738 546.456 208.573C547.856 208.747 549.267 208.833 550.677 208.833C556.046 208.833 561.416 207.585 566.22 205.187C566.712 204.941 567.254 204.679 567.784 204.679C567.94 204.679 568.095 204.701 568.247 204.753C568.912 204.981 569.288 205.738 569.25 206.439C569.212 207.14 568.838 207.781 568.392 208.323C567.442 209.475 566.178 210.264 564.794 210.848C559.233 212.007 553.755 212.565 548.355 212.565"
                    fill="#D76E32"/>
            <path d="M567.376 204.58C567.631 204.927 565.902 206.838 562.234 208.705C560.409 209.635 558.098 210.502 555.423 211.065C552.752 211.631 549.714 211.856 546.553 211.566C543.393 211.253 540.452 210.454 537.937 209.392C535.416 208.333 533.311 207.044 531.695 205.785C528.447 203.256 527.112 201.053 527.428 200.76C527.795 200.393 529.707 201.916 533.037 203.74C536.342 205.572 541.224 207.582 546.882 208.123C552.539 208.663 557.712 207.616 561.304 206.443C564.919 205.283 567.087 204.15 567.376 204.58"
                  fill="#17282F"/>
            <path d="M544.032 228.024C544.012 228.038 543.883 227.89 543.662 227.607C543.439 227.327 543.149 226.897 542.823 226.345C542.169 225.244 541.437 223.605 541.01 221.687C540.59 219.767 540.565 217.972 540.694 216.698C540.756 216.061 540.839 215.548 540.924 215.2C541.004 214.851 541.06 214.661 541.083 214.666C541.142 214.677 541.001 215.453 540.938 216.716C540.872 217.976 540.936 219.731 541.348 221.613C541.766 223.492 542.447 225.11 543.037 226.227C543.626 227.345 544.081 227.989 544.032 228.024"
                  fill="#F8FAFD"/>
            <path d="M578.525 207.262C578.55 207.329 577.769 207.673 576.329 208.239C575.611 208.525 574.728 208.868 573.679 209.192C572.63 209.517 571.452 209.952 570.109 210.284C568.772 210.641 567.311 211.054 565.713 211.368C564.915 211.531 564.096 211.733 563.24 211.877C562.384 212.019 561.502 212.164 560.599 212.313C556.974 212.834 552.952 213.218 548.719 213.219C544.485 213.213 540.461 212.871 536.832 212.358C535.026 212.046 533.302 211.794 531.717 211.41C530.923 211.231 530.152 211.076 529.419 210.891C528.691 210.693 527.991 210.502 527.322 210.32C525.979 209.98 524.799 209.559 523.754 209.218C523.234 209.043 522.747 208.888 522.305 208.727C521.87 208.556 521.47 208.397 521.108 208.254C519.672 207.678 518.893 207.329 518.919 207.262C518.984 207.085 522.18 208.292 527.508 209.611C528.176 209.77 528.875 209.938 529.602 210.112C530.332 210.274 531.1 210.408 531.89 210.567C533.466 210.911 535.176 211.129 536.965 211.412C540.56 211.866 544.536 212.175 548.717 212.181C552.898 212.181 556.872 211.83 560.464 211.367C561.36 211.234 562.234 211.104 563.083 210.978C563.933 210.852 564.746 210.668 565.539 210.525C567.13 210.251 568.586 209.883 569.924 209.574C571.268 209.291 572.451 208.907 573.509 208.637C574.568 208.368 575.463 208.083 576.199 207.856C577.672 207.411 578.501 207.195 578.525 207.262"
                  fill="#17282F"/>
            <path
                    class="listivo-fill-primary-2"
                    d="M544.795 144.113L539.34 119.576L552.342 118.237L556.562 96.3405L558.446 123.392L545.242 124.708L544.795 144.113"
                    fill="#FA823E"/>
            <path
                    class="listivo-fill-primary-2"
                    d="M552.158 147.347L560.567 129.775L569.135 135.177L582.181 123.843L570.392 141.239L561.713 135.727L552.158 147.347"
                    fill="#FA823E"/>
            <path d="M544.795 144.113L539.34 119.576L552.342 118.237L556.562 96.3405L558.446 123.392L545.242 124.708L544.795 144.113"
                  fill="#F8FAFD"/>
            <path d="M552.158 147.347L560.567 129.775L569.135 135.177L582.181 123.843L570.392 141.239L561.713 135.727L552.158 147.347"
                  fill="#F8FAFD"/>
            <path
                    class="listivo-fill-color-4"
                    d="M666.383 358.982C665.935 358.884 665.588 358.644 665.343 358.262C665.097 357.88 665.028 357.442 665.135 356.949L666.891 348.88L645.71 344.271C645.261 344.173 644.914 343.933 644.669 343.551C644.423 343.169 644.354 342.731 644.462 342.238L645.647 336.792C645.715 336.478 645.856 336.156 646.068 335.827C646.281 335.497 646.533 335.2 646.826 334.935L672.411 312.191C673.159 311.556 674.071 311.355 675.147 311.589L683.687 313.448C684.136 313.545 684.482 313.785 684.728 314.167C684.974 314.549 685.043 314.987 684.935 315.48L679.126 342.176L685.11 343.478C685.648 343.595 686.018 343.84 686.218 344.212C686.464 344.594 686.538 345.009 686.44 345.458L685.211 351.106C685.104 351.599 684.859 351.969 684.477 352.214C684.095 352.46 683.68 352.534 683.231 352.436L677.18 351.119L675.424 359.188C675.316 359.681 675.072 360.051 674.689 360.296C674.307 360.542 673.892 360.616 673.444 360.518L666.383 358.982ZM656.392 337.58L668.966 340.317L672.815 322.632L656.392 337.58ZM707.188 368.566C703.96 367.863 701.278 366.81 699.142 365.406C697.061 363.967 695.434 362.275 694.261 360.33C693.142 358.349 692.436 356.2 692.142 353.882C691.903 351.529 691.984 349.106 692.387 346.611C692.605 345.391 692.853 344.036 693.13 342.547C693.462 341.023 693.793 339.499 694.125 337.974C694.502 336.46 694.849 335.08 695.167 333.835C695.793 331.388 696.721 329.172 697.952 327.187C699.227 325.21 700.802 323.581 702.678 322.299C704.553 321.017 706.731 320.176 709.213 319.777C711.749 319.343 714.586 319.467 717.724 320.15C720.862 320.833 723.472 321.894 725.553 323.333C727.644 324.727 729.276 326.397 730.449 328.343C731.622 330.288 732.356 332.42 732.649 334.737C732.988 337.065 732.956 339.476 732.554 341.971C732.326 343.236 732.046 344.63 731.714 346.155C731.427 347.688 731.096 349.213 730.719 350.727C730.397 352.206 730.082 353.546 729.774 354.747C729.103 357.183 728.147 359.417 726.907 361.448C725.677 363.434 724.119 365.09 722.234 366.417C720.403 367.709 718.22 368.572 715.684 369.006C713.203 369.405 710.371 369.258 707.188 368.566ZM709.09 359.824C711.69 360.39 713.781 359.953 715.362 358.513C716.943 357.073 718.095 354.905 718.819 352.011C719.147 350.721 719.462 349.381 719.764 347.991C720.112 346.611 720.414 345.221 720.672 343.822C720.974 342.432 721.235 341.127 721.453 339.907C721.968 337.108 721.811 334.703 720.981 332.691C720.151 330.679 718.441 329.368 715.851 328.758C713.196 328.227 711.073 328.704 709.482 330.189C707.936 331.684 706.816 333.811 706.122 336.571C705.813 337.771 705.486 339.062 705.138 340.442C704.836 341.831 704.534 343.221 704.231 344.611C703.974 346.01 703.726 347.365 703.488 348.675C702.943 351.608 703.091 354.058 703.93 356.025C704.77 357.992 706.49 359.258 709.09 359.824ZM756.151 378.517C755.702 378.419 755.356 378.179 755.11 377.797C754.865 377.415 754.795 376.978 754.903 376.484L756.659 368.415L735.477 363.806C735.029 363.708 734.682 363.468 734.436 363.086C734.191 362.704 734.122 362.267 734.229 361.773L735.414 356.327C735.483 356.013 735.623 355.691 735.836 355.362C736.048 355.033 736.301 354.735 736.593 354.47L762.178 331.726C762.927 331.091 763.839 330.89 764.915 331.124L773.455 332.983C773.903 333.08 774.25 333.32 774.495 333.702C774.741 334.084 774.81 334.522 774.703 335.015L768.893 361.711L774.878 363.013C775.416 363.13 775.785 363.375 775.986 363.747C776.231 364.129 776.305 364.545 776.208 364.993L774.979 370.641C774.871 371.134 774.627 371.504 774.245 371.749C773.862 371.995 773.447 372.069 772.999 371.971L766.947 370.654L765.191 378.723C765.084 379.217 764.839 379.586 764.457 379.831C764.075 380.077 763.66 380.151 763.211 380.053L756.151 378.517ZM746.159 357.116L758.734 359.852L762.582 342.167L746.159 357.116Z"
                    fill="#F2F4F8"/>
        </svg>
    <?php endif; ?>
</div>