<template>
    <div v-if="props.searchFilters.length > 0" class="listivo-search-results__filters">
        <div v-for="filter in props.searchFilters" :key="filter.key">
            <div
                    class="listivo-search-filter"
                    v-if="filter.type === 'taxonomy'"
                    @click.stop.prevent="props.removeTaxonomyFilter(filter.key, filter.termId)"
            >
                <span v-html="filter.label"></span>

                <div class="listivo-search-filter__close">
                    <svg xmlns="http://www.w3.org/2000/svg" width="7" height="7" viewBox="0 0 7 7" fill="none">
                        <path d="M1.16702 0.500289C1.03487 0.500453 0.905782 0.540023 0.796228 0.613946C0.686675 0.687868 0.601634 0.792787 0.55197 0.915298C0.502306 1.03781 0.490273 1.17235 0.517409 1.30174C0.544545 1.43113 0.609617 1.54948 0.704313 1.64169L2.56032 3.49857L0.704313 5.35546C0.640536 5.41672 0.589618 5.4901 0.554541 5.57129C0.519465 5.65249 0.500934 5.73987 0.500034 5.82832C0.499135 5.91677 0.515885 6.00452 0.549304 6.08641C0.582722 6.1683 0.632137 6.2427 0.694655 6.30525C0.757173 6.3678 0.831537 6.41724 0.913391 6.45067C0.995245 6.4841 1.08295 6.50086 1.17135 6.49996C1.25976 6.49906 1.3471 6.48052 1.42826 6.44543C1.50942 6.41034 1.58276 6.35939 1.644 6.29559L3.5 4.4387L5.356 6.29559C5.41723 6.35939 5.49058 6.41034 5.57173 6.44543C5.65289 6.48053 5.74023 6.49907 5.82864 6.49997C5.91705 6.50087 6.00475 6.48411 6.08661 6.45067C6.16846 6.41724 6.24283 6.3678 6.30535 6.30525C6.36786 6.24271 6.41728 6.16831 6.4507 6.08641C6.48412 6.00452 6.50087 5.91678 6.49997 5.82832C6.49907 5.73987 6.48053 5.65249 6.44546 5.57129C6.41038 5.4901 6.35946 5.41672 6.29568 5.35546L4.43968 3.49857L6.29568 1.64169C6.39171 1.5483 6.4573 1.42807 6.48385 1.29675C6.51041 1.16543 6.49669 1.02915 6.44449 0.905766C6.3923 0.782381 6.30407 0.677648 6.19136 0.605294C6.07865 0.53294 5.94672 0.49634 5.81286 0.500289C5.64022 0.505436 5.47636 0.577624 5.356 0.70156L3.5 2.55844L1.644 0.70156C1.58199 0.637793 1.50783 0.587123 1.4259 0.552551C1.34397 0.517979 1.25594 0.500207 1.16702 0.500289Z"
                              fill="#374B5C"/>
                    </svg>
                </div>
            </div>

            <div
                    class="listivo-search-filter"
                    v-if="filter.type === 'regular'"
                    @click.stop.prevent="props.removeFilter(filter.key)"
            >
                <span v-html="filter.label"></span>

                <div class="listivo-search-filter__close">
                    <svg xmlns="http://www.w3.org/2000/svg" width="7" height="7" viewBox="0 0 7 7" fill="none">
                        <path d="M1.16702 0.500289C1.03487 0.500453 0.905782 0.540023 0.796228 0.613946C0.686675 0.687868 0.601634 0.792787 0.55197 0.915298C0.502306 1.03781 0.490273 1.17235 0.517409 1.30174C0.544545 1.43113 0.609617 1.54948 0.704313 1.64169L2.56032 3.49857L0.704313 5.35546C0.640536 5.41672 0.589618 5.4901 0.554541 5.57129C0.519465 5.65249 0.500934 5.73987 0.500034 5.82832C0.499135 5.91677 0.515885 6.00452 0.549304 6.08641C0.582722 6.1683 0.632137 6.2427 0.694655 6.30525C0.757173 6.3678 0.831537 6.41724 0.913391 6.45067C0.995245 6.4841 1.08295 6.50086 1.17135 6.49996C1.25976 6.49906 1.3471 6.48052 1.42826 6.44543C1.50942 6.41034 1.58276 6.35939 1.644 6.29559L3.5 4.4387L5.356 6.29559C5.41723 6.35939 5.49058 6.41034 5.57173 6.44543C5.65289 6.48053 5.74023 6.49907 5.82864 6.49997C5.91705 6.50087 6.00475 6.48411 6.08661 6.45067C6.16846 6.41724 6.24283 6.3678 6.30535 6.30525C6.36786 6.24271 6.41728 6.16831 6.4507 6.08641C6.48412 6.00452 6.50087 5.91678 6.49997 5.82832C6.49907 5.73987 6.48053 5.65249 6.44546 5.57129C6.41038 5.4901 6.35946 5.41672 6.29568 5.35546L4.43968 3.49857L6.29568 1.64169C6.39171 1.5483 6.4573 1.42807 6.48385 1.29675C6.51041 1.16543 6.49669 1.02915 6.44449 0.905766C6.3923 0.782381 6.30407 0.677648 6.19136 0.605294C6.07865 0.53294 5.94672 0.49634 5.81286 0.500289C5.64022 0.505436 5.47636 0.577624 5.356 0.70156L3.5 2.55844L1.644 0.70156C1.58199 0.637793 1.50783 0.587123 1.4259 0.552551C1.34397 0.517979 1.25594 0.500207 1.16702 0.500289Z"
                              fill="#374B5C"/>
                    </svg>
                </div>
            </div>
        </div>

        <div
                v-if="props.searchFilters.length > 1"
                @click="props.onClear"
                class="listivo-search-results__clear-filters"
        >
            <?php echo esc_html(tdf_string('clear_all')); ?>
        </div>
    </div>
</template>