<?php
/* @var \Tangibledesign\Listivo\Widgets\General\ShapeWidget $lstCurrentWidget */
global $lstCurrentWidget;
$lstShapeType = $lstCurrentWidget->getType();
?>
<div class="listivo-shape">
    <?php if ($lstShapeType === \Tangibledesign\Listivo\Widgets\General\ShapeWidget::TYPE_LINE_SEPARATOR) : ?>
        <div class="listivo-shape-line">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 913.000000 42.000000"
                 preserveAspectRatio="xMidYMid meet">
                <g transform="translate(0.000000,42.000000) scale(0.100000,-0.100000)" stroke="none">
                    <path d="M7962 404 c-11 -12 -33 -14 -100 -12 -48 1 -240 -1 -427 -5 -187 -4 -506 -10 -710 -13 -354 -5 -415 -7 -603 -19 -185 -11 -867 -23 -1392 -25 -124 -1 -360 -6 -525 -11 -385 -14 -451 -15 -1170 -23 -411 -5 -646 -12 -745 -22 -86 -9 -301 -17 -530 -20 -244 -3 -422 -10 -485 -19 -90 -13 -202 -18 -640 -30 -77 -2 -189 -11 -250 -19 -60 -9 -151 -16 -202 -16 -50 0 -103 -4 -116 -9 -33 -13 -40 -47 -21 -109 l17 -52 193 0 c123 0 194 4 194 10 0 6 14 10 30 10 17 0 30 -4 30 -10 0 -15 107 -13 112 2 5 13 100 18 562 32 115 4 263 11 330 16 67 5 312 14 546 20 234 5 529 14 655 20 234 10 529 16 1255 25 637 8 931 14 1270 25 173 5 506 15 740 21 675 17 689 17 820 28 69 5 217 10 330 11 271 1 727 18 815 30 39 5 254 9 478 10 452 0 580 9 635 46 l32 22 -32 23 c-20 14 -50 24 -77 26 -26 1 -111 7 -191 13 -80 5 -187 10 -238 11 -65 0 -96 5 -106 15 -17 16 -106 19 -106 4 0 -5 -9 -10 -20 -10 -11 0 -20 5 -20 10 0 6 -61 10 -162 10 -133 -1 -165 -4 -176 -16z"></path>
                </g>
            </svg>
        </div>
    <?php elseif ($lstShapeType === \Tangibledesign\Listivo\Widgets\General\ShapeWidget::TYPE_UNDERLINE) : ?>
        <div class="listivo-shape-underline">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 364 9" width="364.0pt" height="9.0pt">
                <path d="M 40.01 0.75 C 76.35 0.99 112.64 1.27 148.98 1.82 C 166.98 1.74 185.00 1.93 203.00 2.01 C 223.22 2.31 243.46 2.02 263.68 2.48 C 281.79 3.26 299.91 2.62 318.00 3.57 C 328.67 3.99 339.34 3.84 349.99 4.48 C 354.44 4.64 358.78 4.44 363.14 5.56 C 362.37 6.72 361.59 7.87 360.78 9.00 L 359.90 9.00 C 351.89 8.35 344.01 8.66 336.00 8.45 C 309.34 7.82 282.66 7.38 256.00 7.01 C 208.01 6.61 159.98 6.66 112.00 5.80 C 92.00 5.77 72.00 5.01 52.00 4.97 C 40.33 4.76 28.66 4.72 17.00 4.30 C 11.09 4.02 5.76 4.73 0.00 2.87 L 0.00 2.65 C 13.13 0.90 26.78 0.94 40.01 0.75 Z"
                      fill="#ffc14a"/>
            </svg>
        </div>
    <?php elseif ($lstShapeType === \Tangibledesign\Listivo\Widgets\General\ShapeWidget::TYPE_WAVE_SEPARATOR) : ?>
        <svg xmlns="http://www.w3.org/2000/svg" width="2311" height="12" viewBox="0 0 2311 12">
            <g>
                <g>
                    <path d="M192.548 5.145c-1.52 2.298-3.979 3.737-6.49 4.62-2.527.86-5.337 1.187-7.974.441-2.619-.682-5.062-2.032-7.1-3.86a17.488 17.488 0 0 1-2.72-3.087l-.212-.315a2.942 2.942 0 0 1-.15-.233c-.095-.123-.185-.457-.283-.112l-.281.566c-.048.143-.27.451-.472.74a14.306 14.306 0 0 1-4.555 4.36 16.014 16.014 0 0 1-6.324 2.166c-2.237.27-4.526.04-6.54-.7-2.009-.74-3.751-1.973-4.803-3.493-1.052 1.52-2.794 2.752-4.802 3.493-2.015.74-4.304.97-6.54.7a16.014 16.014 0 0 1-6.325-2.166 14.308 14.308 0 0 1-4.555-4.36c-.202-.289-.425-.597-.472-.74l-.281-.566c-.098-.345-.188-.011-.284.112-.046.08-.095.158-.149.233l-.211.315a17.484 17.484 0 0 1-2.722 3.088c-2.037 1.827-4.48 3.177-7.1 3.86-2.636.745-5.446.418-7.973-.442-2.511-.883-4.971-2.322-6.49-4.62-.16-.29-.228-.536-.229-.704 0 .168-.07.414-.23.704-1.518 2.298-3.978 3.737-6.49 4.62-2.526.86-5.336 1.187-7.972.441-2.62-.682-5.063-2.032-7.1-3.86a17.483 17.483 0 0 1-2.721-3.087l-.212-.315a2.942 2.942 0 0 1-.15-.233c-.095-.123-.185-.457-.283-.112l-.281.566c-.047.143-.27.451-.472.74a14.308 14.308 0 0 1-4.555 4.36 16.014 16.014 0 0 1-6.324 2.166c-2.237.27-4.526.04-6.54-.7-2.008-.74-3.751-1.973-4.803-3.493-1.052 1.52-2.794 2.752-4.802 3.493-2.015.74-4.304.97-6.54.7a16.014 16.014 0 0 1-6.325-2.166 14.308 14.308 0 0 1-4.554-4.36c-.203-.289-.425-.597-.473-.74l-.281-.566c-.098-.345-.188-.011-.283.112-.046.08-.096.158-.15.233l-.211.315a17.489 17.489 0 0 1-2.721 3.088c-2.038 1.827-4.481 3.177-7.1 3.86-2.637.745-5.447.418-7.973-.442-2.512-.883-4.972-2.322-6.49-4.62C0 4.28.323 3.817.881 4.581c1.395 1.751 3.452 2.916 5.579 3.752 2.14.821 4.483 1.262 6.709 1.027 2.454-.316 4.884-1.329 6.954-2.828a16.947 16.947 0 0 0 2.844-2.606c.215-.242.423-.491.616-.752l.296-.386.338-.495.888-1.428.214-.346c.018-.022.037-.074.053-.07l.045.09.09.178.356.71.578 1.159.14.278.113.166.225.331c.301.44.576.904.954 1.28.682.818 1.485 1.526 2.345 2.14 1.725 1.229 3.717 2.055 5.788 2.47 2.072.416 4.238.39 6.317-.1 2.074-.491 4.075-1.489 5.642-3.019.165-.152.319-.21.412-.197.094-.012.247.045.413.197 1.566 1.53 3.567 2.528 5.64 3.02 2.08.489 4.246.515 6.318.099 2.072-.415 4.063-1.241 5.788-2.47.86-.614 1.664-1.322 2.345-2.14.379-.376.653-.84.954-1.28l.225-.331.113-.166.14-.278.579-1.159.355-.71.09-.179.045-.09c.016-.003.035.05.053.07l.214.347.888 1.428.338.495.296.386c.194.26.401.51.616.752a16.933 16.933 0 0 0 2.844 2.606c2.07 1.5 4.5 2.512 6.955 2.828 2.225.235 4.569-.206 6.708-1.027 2.128-.836 4.184-2 5.579-3.752.37-.506.636-.474.637-.145.001-.33.268-.36.637.145 1.395 1.751 3.452 2.916 5.579 3.752 2.14.821 4.483 1.262 6.709 1.027 2.453-.316 4.884-1.329 6.954-2.828a16.943 16.943 0 0 0 2.844-2.606c.215-.242.423-.491.616-.752l.296-.386.338-.495.888-1.428.214-.346c.018-.022.037-.074.053-.07l.045.09.09.178.355.71.58 1.159.14.278.112.166.225.331c.301.44.575.904.954 1.28.682.818 1.485 1.526 2.345 2.14 1.725 1.229 3.717 2.055 5.788 2.47 2.072.416 4.238.39 6.317-.1 2.074-.491 4.075-1.489 5.641-3.019.166-.152.32-.21.413-.197.093-.012.247.045.413.197 1.566 1.53 3.567 2.528 5.64 3.02 2.08.489 4.246.515 6.318.099 2.071-.415 4.063-1.241 5.788-2.47.86-.614 1.663-1.322 2.345-2.14.378-.376.653-.84.954-1.28l.225-.331.112-.166.14-.278.58-1.159.355-.71.09-.179.045-.09c.016-.003.035.05.053.07l.214.347.888 1.428.338.495.296.386c.193.26.401.51.616.752a16.938 16.938 0 0 0 2.844 2.606c2.07 1.5 4.5 2.512 6.954 2.828 2.226.235 4.57-.206 6.71-1.027 2.126-.836 4.183-2 5.578-3.752.37-.506.636-.474.637-.144.166.02.431.232.66.59 1.616 2.116 4.04 3.391 6.496 4.183 2.478.765 5.147 1.04 7.639.316 2.506-.67 4.852-1.97 6.795-3.738a16.14 16.14 0 0 0 2.573-2.984c.16-.239.506-.784.723-1.172.244-.338.512-1.207.713-.43l.655 1.233c.106.184.231.47.323.57l.29.39c1.065 1.521 2.627 2.843 4.45 3.733 1.823.896 3.869 1.409 5.905 1.568 4.053.318 7.93-.726 10.955-2.506-.174-.264.067-.359.378-.117a1.174 1.174 0 0 1 .07.059c1.566 1.53 3.567 2.528 5.64 3.02 2.08.489 4.246.515 6.318.099 2.071-.415 4.063-1.241 5.788-2.47.86-.614 1.663-1.322 2.344-2.14.38-.376.653-.84.955-1.28l.225-.331.112-.166.14-.278.58-1.159.355-.71.09-.179.045-.09c.016-.003.035.05.053.07l.214.347.888 1.428.338.495.296.386c.193.26.401.51.616.752a16.942 16.942 0 0 0 2.844 2.606c2.07 1.5 4.5 2.512 6.954 2.828 2.226.235 4.57-.206 6.71-1.027 2.126-.836 4.183-2 5.578-3.752.37-.506.636-.474.637-.144.166.02.43.232.66.59 1.616 2.116 4.04 3.391 6.496 4.183 2.478.765 5.147 1.04 7.639.316 2.506-.67 4.852-1.97 6.795-3.738a16.14 16.14 0 0 0 2.573-2.984c.16-.239.505-.784.723-1.172.244-.338.511-1.207.713-.43l.655 1.233c.106.184.23.47.322.57l.29.39c1.066 1.521 2.628 2.843 4.452 3.733 1.822.896 3.868 1.409 5.904 1.568 4.052.318 7.93-.726 10.955-2.506-.174-.264.067-.359.378-.117a1.167 1.167 0 0 1 .07.059c1.565 1.53 3.567 2.528 5.64 3.02 2.08.489 4.246.515 6.318.099 2.071-.415 4.063-1.241 5.788-2.47.86-.614 1.663-1.322 2.344-2.14.38-.376.653-.84.955-1.28l.225-.331.112-.166.14-.278.58-1.159.355-.71.09-.179.045-.09c.016-.003.035.05.052.07l.215.347.888 1.428.338.495.296.386c.193.26.401.51.616.752a16.937 16.937 0 0 0 2.843 2.606c2.07 1.5 4.501 2.512 6.955 2.828 2.225.235 4.57-.206 6.709-1.027 2.127-.836 4.184-2 5.578-3.752.37-.506.637-.474.638-.144.166.02.43.232.66.59 1.616 2.116 4.04 3.391 6.495 4.183 2.479.765 5.148 1.04 7.64.316 2.506-.67 4.852-1.97 6.795-3.738a16.14 16.14 0 0 0 2.572-2.984c.16-.239.506-.784.723-1.172.245-.338.512-1.207.714-.43l.655 1.233c.106.184.23.47.322.57l.29.39c1.066 1.521 2.628 2.843 4.451 3.733 1.823.896 3.869 1.409 5.905 1.568 4.052.318 7.93-.726 10.955-2.505-.175-.265.067-.36.378-.118a1.189 1.189 0 0 1 .07.059c1.565 1.53 3.567 2.528 5.64 3.02 2.08.489 4.246.515 6.318.099 2.071-.415 4.062-1.241 5.788-2.47.86-.614 1.663-1.322 2.344-2.14.379-.376.653-.84.955-1.28l.224-.331.113-.166.14-.278.58-1.159.355-.71.09-.179.045-.09c.016-.003.035.05.052.07l.214.347.889 1.428.338.495.296.386c.193.261.4.51.616.752a16.937 16.937 0 0 0 2.843 2.606c2.07 1.5 4.5 2.512 6.955 2.828 2.225.235 4.57-.206 6.709-1.027 2.127-.836 4.184-2 5.578-3.752.37-.506.636-.474.637-.144.167.02.432.232.66.59 1.617 2.116 4.04 3.391 6.496 4.183 2.479.765 5.148 1.04 7.64.316 2.505-.67 4.852-1.97 6.795-3.738a16.143 16.143 0 0 0 2.572-2.984c.16-.239.506-.784.723-1.172.245-.338.512-1.207.714-.43l.655 1.233c.106.184.23.47.322.57l.29.39c1.066 1.521 2.627 2.843 4.451 3.733 1.823.896 3.868 1.41 5.905 1.568 4.052.318 7.93-.726 10.955-2.506-.175-.264.067-.359.378-.117a1.188 1.188 0 0 1 .07.059c1.565 1.53 3.567 2.528 5.64 3.02 2.08.489 4.245.515 6.318.099 2.07-.415 4.062-1.241 5.788-2.47.86-.614 1.663-1.322 2.344-2.14.379-.376.653-.84.955-1.28l.224-.331.113-.166.14-.278.579-1.159.356-.71.09-.179.044-.09c.017-.003.036.05.053.07l.214.347.888 1.428.338.495.297.386c.193.261.4.51.615.752a16.942 16.942 0 0 0 2.844 2.606c2.07 1.5 4.5 2.512 6.955 2.828 2.225.235 4.57-.206 6.709-1.027 2.127-.836 4.183-2 5.578-3.752.198-.271.367-.388.48-.387.115 0 .283.116.482.387 1.394 1.751 3.45 2.916 5.578 3.752 2.14.821 4.484 1.262 6.71 1.027 2.453-.316 4.883-1.329 6.954-2.828a16.943 16.943 0 0 0 2.843-2.606c.215-.242.423-.491.616-.752l.296-.386.338-.495.889-1.428.214-.346c.017-.022.036-.074.052-.07l.045.09.09.179.356.71.579 1.158.14.278.112.166.225.331c.302.44.576.904.955 1.28.681.819 1.485 1.526 2.344 2.14 1.726 1.229 3.717 2.055 5.788 2.47 2.073.416 4.238.39 6.318-.1 2.073-.491 4.075-1.489 5.64-3.019a1.166 1.166 0 0 1 .07-.059c.311-.242.552-.147.378.117 3.025 1.78 6.903 2.824 10.955 2.506 2.036-.159 4.082-.672 5.904-1.568 1.824-.89 3.386-2.212 4.451-3.733l.29-.39c.092-.1.217-.386.323-.57l.655-1.234c.202-.776.47.093.713.431.218.388.563.933.724 1.172a16.143 16.143 0 0 0 2.572 2.984c1.943 1.768 4.29 3.069 6.795 3.738 2.492.725 5.161.449 7.64-.316 2.456-.792 4.879-2.067 6.495-4.184.23-.357.494-.57.66-.59.001-.329.268-.36.637.145 1.395 1.751 3.452 2.916 5.579 3.752 2.14.821 4.483 1.262 6.709 1.027 2.454-.316 4.884-1.329 6.954-2.828a16.937 16.937 0 0 0 2.844-2.606c.215-.242.423-.491.616-.752l.296-.386.338-.495.888-1.428.215-.346c.017-.022.036-.074.052-.07l.045.09.09.179.356.71.579 1.158.14.278.112.166.225.331c.302.44.576.904.955 1.28.68.818 1.484 1.526 2.344 2.14 1.725 1.229 3.717 2.055 5.788 2.47 2.072.416 4.238.39 6.318-.1 2.073-.491 4.074-1.489 5.64-3.019a1.174 1.174 0 0 1 .07-.059c.311-.242.552-.147.378.118 3.025 1.779 6.903 2.823 10.955 2.505 2.036-.159 4.082-.672 5.904-1.568 1.824-.89 3.386-2.212 4.451-3.733l.29-.39c.092-.1.217-.386.323-.57l.655-1.234c.202-.776.47.093.713.431.217.388.563.933.723 1.172a16.14 16.14 0 0 0 2.573 2.984c1.943 1.768 4.29 3.069 6.795 3.738 2.492.725 5.161.449 7.64-.316 2.455-.792 4.879-2.067 6.495-4.184.23-.357.494-.57.66-.59.001-.329.268-.36.637.145 1.395 1.751 3.452 2.916 5.579 3.752 2.14.821 4.483 1.262 6.709 1.027 2.454-.316 4.884-1.329 6.954-2.828a16.937 16.937 0 0 0 2.844-2.606c.215-.242.423-.491.616-.752l.296-.386.338-.495.888-1.428.214-.346c.018-.022.037-.074.053-.07l.045.09.09.178.356.71.578 1.159.14.278.113.166.225.331c.302.44.576.904.954 1.28.682.818 1.485 1.526 2.345 2.14 1.725 1.229 3.717 2.055 5.788 2.47 2.072.416 4.238.39 6.317-.1 2.074-.491 4.075-1.489 5.642-3.019a1.178 1.178 0 0 1 .07-.059c.31-.242.551-.147.377.117 3.025 1.78 6.902 2.824 10.955 2.506 2.036-.159 4.081-.672 5.904-1.568 1.824-.89 3.386-2.212 4.451-3.733l.29-.39c.092-.1.217-.386.322-.57l.656-1.234c.201-.776.469.093.713.431.217.388.563.933.723 1.172a16.14 16.14 0 0 0 2.573 2.984c1.943 1.768 4.29 3.069 6.795 3.738 2.492.725 5.16.449 7.64-.316 2.455-.792 4.879-2.067 6.495-4.184.229-.357.494-.57.66-.59.001-.329.268-.36.637.145 1.395 1.751 3.451 2.916 5.579 3.752 2.14.821 4.483 1.262 6.709 1.027 2.454-.316 4.884-1.329 6.954-2.828a16.933 16.933 0 0 0 2.844-2.606c.215-.242.423-.491.616-.752l.296-.386.338-.495.888-1.428.214-.346c.018-.022.037-.074.053-.07l.045.09.09.178.355.71.58 1.159.14.278.112.166.225.331c.301.44.576.904.954 1.28.682.818 1.485 1.526 2.345 2.14 1.725 1.229 3.716 2.055 5.788 2.47 2.072.416 4.238.39 6.317-.1 2.074-.491 4.075-1.489 5.641-3.019a1.173 1.173 0 0 1 .07-.059c.31-.242.552-.147.377.117 3.025 1.78 6.903 2.824 10.956 2.506 2.036-.159 4.081-.672 5.904-1.568 1.824-.89 3.386-2.212 4.451-3.733l.29-.39c.092-.1.217-.386.322-.57l.656-1.234c.201-.776.469.093.713.431.217.388.563.933.723 1.172a16.14 16.14 0 0 0 2.573 2.984c1.943 1.768 4.289 3.069 6.795 3.738 2.492.725 5.16.449 7.64-.316 2.455-.792 4.878-2.067 6.495-4.184.229-.357.494-.57.66-.59 0-.329.268-.36.637.145 1.395 1.751 3.451 2.916 5.579 3.752 2.139.821 4.483 1.262 6.709 1.027 2.453-.316 4.884-1.329 6.954-2.828a16.938 16.938 0 0 0 2.844-2.606c.215-.242.422-.491.616-.752l.296-.386.338-.495.888-1.428.214-.346c.018-.022.036-.074.053-.07l.045.09.09.178.355.71.58 1.159.14.278.112.166.225.331c.301.44.575.904.954 1.28.682.818 1.485 1.526 2.345 2.14 1.725 1.229 3.716 2.055 5.788 2.47 2.072.416 4.238.39 6.317-.1 2.074-.491 4.075-1.489 5.641-3.019.166-.152.32-.21.413-.196.093-.013.247.044.412.196 1.567 1.53 3.568 2.528 5.642 3.02 2.079.489 4.245.515 6.317.099 2.071-.415 4.063-1.241 5.788-2.47.86-.614 1.663-1.322 2.344-2.14.38-.376.653-.84.955-1.28l.225-.331.112-.166.14-.278.58-1.159.355-.71.09-.179.045-.09c.016-.003.035.05.053.07l.214.347.888 1.428.338.495.296.386c.193.26.401.51.616.752a16.938 16.938 0 0 0 2.844 2.606c2.07 1.5 4.5 2.512 6.954 2.828 2.226.235 4.57-.206 6.71-1.027 2.126-.836 4.183-2 5.578-3.752.369-.506.636-.474.637-.145.001-.33.268-.36.637.145 1.395 1.751 3.451 2.916 5.578 3.752 2.14.821 4.484 1.262 6.71 1.027 2.453-.316 4.883-1.329 6.954-2.828a16.933 16.933 0 0 0 2.844-2.606c.214-.242.422-.491.616-.752l.296-.386.337-.495.889-1.428.214-.346c.017-.022.036-.074.052-.07l.046.09.09.178.355.71.579 1.159.14.278.113.166.224.331c.302.44.576.904.955 1.28.681.818 1.485 1.526 2.345 2.14 1.725 1.229 3.716 2.055 5.787 2.47 2.073.416 4.239.39 6.318-.1 2.073-.491 4.075-1.489 5.641-3.019.166-.152.32-.21.413-.197.093-.012.247.045.412.197 1.566 1.53 3.568 2.528 5.641 3.02 2.08.489 4.246.515 6.318.099 2.071-.415 4.063-1.241 5.788-2.47.86-.614 1.663-1.322 2.344-2.14.38-.376.653-.84.955-1.28l.225-.331.112-.166.14-.278.58-1.159.355-.71.09-.179.045-.09c.016-.003.035.05.052.07l.215.347.888 1.428.338.495.296.386c.193.26.4.51.616.752a16.946 16.946 0 0 0 2.843 2.606c2.07 1.5 4.501 2.512 6.955 2.828 2.225.235 4.57-.206 6.709-1.027 2.127-.836 4.184-2 5.578-3.752.045-.061.088-.114.129-.16.005-.187.1-.271.254-.204.153-.067.249.017.254.205.041.045.084.098.129.159 1.394 1.751 3.45 2.916 5.578 3.752 2.14.821 4.483 1.262 6.709 1.027 2.454-.316 4.884-1.329 6.954-2.828a16.947 16.947 0 0 0 2.844-2.606c.215-.242.423-.491.616-.752l.296-.386.338-.495.888-1.428.215-.346c.017-.022.036-.074.052-.07l.045.09.09.178.356.71.579 1.159.14.278.112.166.225.331c.302.44.576.904.955 1.28.681.818 1.485 1.526 2.344 2.14 1.725 1.229 3.717 2.055 5.788 2.47 2.072.416 4.238.39 6.318-.1 2.073-.491 4.075-1.489 5.64-3.02.166-.15.32-.208.413-.196.094-.012.247.045.413.197 1.566 1.53 3.567 2.528 5.641 3.02 2.08.489 4.245.515 6.318.099 2.07-.415 4.062-1.241 5.787-2.47.86-.614 1.664-1.322 2.345-2.14.379-.376.653-.84.955-1.28l.224-.331.113-.166.14-.278.579-1.159.356-.71.09-.179.045-.09c.016-.003.035.05.052.07l.214.347.889 1.428.337.495.296.386c.194.26.402.51.616.752a16.933 16.933 0 0 0 2.844 2.606c2.07 1.5 4.5 2.512 6.955 2.828 2.225.235 4.57-.206 6.709-1.027 2.127-.836 4.183-2 5.578-3.752.559-.764.882-.3.408.564-1.519 2.298-3.979 3.737-6.49 4.62-2.527.86-5.337 1.187-7.973.441-2.62-.682-5.063-2.032-7.1-3.86a17.488 17.488 0 0 1-2.721-3.087l-.212-.315a2.942 2.942 0 0 1-.15-.233c-.094-.123-.184-.457-.282-.112l-.282.566c-.047.143-.27.451-.472.74a14.306 14.306 0 0 1-4.555 4.36 16.014 16.014 0 0 1-6.324 2.166c-2.236.27-4.526.04-6.54-.7-2.008-.74-3.75-1.973-4.803-3.493-1.052 1.52-2.794 2.752-4.802 3.493-2.015.74-4.304.97-6.54.7a16.014 16.014 0 0 1-6.324-2.166 14.308 14.308 0 0 1-4.555-4.36c-.203-.289-.425-.597-.472-.74l-.282-.566c-.098-.345-.188-.011-.283.112-.046.08-.095.158-.15.233l-.211.315a17.484 17.484 0 0 1-2.721 3.088c-2.038 1.827-4.481 3.177-7.1 3.86-2.636.745-5.447.418-7.973-.442-2.498-.878-4.944-2.306-6.465-4.582-1.52 2.276-3.967 3.704-6.465 4.582-2.526.86-5.337 1.187-7.973.441-2.619-.682-5.062-2.032-7.1-3.86a17.484 17.484 0 0 1-2.721-3.087l-.212-.315a2.942 2.942 0 0 1-.149-.233c-.095-.123-.185-.457-.283-.112l-.282.566c-.047.143-.27.451-.472.74a14.308 14.308 0 0 1-4.555 4.36 16.014 16.014 0 0 1-6.324 2.166c-2.236.27-4.525.04-6.54-.7-2.008-.74-3.75-1.973-4.802-3.493-1.052 1.52-2.795 2.752-4.803 3.493-2.014.74-4.304.97-6.54.7a16.014 16.014 0 0 1-6.324-2.166 14.306 14.306 0 0 1-4.555-4.36c-.202-.289-.425-.597-.472-.74l-.282-.566c-.097-.345-.188-.011-.283.112-.046.08-.095.158-.15.233l-.21.315a17.483 17.483 0 0 1-2.722 3.088c-2.037 1.827-4.48 3.177-7.1 3.86-2.636.745-5.446.418-7.973-.442-2.511-.883-4.971-2.322-6.49-4.62-.16-.29-.229-.536-.23-.704 0 .168-.07.413-.228.704-1.52 2.298-3.979 3.737-6.49 4.62-2.527.86-5.338 1.187-7.974.441-2.619-.682-5.062-2.032-7.1-3.86a17.484 17.484 0 0 1-2.72-3.087l-.212-.315a2.974 2.974 0 0 1-.15-.233c-.095-.123-.185-.457-.283-.112l-.281.566c-.048.143-.27.451-.472.74a14.308 14.308 0 0 1-4.555 4.36 16.015 16.015 0 0 1-6.324 2.166c-2.237.27-4.526.04-6.54-.7-2.009-.74-3.751-1.973-4.803-3.493-1.052 1.52-2.795 2.752-4.802 3.493-2.015.74-4.305.97-6.54.7a16.014 16.014 0 0 1-6.325-2.166 14.307 14.307 0 0 1-4.555-4.36c-.202-.289-.425-.597-.472-.74l-.281-.566c-.098-.345-.188-.011-.284.112-.046.08-.095.158-.149.233l-.211.315a17.493 17.493 0 0 1-2.722 3.088c-2.037 1.827-4.48 3.177-7.1 3.86-2.636.745-5.446.418-7.973-.442-2.511-.883-4.971-2.322-6.49-4.62a2.487 2.487 0 0 1-.12-.25 2.52 2.52 0 0 1-.118.29c-1.257 2.358-3.541 3.86-5.869 4.815-2.361.943-4.945 1.35-7.519 1.002-2.763-.443-5.346-1.61-7.56-3.302a17.772 17.772 0 0 1-2.987-2.916c-.222-.27-.436-.546-.634-.836l-.303-.428-.219-.353c-.11-.144-.204-.62-.372-.153l-.2.339-.057.093-.132.175-.263.348c-.354.46-.683.94-1.112 1.32-.785.833-1.686 1.523-2.627 2.107-1.892 1.166-3.986 1.871-6.112 2.196-4.236.602-8.765-.212-12.352-3.048a1.287 1.287 0 0 1-.067-.054c-1.065 1.404-2.724 2.542-4.62 3.24-2.015.742-4.304.97-6.54.701a16.014 16.014 0 0 1-6.325-2.166 14.308 14.308 0 0 1-4.555-4.36c-.202-.289-.424-.597-.472-.74l-.281-.566c-.098-.345-.188-.011-.283.112-.046.08-.096.158-.15.233l-.211.315a17.483 17.483 0 0 1-2.721 3.088c-2.038 1.827-4.481 3.177-7.1 3.859-2.637.746-5.447.419-7.974-.44-2.511-.884-4.97-2.323-6.49-4.621a2.484 2.484 0 0 1-.12-.25c-.027.084-.066.18-.118.29-1.256 2.358-3.541 3.86-5.869 4.815-2.361.943-4.945 1.35-7.518 1.002-2.764-.443-5.347-1.61-7.56-3.302a17.771 17.771 0 0 1-2.988-2.916c-.222-.27-.436-.546-.634-.836l-.303-.428-.219-.353c-.11-.144-.203-.62-.371-.153l-.201.339-.057.093-.132.175-.263.348c-.354.46-.682.94-1.112 1.32-.785.833-1.685 1.523-2.627 2.107-1.891 1.166-3.985 1.871-6.112 2.196-4.236.602-8.765-.212-12.352-3.048a1.285 1.285 0 0 1-.067-.054c-1.065 1.404-2.724 2.542-4.62 3.24-2.015.742-4.304.97-6.54.701a16.016 16.016 0 0 1-6.325-2.166 14.31 14.31 0 0 1-4.554-4.36c-.203-.289-.425-.597-.473-.74l-.281-.566c-.098-.345-.188-.011-.283.112-.046.08-.096.158-.15.233l-.211.315a17.488 17.488 0 0 1-2.721 3.088c-2.038 1.827-4.48 3.177-7.1 3.859-2.636.746-5.447.419-7.973-.44-2.512-.884-4.972-2.323-6.49-4.621a2.484 2.484 0 0 1-.12-.25c-.028.084-.067.18-.119.29-1.256 2.358-3.54 3.86-5.869 4.815-2.361.943-4.945 1.35-7.518 1.002-2.764-.443-5.347-1.61-7.56-3.302a17.78 17.78 0 0 1-2.988-2.916c-.222-.27-.436-.546-.634-.836l-.302-.428-.22-.353c-.11-.144-.203-.62-.372-.153l-.2.339-.057.093-.132.175-.263.348c-.354.46-.682.94-1.112 1.32-.785.833-1.685 1.523-2.627 2.107-1.891 1.166-3.985 1.871-6.112 2.196-4.236.602-8.765-.212-12.352-3.048a1.278 1.278 0 0 1-.067-.054c-1.065 1.404-2.724 2.542-4.62 3.24-2.015.742-4.304.97-6.54.701a16.016 16.016 0 0 1-6.324-2.166 14.308 14.308 0 0 1-4.555-4.36c-.203-.289-.425-.597-.472-.74l-.282-.566c-.098-.345-.188-.011-.283.112a2.97 2.97 0 0 1-.15.233l-.211.315a17.488 17.488 0 0 1-2.721 3.088c-2.038 1.827-4.48 3.177-7.1 3.859-2.636.746-5.447.419-7.973-.44-2.512-.884-4.971-2.323-6.49-4.621a2.486 2.486 0 0 1-.12-.25c-.028.084-.067.18-.119.29-1.256 2.358-3.54 3.86-5.868 4.815-2.362.943-4.945 1.35-7.52 1.002-2.763-.443-5.346-1.61-7.559-3.302a17.776 17.776 0 0 1-2.988-2.916c-.222-.27-.436-.546-.634-.836l-.302-.428-.22-.353c-.11-.144-.203-.62-.371-.153l-.201.339-.057.093-.131.175-.264.348c-.354.46-.682.94-1.112 1.32-.785.833-1.685 1.523-2.627 2.107-1.891 1.166-3.985 1.871-6.112 2.196-4.236.602-8.765-.212-12.352-3.048a1.28 1.28 0 0 1-.067-.054c-1.065 1.404-2.724 2.542-4.62 3.24-2.015.742-4.304.97-6.54.701a16.014 16.014 0 0 1-6.324-2.166 14.307 14.307 0 0 1-4.555-4.36c-.202-.289-.425-.597-.472-.74L603 2.599c-.098-.345-.188-.011-.283.112-.046.08-.095.157-.15.233l-.21.315a17.478 17.478 0 0 1-2.722 3.088c-2.037 1.827-4.48 3.177-7.1 3.859-2.636.746-5.446.419-7.973-.44-2.511-.884-4.971-2.323-6.49-4.621a2.663 2.663 0 0 1-.073-.142 2.657 2.657 0 0 1-.073.142c-1.519 2.298-3.978 3.737-6.49 4.62-2.527.86-5.337 1.187-7.973.441-2.62-.682-5.063-2.032-7.1-3.86a17.478 17.478 0 0 1-2.721-3.087l-.212-.315a3.008 3.008 0 0 1-.15-.233c-.094-.123-.184-.457-.282-.112l-.282.566c-.047.143-.27.451-.472.74a14.307 14.307 0 0 1-4.555 4.36 16.015 16.015 0 0 1-6.324 2.166c-2.236.27-4.525.04-6.54-.7-1.896-.7-3.555-1.837-4.62-3.241a1.28 1.28 0 0 1-.067.054c-3.587 2.836-8.116 3.65-12.352 3.048-2.127-.325-4.22-1.03-6.112-2.196-.942-.584-1.842-1.274-2.627-2.107-.43-.38-.758-.86-1.112-1.32l-.263-.348-.132-.175-.057-.093-.2-.34c-.169-.466-.262.01-.372.154l-.22.353-.302.428c-.198.29-.412.566-.634.836a17.776 17.776 0 0 1-2.988 2.916c-2.213 1.691-4.796 2.86-7.56 3.302-2.573.347-5.157-.059-7.519-1.002-2.327-.955-4.612-2.457-5.868-4.816a2.518 2.518 0 0 1-.118-.289 2.486 2.486 0 0 1-.12.25c-1.52 2.298-3.98 3.737-6.49 4.62-2.527.86-5.338 1.187-7.974.441-2.62-.682-5.062-2.032-7.1-3.86a17.492 17.492 0 0 1-2.72-3.087l-.213-.315a2.973 2.973 0 0 1-.149-.233c-.095-.123-.185-.457-.283-.112l-.281.566c-.048.143-.27.451-.473.74a14.307 14.307 0 0 1-4.555 4.36 16.016 16.016 0 0 1-6.324 2.166c-2.236.27-4.525.04-6.54-.7-1.896-.7-3.555-1.837-4.62-3.241a1.28 1.28 0 0 1-.067.054c-3.587 2.836-8.116 3.65-12.352 3.048-2.127-.325-4.22-1.03-6.112-2.196-.942-.584-1.842-1.274-2.627-2.107-.43-.38-.758-.86-1.112-1.32l-.263-.348-.132-.175-.057-.093-.2-.34c-.168-.466-.262.01-.372.154l-.22.353-.302.428c-.198.29-.412.566-.634.836a17.776 17.776 0 0 1-2.988 2.916c-2.213 1.691-4.796 2.86-7.56 3.302-2.573.347-5.157-.059-7.518-1.002-2.328-.955-4.613-2.457-5.869-4.816a2.518 2.518 0 0 1-.118-.289 2.488 2.488 0 0 1-.12.25c-1.52 2.298-3.979 3.737-6.49 4.62-2.527.86-5.337 1.187-7.974.441-2.619-.682-5.062-2.032-7.1-3.86a17.488 17.488 0 0 1-2.72-3.087l-.212-.315a2.974 2.974 0 0 1-.15-.233c-.095-.123-.185-.457-.283-.112l-.281.566c-.048.143-.27.451-.472.74A14.31 14.31 0 0 1 355 8.265a16.016 16.016 0 0 1-6.324 2.166c-2.237.27-4.526.04-6.541-.7-1.896-.7-3.555-1.837-4.62-3.241a1.28 1.28 0 0 1-.067.054c-3.587 2.836-8.116 3.65-12.352 3.048-2.127-.325-4.22-1.03-6.112-2.196-.942-.584-1.842-1.274-2.627-2.107-.43-.38-.758-.86-1.112-1.32l-.263-.348-.132-.175-.057-.093-.2-.34c-.168-.466-.262.01-.372.154l-.22.353-.302.428c-.198.29-.412.566-.634.836a17.775 17.775 0 0 1-2.988 2.916c-2.213 1.691-4.796 2.86-7.56 3.302-2.573.348-5.157-.059-7.518-1.002-2.328-.955-4.613-2.457-5.869-4.816a2.516 2.516 0 0 1-.118-.288 2.486 2.486 0 0 1-.12.249c-1.519 2.298-3.979 3.737-6.49 4.62-2.527.86-5.337 1.187-7.974.441-2.619-.682-5.062-2.032-7.1-3.86a17.483 17.483 0 0 1-2.72-3.087l-.212-.315a2.974 2.974 0 0 1-.15-.233c-.095-.123-.185-.457-.283-.112l-.281.566c-.047.143-.27.451-.472.74a14.31 14.31 0 0 1-4.555 4.36 16.015 16.015 0 0 1-6.324 2.166c-2.237.27-4.526.04-6.54-.7-1.896-.7-3.556-1.837-4.62-3.241a1.28 1.28 0 0 1-.067.054c-3.588 2.836-8.117 3.65-12.353 3.048-2.126-.325-4.22-1.03-6.112-2.196-.941-.584-1.842-1.274-2.627-2.107-.43-.38-.758-.86-1.111-1.32l-.264-.348-.132-.175-.056-.093-.201-.34c-.168-.466-.261.01-.372.154l-.22.353-.302.428c-.198.29-.412.566-.634.836a17.776 17.776 0 0 1-2.988 2.916c-2.213 1.691-4.796 2.86-7.56 3.302-2.573.348-5.157-.059-7.518-1.002-2.328-.955-4.612-2.457-5.868-4.816a2.518 2.518 0 0 1-.119-.289 2.488 2.488 0 0 1-.12.25zm1926.312-.564c1.395 1.751 3.451 2.916 5.579 3.752 2.14.821 4.483 1.262 6.709 1.027 2.454-.316 4.884-1.329 6.954-2.828a16.938 16.938 0 0 0 2.844-2.606c.215-.242.422-.491.616-.752l.296-.386.338-.495.888-1.428.214-.346c.018-.022.037-.074.053-.07l.045.09.09.178.355.71.58 1.159.14.278.112.166.225.331c.301.44.575.904.954 1.28.682.818 1.485 1.526 2.345 2.14 1.725 1.229 3.716 2.055 5.788 2.47 2.072.416 4.238.39 6.317-.1 2.074-.491 4.075-1.489 5.641-3.019.166-.152.32-.21.413-.197.093-.012.247.045.412.197 1.567 1.53 3.568 2.528 5.642 3.02 2.079.489 4.245.515 6.317.099 2.071-.415 4.063-1.241 5.788-2.47.86-.614 1.663-1.322 2.345-2.14.379-.376.653-.84.954-1.28l.225-.331.112-.166.14-.278.58-1.159.355-.71.09-.179.045-.09c.016-.003.035.05.053.07l.214.347.888 1.428.338.495.296.386c.193.26.401.51.616.752a16.942 16.942 0 0 0 2.844 2.606c2.07 1.5 4.5 2.512 6.954 2.828 2.226.235 4.57-.206 6.71-1.027 2.126-.836 4.183-2 5.578-3.752.369-.506.636-.474.637-.145.001-.33.268-.36.637.145 1.395 1.751 3.451 2.916 5.578 3.752 2.14.821 4.484 1.262 6.71 1.027 2.453-.316 4.884-1.329 6.954-2.828a16.938 16.938 0 0 0 2.844-2.606c.214-.242.422-.491.616-.752l.296-.386.337-.495.889-1.428.214-.346c.017-.022.036-.074.053-.07l.045.09.09.178.355.71.579 1.159.14.278.113.166.224.331c.302.44.576.904.955 1.28.681.818 1.485 1.526 2.345 2.14 1.725 1.229 3.716 2.055 5.787 2.47 2.073.416 4.239.39 6.318-.1 2.074-.491 4.075-1.489 5.641-3.019.166-.152.32-.21.413-.197.093-.012.247.045.412.197 1.567 1.53 3.568 2.528 5.641 3.02 2.08.489 4.246.515 6.318.099 2.071-.415 4.063-1.241 5.788-2.47.86-.614 1.663-1.322 2.344-2.14.38-.376.653-.84.955-1.28l.225-.331.112-.166.14-.278.58-1.159.355-.71.09-.179.045-.09c.016-.003.035.05.052.07l.215.347.888 1.428.338.495.296.386c.193.26.401.51.616.752a16.943 16.943 0 0 0 2.844 2.606c2.07 1.5 4.5 2.512 6.954 2.828 2.226.235 4.57-.206 6.71-1.027 2.126-.836 4.183-2 5.577-3.752.56-.764.883-.3.409.564-1.52 2.298-3.98 3.737-6.49 4.62-2.527.86-5.338 1.187-7.974.441-2.619-.682-5.062-2.032-7.1-3.86a17.488 17.488 0 0 1-2.72-3.087l-.212-.315a2.942 2.942 0 0 1-.15-.233c-.095-.123-.185-.457-.283-.112l-.281.566c-.048.143-.27.451-.473.74a14.308 14.308 0 0 1-4.554 4.36 16.014 16.014 0 0 1-6.325 2.166c-2.236.27-4.525.04-6.54-.7-2.008-.74-3.75-1.973-4.802-3.493-1.052 1.52-2.795 2.752-4.802 3.493-2.015.74-4.305.97-6.54.7a16.014 16.014 0 0 1-6.325-2.166 14.308 14.308 0 0 1-4.555-4.36c-.202-.289-.425-.597-.472-.74l-.282-.566c-.097-.345-.188-.011-.283.112-.046.08-.095.158-.15.233l-.21.315a17.483 17.483 0 0 1-2.722 3.088c-2.037 1.827-4.48 3.177-7.1 3.86-2.636.745-5.446.418-7.973-.442-2.511-.883-4.971-2.322-6.49-4.62-.16-.29-.229-.536-.23-.704 0 .168-.07.413-.228.704-1.52 2.298-3.979 3.737-6.49 4.62-2.527.86-5.337 1.187-7.974.441-2.619-.682-5.062-2.032-7.1-3.86a17.484 17.484 0 0 1-2.72-3.087l-.212-.315a2.942 2.942 0 0 1-.15-.233c-.095-.123-.185-.457-.283-.112l-.281.566c-.048.143-.27.451-.472.74a14.308 14.308 0 0 1-4.555 4.36 16.014 16.014 0 0 1-6.324 2.166c-2.237.27-4.526.04-6.54-.7-2.009-.74-3.751-1.973-4.803-3.493-1.052 1.52-2.794 2.752-4.802 3.493-2.015.74-4.304.97-6.54.7a16.014 16.014 0 0 1-6.325-2.166 14.306 14.306 0 0 1-4.555-4.36c-.202-.289-.425-.597-.472-.74l-.281-.566c-.098-.345-.188-.011-.283.112-.047.08-.096.158-.15.233l-.211.315a17.483 17.483 0 0 1-2.722 3.088c-2.037 1.827-4.48 3.177-7.1 3.86-2.636.745-5.446.418-7.973-.442-2.511-.883-4.971-2.322-6.49-4.62a2.483 2.483 0 0 1-.12-.25c-.028.084-.066.18-.118.29-1.256 2.358-3.541 3.86-5.869 4.815-2.361.943-4.945 1.35-7.519 1.002-2.763-.443-5.346-1.61-7.56-3.302a17.776 17.776 0 0 1-2.987-2.916c-.222-.27-.436-.546-.634-.836l-.303-.428-.219-.353c-.11-.144-.204-.62-.372-.153l-.2.339-.057.093-.132.175-.263.348c-.354.46-.682.94-1.112 1.32-.785.833-1.685 1.523-2.627 2.107-1.891 1.166-3.986 1.871-6.112 2.196-4.236.602-8.765-.212-12.352-3.048a1.28 1.28 0 0 1-.067-.054c-1.065 1.404-2.724 2.542-4.62 3.24-2.015.742-4.304.97-6.54.701a16.015 16.015 0 0 1-6.325-2.166 14.31 14.31 0 0 1-4.555-4.36c-.202-.289-.424-.597-.472-.74l-.281-.566c-.098-.345-.188-.011-.283.112-.046.08-.096.158-.15.233l-.211.315a17.483 17.483 0 0 1-2.721 3.088c-2.038 1.827-4.481 3.177-7.1 3.86-2.637.745-5.447.418-7.973-.442-2.512-.883-4.972-2.322-6.49-4.62a2.487 2.487 0 0 1-.12-.25c-.028.084-.067.18-.12.29-1.255 2.358-3.54 3.86-5.868 4.815-2.361.943-4.945 1.35-7.518 1.002-2.764-.443-5.347-1.61-7.56-3.302a17.775 17.775 0 0 1-2.988-2.916 11.71 11.71 0 0 1-.634-.836l-.302-.428-.22-.353c-.11-.144-.203-.62-.371-.153l-.201.339-.057.093-.132.175-.263.348c-.354.46-.682.94-1.112 1.32-.785.833-1.685 1.523-2.627 2.107-1.891 1.166-3.985 1.871-6.112 2.196-4.236.602-8.765-.212-12.352-3.048a1.28 1.28 0 0 1-.067-.054c-1.065 1.404-2.724 2.542-4.62 3.24-2.015.742-4.304.97-6.54.701A16.016 16.016 0 0 1 1956 8.265a14.308 14.308 0 0 1-4.555-4.36c-.203-.289-.425-.597-.472-.74l-.282-.566c-.098-.345-.188-.011-.283.112-.046.08-.095.158-.15.233l-.211.315a17.488 17.488 0 0 1-2.721 3.088c-2.038 1.827-4.48 3.177-7.1 3.859-2.636.746-5.447.419-7.973-.44-2.512-.884-4.972-2.323-6.49-4.621a2.487 2.487 0 0 1-.12-.25c-.028.084-.067.18-.119.29-1.256 2.358-3.54 3.86-5.869 4.815-2.361.943-4.945 1.35-7.518 1.002-2.764-.443-5.347-1.61-7.56-3.302a17.776 17.776 0 0 1-2.988-2.916c-.222-.27-.436-.546-.634-.836l-.302-.428-.22-.353c-.11-.144-.203-.62-.372-.153l-.2.339-.057.093-.131.175-.264.348c-.354.46-.682.94-1.112 1.32-.785.833-1.685 1.523-2.627 2.107-1.891 1.166-3.985 1.871-6.112 2.196-4.236.602-8.765-.212-12.352-3.048a1.28 1.28 0 0 1-.067-.054c-1.065 1.404-2.724 2.542-4.62 3.24-2.015.742-4.304.97-6.54.701a16.016 16.016 0 0 1-6.324-2.166 14.308 14.308 0 0 1-4.555-4.36c-.202-.289-.425-.597-.472-.74l-.282-.566c-.098-.345-.188-.011-.283.112a2.97 2.97 0 0 1-.15.233l-.21.315a17.492 17.492 0 0 1-2.722 3.088c-2.038 1.827-4.48 3.177-7.1 3.859-2.636.746-5.446.419-7.973-.44-2.512-.884-4.971-2.323-6.49-4.621a2.488 2.488 0 0 1-.12-.25c-.028.084-.067.18-.119.29-1.256 2.358-3.54 3.86-5.868 4.815-2.362.943-4.945 1.35-7.52 1.002-2.763-.443-5.346-1.61-7.559-3.302a17.776 17.776 0 0 1-2.988-2.916c-.222-.27-.436-.546-.634-.836l-.302-.428-.22-.353c-.11-.144-.203-.62-.371-.153l-.2.339-.058.093-.131.175-.264.348c-.354.46-.682.94-1.112 1.32-.785.833-1.685 1.523-2.627 2.107-1.891 1.166-3.985 1.871-6.112 2.196-4.236.602-8.765-.212-12.352-3.048a1.278 1.278 0 0 1-.067-.054c-1.065 1.404-2.724 2.542-4.62 3.24-2.015.742-4.304.97-6.54.701a16.015 16.015 0 0 1-6.324-2.166 14.307 14.307 0 0 1-4.555-4.36c-.202-.289-.425-.597-.472-.74l-.282-.566c-.098-.345-.188-.011-.283.112-.046.08-.095.158-.15.233l-.21.315a17.483 17.483 0 0 1-2.722 3.088c-2.037 1.827-4.48 3.177-7.1 3.859-2.636.746-5.446.419-7.973-.44-2.511-.884-4.971-2.323-6.49-4.621a2.657 2.657 0 0 1-.073-.142 2.657 2.657 0 0 1-.073.142c-1.519 2.298-3.978 3.737-6.49 4.62-2.526.86-5.337 1.187-7.973.441-2.62-.682-5.062-2.032-7.1-3.86a17.478 17.478 0 0 1-2.72-3.087l-.213-.315a3.008 3.008 0 0 1-.15-.233c-.094-.123-.184-.457-.282-.112l-.282.566c-.047.143-.27.451-.472.74a14.306 14.306 0 0 1-4.555 4.36 16.014 16.014 0 0 1-6.324 2.166c-2.236.27-4.525.04-6.54-.7-1.896-.7-3.555-1.837-4.62-3.241a1.28 1.28 0 0 1-.067.054c-3.587 2.836-8.116 3.65-12.352 3.048-2.127-.325-4.22-1.03-6.112-2.196-.942-.584-1.842-1.274-2.627-2.107-.43-.38-.758-.86-1.112-1.32l-.263-.348-.132-.175-.057-.093-.2-.34c-.169-.466-.262.01-.372.154l-.22.353-.302.428c-.198.29-.412.566-.634.836a17.776 17.776 0 0 1-2.988 2.916c-2.213 1.691-4.796 2.86-7.56 3.302-2.573.347-5.157-.059-7.518-1.002-2.328-.955-4.613-2.457-5.869-4.816a2.515 2.515 0 0 1-.118-.289 2.488 2.488 0 0 1-.12.25c-1.52 2.298-3.979 3.737-6.49 4.62-2.527.86-5.338 1.187-7.974.441-2.62-.682-5.062-2.032-7.1-3.86a17.493 17.493 0 0 1-2.72-3.087l-.212-.315a2.974 2.974 0 0 1-.15-.233c-.095-.123-.185-.457-.283-.112l-.281.566c-.048.143-.27.451-.473.74a14.308 14.308 0 0 1-4.555 4.36 16.015 16.015 0 0 1-6.324 2.166c-2.236.27-4.525.04-6.54-.7-1.896-.7-3.555-1.837-4.62-3.241-.02.018-.043.036-.067.054-3.587 2.836-8.116 3.65-12.352 3.048-2.127-.325-4.22-1.03-6.112-2.196-.942-.584-1.842-1.274-2.627-2.107-.43-.38-.758-.86-1.112-1.32l-.263-.348-.132-.175-.057-.093-.2-.34c-.168-.466-.262.01-.372.154l-.22.353-.302.428c-.198.29-.412.566-.634.836a17.78 17.78 0 0 1-2.988 2.916c-2.213 1.691-4.796 2.86-7.56 3.302-2.573.347-5.157-.059-7.518-1.002-2.328-.955-4.613-2.457-5.869-4.816a2.516 2.516 0 0 1-.118-.288 2.487 2.487 0 0 1-.12.249c-1.52 2.298-3.979 3.737-6.49 4.62-2.527.86-5.337 1.187-7.974.441-2.619-.682-5.062-2.032-7.1-3.86a17.488 17.488 0 0 1-2.72-3.087l-.212-.315a2.974 2.974 0 0 1-.15-.233c-.095-.123-.185-.457-.283-.112l-.281.566c-.048.143-.27.451-.472.74a14.31 14.31 0 0 1-4.555 4.36 16.016 16.016 0 0 1-6.324 2.166c-2.237.27-4.526.04-6.54-.7-1.897-.7-3.556-1.837-4.62-3.241a1.28 1.28 0 0 1-.068.054c-3.587 2.836-8.116 3.65-12.352 3.048-2.126-.325-4.22-1.03-6.112-2.196-.942-.584-1.842-1.274-2.627-2.107-.43-.38-.758-.86-1.112-1.32l-.263-.348-.132-.175-.057-.093-.2-.34c-.168-.466-.262.01-.372.154l-.22.353-.302.428c-.198.29-.412.566-.634.836a17.77 17.77 0 0 1-2.988 2.916c-2.213 1.691-4.796 2.86-7.56 3.302-2.573.348-5.157-.059-7.518-1.002-2.328-.955-4.613-2.457-5.869-4.816a2.516 2.516 0 0 1-.118-.288 2.486 2.486 0 0 1-.12.249c-1.519 2.298-3.979 3.737-6.49 4.62-2.527.86-5.337 1.187-7.973.441-2.62-.682-5.063-2.032-7.1-3.86a17.488 17.488 0 0 1-2.721-3.087l-.212-.315a2.974 2.974 0 0 1-.15-.233c-.095-.123-.185-.457-.283-.112l-.281.566c-.047.143-.27.451-.472.74a14.307 14.307 0 0 1-4.555 4.36 16.014 16.014 0 0 1-6.324 2.166c-2.237.27-4.526.04-6.54-.7-1.896-.7-3.556-1.837-4.62-3.241-.021.018-.043.036-.067.054-3.587 2.836-8.117 3.65-12.353 3.048-2.126-.325-4.22-1.03-6.111-2.196-.942-.584-1.843-1.274-2.628-2.107-.43-.38-.757-.86-1.111-1.32l-.264-.348-.132-.175-.056-.093-.201-.34c-.168-.466-.261.01-.372.154l-.22.353-.301.428c-.199.29-.413.566-.635.836a17.772 17.772 0 0 1-2.988 2.916c-2.213 1.691-4.795 2.86-7.56 3.302-2.573.348-5.156-.059-7.518-1.002-2.328-.955-4.612-2.457-5.868-4.816a2.518 2.518 0 0 1-.119-.289 2.488 2.488 0 0 1-.12.25c-1.519 2.298-3.979 3.737-6.49 4.62-2.527.86-5.337 1.187-7.973.441-2.62-.682-5.063-2.032-7.1-3.86a17.489 17.489 0 0 1-2.721-3.087l-.212-.315a2.911 2.911 0 0 1-.15-.233c-.094-.123-.184-.457-.282-.112l-.282.566c-.047.143-.27.451-.472.74a14.308 14.308 0 0 1-4.555 4.36 16.015 16.015 0 0 1-6.324 2.166c-2.236.27-4.526.04-6.54-.7-2.008-.74-3.75-1.973-4.803-3.493-1.052 1.52-2.794 2.752-4.802 3.493-2.015.74-4.304.97-6.54.7a16.014 16.014 0 0 1-6.324-2.166 14.307 14.307 0 0 1-4.555-4.36c-.203-.289-.425-.597-.472-.74l-.282-.566c-.098-.345-.188-.011-.283.112-.046.08-.095.158-.15.233l-.211.315a17.488 17.488 0 0 1-2.721 3.088c-2.038 1.827-4.481 3.177-7.1 3.86-2.636.745-5.447.418-7.973-.442-2.512-.883-4.972-2.322-6.49-4.62-.475-.865-.151-1.328.408-.564 1.394 1.751 3.45 2.916 5.578 3.752 2.14.821 4.483 1.262 6.709 1.027 2.454-.316 4.884-1.329 6.954-2.828a16.938 16.938 0 0 0 2.844-2.606c.215-.242.423-.491.616-.752l.296-.386.338-.495.888-1.428.215-.346c.017-.022.036-.074.052-.07l.045.09.09.178.356.71.579 1.159.14.278.112.166.225.331c.302.44.576.904.955 1.28.681.818 1.485 1.526 2.344 2.14 1.726 1.229 3.717 2.055 5.788 2.47 2.072.416 4.238.39 6.318-.1 2.073-.491 4.074-1.489 5.64-3.019.166-.152.32-.21.413-.196.094-.013.247.044.413.196 1.566 1.53 3.568 2.528 5.641 3.02 2.08.489 4.245.515 6.318.099 2.07-.415 4.062-1.241 5.787-2.47.86-.614 1.664-1.322 2.345-2.14.379-.376.653-.84.955-1.28l.224-.331.113-.166.14-.278.579-1.159.356-.71.09-.179.044-.09c.017-.003.036.05.053.07l.214.347.888 1.428.338.495.296.386c.194.26.401.51.616.752a16.942 16.942 0 0 0 2.844 2.606c2.07 1.5 4.5 2.512 6.955 2.828 2.225.235 4.57-.206 6.709-1.027 2.127-.836 4.183-2 5.578-3.752.37-.506.636-.474.637-.144.166.02.431.232.66.59 1.617 2.116 4.04 3.391 6.496 4.183 2.478.765 5.148 1.04 7.64.316 2.505-.67 4.852-1.97 6.794-3.738a16.14 16.14 0 0 0 2.573-2.984c.16-.239.506-.784.723-1.172.244-.338.512-1.207.713-.43l.656 1.233c.106.184.23.47.322.57l.29.39c1.066 1.521 2.627 2.843 4.451 3.733 1.823.896 3.868 1.409 5.904 1.568 4.053.318 7.93-.726 10.956-2.506-.175-.264.067-.359.377-.117a1.174 1.174 0 0 1 .07.059c1.566 1.53 3.567 2.528 5.64 3.02 2.08.489 4.246.515 6.318.099 2.072-.415 4.063-1.241 5.788-2.47.86-.614 1.664-1.322 2.345-2.14.379-.376.653-.84.954-1.28l.225-.331.113-.166.14-.278.579-1.159.355-.71.09-.179.045-.09c.017-.003.035.05.053.07l.214.347.888 1.428.338.495.296.386c.194.26.401.51.616.752a16.933 16.933 0 0 0 2.844 2.606c2.07 1.5 4.5 2.512 6.955 2.828 2.225.235 4.57-.206 6.708-1.027 2.128-.836 4.184-2 5.579-3.752.37-.506.636-.474.637-.144.166.02.431.232.66.59 1.617 2.116 4.04 3.391 6.496 4.183 2.478.765 5.147 1.04 7.639.316 2.506-.67 4.852-1.97 6.795-3.738a16.14 16.14 0 0 0 2.573-2.984c.16-.239.506-.784.723-1.172.244-.338.512-1.207.713-.43l.656 1.233c.105.184.23.47.322.57l.29.39c1.065 1.521 2.627 2.843 4.45 3.733 1.824.896 3.87 1.409 5.905 1.568 4.053.318 7.93-.726 10.956-2.506-.175-.264.066-.359.377-.117a1.179 1.179 0 0 1 .07.059c1.566 1.53 3.567 2.528 5.64 3.02 2.08.489 4.246.515 6.318.099 2.072-.415 4.063-1.241 5.788-2.47.86-.614 1.663-1.322 2.345-2.14.379-.376.653-.84.954-1.28l.225-.331.113-.166.14-.278.579-1.159.355-.71.09-.179.045-.09c.016-.003.035.05.053.07l.214.347.888 1.428.338.495.296.386c.193.26.401.51.616.752a16.937 16.937 0 0 0 2.844 2.606c2.07 1.5 4.5 2.512 6.954 2.828 2.226.235 4.57-.206 6.71-1.027 2.127-.836 4.183-2 5.578-3.752.37-.506.636-.474.637-.144.166.02.431.232.66.59 1.617 2.116 4.04 3.391 6.496 4.183 2.478.765 5.147 1.04 7.639.316 2.506-.67 4.852-1.97 6.795-3.738a16.143 16.143 0 0 0 2.573-2.984c.16-.239.506-.784.723-1.172.244-.338.512-1.207.713-.43l.656 1.233c.105.184.23.47.322.57l.29.39c1.065 1.521 2.627 2.843 4.45 3.733 1.824.896 3.87 1.409 5.905 1.568 4.053.318 7.93-.726 10.955-2.505-.174-.265.067-.36.378-.118a1.177 1.177 0 0 1 .07.059c1.566 1.53 3.567 2.528 5.64 3.02 2.08.489 4.246.515 6.318.099 2.071-.415 4.063-1.241 5.788-2.47.86-.614 1.663-1.322 2.345-2.14.378-.376.653-.84.954-1.28l.225-.331.112-.166.14-.278.58-1.159.355-.71.09-.179.045-.09c.016-.003.035.05.053.07l.214.347.888 1.428.338.495.296.386c.193.261.401.51.616.752a16.941 16.941 0 0 0 2.844 2.606c2.07 1.5 4.5 2.512 6.954 2.828 2.226.235 4.57-.206 6.71-1.027 2.126-.836 4.183-2 5.578-3.752.37-.506.636-.474.637-.144.166.02.431.232.66.59 1.616 2.116 4.04 3.391 6.496 4.183 2.478.765 5.147 1.04 7.639.316 2.506-.67 4.852-1.97 6.795-3.738a16.144 16.144 0 0 0 2.573-2.984c.16-.239.506-.784.723-1.172.244-.338.511-1.207.713-.43l.655 1.233c.106.184.231.47.323.57l.29.39c1.065 1.521 2.627 2.843 4.45 3.733 1.823.896 3.869 1.41 5.905 1.568 4.052.318 7.93-.726 10.955-2.506-.174-.264.067-.359.378-.117a1.188 1.188 0 0 1 .07.059c1.566 1.53 3.567 2.528 5.64 3.02 2.08.489 4.246.515 6.318.099 2.071-.415 4.063-1.241 5.788-2.47.86-.614 1.663-1.322 2.344-2.14.38-.376.653-.84.955-1.28l.225-.331.112-.166.14-.278.58-1.159.355-.71.09-.179.045-.09c.016-.003.035.05.052.07l.215.347.888 1.428.338.495.296.386c.193.261.401.51.616.752a16.937 16.937 0 0 0 2.844 2.606c2.07 1.5 4.5 2.512 6.954 2.828 2.226.235 4.57-.206 6.709-1.027 2.127-.836 4.184-2 5.579-3.752.198-.271.366-.388.48-.387.114-.001.283.116.481.387 1.395 1.751 3.451 2.916 5.579 3.752 2.139.821 4.483 1.262 6.708 1.027 2.454-.316 4.885-1.329 6.955-2.828a16.946 16.946 0 0 0 2.844-2.606c.214-.242.422-.491.616-.752l.296-.386.338-.495.888-1.428.214-.346c.018-.022.036-.074.053-.07l.045.09.09.179.355.71.58 1.158.14.278.112.166.224.331c.302.44.576.904.955 1.28.681.818 1.485 1.526 2.345 2.14 1.725 1.229 3.716 2.055 5.788 2.47 2.072.416 4.238.39 6.317-.1 2.074-.491 4.075-1.489 5.641-3.019a1.166 1.166 0 0 1 .07-.059c.31-.242.552-.147.377.118 3.025 1.779 6.903 2.823 10.956 2.505 2.036-.159 4.081-.672 5.904-1.568 1.824-.89 3.386-2.212 4.451-3.733l.29-.39c.092-.1.216-.386.322-.57l.656-1.234c.201-.776.469.093.713.431.217.388.563.933.723 1.172a16.143 16.143 0 0 0 2.573 2.984c1.942 1.768 4.289 3.069 6.795 3.738 2.491.725 5.16.449 7.639-.316 2.456-.792 4.88-2.067 6.496-4.184.229-.357.494-.57.66-.59 0-.329.267-.36.637.145 1.395 1.751 3.451 2.916 5.578 3.752 2.14.821 4.484 1.262 6.71 1.027 2.453-.316 4.884-1.329 6.954-2.828a16.937 16.937 0 0 0 2.844-2.606c.214-.242.422-.491.616-.752l.296-.386.337-.495.889-1.428.214-.346c.017-.022.036-.074.053-.07l.044.09.09.179.356.71.579 1.158.14.278.113.166.224.331c.302.44.576.904.955 1.28.681.818 1.485 1.526 2.345 2.14 1.725 1.229 3.716 2.055 5.787 2.47 2.073.416 4.239.39 6.318-.1 2.074-.491 4.075-1.489 5.641-3.019a1.18 1.18 0 0 1 .07-.059c.31-.242.552-.147.377.118 3.025 1.779 6.903 2.823 10.956 2.505 2.036-.159 4.08-.672 5.904-1.568 1.824-.89 3.385-2.212 4.45-3.733l.29-.39c.092-.1.217-.386.323-.57l.655-1.234c.202-.776.47.093.714.431.217.388.562.933.723 1.172a16.143 16.143 0 0 0 2.573 2.984c1.942 1.768 4.289 3.069 6.795 3.738 2.491.725 5.16.449 7.639-.316 2.456-.792 4.879-2.067 6.496-4.184.228-.357.493-.57.66-.59 0-.329.267-.36.637.145 1.394 1.751 3.451 2.916 5.578 3.752 2.14.821 4.484 1.262 6.71 1.027 2.453-.316 4.883-1.329 6.954-2.828a16.933 16.933 0 0 0 2.843-2.606c.215-.242.423-.491.616-.752l.296-.386.338-.495.889-1.428.214-.346c.017-.022.036-.074.052-.07l.045.09.09.178.356.71.579 1.159.14.278.113.166.224.331c.302.44.576.904.955 1.28.681.818 1.485 1.526 2.344 2.14 1.726 1.229 3.717 2.055 5.788 2.47 2.073.416 4.239.39 6.318-.1 2.073-.491 4.075-1.489 5.641-3.019a1.182 1.182 0 0 1 .07-.059c.31-.242.552-.147.377.117 3.025 1.78 6.903 2.824 10.955 2.506 2.036-.159 4.082-.672 5.905-1.568 1.824-.89 3.385-2.212 4.45-3.733l.29-.39c.092-.1.217-.386.323-.57l.655-1.234c.202-.776.47.093.713.431.218.388.564.933.724 1.172a16.14 16.14 0 0 0 2.572 2.984c1.943 1.768 4.29 3.069 6.796 3.738 2.491.725 5.16.449 7.639-.316 2.456-.792 4.879-2.067 6.496-4.184.228-.357.493-.57.66-.59 0-.329.267-.36.637.145 1.394 1.751 3.45 2.916 5.578 3.752 2.14.821 4.484 1.262 6.709 1.027 2.454-.316 4.884-1.329 6.955-2.828a16.943 16.943 0 0 0 2.843-2.606c.215-.242.423-.491.616-.752l.296-.386.338-.495.889-1.428.214-.346c.017-.022.036-.074.052-.07l.045.09.09.178.356.71.579 1.159.14.278.113.166.224.331c.302.44.576.904.955 1.28.681.818 1.485 1.526 2.344 2.14 1.726 1.229 3.717 2.055 5.788 2.47 2.072.416 4.238.39 6.318-.1 2.073-.491 4.075-1.489 5.64-3.019a1.182 1.182 0 0 1 .07-.059c.311-.242.553-.147.378.117 3.025 1.78 6.903 2.824 10.955 2.506 2.036-.159 4.082-.672 5.905-1.568 1.823-.89 3.385-2.212 4.45-3.733l.29-.39c.092-.1.217-.386.323-.57l.655-1.234c.202-.776.47.093.713.431.218.388.563.933.724 1.172a16.14 16.14 0 0 0 2.572 2.984c1.943 1.768 4.29 3.069 6.795 3.738 2.492.725 5.161.449 7.64-.316 2.456-.792 4.879-2.067 6.495-4.184.23-.357.494-.57.66-.59.001-.329.268-.36.638.145z"/>
                </g>
            </g>
        </svg>
    <?php elseif ($lstShapeType === \Tangibledesign\Listivo\Widgets\General\ShapeWidget::TYPE_CLOUD) : ?>
        <svg xmlns="http://www.w3.org/2000/svg" width="127" height="30" viewBox="0 0 127 30">
            <g>
                <g>
                    <path d="M123.223-.002H33.12c-2.078 0-3.777 1.705-3.777 3.787 0 2.083 1.7 3.787 3.777 3.787h7.625c-.16 0-.317.013-.47.035 1.267.18 2.238 1.07 2.238 2.134 0 .532-.242 1.018-.64 1.396h-26.49c-2.077 0-3.777 1.704-3.777 3.786 0 2.083 1.7 3.786 3.777 3.786h5.086c.333.097.683.15 1.045.15h1.529c1.01.315 1.734 1.102 1.734 2.02 0 .605-.313 1.152-.814 1.545H3.777C1.7 22.424 0 24.128 0 26.21c0 2.083 1.7 3.788 3.777 3.788H93.88c2.077 0 3.777-1.705 3.777-3.788 0-2.082-1.7-3.786-3.777-3.786h-6.707c-.5-.394-.812-.941-.812-1.544 0-.918.72-1.704 1.73-2.02h23.526c2.077 0 3.777-1.705 3.777-3.787 0-2.083-1.7-3.787-3.777-3.787h-5.086a3.753 3.753 0 0 0-1.046-.149h-.747c-.399-.379-.64-.865-.64-1.396 0-1.193 1.218-2.17 2.708-2.17h16.416c2.077 0 3.777-1.703 3.777-3.786 0-2.082-1.7-3.787-3.777-3.787z"/>
                </g>
            </g>
        </svg>
    <?php elseif ($lstShapeType === \Tangibledesign\Listivo\Widgets\General\ShapeWidget::TYPE_WAVE) : ?>
        <svg xmlns="http://www.w3.org/2000/svg" width="65" height="35" viewBox="0 0 65 35">
            <g>
                <g>
                    <path d="M1.996 17.764c3.454-1.313 5.977-.028 8.005 1.005 1.99 1.014 3.207 1.553 5.067.846 1.86-.707 2.412-1.917 3.227-3.998.831-2.12 1.865-4.756 5.32-6.069 3.453-1.312 5.976-.027 8.003 1.006 1.99 1.015 3.207 1.553 5.066.847 1.86-.707 2.411-1.917 3.227-3.998.83-2.119 1.864-4.756 5.318-6.068 3.454-1.313 5.976-.027 8.004 1.006 1.99 1.014 3.206 1.553 5.065.847a1.82 1.82 0 1 1 1.293 3.406c-3.454 1.312-5.977.026-8.004-1.008-1.99-1.013-3.206-1.552-5.065-.845-1.86.706-2.412 1.917-3.227 3.996-.83 2.12-1.864 4.757-5.318 6.07-3.454 1.313-5.977.027-8.005-1.007-1.99-1.014-3.206-1.553-5.065-.846-1.86.706-2.412 1.918-3.228 3.998-.83 2.12-1.865 4.757-5.319 6.07-3.454 1.312-5.977.026-8.005-1.007-1.99-1.014-3.206-1.553-5.066-.846a1.82 1.82 0 0 1-2.346-1.057 1.82 1.82 0 0 1 1.053-2.348zm4.04 10.64c3.453-1.312 5.977-.026 8.004 1.006 1.99 1.015 3.207 1.554 5.067.847 1.86-.707 2.412-1.918 3.228-3.998.83-2.12 1.865-4.757 5.319-6.069 3.453-1.312 5.977-.027 8.004 1.006 1.99 1.014 3.206 1.553 5.066.847 1.859-.707 2.41-1.918 3.227-3.998.83-2.119 1.864-4.756 5.317-6.068 3.454-1.313 5.977-.027 8.005 1.006 1.99 1.014 3.206 1.553 5.065.847a1.818 1.818 0 0 1 2.345 1.056 1.82 1.82 0 0 1-1.052 2.349c-3.454 1.312-5.977.027-8.004-1.007-1.99-1.014-3.207-1.553-5.066-.846-1.859.706-2.411 1.918-3.226 3.997-.83 2.12-1.865 4.757-5.318 6.07-3.454 1.312-5.978.026-8.005-1.007-1.99-1.014-3.206-1.553-5.065-.847-1.86.707-2.412 1.919-3.228 3.999-.83 2.119-1.865 4.757-5.32 6.069-3.453 1.312-5.977.027-8.004-1.007-1.99-1.013-3.207-1.552-5.067-.846a1.819 1.819 0 0 1-2.345-1.057 1.82 1.82 0 0 1 1.053-2.348z"/>
                </g>
            </g>
        </svg>
    <?php elseif ($lstShapeType === \Tangibledesign\Listivo\Widgets\General\ShapeWidget::TYPE_OX) : ?>
        <div class="listivo-shape-ox">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 39">
                <g>
                    <g>
                        <path d="M35.386 13.26a1.437 1.437 0 0 1-2.027 0l-4.415-4.4-4.415 4.4a1.437 1.437 0 0 1-2.027 0 1.425 1.425 0 0 1 0-2.02l4.415-4.4-4.415-4.399a1.425 1.425 0 0 1 0-2.02 1.437 1.437 0 0 1 2.027 0l4.415 4.4 4.415-4.4a1.437 1.437 0 0 1 2.027 0c.56.558.56 1.462 0 2.02L30.97 6.84l4.415 4.4c.56.557.56 1.461 0 2.02zM11.58 33.58c0 2.932-2.384 5.307-5.326 5.307-2.94 0-5.325-2.375-5.325-5.307 0-2.93 2.384-5.306 5.325-5.306 2.942 0 5.326 2.376 5.326 5.306z"/>
                    </g>
                </g>
            </svg>
        </div>
    <?php elseif ($lstShapeType === \Tangibledesign\Listivo\Widgets\General\ShapeWidget::TYPE_TRIANGLE) : ?>
        <div class="listivo-shape-triangle">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 121.000000 121.000000"
                 preserveAspectRatio="xMidYMid meet">
                <g transform="translate(0.000000,121.000000) scale(0.100000,-0.100000)" stroke="none">
                    <path d="M1127 1196 c-3 -8 -23 -18 -44 -21 -21 -3 -67 -14 -103 -25 -124 -35 -185 -51 -240 -64 -30 -7 -71 -18 -90 -24 -40 -13 -128 -37 -210 -56 -30 -7 -77 -21 -103 -30 -26 -9 -57 -16 -67 -16 -11 0 -46 -9 -77 -19 -32 -11 -76 -22 -98 -26 -46 -8 -65 -21 -65 -44 0 -21 820 -841 841 -841 23 0 36 19 44 65 4 22 15 66 26 98 10 31 19 66 19 77 0 10 7 41 16 67 9 26 23 73 30 103 19 82 43 170 56 210 6 19 17 60 24 90 13 55 29 116 64 240 11 36 22 82 25 103 3 21 13 41 21 44 9 3 14 19 14 44 0 39 0 39 -39 39 -25 0 -41 -5 -44 -14z m-78 -149 c11 -14 -1 -90 -32 -192 -19 -65 -35 -126 -51 -195 -7 -30 -20 -77 -29 -105 -20 -63 -44 -151 -62 -234 -15 -64 -38 -111 -55 -111 -12 0 -610 598 -610 610 0 17 47 40 111 55 83 18 171 42 234 62 28 9 75 22 105 29 70 16 131 32 195 52 48 14 148 38 171 41 6 0 17 -5 23 -12z"></path>
                </g>
            </svg>
        </div>
    <?php elseif ($lstShapeType === \Tangibledesign\Listivo\Widgets\General\ShapeWidget::TYPE_DOTS) : ?>
        <div class="listivo-shape-dots"></div>
    <?php elseif ($lstShapeType === \Tangibledesign\Listivo\Widgets\General\ShapeWidget::TYPE_ARROW_1) : ?>
        <div class="listivo-shape-arrow-1">
            <svg xmlns="http://www.w3.org/2000/svg" version="1.0" viewBox="0 0 346.000000 258.000000"
                 preserveAspectRatio="xMidYMid meet">
                <g transform="translate(0.000000,258.000000) scale(0.100000,-0.100000)" stroke="none">
                    <path d="M3071 2511 c-12 -16 -21 -33 -21 -37 0 -5 -11 -31 -24 -59 -57 -117         -86 -184 -86 -198 0 -16 26 -47 38 -47 7 0 51 83 71 135 7 17 23 43 36 60 22         27 25 28 31 10 4 -11 11 -26 17 -32 14 -19 47 3 47 32 0 13 4 26 8 29 5 3 53         -17 108 -44 90 -45 100 -48 112 -33 6 9 12 20 12 24 0 9 -62 56 -92 70 -13 5         -41 21 -63 34 -63 38 -155 85 -165 85 -5 0 -18 -13 -29 -29z"></path>
                    <path d="M3177 2193 c-11 -11 -8 -128 4 -140 5 -5 21 -8 35 -5 21 4 24 10 24         49 0 67 -37 123 -63 96z"></path>
                    <path d="M3201 1876 c-18 -19 -22 -33 -19 -72 3 -47 4 -49 33 -49 30 0 30 1         33 61 4 76 -13 97 -47 60z"></path>
                    <path d="M3173 1578 c-5 -7 -15 -33 -22 -57 -12 -41 -11 -46 5 -58 32 -24 48         -11 58 44 6 39 5 57 -4 68 -15 18 -25 19 -37 3z"></path>
                    <path d="M3075 1243 c-25 -55 -25 -58 -8 -71 21 -15 43 -12 53 8 27 55 40 94         33 100 -4 4 -18 11 -30 15 -20 5 -26 -1 -48 -52z"></path>
                    <path d="M2960 991 c-11 -22 -24 -42 -29 -45 -4 -3 -6 -17 -3 -31 4 -21 9 -25         30 -23 19 2 32 15 49 47 27 52 29 77 7 85 -27 10 -33 7 -54 -33z"></path>
                    <path d="M2780 729 c-28 -36 -31 -44 -21 -66 l11 -24 28 19 c51 37 74 69 67         91 -11 35 -48 26 -85 -20z"></path>
                    <path d="M37 563 c-4 -3 -7 -16 -7 -28 0 -28 70 -76 100 -68 29 8 23 53 -8 69         -13 6 -29 17 -35 23 -12 12 -40 15 -50 4z"></path>
                    <path d="M2566 514 c-37 -33 -37 -36 -21 -54 16 -18 19 -18 43 -2 48 31 75 61         68 77 -9 26 -49 17 -90 -21z"></path>
                    <path d="M287 409 c-17 -10 -16 -12 3 -39 25 -35 93 -58 116 -39 20 17 18 24         -20 52 -40 31 -75 40 -99 26z"></path>
                    <path d="M2370 373 c-8 -3 -32 -16 -52 -30 -36 -25 -37 -26 -23 -53 l15 -29         45 26 c53 29 72 57 54 79 -12 15 -15 15 -39 7z"></path>
                    <path d="M557 283 c-4 -3 -7 -17 -7 -30 0 -32 82 -70 117 -54 35 16 28 33 -26         64 -49 27 -72 33 -84 20z"></path>
                    <path d="M2080 230 c-8 -6 -27 -14 -42 -20 -18 -6 -28 -17 -28 -30 0 -29 23         -34 83 -18 47 13 52 17 52 44 0 24 -5 29 -25 31 -14 1 -32 -2 -40 -7z"></path>
                    <path d="M841 167 c-6 -6 -11 -17 -11 -25 0 -17 84 -54 113 -50 31 4 35 43 5         61 -31 20 -93 28 -107 14z"></path>
                    <path d="M1758 128 c-27 -7 -38 -15 -38 -29 0 -27 21 -33 88 -23 52 8 57 11         57 34 0 22 -5 25 -35 27 -19 1 -52 -3 -72 -9z"></path>
                    <path d="M1135 105 c-3 -8 -7 -21 -9 -29 -8 -24 16 -36 70 -36 87 0 94 51 9         70 -55 13 -65 12 -70 -5z"></path>
                    <path d="M1457 93 c-33 -5 -45 -27 -26 -49 11 -13 25 -15 68 -11 62 7 91 26         67 46 -17 14 -69 21 -109 14z"></path>
                </g>
            </svg>
        </div>
    <?php endif; ?>
</div>
