<?php
/* @var \Tangibledesign\Listivo\Widgets\User\UserHiddenPhoneWidget $lstCurrentWidget */
global $lstCurrentWidget;

$lstUser = $lstCurrentWidget->getUser();
if (!$lstUser || empty($lstUser->getPhone())) {
    return;
}

$lstModel = $lstCurrentWidget->getModel();

if ($lstCurrentWidget->showAtStart()) : ?>
    <a
            href="tel:<?php echo esc_attr($lstUser->getPhoneUrl()); ?>"
            class="listivo-contact-button"
    >
        <div class="listivo-contact-button__inner">
            <div class="listivo-contact-button__icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="24" viewBox="0 0 14 24"
                     fill="none">
                    <path d="M2.625 0C1.18562 0 0 1.18562 0 2.625V20.7083C0 22.1477 1.18562 23.3333 2.625 23.3333H11.375C12.8144 23.3333 14 22.1477 14 20.7083V2.625C14 1.18562 12.8144 0 11.375 0H2.625ZM2.625 1.75H11.375C11.8688 1.75 12.25 2.13121 12.25 2.625V20.7083C12.25 21.2021 11.8688 21.5833 11.375 21.5833H2.625C2.13121 21.5833 1.75 21.2021 1.75 20.7083V2.625C1.75 2.13121 2.13121 1.75 2.625 1.75ZM7 3.5C6.76794 3.5 6.54538 3.59219 6.38128 3.75628C6.21719 3.92038 6.125 4.14294 6.125 4.375C6.125 4.60706 6.21719 4.82962 6.38128 4.99372C6.54538 5.15781 6.76794 5.25 7 5.25C7.23206 5.25 7.45462 5.15781 7.61872 4.99372C7.78281 4.82962 7.875 4.60706 7.875 4.375C7.875 4.14294 7.78281 3.92038 7.61872 3.75628C7.45462 3.59219 7.23206 3.5 7 3.5ZM5.54167 18.0833C5.42572 18.0817 5.3106 18.1031 5.203 18.1464C5.09541 18.1896 4.99748 18.2538 4.9149 18.3352C4.83233 18.4166 4.76676 18.5136 4.722 18.6206C4.67725 18.7276 4.6542 18.8424 4.6542 18.9583C4.6542 19.0743 4.67725 19.1891 4.722 19.2961C4.76676 19.403 4.83233 19.5001 4.9149 19.5815C4.99748 19.6629 5.09541 19.7271 5.203 19.7703C5.3106 19.8136 5.42572 19.835 5.54167 19.8333H8.45833C8.57428 19.835 8.6894 19.8136 8.797 19.7703C8.90459 19.7271 9.00252 19.6629 9.0851 19.5815C9.16767 19.5001 9.23324 19.403 9.278 19.2961C9.32275 19.1891 9.3458 19.0743 9.3458 18.9583C9.3458 18.8424 9.32275 18.7276 9.278 18.6206C9.23324 18.5136 9.16767 18.4166 9.0851 18.3352C9.00252 18.2538 8.90459 18.1896 8.797 18.1464C8.6894 18.1031 8.57428 18.0817 8.45833 18.0833H5.54167Z"
                          fill="#2A3946"/>
                </svg>
            </div>

            <?php echo wp_kses_post($lstUser->getDisplayPhone()); ?>
        </div>
    </a>
<?php else : ?>
    <div class="listivo-app">
        <lst-phone
                :user-id="<?php echo esc_attr($lstUser->getId()); ?>"
                request-url="<?php echo esc_url(admin_url('admin-post.php?action=listivo/phone')); ?>"
                phone-nonce="<?php echo esc_attr(wp_create_nonce('phone_' . $lstUser->getId())) ?>"
            <?php if ($lstModel) : ?>
                :model-id="<?php echo esc_attr($lstModel->getId()); ?>"
            <?php endif; ?>
        >
            <div slot-scope="props">
                <div
                        v-if="!props.phone"
                        @click.prevent="props.onShow"
                        class="listivo-contact-button"
                >
                    <div class="listivo-contact-button__inner">
                        <div class="listivo-contact-button__icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="24" viewBox="0 0 14 24"
                                 fill="none">
                                <path d="M2.625 0C1.18562 0 0 1.18562 0 2.625V20.7083C0 22.1477 1.18562 23.3333 2.625 23.3333H11.375C12.8144 23.3333 14 22.1477 14 20.7083V2.625C14 1.18562 12.8144 0 11.375 0H2.625ZM2.625 1.75H11.375C11.8688 1.75 12.25 2.13121 12.25 2.625V20.7083C12.25 21.2021 11.8688 21.5833 11.375 21.5833H2.625C2.13121 21.5833 1.75 21.2021 1.75 20.7083V2.625C1.75 2.13121 2.13121 1.75 2.625 1.75ZM7 3.5C6.76794 3.5 6.54538 3.59219 6.38128 3.75628C6.21719 3.92038 6.125 4.14294 6.125 4.375C6.125 4.60706 6.21719 4.82962 6.38128 4.99372C6.54538 5.15781 6.76794 5.25 7 5.25C7.23206 5.25 7.45462 5.15781 7.61872 4.99372C7.78281 4.82962 7.875 4.60706 7.875 4.375C7.875 4.14294 7.78281 3.92038 7.61872 3.75628C7.45462 3.59219 7.23206 3.5 7 3.5ZM5.54167 18.0833C5.42572 18.0817 5.3106 18.1031 5.203 18.1464C5.09541 18.1896 4.99748 18.2538 4.9149 18.3352C4.83233 18.4166 4.76676 18.5136 4.722 18.6206C4.67725 18.7276 4.6542 18.8424 4.6542 18.9583C4.6542 19.0743 4.67725 19.1891 4.722 19.2961C4.76676 19.403 4.83233 19.5001 4.9149 19.5815C4.99748 19.6629 5.09541 19.7271 5.203 19.7703C5.3106 19.8136 5.42572 19.835 5.54167 19.8333H8.45833C8.57428 19.835 8.6894 19.8136 8.797 19.7703C8.90459 19.7271 9.00252 19.6629 9.0851 19.5815C9.16767 19.5001 9.23324 19.403 9.278 19.2961C9.32275 19.1891 9.3458 19.0743 9.3458 18.9583C9.3458 18.8424 9.32275 18.7276 9.278 18.6206C9.23324 18.5136 9.16767 18.4166 9.0851 18.3352C9.00252 18.2538 8.90459 18.1896 8.797 18.1464C8.6894 18.1031 8.57428 18.0817 8.45833 18.0833H5.54167Z"
                                      fill="#2A3946"/>
                            </svg>
                        </div>

                        <?php echo wp_kses_post($lstUser->getPhonePlaceholder()); ?>
                    </div>

                    <div class="listivo-contact-button__icon listivo-contact-button__icon--additional">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="14" viewBox="0 0 20 14"
                             fill="none">
                            <path d="M10 0.333252C3.33334 0.333252 0.833344 6.99992 0.833344 6.99992C0.833344 6.99992 3.33334 13.6666 10 13.6666C16.6667 13.6666 19.1667 6.99992 19.1667 6.99992C19.1667 6.99992 16.6667 0.333252 10 0.333252ZM10 1.99992C14.3967 1.99992 16.6205 5.55583 17.3405 6.99666C16.6197 8.4275 14.3792 11.9999 10 11.9999C5.60334 11.9999 3.37952 8.44401 2.65952 7.00317C3.38118 5.57234 5.62084 1.99992 10 1.99992ZM10 3.66658C8.15918 3.66658 6.66668 5.15908 6.66668 6.99992C6.66668 8.84075 8.15918 10.3333 10 10.3333C11.8408 10.3333 13.3333 8.84075 13.3333 6.99992C13.3333 5.15908 11.8408 3.66658 10 3.66658ZM10 5.33325C10.9208 5.33325 11.6667 6.07908 11.6667 6.99992C11.6667 7.92075 10.9208 8.66658 10 8.66658C9.07918 8.66658 8.33334 7.92075 8.33334 6.99992C8.33334 6.07908 9.07918 5.33325 10 5.33325Z"
                                  fill="#FDFDFE"/>
                        </svg>
                    </div>
                </div>

                <template>
                    <a
                            v-if="props.phone"
                            :href="'tel:' + props.phone.url"
                            class="listivo-contact-button"
                    >
                        <div class="listivo-contact-button__inner">
                            <div class="listivo-contact-button__icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="24" viewBox="0 0 14 24"
                                     fill="none">
                                    <path d="M2.625 0C1.18562 0 0 1.18562 0 2.625V20.7083C0 22.1477 1.18562 23.3333 2.625 23.3333H11.375C12.8144 23.3333 14 22.1477 14 20.7083V2.625C14 1.18562 12.8144 0 11.375 0H2.625ZM2.625 1.75H11.375C11.8688 1.75 12.25 2.13121 12.25 2.625V20.7083C12.25 21.2021 11.8688 21.5833 11.375 21.5833H2.625C2.13121 21.5833 1.75 21.2021 1.75 20.7083V2.625C1.75 2.13121 2.13121 1.75 2.625 1.75ZM7 3.5C6.76794 3.5 6.54538 3.59219 6.38128 3.75628C6.21719 3.92038 6.125 4.14294 6.125 4.375C6.125 4.60706 6.21719 4.82962 6.38128 4.99372C6.54538 5.15781 6.76794 5.25 7 5.25C7.23206 5.25 7.45462 5.15781 7.61872 4.99372C7.78281 4.82962 7.875 4.60706 7.875 4.375C7.875 4.14294 7.78281 3.92038 7.61872 3.75628C7.45462 3.59219 7.23206 3.5 7 3.5ZM5.54167 18.0833C5.42572 18.0817 5.3106 18.1031 5.203 18.1464C5.09541 18.1896 4.99748 18.2538 4.9149 18.3352C4.83233 18.4166 4.76676 18.5136 4.722 18.6206C4.67725 18.7276 4.6542 18.8424 4.6542 18.9583C4.6542 19.0743 4.67725 19.1891 4.722 19.2961C4.76676 19.403 4.83233 19.5001 4.9149 19.5815C4.99748 19.6629 5.09541 19.7271 5.203 19.7703C5.3106 19.8136 5.42572 19.835 5.54167 19.8333H8.45833C8.57428 19.835 8.6894 19.8136 8.797 19.7703C8.90459 19.7271 9.00252 19.6629 9.0851 19.5815C9.16767 19.5001 9.23324 19.403 9.278 19.2961C9.32275 19.1891 9.3458 19.0743 9.3458 18.9583C9.3458 18.8424 9.32275 18.7276 9.278 18.6206C9.23324 18.5136 9.16767 18.4166 9.0851 18.3352C9.00252 18.2538 8.90459 18.1896 8.797 18.1464C8.6894 18.1031 8.57428 18.0817 8.45833 18.0833H5.54167Z"
                                          fill="#2A3946"/>
                                </svg>
                            </div>

                            {{ props.phone.label }}
                        </div>
                    </a>
                </template>
            </div>
        </lst-phone>
    </div>
<?php
endif;