<?php
/**
 * Interface Loco_Automatic_Translate_Addon_Pro\AI_Translate\Services\Contracts\Generative_AI_API_Client
 */

namespace Loco_Automatic_Translate_Addon_Pro\AI_Translate\Services\Contracts;

use Loco_Automatic_Translate_Addon_Pro\AI_Translate\Services\Exception\Generative_AI_Exception;
use Felix_Arntz\WP_OOP_Plugin_Lib\HTTP\Contracts\Request;
use Felix_Arntz\WP_OOP_Plugin_Lib\HTTP\Contracts\Response;
use Generator;

/**
 * Interface for a class representing a client for a generative AI web API.
 */
interface Generative_AI_API_Client {

	/**
	 * Sends the given request to the API and returns the response data.
	 *
	 * @param Request $request The request instance.
	 * @return Response The response instance.
	 *
	 * @throws Generative_AI_Exception If an error occurs while making the request.
	 */
	public function make_request( Request $request ): Response;

	/**
	 * Processes the response data from the API.
	 *
	 * @param Response $response         The response instance. Must not be a stream response, i.e. not implement the
	 *                                   With_Stream interface.
	 * @param callable $process_callback The callback to process the response data. Receives the JSON-decoded response
	 *                                   data as associative array and should return the processed data in the desired
	 *                                   format.
	 * @return mixed The processed response data.
	 *
	 * @throws Generative_AI_Exception If an error occurs while processing the response data.
	 */
	public function process_response_data( Response $response, $process_callback );

	/**
	 * Creates a new exception for an AI API request error.
	 *
	 * @param string $message The error message to include in the exception.
	 * @return Generative_AI_Exception The exception instance.
	 */
	public function create_request_exception( string $message ): Generative_AI_Exception;

	/**
	 * Creates a new exception for an AI API response error.
	 *
	 * @param string $message The error message to include in the exception.
	 * @return Generative_AI_Exception The exception instance.
	 */
	public function create_response_exception( string $message ): Generative_AI_Exception;

	/**
	 * Creates a new exception for an AI API response error for a missing key.
	 *
	 * @param string $key The missing key in the response data.
	 * @return Generative_AI_Exception The exception instance.
	 */
	public function create_missing_response_key_exception( string $key ): Generative_AI_Exception;
}
